/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.comparator.AnyObjectComparator;
import com.jmorgan.util.comparator.CollectionComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class Index<K, V>
extends JMBean
implements Comparable<Index<K, V>> {
    private static final long serialVersionUID = 6926848633871381119L;
    private HashMap<K, ArrayList<V>> map = new HashMap();
    private transient AnyObjectComparator keySorter;
    private transient CollectionComparator<V> collectionComparator;

    public HashMap<K, ArrayList<V>> getMap() {
        return this.map;
    }

    public void setMap(HashMap<K, ArrayList<V>> map) {
        this.map = map;
    }

    public Collection<K> getKeys() {
        return new ArrayList<K>(this.map.keySet());
    }

    public Collection<V> getValues() {
        ArrayList values = new ArrayList(this.totalSize());
        for (K key : this.map.keySet()) {
            values.addAll(this.map.get(key));
        }
        return values;
    }

    public V put(K key, V value) {
        ArrayList<Object> list = this.map.get(key);
        if (list == null) {
            list = new ArrayList();
            this.map.put(key, list);
        }
        list.add(value);
        return value;
    }

    public void put(K key, Collection<V> values) {
        this.map.put(key, new ArrayList<V>(values));
    }

    public void append(Index<K, V> index) {
        for (K key : index.getKeys()) {
            this.append(key, index.get(key));
        }
    }

    public void append(K key, Collection<V> values) {
        ArrayList currentValues = (ArrayList)this.get(key);
        if (currentValues == null) {
            this.put(key, values);
        } else {
            currentValues.addAll(values);
        }
    }

    public Collection<V> get(K key) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("The key for Index.get(K key, int) is not allowed to be null.");
        }
        if (this.map.size() == 0) {
            return null;
        }
        ArrayList<V> list = this.map.get(key);
        return list;
    }

    public V get(K key, int index) throws NullPointerException, IndexOutOfBoundsException {
        if (key == null) {
            throw new NullPointerException("The key for Index.get(K key, int) is not allowed to be null.");
        }
        if (this.map.size() == 0) {
            return null;
        }
        ArrayList<V> list = this.map.get(key);
        if (list == null || index >= list.size() || index < 0) {
            throw new IndexOutOfBoundsException("The index " + index + " for Index.get(K key, int) is out of bounds.");
        }
        return list.get(index);
    }

    public V remove(K key, int index) throws NullPointerException, IndexOutOfBoundsException, IllegalStateException {
        V value = this.get(key, index);
        ArrayList<V> list = this.map.get(key);
        list.remove(index);
        if (list.size() == 0) {
            this.map.remove(key);
        }
        return value;
    }

    public V remove(K key, V value) throws NullPointerException, IllegalStateException {
        int valueIndex = this.indexOf(key, value);
        if (valueIndex > -1) {
            return this.remove(key, (V)valueIndex);
        }
        return null;
    }

    public void removeAll(K key) throws NullPointerException {
        if (CollectionUtility.isEmpty(this.map)) {
            return;
        }
        if (key == null) {
            throw new NullPointerException("The key for Index.removeAll(K key) is not allowed to be null.");
        }
        ArrayList<V> values = this.map.get(key);
        if (values != null) {
            values.clear();
        }
        this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public int sizeOf(K key) throws NullPointerException, IllegalStateException {
        if (this.map.size() == 0) {
            throw new IllegalStateException("The index is empty.");
        }
        if (key == null) {
            throw new NullPointerException("The key for Index.sizeOf(K key) is not allowed to be null.");
        }
        if (!this.map.containsKey(key)) {
            return -1;
        }
        ArrayList<V> values = this.map.get(key);
        if (values == null) {
            return 1;
        }
        return values.size();
    }

    public int totalSize() {
        if (this.map.size() == 0) {
            return 0;
        }
        int totalSize = 0;
        for (K key : this.map.keySet()) {
            totalSize += this.map.get(key).size();
        }
        return totalSize;
    }

    public boolean containsKey(K key) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("The key for Index.get(K key, int) is not allowed to be null.");
        }
        return this.map.containsKey(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsValue(V value) {
        for (K key : this.map.keySet()) {
            if (!this.containsValue(key, value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(K key, V value) throws NullPointerException, IllegalStateException {
        if (this.map == null) {
            throw new IllegalStateException("The index is empty.");
        }
        if (key == null) {
            throw new NullPointerException("The key for Index.containsValue(K key, V value) is not allowed to be null.");
        }
        if (this.map.size() == 0) {
            return false;
        }
        ArrayList<V> values = this.map.get(key);
        if (values == null) {
            return false;
        }
        return values.contains(value);
    }

    public int indexOf(K key, V value) throws NullPointerException, IllegalStateException {
        if (this.map.size() == 0) {
            throw new IllegalStateException("The index is empty.");
        }
        if (key == null) {
            throw new NullPointerException("The key for Index.indexOf(K key, V value) is not allowed to be null.");
        }
        ArrayList<V> values = this.map.get(key);
        if (values == null) {
            return -1;
        }
        return values.indexOf(value);
    }

    public void clear() {
        for (K key : this.getKeys()) {
            try {
                ArrayList list;
                if (key == null || (list = (ArrayList)this.get(key)) == null) continue;
                list.clear();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.printf("Index.clear(): %s\n", e.getMessage());
            }
        }
        this.map.clear();
    }

    @Override
    public int compareTo(Index<K, V> that) {
        if (that == null) {
            return 1;
        }
        if (this.equals(that)) {
            return 0;
        }
        if (this.keySorter == null) {
            this.keySorter = new AnyObjectComparator();
        }
        if (this.collectionComparator == null) {
            this.collectionComparator = new CollectionComparator();
        }
        ArrayList keys = (ArrayList)this.getKeys();
        Collections.sort(keys, this.keySorter);
        for (Object key : keys) {
            Collection<V> thatValues;
            Collection<V> thisValues = this.get(key);
            int cmp = this.collectionComparator.compare(thisValues, thatValues = that.get(key));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof Index) {
            Index that = (Index)o;
            return this.map.equals(that.map);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        for (K key : this.getKeys()) {
            str.append("\n\nValues For ").append(key).append(":\n");
            str.append("\t").append(this.get(key));
        }
        return str.toString();
    }

    public static <KeyType, ValueType, SourceType> Index<KeyType, ValueType> createIndexFrom(Collection<SourceType> objectCollection, String keyPropertyName, String valuePropertyName) {
        Index index = new Index();
        for (SourceType object : objectCollection) {
            Object key = BeanService.getPropertyValue(object, keyPropertyName);
            Object value = BeanService.getPropertyValue(object, valuePropertyName);
            index.put(key, value);
        }
        return index;
    }
}

