/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.util.comparator.AnyObjectComparator;
import java.io.Serializable;
import java.util.Objects;

public class Pair<E, F>
implements Serializable,
Comparable<Pair<E, F>> {
    public E first;
    public F second;

    public Pair() {
        this.first = null;
        this.second = null;
    }

    public Pair(E first, F second) {
        this.first = first;
        this.second = second;
    }

    public E getFirst() {
        return this.first;
    }

    public void setFirst(E first) {
        this.first = first;
    }

    public F getSecond() {
        return this.second;
    }

    public void setSecond(F second) {
        this.second = second;
    }

    @Override
    public int compareTo(Pair<E, F> that) {
        AnyObjectComparator comparator = new AnyObjectComparator(1);
        int firstCmp = comparator.compare(this.first, that.first);
        if (firstCmp != 0) {
            return firstCmp;
        }
        return comparator.compare(this.second, that.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof Pair) {
            Pair that = (Pair)o;
            if (this.first == null && that.first != null) {
                return false;
            }
            if (this.second == null && that.second != null) {
                return false;
            }
            if (this.first != null && that.first == null) {
                return false;
            }
            if (this.second != null && that.second == null) {
                return false;
            }
            return this.first != null && this.first.equals(that.first) && this.second != null && this.second.equals(that.second);
        }
        return false;
    }

    public String toString() {
        return "(" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + ")";
    }
}

