/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.lang.MathExt;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.CharacterUtility;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.collection.CollectionUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtility {
    public static final int JUSTIFY_RIGHT = 0;
    public static final int JUSTIFY_LEFT = 1;
    public static final int JUSTIFY_CENTER = 2;
    private static char[] SPECIAL_CHARACTERS = new char[]{' ', ';', ':', '_', '-', '\n', '\r'};
    static String SEPARATOR = "=".repeat(132);

    private StringUtility() {
    }

    public static boolean isEmpty(String source) {
        return source == null || source.trim().length() == 0;
    }

    public static boolean isNotEmpty(String source) {
        return !StringUtility.isEmpty(source);
    }

    public static String clone(String source) {
        if (source == null) {
            return null;
        }
        return new String(source);
    }

    public static String coalesce(String source, String repeated) {
        if (source == null) {
            return null;
        }
        if (source.length() == 0 || repeated == null) {
            return source;
        }
        String replaceString = repeated + repeated;
        while (source.contains(replaceString)) {
            source = source.replaceAll(replaceString, repeated);
        }
        return source;
    }

    public static boolean containsIgnoreCase(String source, String searchString) {
        return source.toLowerCase().contains(searchString.toLowerCase());
    }

    public static int getCountOf(String source, String subString) throws NullPointerException {
        if (source == null || subString == null) {
            throw new NullPointerException("Neither source nor substring can be null in StringUility.getCountOf(source, subString)");
        }
        int count = 0;
        int index = source.indexOf(subString);
        while (index >= 0) {
            ++count;
            index = source.indexOf(subString, index + subString.length());
        }
        return count;
    }

    public static boolean containsAnyOf(String source, String chars) {
        if (source == null || chars == null || source.length() == 0 || chars.length() == 0) {
            return false;
        }
        return StringUtility.containsAnyOf(source, chars.toCharArray());
    }

    public static boolean containsAnyOf(String source, char[] chars) {
        if (source == null || chars == null || source.length() == 0 || chars.length == 0) {
            return false;
        }
        char[] cArray = source.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Comparison.isIn(c, chars)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean startsWithAnyOf(String source, String ... prefixes) {
        if (source == null && prefixes == null) {
            return true;
        }
        if (source == null || prefixes == null || prefixes.length == 0) {
            return false;
        }
        String[] stringArray = prefixes;
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (source.startsWith(prefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean startsWith(String source, String regEx) {
        String startRegEx = null;
        startRegEx = !regEx.startsWith("^") ? String.format("^%s.*?$", regEx) : regEx;
        return source.matches(startRegEx);
    }

    public static boolean endsWidth(String source, String regEx) {
        String endRegEx = null;
        endRegEx = !regEx.endsWith("$") ? String.format("^.*?%s$", regEx) : regEx;
        return source.matches(endRegEx);
    }

    public static String escapeCharacters(String source, char[] charsToEscape, String escapePrefix, String escapeSuffix) {
        char[] sourceChars;
        if (StringUtility.isEmpty(source) || ArrayUtility.isEmpty(charsToEscape) || StringUtility.isEmpty(escapePrefix) && StringUtility.isEmpty(escapeSuffix)) {
            return source;
        }
        StringBuilder sb = new StringBuilder(source.length());
        char[] cArray = sourceChars = source.toCharArray();
        int n = sourceChars.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Comparison.isIn(ch, charsToEscape)) {
                if (escapePrefix != null) {
                    sb.append(escapePrefix);
                }
                sb.append(ch);
                if (escapeSuffix != null) {
                    sb.append(escapeSuffix);
                }
            } else {
                sb.append(ch);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String escapeCharacters(String source, byte[] charsToEscape, String escapePrefix, String escapeSuffix) {
        byte[] sourceChars;
        if (StringUtility.isEmpty(source) || ArrayUtility.isEmpty(charsToEscape) || StringUtility.isEmpty(escapePrefix) && StringUtility.isEmpty(escapeSuffix)) {
            return source;
        }
        StringBuilder sb = new StringBuilder(source.length());
        byte[] byArray = sourceChars = source.getBytes();
        int n = sourceChars.length;
        int n2 = 0;
        while (n2 < n) {
            byte ch = byArray[n2];
            if (Comparison.isIn(ch, charsToEscape)) {
                if (escapePrefix != null) {
                    sb.append(escapePrefix);
                }
                sb.append((char)ch);
                if (escapeSuffix != null) {
                    sb.append(escapeSuffix);
                }
            } else {
                sb.append((char)ch);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String escapeString(String source, String target, String escapePrefix, String escapeSuffix) {
        if (StringUtility.isEmpty(source) || StringUtility.isEmpty(target) || StringUtility.isEmpty(escapePrefix) && StringUtility.isEmpty(escapeSuffix)) {
            return source;
        }
        String replaceString = null;
        if (!StringUtility.isEmpty(escapePrefix) && !StringUtility.isEmpty(escapeSuffix)) {
            replaceString = String.format("%s%s%s", escapePrefix, target, escapeSuffix);
        } else if (!StringUtility.isEmpty(escapePrefix)) {
            replaceString = String.format("%s%s", escapePrefix, target);
        } else if (!StringUtility.isEmpty(escapeSuffix)) {
            replaceString = String.format("%s%s", target, escapeSuffix);
        }
        return source.replace(target, replaceString);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isMarked(String source, String target, String beginningMarker, String endingMarker) {
        if (StringUtility.isEmpty(source) || StringUtility.isEmpty(target) || StringUtility.isEmpty(beginningMarker)) {
            return false;
        }
        if (endingMarker == null) {
            endingMarker = beginningMarker;
        }
        if (!(source.contains(target) && source.contains(beginningMarker) && source.contains(endingMarker))) {
            return false;
        }
        beginningMarkerPosition = source.indexOf(beginningMarker);
        targetPosition = source.indexOf(target);
        while (true) {
            if (targetPosition < beginningMarkerPosition) {
                if ((targetPosition = source.indexOf(targetPosition, targetPosition + 1)) != -1) continue;
                return false;
            }
            endingMarkerPosition = source.indexOf(endingMarker, beginningMarkerPosition + 1);
            if (endingMarkerPosition == -1) {
                return false;
            }
            if (targetPosition <= beginningMarkerPosition || targetPosition >= endingMarkerPosition) ** GOTO lbl23
            return true;
lbl-1000:
            // 1 sources

            {
                beginningMarkerPosition = source.indexOf(beginningMarker, endingMarkerPosition + 1);
                if (beginningMarkerPosition == -1) {
                    return false;
                }
                if ((endingMarkerPosition = source.indexOf(endingMarkerPosition, beginningMarkerPosition + 1)) != -1) continue;
                return false;
lbl23:
                // 2 sources

                ** while (targetPosition > endingMarkerPosition)
            }
lbl24:
            // 1 sources

        }
    }

    public static String createStringOfCharacters(char c, int length) {
        if (length <= 0) {
            return "";
        }
        char[] chars = new char[length];
        Arrays.fill(chars, c);
        return new String(chars);
    }

    @Deprecated
    public static String duplicateString(String source, int numberOfDuplicates) {
        StringBuilder sb = new StringBuilder(source.length() * numberOfDuplicates);
        int i = 0;
        while (i < numberOfDuplicates) {
            sb.append(source);
            ++i;
        }
        return sb.toString();
    }

    public static String getSubstring(String source, int start, int length) throws NullPointerException, IndexOutOfBoundsException {
        if (source == null) {
            throw new NullPointerException("The source string cannot be null in StringUtility.getSubstring()");
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException("The starting location cannot be negative in StringUtility.getSubstring()");
        }
        int sourceLen = source.length();
        if (start >= sourceLen) {
            throw new IndexOutOfBoundsException("Start cannot be greater than the length of the source string in StringUtility.getSubstring()");
        }
        int end = start + length;
        if (end > sourceLen) {
            end = sourceLen;
        }
        return source.substring(start, end);
    }

    public static String getLeftSubstring(String source, int length) {
        if (length < 0) {
            throw new StringIndexOutOfBoundsException(length);
        }
        if (length >= source.length()) {
            return source;
        }
        return source.substring(0, length);
    }

    public static String getMarkupContent(String source, String startingDelimiter, String endingDelimiter) {
        return StringUtility.getMarkupContent(source, 0, startingDelimiter, endingDelimiter);
    }

    public static String getMarkupContent(String source, int startingIndex, String startingDelimiter, String endingDelimiter) {
        int beginMarker = source.indexOf(startingDelimiter, startingIndex);
        if (beginMarker == -1) {
            return null;
        }
        int startEndSearchAt = beginMarker;
        if (startingDelimiter.equals(endingDelimiter)) {
            startEndSearchAt += startingDelimiter.length();
        }
        int endMarker = source.indexOf(endingDelimiter, startEndSearchAt);
        String subString = source.substring(beginMarker + startingDelimiter.length(), endMarker);
        return subString;
    }

    public static String setInField(String string, int fieldLength, char filler, int justify) {
        boolean leftRightToggle = true;
        while (((String)string).length() < fieldLength) {
            switch (justify) {
                case 0: {
                    string = filler + (String)string;
                    break;
                }
                case 1: {
                    string = (String)string + filler;
                    break;
                }
                case 2: {
                    string = leftRightToggle ? filler + (String)string : (String)string + filler;
                    boolean bl = leftRightToggle = !leftRightToggle;
                }
            }
        }
        return string;
    }

    public static String capitalize(String source) {
        return source.toUpperCase().charAt(0) + source.substring(1);
    }

    public static String toNameCase(String string) {
        if (StringUtility.isEmpty(string)) {
            return string;
        }
        char[] chars = string.toLowerCase().toCharArray();
        char[] newChars = new char[chars.length];
        boolean afterSpace = true;
        int i = 0;
        while (i < chars.length) {
            if (Character.isWhitespace(chars[i]) || Comparison.isIn(chars[i], CharacterUtility.PUNCTUATION_CHARACTERS)) {
                afterSpace = true;
                newChars[i] = chars[i];
            } else if (afterSpace) {
                newChars[i] = Character.isLetter(chars[i]) ? (char)(chars[i] - 32) : chars[i];
                afterSpace = false;
            } else {
                newChars[i] = chars[i];
            }
            ++i;
        }
        return new String(newChars);
    }

    public static String americanSoundexOf(String string) {
        if (string == null) {
            return null;
        }
        if (string.trim().length() == 0) {
            return "0000";
        }
        string = string.toUpperCase();
        char[] output = new char[]{string.charAt(0), '0', '0', '0'};
        char[] input = string.substring(1).toCharArray();
        int lastCode = 0;
        int charCode = 0;
        int outputIndex = 1;
        int i = 0;
        while (i < input.length && outputIndex < 4) {
            switch (input[i]) {
                case 'A': 
                case 'E': 
                case 'H': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'W': 
                case 'Y': {
                    charCode = 48;
                    break;
                }
                case 'B': 
                case 'F': 
                case 'P': 
                case 'V': {
                    charCode = 49;
                    break;
                }
                case 'C': 
                case 'G': 
                case 'J': 
                case 'K': 
                case 'Q': 
                case 'S': 
                case 'X': 
                case 'Z': {
                    charCode = 50;
                    break;
                }
                case 'D': 
                case 'T': {
                    charCode = 51;
                    break;
                }
                case 'L': {
                    charCode = 52;
                    break;
                }
                case 'M': 
                case 'N': {
                    charCode = 53;
                    break;
                }
                case 'R': {
                    charCode = 54;
                }
            }
            if (charCode != lastCode && charCode != 48) {
                output[outputIndex++] = charCode;
            }
            lastCode = charCode;
            ++i;
        }
        return new String(output);
    }

    public static String wordWrap(String string, int maxRightColumn) {
        StringBuilder sb = new StringBuilder();
        int stringLength = 0;
        int offset = 0;
        char[] chars = " ,.?{}()<>[]|*&^%$#@!".toCharArray();
        while ((stringLength = string.length()) >= maxRightColumn) {
            offset = stringLength > maxRightColumn ? maxRightColumn : stringLength;
            int[] lastIx = new int[chars.length];
            int i = 0;
            while (i < chars.length) {
                lastIx[i] = string.lastIndexOf(chars[i], offset);
                ++i;
            }
            int lastSpace = MathExt.getMaximumOf(lastIx);
            if (lastSpace > -1) {
                sb.append(string.substring(0, lastSpace));
                sb.append("\n");
                string = string.substring(lastSpace + 1);
            } else {
                sb.append(string.substring(0, maxRightColumn >= stringLength ? stringLength : maxRightColumn));
                sb.append("\n");
                string = string.substring(maxRightColumn >= stringLength ? stringLength : maxRightColumn);
            }
            if (offset < stringLength) continue;
        }
        if (string.length() > 0) {
            sb.append(string);
        }
        return sb.toString();
    }

    public static String substring(String source, String regex) {
        return StringUtility.substring(source, Pattern.compile(regex), 0, 0);
    }

    public static String substring(String source, Pattern pattern) {
        return StringUtility.substring(source, pattern, 0, 0);
    }

    public static String substring(String source, String regex, int group) {
        return StringUtility.substring(source, Pattern.compile(regex), 0, group);
    }

    public static String substring(String source, Pattern pattern, int group) {
        return StringUtility.substring(source, pattern, 0, group);
    }

    public static String substring(String source, String regex, int start, int group) {
        return StringUtility.substring(source, Pattern.compile(regex), start, group);
    }

    public static String substring(String source, Pattern pattern, int start, int group) {
        Matcher matcher = pattern.matcher(source);
        matcher.find(start);
        return matcher.group(group);
    }

    public static String trim(String source, String chars) {
        if (source == null || chars == null || chars.length() == 0) {
            return source;
        }
        return StringUtility.trim(source, chars.toCharArray());
    }

    public static String trim(String source, char[] chars) {
        String leftTrimmed = StringUtility.trimLeft(source, chars);
        return StringUtility.trimRight(leftTrimmed, chars);
    }

    public static String trimLeft(String source, String chars) {
        if (source == null || chars == null || chars.length() == 0) {
            return source;
        }
        return StringUtility.trimLeft(source, chars.toCharArray());
    }

    public static String trimLeft(String source, char[] chars) {
        if (source == null || chars == null || chars.length == 0) {
            return source;
        }
        char[] sourceChars = source.toCharArray();
        StringBuilder sb = new StringBuilder();
        boolean justAppend = false;
        int i = 0;
        while (i < sourceChars.length) {
            if (justAppend) {
                sb.append(sourceChars[i]);
            } else if (!Comparison.isIn(sourceChars[i], chars)) {
                sb.append(sourceChars[i]);
                justAppend = true;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String trimRight(String source, String chars) {
        if (source == null || chars == null || chars.length() == 0) {
            return source;
        }
        return StringUtility.trimRight(source, chars.toCharArray());
    }

    public static String trimRight(String source, char[] chars) {
        if (source == null || chars == null || chars.length == 0) {
            return source;
        }
        char[] sourceChars = source.toCharArray();
        StringBuilder sb = new StringBuilder();
        boolean justAppend = false;
        int i = sourceChars.length - 1;
        while (i >= 0) {
            if (justAppend) {
                sb.append(sourceChars[i]);
            } else if (!Comparison.isIn(sourceChars[i], chars)) {
                sb.append(sourceChars[i]);
                justAppend = true;
            }
            --i;
        }
        return sb.reverse().toString();
    }

    public static String substringBefore(String source, String subString) {
        int substringPos = source.indexOf(subString);
        if (substringPos == -1) {
            return source;
        }
        return source.substring(0, substringPos);
    }

    public static String substringAfter(String source, String subString) {
        int substringPos = source.indexOf(subString);
        if (substringPos == -1) {
            return source;
        }
        return source.substring(substringPos + subString.length());
    }

    public static String replaceAllExcept(String source, String exceptionCharSet, String replacementString) {
        return StringUtility.replaceAllExcept(source, exceptionCharSet, replacementString, false);
    }

    public static String replaceAllExcept(String source, String exceptionCharSet, String replacementString, boolean coalesceDuplicateReplacements) {
        char[] sourceChars = source.toCharArray();
        char[] exceptionChars = exceptionCharSet.toCharArray();
        StringBuilder sb = new StringBuilder();
        char[] cArray = sourceChars;
        int n = sourceChars.length;
        int n2 = 0;
        while (n2 < n) {
            char sourceChar = cArray[n2];
            if (Comparison.isIn(sourceChar, exceptionChars)) {
                sb.append(sourceChar);
            } else {
                sb.append(replacementString);
            }
            ++n2;
        }
        return StringUtility.coalesce(sb.toString(), replacementString);
    }

    public static String remove(String source, String stringToRemove, int startingLocation) throws NullPointerException, IllegalArgumentException {
        if (StringUtility.isEmpty(source) || StringUtility.isEmpty(stringToRemove)) {
            throw new NullPointerException(String.format("StringUtility.remove(String source=%s, String stringToRemove=%s, int startingLocation=%d):  Neither source nor stringToRemove may be null.", source, stringToRemove, startingLocation));
        }
        if (startingLocation < 0 || startingLocation >= source.length()) {
            throw new IllegalArgumentException(String.format("StringUtility.remove(String source=%s, String stringToRemove=%s, int startingLocation=%d):  startingLocation is out of range.", source, stringToRemove, startingLocation));
        }
        int removeStart = source.indexOf(stringToRemove, startingLocation);
        if (removeStart < 0) {
            return source;
        }
        String leftSource = source.substring(0, removeStart);
        String rightSource = source.substring(removeStart + stringToRemove.length());
        return leftSource + rightSource;
    }

    public static String replaceAll(String source, char[] characters, char replacement) {
        if (StringUtility.isEmpty(source)) {
            return source;
        }
        char[] textChars = source.toCharArray();
        int i = 0;
        while (i < textChars.length) {
            if (Comparison.isIn(textChars[i], characters)) {
                textChars[i] = replacement;
            }
            ++i;
        }
        return new String(textChars);
    }

    public static String replaceAll(String source, String[] subStrings, String replacement) {
        if (StringUtility.isEmpty(source)) {
            return source;
        }
        String returnValue = source;
        int i = 0;
        while (i < subStrings.length) {
            returnValue = returnValue.replace(subStrings[i], replacement);
            ++i;
        }
        return returnValue;
    }

    public static String removeAll(String text, String charsToRemove) {
        if (text == null || charsToRemove == null) {
            return text;
        }
        char[] sourceChars = text.toCharArray();
        char[] badChars = charsToRemove.toCharArray();
        StringBuilder sb = new StringBuilder();
        char[] cArray = sourceChars;
        int n = sourceChars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Comparison.isIn(c, badChars)) {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String replaceAt(String text, String targetSubString, String replacement, int location) {
        String leftText = text.substring(0, location);
        int targetEnd = location + targetSubString.length();
        String rightText = text.substring(targetEnd);
        String targetText = text.substring(location, targetEnd);
        String newText = targetText.replace(targetSubString, replacement);
        String newString = String.format("%s%s%s", leftText, newText, rightText);
        return newString;
    }

    public static String removeAllExcept(String text, String allowedCharacters) {
        if (text == null || allowedCharacters == null) {
            return text;
        }
        char[] sourceChars = text.toCharArray();
        char[] allowedChars = allowedCharacters.toCharArray();
        StringBuilder sb = new StringBuilder();
        char[] cArray = sourceChars;
        int n = sourceChars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Comparison.isIn(c, allowedChars)) {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String getNthOfDelimited(String source, String delimiter) {
        return StringUtility.getNthOfDelimited(source, delimiter, -1);
    }

    public static String getNthOfDelimited(String source, String delimiter, int elementNumber) {
        switch (delimiter) {
            case "(": 
            case ")": 
            case ".": 
            case "[": 
            case "\\": 
            case "]": {
                delimiter = "\\" + (String)delimiter;
            }
        }
        String[] elements = source.split((String)delimiter);
        if (elements.length == 0) {
            return source;
        }
        if (elementNumber < 0) {
            elementNumber = elements.length - 1;
        }
        return elements[elementNumber];
    }

    public static ArrayList<String> toList(String source, String delimiter) {
        if (source == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtility.isEmpty(source)) {
            return list;
        }
        if (StringUtility.isEmpty(delimiter) || !source.contains(delimiter)) {
            list.add(source);
            return list;
        }
        String[] elements = source.split(delimiter);
        int i = 0;
        while (i < elements.length) {
            elements[i] = elements[i].trim();
            ++i;
        }
        CollectionUtility.addAll(elements, list);
        return list;
    }

    public static String getDelimitedString(Collection<?> list, String delimiter) {
        if (list == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Object o : list) {
            if (i > 0) {
                sb.append(delimiter);
            }
            if (o == null) {
                sb.append("--null--");
            } else {
                sb.append(o.toString());
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getDelimitedString(Object[] list, String delimiter) {
        if (list == null) {
            return null;
        }
        List<Object> objectList = Arrays.asList(list);
        return StringUtility.getDelimitedString(objectList, delimiter);
    }

    public static String getRegexMatchExpression(Collection<String> valueSet) {
        return StringUtility.getRegexMatchExpression(valueSet.toArray(new String[0]));
    }

    public static String getRegexMatchExpression(String ... valueSet) {
        if (ArrayUtility.isEmpty(valueSet)) {
            return ".*";
        }
        if (valueSet.length == 1) {
            return String.format("^%s$", valueSet[0]);
        }
        StringBuilder expression = new StringBuilder("(");
        String[] stringArray = valueSet;
        int n = valueSet.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (expression.length() > 1) {
                expression.append("|");
            }
            expression.append("^");
            expression.append(type);
            expression.append("$");
            ++n2;
        }
        expression.append(")");
        return expression.toString();
    }

    public static String getDisplayableTitle(String plainValue) {
        if (plainValue == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        char[] nameChars = plainValue.toCharArray();
        boolean lastCharIsUpper = false;
        boolean lastCharIsSpecial = false;
        int i = 0;
        while (i < nameChars.length) {
            char peek;
            char c = peek = i < nameChars.length - 1 ? nameChars[i + 1] : (char)'A';
            if (i == 0) {
                if (Character.isUpperCase(nameChars[i])) {
                    sb.append(nameChars[i]);
                } else {
                    sb.append((char)(nameChars[i] - 32));
                }
                lastCharIsUpper = true;
                lastCharIsSpecial = false;
            } else if (Comparison.isIn(nameChars[i], SPECIAL_CHARACTERS)) {
                sb.append(nameChars[i]);
                lastCharIsSpecial = true;
            } else if (Character.isUpperCase(nameChars[i])) {
                if (!(!Character.isLowerCase(peek) && lastCharIsUpper || lastCharIsSpecial)) {
                    sb.append(" ");
                }
                sb.append(nameChars[i]);
                lastCharIsUpper = true;
                lastCharIsSpecial = false;
            } else if (Character.isLowerCase(nameChars[i]) && lastCharIsSpecial) {
                sb.append((char)(nameChars[i] - 32));
                lastCharIsUpper = true;
                lastCharIsSpecial = false;
            } else {
                sb.append(nameChars[i]);
                lastCharIsUpper = false;
                lastCharIsSpecial = false;
            }
            ++i;
        }
        String title = sb.toString();
        return title;
    }

    public static String reverse(String string) {
        char[] in = string.toCharArray();
        char[] out = new char[in.length];
        int end = in.length - 1;
        int mid = in.length / 2;
        int i = 0;
        while (i <= mid) {
            out[i] = in[end - i];
            out[end - i] = in[i];
            ++i;
        }
        return new String(out);
    }

    public static String insertInto(String insertText, String targetText, int insertLocation) {
        StringBuilder sb = new StringBuilder(targetText);
        sb.insert(insertLocation, insertText);
        return sb.toString();
    }

    public static String pluralize(String source) {
        Object pluralizedForm = source;
        int sourceLength = source.length();
        String lcSource = source.toLowerCase();
        if (lcSource.endsWith("ion") || lcSource.endsWith("non")) {
            pluralizedForm = lcSource.endsWith("tion") ? (String)pluralizedForm + "s" : source.substring(0, sourceLength - 2) + "a";
        } else if (lcSource.endsWith("ss")) {
            pluralizedForm = source + "es";
        } else if (lcSource.endsWith("is")) {
            pluralizedForm = source.substring(0, sourceLength - 2) + "es";
        } else if (lcSource.endsWith("us")) {
            pluralizedForm = sourceLength <= 4 ? (String)pluralizedForm + "es" : source.substring(0, sourceLength - 2) + "i";
        } else if (lcSource.endsWith("s") && !lcSource.endsWith("es")) {
            char prevChar = lcSource.charAt(sourceLength - 2);
            if (Comparison.isIn(prevChar, CharacterUtility.VOWELS)) {
                pluralizedForm = (String)pluralizedForm + "es";
            }
        } else if (lcSource.endsWith("x") || lcSource.endsWith("z")) {
            pluralizedForm = (String)pluralizedForm + "es";
        } else if (lcSource.endsWith("sh") || lcSource.endsWith("ch")) {
            pluralizedForm = (String)pluralizedForm + "es";
        } else if (lcSource.endsWith("y")) {
            char beforeY = lcSource.charAt(sourceLength - 2);
            pluralizedForm = Comparison.isIn(beforeY, CharacterUtility.VOWELS) ? (String)pluralizedForm + "s" : source.substring(0, sourceLength - 1) + "ies";
        } else if (!lcSource.endsWith("s")) {
            pluralizedForm = (String)pluralizedForm + "s";
        }
        return pluralizedForm;
    }

    public static void main(String[] args) {
        String[] words = new String[]{"class", "criterion", "phenomenon", "axis", "oasis", "crisis", "lemon", "crayon", "salon", "bus", "box", "buzz", "wish", "watch", "fairy", "candy", "dummy", "way", "monkey", "toy", "guy", "fungus", "cactus", "stimulus", "bats", "bars"};
        StringUtility.showTest("pluralize(String source)");
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            String plural = StringUtility.pluralize(word);
            System.out.printf("Singular: %s, Plural: %s\n", word, plural);
            ++n2;
        }
        StringUtility.endTest("pluralize(String source)");
    }

    private static void showTest(String test) {
        System.out.printf("%s\nTesting %s\n%s\n", SEPARATOR, test, SEPARATOR);
    }

    private static void endTest(String test) {
        System.out.printf("%s\nEnd Testing of %s\n%s\n\n", SEPARATOR, test, SEPARATOR);
    }
}

