/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.beans.PropertyChangeNotifier;
import com.jmorgan.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;

public class ArrayListBean<E>
extends ArrayList<E>
implements PropertyChangeNotifier {
    private PropertyChangeSupport propertyChangeSupport;

    public ArrayListBean(int initialCapacity) {
        super(initialCapacity);
        this.standardConstructor();
    }

    public ArrayListBean() {
        this.standardConstructor();
    }

    public ArrayListBean(Collection<E> collection) {
        super(collection);
        this.standardConstructor();
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.propertyChangeSupport.fireIndexedPropertyChange("element", index, null, element);
    }

    @Override
    public boolean add(E element) {
        boolean result = super.add(element);
        this.propertyChangeSupport.firePropertyChange("element", null, element);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        ArrayList oldList = new ArrayList(this);
        boolean result = super.addAll(collection);
        if (result) {
            this.propertyChangeSupport.firePropertyChange("elements", oldList, this);
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        ArrayList oldList = new ArrayList(this);
        boolean result = super.addAll(index, collection);
        if (result) {
            this.propertyChangeSupport.fireIndexedPropertyChange("elements", index, oldList, this);
        }
        return result;
    }

    @Override
    public void clear() {
        ArrayList oldList = new ArrayList(this);
        super.clear();
        this.propertyChangeSupport.firePropertyChange("elements", oldList, this);
    }

    @Override
    public E remove(int index) {
        Object oldValue = super.remove(index);
        this.propertyChangeSupport.fireIndexedPropertyChange("element", index, oldValue, null);
        return oldValue;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = super.remove(o);
        if (result) {
            this.propertyChangeSupport.firePropertyChange("element", o, null);
        }
        return result;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ArrayList oldList = new ArrayList(this);
        super.removeRange(fromIndex, toIndex);
        this.propertyChangeSupport.fireIndexedPropertyChange("elements", fromIndex, oldList, this);
    }

    @Override
    public E set(int index, E newValue) {
        E oldValue = super.set(index, newValue);
        this.propertyChangeSupport.fireIndexedPropertyChange("element", index, oldValue, newValue);
        return oldValue;
    }

    private void standardConstructor() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

