/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.util.collection.CollectionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;

public abstract class CollectionSelector<E>
extends CollectionService<E> {
    private int maxResultSize;
    private int currentResultSize;
    private ArrayList<E> selection;

    protected CollectionSelector(Collection<? extends E> collection) throws NullPointerException {
        super(collection);
    }

    public Collection<E> getSelectedElements() {
        return this.getSelectedElements(0);
    }

    public synchronized Collection<E> getSelectedElements(int maxResultSize) {
        this.maxResultSize = maxResultSize;
        this.currentResultSize = 0;
        if (this.selection != null) {
            this.selection.clear();
            this.selection = null;
        }
        this.selection = new ArrayList();
        this.iterateCollection();
        return (Collection)this.selection.clone();
    }

    public synchronized E getSelectedElement(int elementNumber) throws IllegalArgumentException {
        if (elementNumber < 0) {
            throw new IllegalArgumentException(this.getClass().getName() + ".getSelectedElement(int elementNumber): The elementNumber cannot be negative.");
        }
        this.maxResultSize = elementNumber;
        this.currentResultSize = 0;
        this.selection = new ArrayList();
        this.iterateCollection();
        if (elementNumber >= this.selection.size()) {
            return null;
        }
        return this.selection.get(elementNumber);
    }

    @Override
    protected void processElement(E element) {
        if (this.maxResultSize > 0 && this.currentResultSize == this.maxResultSize) {
            return;
        }
        try {
            if (this.isElementSelected(element)) {
                this.selection.add(element);
                ++this.currentResultSize;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ConcurrentModificationException e) {
            this.selection.clear();
            this.iterateCollection();
        }
    }

    protected abstract boolean isElementSelected(E var1);

    public int getMaxResultSize() {
        return this.maxResultSize;
    }

    public void setMaxResultSize(int maxResultSize) {
        this.maxResultSize = maxResultSize;
    }
}

