/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.util.collection.CollectionExecutor;
import java.util.Collection;

public class MethodExecutor<E>
extends CollectionExecutor<E> {
    private String methodName;
    private Object[] methodParameters;
    private boolean synchronousExecution;

    public MethodExecutor(Collection<? extends E> collection, String methodName) throws NullPointerException {
        super(collection);
        this.setMethodName(methodName);
    }

    public MethodExecutor(Collection<? extends E> collection, String methodName, Object ... arguments) {
        this(collection, methodName);
        this.setMethodParameters(arguments);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Object[] getMethodParameters() {
        return this.methodParameters;
    }

    public void setMethodParameters(Object[] methodParameters) {
        this.methodParameters = methodParameters;
    }

    public boolean isSynchronousExecution() {
        return this.synchronousExecution;
    }

    public void setSynchronousExecution(boolean synchronousExecution) {
        this.synchronousExecution = synchronousExecution;
    }

    @Override
    protected void processElement(Object element) {
        if (this.methodParameters == null) {
            if (this.synchronousExecution) {
                new MethodInvoker(element, this.methodName, new Object[0]).invoke();
            } else {
                new AsynchMethodInvoker(element, this.methodName);
            }
        } else if (this.synchronousExecution) {
            new MethodInvoker(element, this.methodName, this.methodParameters).invoke();
        } else {
            new AsynchMethodInvoker(element, this.methodName, this.methodParameters);
        }
    }
}

