/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.beans.util.BeanService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PropertyIterator<BeanType, FieldType>
implements Iterator<FieldType> {
    private Collection<BeanType> beans;
    private String propertyName;
    private int index;

    public PropertyIterator(Collection<BeanType> beanList, String propertyName) {
        this.beans = beanList;
        this.propertyName = propertyName;
        this.index = -1;
    }

    public PropertyIterator(BeanType[] beanArray, String propertyName) {
        this(Arrays.asList(beanArray), propertyName);
    }

    @Override
    public boolean hasNext() {
        return this.index < this.beans.size() - 1;
    }

    @Override
    public FieldType next() throws NoSuchElementException {
        ++this.index;
        if (this.index == this.beans.size()) {
            throw new NoSuchElementException();
        }
        Object[] beanArray = this.beans.toArray();
        Object bean = beanArray[this.index];
        Object field = BeanService.getPropertyValue(bean, this.propertyName);
        return (FieldType)field;
    }

    @Override
    public void remove() throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("PropertyIterator cannot remove a single field from an element.");
    }
}

