/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Pair;
import com.jmorgan.util.collection.CollectionSelector;
import com.jmorgan.util.comparator.AnyObjectComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Pattern;

public class PropertyValueSelector<E>
extends CollectionSelector<E> {
    public static final int IS_EQUAL_TO = 0;
    public static final int IS_NOT_EQUAL_TO = 1;
    public static final int IS_GREATER_THAN = 2;
    public static final int IS_LESS_THAN = 3;
    public static final int IS_GREATER_THAN_OR_EQUAL_TO = 4;
    public static final int IS_LESS_THAN_OR_EQUAL_TO = 5;
    public static final int STARTS_WITH = 6;
    public static final int ENDS_WITH = 7;
    public static final int CONTAINS = 8;
    public static final int IS_IN = 9;
    public static final int IS_NOT_IN = 10;
    public static final int MATCHES = 11;
    public static final int NOT_MATCHES = 12;
    public static final int IS_NULL = 100;
    public static final int IS_NOT_NULL = 101;
    private HashMap<String, Pair<Object, Integer>> valueMap = new HashMap();
    private AnyObjectComparator comparator = new AnyObjectComparator(1);

    public PropertyValueSelector(Collection<? extends E> collection) throws NullPointerException {
        super(collection);
    }

    public PropertyValueSelector(Collection<? extends E> collection, String propertyName, Object value) throws NullPointerException {
        this(collection);
        this.addPropertyValueMap(propertyName, value);
    }

    public void addPropertyValueMap(String propertyName, Object value) {
        this.addPropertyValueMap(propertyName, value, 0);
    }

    public void addPropertyValueMap(String propertyName, Object value, int comparisonType) {
        if (propertyName == null) {
            throw new IllegalArgumentException("The property name cannot be null in PropertyValueSelector.addPropertyValueMap()");
        }
        if (!PropertyValueSelector.validateComparisonType(comparisonType)) {
            throw new IllegalArgumentException("The value for comparisonType for PropertyValueSelector.addPropertyValueMap() is not valid.");
        }
        this.valueMap.put(propertyName, new Pair<Object, Integer>(value, comparisonType));
    }

    private static boolean validateComparisonType(int comparisonType) {
        return Comparison.isBetween(comparisonType, 0, 12) || Comparison.isBetween(comparisonType, 100, 101);
    }

    public void removePropertyValueMap(String propertyName) {
        this.valueMap.remove(propertyName);
    }

    public void clearMap() {
        this.valueMap.clear();
    }

    @Override
    protected boolean isElementSelected(E element) {
        if (element == null) {
            throw new NullPointerException("PropertyValueSelector.isElementSelected(E element):  The element cannot be null.");
        }
        if (this.valueMap.size() == 0) {
            return false;
        }
        block15: for (String key : this.valueMap.keySet()) {
            Pair<Object, Integer> valuePair = this.valueMap.get(key);
            Object value = valuePair.first;
            int comparisonType = (Integer)valuePair.second;
            Object eValue = BeanService.getPropertyValue(element, key);
            String stringValue = null;
            switch (comparisonType) {
                case 0: {
                    if (value == null || value.equals(eValue)) continue block15;
                    return false;
                }
                case 1: {
                    if (value == null || !value.equals(eValue)) continue block15;
                    return false;
                }
                case 2: {
                    if (this.comparator.compare(value, eValue) < 0) break;
                    return false;
                }
                case 3: {
                    if (this.comparator.compare(value, eValue) > 0) break;
                    return false;
                }
                case 4: {
                    if (this.comparator.compare(value, eValue) <= 0) break;
                    return false;
                }
                case 5: {
                    if (this.comparator.compare(value, eValue) >= 0) break;
                    return false;
                }
                case 6: {
                    stringValue = eValue.toString();
                    if (stringValue.startsWith(String.valueOf(value))) break;
                    return false;
                }
                case 7: {
                    stringValue = eValue.toString();
                    if (stringValue.endsWith(String.valueOf(value))) break;
                    return false;
                }
                case 8: {
                    stringValue = eValue.toString();
                    if (stringValue.contains(String.valueOf(value))) break;
                    return false;
                }
                case 9: 
                case 10: {
                    if (value == null) {
                        return false;
                    }
                    ArrayList<Object> arrayElements = new ArrayList<Object>();
                    if (value.getClass().isArray()) {
                        arrayElements.addAll(Arrays.asList((Object[])value));
                    } else if (value instanceof Collection) {
                        arrayElements.addAll((Collection)value);
                    }
                    for (Object e : arrayElements) {
                        boolean match = e.equals(eValue);
                        if (match && comparisonType == 10) {
                            return false;
                        }
                        if (!match || comparisonType != 9) continue;
                        return true;
                    }
                    if (comparisonType != 9) break;
                    return false;
                }
                case 11: 
                case 12: {
                    if (value == null && eValue == null && comparisonType == 11) {
                        return true;
                    }
                    if (value == null || eValue == null) {
                        return false;
                    }
                    stringValue = eValue.toString();
                    boolean bl = Pattern.matches((String)value, stringValue);
                    if (bl && comparisonType == 12) {
                        return false;
                    }
                    if (bl || comparisonType != 11) continue block15;
                    return false;
                }
                case 100: {
                    if (eValue == null) break;
                    return false;
                }
                case 101: {
                    if (eValue != null) break;
                    return false;
                }
            }
        }
        return true;
    }
}

