/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.util.collection.OrderedSet;
import com.jmorgan.util.collection.UniqueArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;

public final class Sets {
    private Sets() {
    }

    @SafeVarargs
    public static <T> Set<T> toSet(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    public static <T> Set<T> toSet(Collection<T> list) {
        UniqueArrayList<T> ual = new UniqueArrayList<T>(list);
        return new HashSet<T>(ual);
    }

    @SafeVarargs
    public static <T> Set<T> union(Set<T> ... sets) {
        HashSet<T> union = new HashSet<T>();
        if (sets == null) {
            return union;
        }
        Set<T>[] setArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            Set<T> set = setArray[n2];
            union.addAll(set);
            ++n2;
        }
        return union;
    }

    public static <T extends Comparable<? super T>> SortedSet<T> sort(Set<T> set) {
        return Sets.sortSet(set, null);
    }

    public static <T extends Comparable<? super T>> SortedSet<T> sort(Set<T> set, Comparator<T> comparator) {
        return Sets.sortSet(set, comparator);
    }

    private static <T extends Comparable<? super T>> SortedSet<T> sortSet(Set<T> set, Comparator<T> comparator) {
        OrderedSet<T> orderedSet = new OrderedSet<T>(set);
        orderedSet.setComparator(comparator);
        return orderedSet;
    }
}

