/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.util.collection.ListElementRemovalListener;
import com.jmorgan.util.collection.ListNotUniqueException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public class UniqueArrayList<E>
extends ArrayList<E> {
    public static final boolean UNIQUE_ASSURANCE_ENABLED = true;
    public static final boolean UNIQUE_ASSURANCE_DISABLED = false;
    private boolean uniqueAssurance = true;
    private long lastCollectionAddCount = 0L;
    private boolean allowNulls = true;

    public UniqueArrayList() {
    }

    public UniqueArrayList(Collection<? extends E> c) {
        this.addAll(c);
    }

    public UniqueArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public void sort() {
        this.sort(null);
    }

    @Override
    public void sort(Comparator<? super E> c) {
        try {
            this.setUniqueAssurancePolicy(false);
            super.sort(c);
            this.setUniqueAssurancePolicy(true);
        }
        catch (ListNotUniqueException e) {
            e.printStackTrace();
        }
    }

    public boolean getUniqueAssurance() {
        return this.uniqueAssurance;
    }

    public void setUniqueAssurancePolicy(boolean policy) throws ListNotUniqueException {
        if (!this.uniqueAssurance && policy && !this.isUnique()) {
            throw new ListNotUniqueException("List is not unique", this);
        }
        this.uniqueAssurance = policy;
    }

    public boolean areNullsAllowed() {
        return this.allowNulls;
    }

    public void setAllowNulls(boolean allowNulls) {
        if (this.allowNulls && !allowNulls) {
            this.removeNullValues();
        }
        this.allowNulls = allowNulls;
    }

    public synchronized void removeNullValues() {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object e = i.next();
            if (e != null) continue;
            i.remove();
        }
    }

    public void ensureUniqueness() {
        this.ensureUniqueness(null);
    }

    public void ensureUniqueness(ListElementRemovalListener listener) {
        Object[] arr = this.toArray();
        Object[] toBeRemoved = new Object[arr.length];
        int j = 0;
        int i = 0;
        while (i < arr.length) {
            if (this.contains(arr[i])) {
                toBeRemoved[j++] = arr[i];
            }
            ++i;
        }
        i = 0;
        while (i < j) {
            this.remove(toBeRemoved[i]);
            if (listener != null) {
                listener.elementRemoved(toBeRemoved[i]);
            }
            ++i;
        }
    }

    public boolean isUnique() {
        Object[] arr = this.toArray();
        int i = 0;
        int top = arr.length - 1;
        while (i < top) {
            int j = i + 1;
            while (j < arr.length) {
                if (arr[i] == null && arr[j] == null) {
                    return false;
                }
                if (arr[i] == null && arr[j] != null) {
                    return true;
                }
                if (arr[i] != null && arr[j] == null) {
                    return true;
                }
                if (arr[i].equals(arr[j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean add(E o) {
        if (this.uniqueAssurance && this.contains(o)) {
            return false;
        }
        if (o == null && !this.allowNulls) {
            return false;
        }
        return super.add(o);
    }

    @Override
    public void add(int index, E element) {
        if (this.uniqueAssurance && this.contains(element)) {
            throw new IllegalArgumentException(String.valueOf(element) + " duplicates an element already contained in this list.");
        }
        if (element == null && !this.allowNulls) {
            return;
        }
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int addCount = 0;
        if (c == this) {
            return false;
        }
        for (E e : c) {
            if (!this.add(e)) continue;
            ++addCount;
        }
        this.lastCollectionAddCount = addCount;
        return addCount > 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        long addCount = 0L;
        for (E e : c) {
            this.add(index, e);
        }
        this.lastCollectionAddCount = addCount;
        return addCount > 0L;
    }

    public long getLastCollectionAddCount() {
        return this.lastCollectionAddCount;
    }

    @Override
    public E set(int index, E element) {
        Object currentItem = this.get(index);
        if (currentItem == null || currentItem.equals(element)) {
            return super.set(index, element);
        }
        if (this.uniqueAssurance && this.contains(element)) {
            throw new IllegalArgumentException("Changing the element at " + index + " to " + String.valueOf(element) + " would prevent the list from being unique.");
        }
        return super.set(index, element);
    }
}

