/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.comparator;

import com.jmorgan.util.NumberUtility;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.comparator.FileComparator;
import java.io.File;

public class FileNameComparator
extends FileComparator {
    private boolean useAbsolutePath = true;
    private boolean sortNumericalNamesAsNumbers = true;

    public boolean isUseAbsolutePath() {
        return this.useAbsolutePath;
    }

    public void setUseAbsolutePath(boolean useAbsolutePath) {
        this.useAbsolutePath = useAbsolutePath;
    }

    public boolean isSortNumericalNamesAsNumbers() {
        return this.sortNumericalNamesAsNumbers;
    }

    public void setSortNumericalNamesAsNumbers(boolean sortNumericalNamesAsNumbers) {
        this.sortNumericalNamesAsNumbers = sortNumericalNamesAsNumbers;
    }

    @Override
    public int compare(File f1, File f2) {
        if (f1 == null && f2 == null) {
            return 0;
        }
        if (f1 == null && f2 != null) {
            return -1;
        }
        if (f2 == null && f1 != null) {
            return 1;
        }
        if (this.useAbsolutePath) {
            String f1AbsolutePath = f1.getAbsolutePath();
            String f2AbsolutePath = f2.getAbsolutePath();
            return f1AbsolutePath.compareTo(f2AbsolutePath);
        }
        String f1Name = StringUtility.substringBefore(f1.getName(), ".");
        String f2Name = StringUtility.substringBefore(f2.getName(), ".");
        if (this.sortNumericalNamesAsNumbers && NumberUtility.isNumber(f1Name) && NumberUtility.isNumber(f2Name)) {
            if (f1Name.contains(".") || f2Name.contains(".")) {
                double f1d = Double.parseDouble(f1Name);
                double f2d = Double.parseDouble(f2Name);
                return (int)(f1d - f2d);
            }
            long f1L = Long.parseLong(f1Name);
            long f2L = Long.parseLong(f2Name);
            return (int)(f1L - f2L);
        }
        return f1Name.compareTo(f2Name);
    }
}

