/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.comparator;

import com.jmorgan.util.comparator.AbstractStringComparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexComparator
extends AbstractStringComparator {
    private Pattern pattern;

    public RegexComparator() {
    }

    public RegexComparator(String regex) {
        this(Pattern.compile(regex));
    }

    public RegexComparator(Pattern pattern) {
        this();
        this.setPattern(pattern);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(String regex) {
        if (regex == null) {
            this.pattern = null;
        } else {
            this.setPattern(Pattern.compile(regex));
        }
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public int compare(String s1, String s2) {
        if (this.pattern == null) {
            throw new IllegalStateException("RegexComparator.compare():  The Pattern is null");
        }
        Matcher matcher1 = this.pattern.matcher(s1);
        Matcher matcher2 = this.pattern.matcher(s2);
        if (!matcher1.matches() || !matcher2.matches()) {
            return s1.compareTo(s2);
        }
        matcher1.find();
        String match1 = s1.substring(matcher1.start(), matcher1.end());
        matcher2.find();
        String match2 = s2.substring(matcher2.start(), matcher2.end());
        return match1.compareTo(match2);
    }
}

