/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.logging;

import com.jmorgan.lang.Application;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LMG {
    private LMG() {
    }

    public static void log(Logger logger, Level logLevel, String messageFormat, Object ... values) {
        Supplier[] valueSuppliers = new Supplier[values.length];
        int i = 0;
        while (i < values.length) {
            int index = i;
            valueSuppliers[i] = () -> values[index];
            ++i;
        }
        logger.log(logLevel, () -> LMG.log(messageFormat, valueSuppliers));
    }

    public static String log(String messageFormat, Supplier<?> ... arguments) {
        Object[] outputs = new Object[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            outputs[i] = arguments[i].get();
            ++i;
        }
        return String.format(messageFormat, outputs);
    }

    public static void log(Level logLevel, String message) {
        Logger logger;
        Application application = Application.getApplication();
        if (application != null && (logger = application.getApplicationLogger()) != null) {
            logger.log(logLevel, message);
            return;
        }
        if (logLevel.intValue() < Level.WARNING.intValue()) {
            System.out.println(message);
        } else {
            System.err.println(message);
        }
    }
}

