/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.app;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.IPAddress;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.beans.util.StringToBigIntegerConverter;
import com.jmorgan.beans.util.StringToIPAddressConverter;
import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.ApplicationProperties;
import com.jmorgan.lang.ApplicationServices;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.ExceptionListenerClient;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.DataPowerStatusCache;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.KumbaCoreApplicationParameters;
import com.kumbasoft.core.beans.status.StatusFirmwareVersion3;
import com.kumbasoft.core.tools.CreatePropertyMapForFirmwareVersion;
import com.kumbasoft.core.tools.DataPowerFileReader;
import com.kumbasoft.core.tools.DataPowerStatusMonitor;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.core.util.logging.AuditLogHandler;
import com.kumbasoft.core.util.logging.FinestLogHandler;
import com.kumbasoft.core.util.security.LicenseInformation;
import com.kumbasoft.core.util.security.SecurityManager;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public abstract class KumbaCoreApplicationServices<ApplicationType extends Application, ApplicationPropertiesType extends KumbaCoreApplicationProperties, ApplicationParametersType extends KumbaCoreApplicationParameters>
extends ApplicationServices {
    public static final String[] XML_MANAGEMENT_FILES = new String[]{"xml-mgmt.wsdl", "xml-mgmt-base.xsd", "xml-mgmt-ops.xsd", "xml-mgmt.xsd", "xml-mgmt-b2b.xsd"};
    protected static Logger applicationLogger;
    protected ApplicationType application;
    protected ApplicationPropertiesType applicationProperties;
    protected ApplicationParametersType parameters;
    protected FinestLogHandler finestLogHandler;
    protected boolean configFileExists;

    static {
        BeanService.addCoercionMap(BigInteger.class, new StringToBigIntegerConverter());
        BeanService.addCoercionMap(IPAddress.class, new StringToIPAddressConverter());
    }

    public static String getLogonMessage(String extension) {
        String logonMessageLocalFileName = String.format("LogonMessage.%s", extension);
        File logonMessageFile = new File(logonMessageLocalFileName);
        if (!logonMessageFile.exists()) {
            try {
                String defaultLogonMessage = FileUtility.readFile(String.format("/configs/DefaultLogonMessage.%s", extension));
                new ASCFileWriter(logonMessageFile, defaultLogonMessage);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String logonMessageLabel = "ERROR";
        try {
            logonMessageLabel = FileUtility.readFile(new File(logonMessageLocalFileName));
        }
        catch (IOException e) {
            logonMessageLabel = LabelUtility.wrapInHTML("Authorized Access Only");
        }
        return logonMessageLabel;
    }

    public ApplicationType getApplication() {
        return this.application;
    }

    public void setApplication(ApplicationType kumbaApplication) {
        this.application = kumbaApplication;
        new AsynchMethodInvoker((Object)this, "waitForLogger");
    }

    @Reflected
    private void waitForLogger() {
        while (applicationLogger == null) {
            applicationLogger = ((Application)this.application).getApplicationLogger();
            ThreadUtility.sleep(50L);
        }
    }

    public void processArguments(String[] args) {
        int maxThreads;
        KumbaCoreConstants.MAX_THREADS = maxThreads = this.parameters == null ? KumbaCoreConstants.MAX_THREADS : ((KumbaCoreApplicationParameters)this.parameters).getMaxThreads();
    }

    public ApplicationParametersType getParameters() {
        return this.parameters;
    }

    public void setParameters(ApplicationParametersType parameters) {
        this.parameters = parameters;
    }

    public String getPropertiesFileName(String applicationClassName) {
        return String.format("/configs/%sProperties.xml", applicationClassName);
    }

    public ApplicationPropertiesType getApplicationProperties() {
        return this.applicationProperties;
    }

    public void loadProperties(String propertiesFileName, ApplicationProperties applicationProperties) {
        InputStream in = this.getClass().getResourceAsStream(propertiesFileName);
        if (in == null) {
            System.err.printf("KumbaCoreApplication.loadProperties(propertiesFileName=%s, applicationProperties):\n", propertiesFileName);
        }
        XMLDecoder decoder = new XMLDecoder(in);
        ApplicationProperties appProps = (ApplicationProperties)decoder.readObject();
        decoder.close();
        ((Application)this.application).setAttribute("Application.propertiesFileName", propertiesFileName);
        ((Application)this.application).setApplicationProperties(appProps);
        this.setApplicationProperties((KumbaCoreApplicationProperties)appProps);
    }

    public void setApplicationProperties(ApplicationPropertiesType kumbaApplicationProperties) {
        this.applicationProperties = kumbaApplicationProperties;
    }

    public String getApplicationLogFileName(String baseAppicationLogFileName) {
        return "./logs/" + baseAppicationLogFileName;
    }

    public void setApplicationLogging(String appLogFileName) {
        this.finestLogHandler = new FinestLogHandler();
        ((Application)this.application).getApplicationLogger().addHandler(AuditLogHandler.getInstance());
    }

    protected void logon() {
        String initConfigFileName;
        File configFile;
        File configDirectory = new File("configs");
        if (!configDirectory.exists()) {
            configDirectory.mkdirs();
        }
        if (!(configFile = new File(initConfigFileName = ((KumbaCoreApplicationProperties)this.applicationProperties).getInitConfigFile())).exists()) {
            String warningMessage = String.format("%s.logon():  Init Config File not found.  First time running?", this.getClass().getSimpleName());
            applicationLogger.warning(warningMessage);
            this.configFileExists = false;
        } else {
            this.configFileExists = true;
        }
        LicenseInformation licenseInformation = new LicenseInformation();
        SecurityManager.setExtraCharacters(licenseInformation.getPasswordSalt().toCharArray());
        if (!this.doLogon()) {
            System.exit(0);
        }
        new AsynchMethodInvoker((Object)this, "loadCLIObjectNameMap");
    }

    public boolean doLogon() {
        applicationLogger.finer("(): Starting.");
        ApplicationParametersType parameters = this.getParameters();
        String userName = ((KumbaCoreApplicationParameters)parameters).getUserName();
        String password = ((KumbaCoreApplicationParameters)parameters).getPassword();
        if (StringUtility.isNotEmpty(userName) && StringUtility.isNotEmpty(password)) {
            applicationLogger.finer("(): Username and password supplied  Reading credentials.");
            SecurityManager.setUserSuppliedCredentials(userName.toCharArray(), password.toCharArray());
            boolean logonValid = SecurityManager.readInitConfigData();
            ((KumbaCoreApplicationParameters)parameters).setUserName(null);
            ((KumbaCoreApplicationParameters)parameters).setPassword(null);
            ((Application)this.application).setAttribute("openApplianceManagementOnStartup", false);
            applicationLogger.finer(() -> LMG.log("(): Done.  Returning %b.", () -> logonValid));
            return logonValid;
        }
        applicationLogger.finer("(): Done.  Returning false.");
        return false;
    }

    public ArrayList<Appliance> getAppliances() {
        applicationLogger.finer("(): Starting.");
        ArrayList appliances = (ArrayList)((Application)this.application).getAttribute("Appliances");
        int numberOfTries = 0;
        while (CollectionUtility.isEmpty(appliances)) {
            applicationLogger.finer("():  No appliances yet.  Giving system some time to load them.");
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
            appliances = (ArrayList)((Application)this.application).getAttribute("Appliances");
            if (++numberOfTries == 20) break;
        }
        if (appliances != null) {
            int applianceCount = appliances.size();
            applicationLogger.finer(() -> LMG.log("(): Done.  Returning %d appliances.", () -> applianceCount));
        } else {
            applicationLogger.finer("():  No appliances found.  First time?");
        }
        return appliances;
    }

    public void cleanupTemporaryFiles() {
        applicationLogger.finer("(): Starting");
        String certificateFilesDirectoryName = ((KumbaCoreApplicationProperties)this.applicationProperties).getCertificateFileDirectory();
        String temporaryDirectoryName = ((KumbaCoreApplicationProperties)this.applicationProperties).getTemporaryDirectory();
        try {
            applicationLogger.fine(() -> LMG.log("(): Cleaning certificate files directory: '%s'.", () -> certificateFilesDirectoryName));
            FileUtils.cleanDirectory(new File(certificateFilesDirectoryName));
            applicationLogger.fine(() -> LMG.log("(): Cleaning up temporary files: '%s'.", () -> temporaryDirectoryName));
            FileUtils.cleanDirectory(new File(temporaryDirectoryName));
        }
        catch (IllegalArgumentException e) {
            applicationLogger.severe(() -> LMG.log("Illegal Argument Exception Occurred:\n\t%s", () -> e.getMessage()));
        }
        catch (IOException e) {
            applicationLogger.severe(() -> LMG.log("I/O Exception Occurred:\n\t%s", () -> e.getMessage()));
        }
        applicationLogger.finer("(): Done");
    }

    @Reflected
    protected void createFirmwareMetaData(ArrayList<Appliance> appliances) {
        applicationLogger.finer("(appliances):  Starting");
        String firmwareMetaDataDirectoryName = ((KumbaCoreApplicationProperties)this.applicationProperties).getFirmwareMetaDataDirectory();
        applicationLogger.finer(() -> LMG.log("(appliances):  Firmware Metadata Directory Name: %s", () -> firmwareMetaDataDirectoryName));
        File firmwareMetaDataBaseDirectory = new File(firmwareMetaDataDirectoryName);
        applicationLogger.finer(() -> LMG.log("(appliances):  Firmware Metadata Directory Exists? %b", () -> firmwareMetaDataBaseDirectory.exists()));
        applicationLogger.finer("(appliances):  Getting Firmware Version for all appliances");
        for (Appliance appliance : appliances) {
            new AsynchMethodInvoker((Object)this, "createFirmwareMetaData", new Object[]{appliance, firmwareMetaDataBaseDirectory, 0});
            ThreadUtility.sleep(1000L);
        }
    }

    @Reflected
    protected void createFirmwareMetaData(Appliance appliance, File firmwareMetaDataBaseDirectory, int attempt) {
        String loggerPrefix = String.format("(appliance=%s, firmwareMetaDataBaseDirectory, attempt=%d):  ", appliance.getName(), attempt);
        applicationLogger.finer(() -> LMG.log("%sStarting", () -> loggerPrefix));
        if (!appliance.isActive()) {
            applicationLogger.info(() -> LMG.log("%sAppliance not active.  Not going to try.", () -> loggerPrefix));
            return;
        }
        if (attempt >= 10) {
            applicationLogger.severe(() -> LMG.log("%sNot connected after 10 attempts.  Giving up on this appliance.", () -> loggerPrefix));
            return;
        }
        if (!appliance.isConnected()) {
            applicationLogger.warning(() -> LMG.log("%sAppliance not connected", () -> loggerPrefix));
            new AsynchMethodInvoker((Object)this, "createFirmwareMetaData", new Object[]{appliance, firmwareMetaDataBaseDirectory, ++attempt}, KumbaCoreConstants.RETRY_INTERVAL);
            return;
        }
        Domain defaultDomain = appliance.getDomain("default");
        if (defaultDomain == null) {
            applicationLogger.warning(() -> LMG.log("%sDefault domain for appliance is null.  How?  Maybe new or lost?", () -> loggerPrefix));
            new AsynchMethodInvoker((Object)this, "createFirmwareMetaData", new Object[]{appliance, firmwareMetaDataBaseDirectory, ++attempt}, KumbaCoreConstants.RETRY_INTERVAL);
            return;
        }
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        DataPowerStatusCache firmwareStatusCache = new DataPowerStatusCache();
        DataPowerStatusMonitor domainStatusMonitor = new DataPowerStatusMonitor(appliance, defaultDomain, "FirmwareVersion3", 0L);
        domainStatusMonitor.getProcessThread().addInvocationListener(stil);
        domainStatusMonitor.addStatusListener(firmwareStatusCache);
        applicationLogger.finer(() -> LMG.log("%sWaiting for firmware versions to complete.", () -> loggerPrefix));
        boolean completedOnTime = stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
        if (completedOnTime) {
            applicationLogger.finer(() -> LMG.log("%sFirmware version completed on time.", () -> loggerPrefix));
        } else {
            applicationLogger.warning(() -> LMG.log("%sFirmware version status did not complete on time. Will see if we have it.", () -> loggerPrefix));
        }
        ArrayList firmwareVersions = firmwareStatusCache.getStatusCache();
        if (CollectionUtility.isEmpty(firmwareVersions)) {
            applicationLogger.warning(() -> LMG.log("%sDid not find firmware version status.  Retrying.", () -> loggerPrefix));
            new AsynchMethodInvoker((Object)this, "createFirmwareMetaData", new Object[]{appliance, firmwareMetaDataBaseDirectory, ++attempt}, KumbaCoreConstants.RETRY_INTERVAL);
            return;
        }
        StatusFirmwareVersion3 firmwareVersion = (StatusFirmwareVersion3)firmwareVersions.get(0);
        String version = this.cleanFirmwareVersion(firmwareVersion.getVersion());
        firmwareVersion.getAppliance().setFirmwareVersion(version);
        applicationLogger.finer(() -> LMG.log("%sProcessing Firmware Version %s", () -> loggerPrefix, () -> version));
        File firmwareMetaDataDirectory = new File(firmwareMetaDataBaseDirectory, version);
        if (firmwareMetaDataDirectory.exists()) {
            applicationLogger.finer(() -> LMG.log("%sDirectory exists Firmware Version %s.  Nothing to do.", () -> loggerPrefix, () -> version));
            return;
        }
        firmwareMetaDataDirectory.mkdirs();
        applicationLogger.fine(() -> LMG.log("%sNeed to create meta-data for Firmware Version %s", () -> loggerPrefix, () -> version));
        this.extractXMLManagementFiles(appliance, firmwareMetaDataBaseDirectory);
        applicationLogger.finer(() -> LMG.log("%sFinished", () -> loggerPrefix));
    }

    private String cleanFirmwareVersion(String firmwareVersion) {
        if ((firmwareVersion = StringUtility.removeAllExcept(firmwareVersion, "0123456789.")).startsWith(".")) {
            firmwareVersion = firmwareVersion.substring(1);
        }
        return firmwareVersion;
    }

    private void extractXMLManagementFiles(Appliance appliance, File firmwareMetaDataBaseDirectory) {
        String loggerPrefix = String.format("(appliance=%s, firmwareMetaDataBaseDirectory=%s): ", appliance.getName(), firmwareMetaDataBaseDirectory.getAbsolutePath());
        applicationLogger.finer(() -> LMG.log("%sStarting", () -> loggerPrefix));
        File temporaryDirectory = new File(((KumbaCoreApplicationProperties)this.applicationProperties).getTemporaryDirectory());
        temporaryDirectory.mkdirs();
        String applianceTemporaryDirectoryName = String.format("%s%sdefault%sFileSystem%sstore%s", appliance.getName(), File.separator, File.separator, File.separator, File.separator);
        File applianceTemporaryDirectory = new File(temporaryDirectory, applianceTemporaryDirectoryName);
        ArrayList<DataPowerFileInfo> xmlManagementFiles = new ArrayList<DataPowerFileInfo>(XML_MANAGEMENT_FILES.length);
        String[] stringArray = XML_MANAGEMENT_FILES;
        int n = XML_MANAGEMENT_FILES.length;
        int n2 = 0;
        while (n2 < n) {
            String xmlManagementFile = stringArray[n2];
            Domain defaultDomain = appliance.getDomain("default");
            applicationLogger.fine(() -> LMG.log("%sGetting %s - Writing to %s", () -> loggerPrefix, () -> xmlManagementFile, () -> temporaryDirectory.getAbsolutePath()));
            DataPowerFileInfo dpFileInfo = new DataPowerFileInfo(appliance, defaultDomain, null, 0L, "store:/", xmlManagementFile);
            xmlManagementFiles.add(dpFileInfo);
            ++n2;
        }
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        ConfigObjectCache fileCache = new ConfigObjectCache();
        DataPowerFileReader fileReader = new DataPowerFileReader(xmlManagementFiles);
        fileReader.getProcessThread().addInvocationListener(stil);
        fileReader.addConfigObjectSubscriber(DataPowerFileInfo.class, fileCache);
        applicationLogger.finer(() -> LMG.log("%sWaiting for all files to download.", () -> loggerPrefix));
        boolean completedOnTime = stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
        if (completedOnTime) {
            applicationLogger.finer(() -> LMG.log("%sAll files downloaded in time.  Writing files.", () -> loggerPrefix));
            Vector dataPowerFiles = fileCache.getObjectCache();
            for (DataPowerFileInfo fileInfo : dataPowerFiles) {
                String fileName = fileInfo.getFileName();
                File outputFile = new File(applianceTemporaryDirectory, fileName);
                FileUtility.writeFile(outputFile, fileInfo.getFileData());
            }
            applicationLogger.finer(() -> LMG.log("%sCreating meta data for firmware version %s.", () -> loggerPrefix, () -> appliance.getFirmwareVersion()));
            stil.clearCompletionStatus();
            CreatePropertyMapForFirmwareVersion mapCreator = new CreatePropertyMapForFirmwareVersion(appliance.getFirmwareVersion(), applianceTemporaryDirectory, firmwareMetaDataBaseDirectory);
            mapCreator.getProcessThread().addInvocationListener(stil);
            applicationLogger.finer(() -> LMG.log("%sWaiting for meta-data process to complete for firmware version %s.", () -> loggerPrefix, () -> appliance.getFirmwareVersion()));
            completedOnTime = stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT * 6);
            if (!completedOnTime) {
                applicationLogger.warning(() -> LMG.log("%sMeta-data processing for firmware version %s did not complete on time.  It may still complete.", () -> loggerPrefix, () -> appliance.getFirmwareVersion()));
            }
            applicationLogger.finer(() -> LMG.log("%sFinished\n", () -> loggerPrefix));
        } else {
            applicationLogger.severe(() -> LMG.log("%sDownload of files did not complete on time - cannot crate metadata for %s.", () -> loggerPrefix, () -> appliance.getFirmwareVersion()));
        }
    }

    @Reflected
    private void loadCLIObjectNameMap() {
        applicationLogger.finer("(): Starting.");
        ExceptionListenerClient exceptionListenerClient = new ExceptionListenerClient();
        ArrayList map = (ArrayList)FileUtility.readObject(((KumbaCoreApplicationProperties)this.applicationProperties).getCliMapFileName(), (ExceptionListener)exceptionListenerClient);
        if (exceptionListenerClient.hasException()) {
            Exception e = exceptionListenerClient.getException();
            applicationLogger.severe("(): Could not read CLI Name Map.  This is effectively fatal.");
        } else {
            ((Application)this.application).setAttribute("CLI Name Map", map);
        }
        applicationLogger.finer("(): Done.");
    }
}

