/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.app;

import com.jmorgan.lang.Application;
import com.jmorgan.lang.ExceptionListenerClient;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.beans.StatusProviderInfo;
import com.kumbasoft.core.util.FileUtility;
import java.beans.ExceptionListener;
import java.util.ArrayList;

public class KumbaCorePersistenceHandler {
    protected static Application application;
    protected static KumbaCoreApplicationProperties appProperties;
    private static String statusProvidersDefinitionFile;
    private static String statusProvidersFile;

    protected KumbaCorePersistenceHandler() {
    }

    protected static void loadApplicationConstants() {
        if (application == null) {
            application = Application.getApplication();
        }
        if (appProperties == null) {
            appProperties = (KumbaCoreApplicationProperties)application.getApplicationProperties();
        }
    }

    public static final ArrayList<StatusProviderInfo> readStatusProviderDefinitions() {
        KumbaCorePersistenceHandler.loadApplicationConstants();
        if (statusProvidersDefinitionFile == null) {
            statusProvidersDefinitionFile = appProperties.getStatusProviderDefinitionsFile();
        }
        if (statusProvidersFile == null) {
            statusProvidersFile = appProperties.getStatusProvidersFile();
        }
        ExceptionListenerClient exceptionListenerClient = new ExceptionListenerClient();
        ArrayList statusProviderInfo = (ArrayList)FileUtility.readObject(statusProvidersDefinitionFile, (ExceptionListener)exceptionListenerClient);
        if (exceptionListenerClient.hasException()) {
            new JMMessageBox(null, "Failed to read Status Provider Definitions", "Cannot Read Status Provider Definitions.");
        }
        return statusProviderInfo;
    }

    public static final ArrayList<StatusProviderInfo> readStatusProviderInfo() {
        KumbaCorePersistenceHandler.loadApplicationConstants();
        ExceptionListenerClient exceptionListenerClient = new ExceptionListenerClient();
        ArrayList statusProviderInfo = (ArrayList)FileUtility.readObject(statusProvidersFile, (ExceptionListener)exceptionListenerClient);
        if (exceptionListenerClient.hasException()) {
            new JMMessageBox(null, "Failed to read Status Provider Information", "Cannot Read Status Provider Information.");
        }
        if (CollectionUtility.isNotEmpty(statusProviderInfo)) {
            for (StatusProviderInfo spi : statusProviderInfo) {
                spi.setBeingMonitored(false);
            }
        }
        return statusProviderInfo;
    }

    public static final void writeStatusProviderInfo(ArrayList<StatusProviderInfo> statusProviderInfo) {
        KumbaCorePersistenceHandler.loadApplicationConstants();
        application.getApplicationLogger().fine("():  Writing status provider info.");
        FileUtility.writeObject(statusProvidersFile, statusProviderInfo);
    }
}

