/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.beans.JMBean;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ApplianceGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public class ApplianceGroupObject
extends JMBean
implements ApplianceGroup,
Comparable<ApplianceGroup> {
    private boolean createdFromCategory;
    private String groupName;
    private ArrayList<Appliance> group;

    public ApplianceGroupObject() {
    }

    public ApplianceGroupObject(String groupName) {
        this(groupName, null);
    }

    public ApplianceGroupObject(String groupName, ArrayList<Appliance> appliances) {
        this.setGroupName(groupName);
        this.setAppliances(appliances);
    }

    protected ApplianceGroupObject(ApplianceGroupObject source) {
        ApplianceGroupObject apo = new ApplianceGroupObject();
        apo.setGroupName(source.getGroupName());
        apo.setAppliances(source.getAppliances());
        apo.setCreatedFromCategory(source.isCreatedFromCategory());
    }

    public boolean isCreatedFromCategory() {
        return this.createdFromCategory;
    }

    public void setCreatedFromCategory(boolean createdFromCategory) {
        this.createdFromCategory = createdFromCategory;
    }

    protected void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    public void addAppliance(Appliance appliance) {
        if (this.group == null) {
            this.group = new ArrayList();
        }
        this.group.add(appliance);
    }

    public void addAll(Collection<Appliance> appliances) {
        this.group.addAll(appliances);
    }

    @Override
    public ArrayList<Appliance> getAppliances() {
        ArrayList<Appliance> activeAppliances = new ArrayList<Appliance>();
        if (this.group != null) {
            for (Appliance appliance : this.group) {
                if (!appliance.isActive()) continue;
                activeAppliances.add(appliance);
            }
        }
        return activeAppliances;
    }

    public void setAppliances(ArrayList<Appliance> group) {
        this.group = group;
    }

    public ArrayList<Appliance> getAppliancesConnected() {
        ArrayList<Appliance> connectedAppliances = new ArrayList<Appliance>();
        if (this.group != null) {
            for (Appliance appliance : this.group) {
                if (!appliance.isActive() || !appliance.isConnected()) continue;
                connectedAppliances.add(appliance);
            }
        }
        return connectedAppliances;
    }

    public boolean isConnected() {
        boolean isConnected = false;
        if (this.group == null) {
            return false;
        }
        for (Appliance appliance : this.group) {
            if (!appliance.isConnected()) continue;
            isConnected = true;
            break;
        }
        return isConnected;
    }

    public double getPercentOfAppliancesConnected() {
        if (this.group == null) {
            return 1.0;
        }
        double totalConnected = 0.0;
        int groupSize = 0;
        for (Appliance appliance : this.group) {
            if (!appliance.isActive()) continue;
            ++groupSize;
            if (!appliance.isConnected()) continue;
            totalConnected += 1.0;
        }
        return totalConnected / (double)groupSize;
    }

    @Override
    public int compareTo(ApplianceGroup that) {
        return this.compareTo(that, "groupName");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.groupName);
    }

    public boolean equals(Object o) {
        return this.equals(o, "groupName");
    }
}

