/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.beans.JMBean;
import com.kumbasoft.core.beans.ConfigObjectSubscriber;
import com.kumbasoft.core.beans.DataPowerConfig;
import java.util.Vector;

public class ConfigObjectCache<ConfigType extends DataPowerConfig>
extends JMBean
implements ConfigObjectSubscriber<ConfigType> {
    private Vector<ConfigType> objectCache = new Vector();
    private int completeCount;
    private int lastCompleteCount = -1;

    public Vector<ConfigType> getObjectCache() {
        return this.objectCache;
    }

    public void clearCache() {
        if (this.objectCache == null) {
            return;
        }
        this.objectCache.clear();
        this.completeCount = 0;
        this.lastCompleteCount = -1;
    }

    @Override
    public void processDataPowerConfig(ConfigType dataPowerConfig) {
        this.objectCache.add(dataPowerConfig);
    }

    @Override
    public void configProcessingComplete() {
        ++this.completeCount;
    }

    public boolean isComplete() {
        if (this.completeCount == this.lastCompleteCount) {
            return true;
        }
        if (this.completeCount != 0) {
            this.lastCompleteCount = this.completeCount;
        }
        return false;
    }
}

