/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.BenignStackTraceException;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.PropertyValueSelector;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.ConfigurationRelationshipType;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.DataPowerObject;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigParseSettings;
import com.kumbasoft.core.beans.config.ConfigStylePolicyAction;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.DynamicParseSettingsReference;
import com.kumbasoft.core.beans.types.StylesheetParameter;
import com.kumbasoft.core.tools.AbstractTool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Supplier;

public class ConfigurationRelationship
extends AbstractTool {
    private static final HashSet<String> FILE_STORES = new HashSet<String>(Arrays.asList(DPEnumerations.FILE_STORE));
    private DataPowerConfig objectInFocus;
    private ArrayList<ConfigurationRelationship> references;
    private ConfigurationRelationshipType relationshipType;
    private ArrayList<DataPowerConfig> allObjects;
    private Index<String, DataPowerConfig> objectsByType;
    private PropertyValueSelector<DataPowerConfig> selector;
    private AsynchMethodInvoker<Void> setupThread;

    static {
        FILE_STORES.add("hsm:");
    }

    private ConfigurationRelationship(ConfigurationRelationshipType relationshipType) {
        logger.finer(() -> LMG.log("(relationshipType=%s):  Starting", () -> relationshipType.toString()));
        this.relationshipType = relationshipType;
        this.references = new ArrayList();
    }

    public ConfigurationRelationship(DataPowerObject objectInFocus, ConfigurationRelationshipType relationshipType) {
        this(relationshipType);
        logger.finer(() -> LMG.log("DataPowerObject objectInFocus=%s, relationshipType=%s):  Starting", () -> objectInFocus.getFQON(), () -> relationshipType.toString()));
        this.setupThread = new AsynchMethodInvoker((Object)this, "setupRelationship", (Object)objectInFocus);
    }

    public ConfigurationRelationship(DataPowerObject objectInFocus, ConfigurationRelationshipType relationshipType, ArrayList<DataPowerConfig> allObjectsInDomain, Index<String, DataPowerConfig> objectsByType, PropertyValueSelector<DataPowerConfig> selector) {
        this(objectInFocus, relationshipType);
        logger.finer(() -> LMG.log("(DataPowerObject objectInFocus=%s, relationshipType=%s, allObjectsInDomain, objectsByType, selector):  Starting", () -> objectInFocus.getFQON(), () -> relationshipType.toString()));
        this.allObjects = allObjectsInDomain;
        this.objectsByType = objectsByType;
        this.selector = selector;
    }

    private ConfigurationRelationship(DataPowerConfig objectInFocus, ConfigurationRelationshipType relationshipType, ArrayList<DataPowerConfig> allObjectsInDomain, Index<String, DataPowerConfig> objectsByType, PropertyValueSelector<DataPowerConfig> selector) {
        this(relationshipType);
        logger.finer(() -> LMG.log("(DataPowerConfig objectInFocus=%s, relationshipType=%s, allObjectsInDomain, objectsByType, selector):  Starting", () -> objectInFocus.getFQON(), () -> relationshipType.toString()));
        this.allObjects = allObjectsInDomain;
        this.objectsByType = objectsByType;
        this.selector = selector;
        this.setObjectInFocus(objectInFocus);
    }

    public AsynchMethodInvoker<Void> getSetupThread() {
        return this.setupThread;
    }

    @Reflected
    private void setupRelationship(DataPowerObject objectInFocus) {
        StatusObjectStatus o;
        String loggerPrefix = String.format("(DataPowerConfig objectInFocus=%s)", objectInFocus.getFQON());
        logger.finer(() -> LMG.log("%s: Starting", () -> loggerPrefix));
        if (objectInFocus instanceof StatusObjectStatus && (o = (StatusObjectStatus)objectInFocus).getAdminState().equals("deleted")) {
            logger.config(() -> LMG.log("%s:  Object is deleted.  Not showing.", () -> loggerPrefix));
            return;
        }
        ConfigurationManager.setExportOptionsSessionTime(System.currentTimeMillis() - 300000L);
        Appliance appliance = objectInFocus.getAppliance();
        Domain domain = objectInFocus.getSourceDomain();
        logger.fine(() -> LMG.log("%s:  Getting all objects in domain.", () -> loggerPrefix));
        this.getAllObjectsInDomain(appliance, domain);
        logger.fine(() -> LMG.log("%s:  Done getting all objects in domain.", () -> loggerPrefix));
        DataPowerConfig objectConfig = null;
        if (objectInFocus instanceof StatusObjectStatus) {
            StatusObjectStatus o2 = (StatusObjectStatus)objectInFocus;
            logger.fine(() -> LMG.log("%s:  Getting reference: %s->%s", () -> loggerPrefix, () -> o2.getDataPowerClass(), () -> o2.getName()));
            objectConfig = this.getReferencedObject(o2.getDataPowerClass(), o2.getName());
        } else {
            ObjectReference<DataPowerFileInfo> objectRef = this.createPseudoFileObjectReference((DataPowerFileInfo)objectInFocus);
            objectConfig = objectRef.getReferencedObject();
        }
        if (objectConfig == null) {
            logger.config(() -> LMG.log("%s:  Unable to get configuration.  Result is NULL.", () -> loggerPrefix));
        } else {
            this.setObjectInFocus(objectConfig);
        }
        logger.finer(() -> LMG.log("%s: Done", () -> loggerPrefix));
    }

    private void setObjectInFocus(DataPowerConfig objectInFocus) {
        if (objectInFocus == null) {
            logger.info("(DataPowerConfig objectInFocus):  Starting:  Object in focus is null.  How, but won't process.");
            BenignStackTraceException ste = new BenignStackTraceException("ConfigurationRelationship.setObjectInFocus(DataPowerConfig objectInFocus):  objectInFocus is null");
            ste.printStackTrace();
            return;
        }
        logger.finer(() -> LMG.log("(DataPowerConfig objectInFocus=%s): Starting", () -> objectInFocus.getFQON()));
        this.objectInFocus = objectInFocus;
        switch (this.relationshipType) {
            case PARENT_DOWN: {
                this.processTopDown();
                break;
            }
            case CHILD_UP: {
                this.processBottomUp();
            }
        }
        logger.finer(() -> LMG.log("(DataPowerConfig objectInFocus=%s): Starting", () -> objectInFocus.getFQON()));
    }

    private void getAllObjectsInDomain(Appliance appliance, Domain domain) {
        String loggerPrefix = String.format("(appliance=%s, domain=%s)", appliance.getName(), domain.getName());
        logger.finer(() -> LMG.log("%s:  Starting", () -> loggerPrefix));
        if (this.allObjects == null) {
            logger.finer(() -> LMG.log("%s: Getting all objects in domain.", () -> loggerPrefix));
            ConfigurationManager configurationManager = new ConfigurationManager();
            this.allObjects = configurationManager.getObjects(appliance, domain, null, null);
            logger.finer(() -> LMG.log("%s: Done getting all objects in domain.", () -> loggerPrefix));
            BeanIndexer<DataPowerConfig> objectIndexer = new BeanIndexer<DataPowerConfig>(this.allObjects);
            this.objectsByType = objectIndexer.getIndexOf("configObjectType", "");
            this.selector = new PropertyValueSelector<DataPowerConfig>(this.allObjects);
        }
        logger.finer(() -> LMG.log("%s:  Done", () -> loggerPrefix));
    }

    private DataPowerConfig getObject(String objectType, String objectName) {
        logger.finer(() -> LMG.log("(objectType=%s, objectName=%s):  Starting for appliance=%s and domain=%s.", () -> objectType, () -> objectName, () -> this.objectInFocus.getAppliance().getName(), () -> this.objectInFocus.getSourceDomain().getName()));
        Collection<DataPowerConfig> objectsByType = this.objectsByType.get(objectType);
        if (objectsByType == null) {
            logger.info(() -> LMG.log("(objectType=%s, objectName=%s):  No objects of the objecType found in appliance=%s and domain=%s.  Returning NULL", () -> objectType, () -> objectName, () -> this.objectInFocus.getAppliance().getName(), () -> this.objectInFocus.getSourceDomain().getName()));
            return null;
        }
        this.selector.clearMap();
        this.selector.setCollection(objectsByType);
        this.selector.addPropertyValueMap("name", objectName);
        ArrayList objectsByName = (ArrayList)this.selector.getSelectedElements();
        if (objectsByName.size() > 0) {
            DataPowerConfig object = (DataPowerConfig)objectsByName.get(0);
            if (objectsByName.size() > 1) {
                logger.warning(() -> LMG.log("(objectType=%s, objectName=%s):  Found %d objects in appliance=%s and domain=%s.  How is this possible?", () -> objectType, () -> objectName, () -> objectsByName.size(), () -> this.objectInFocus.getAppliance().getName(), () -> this.objectInFocus.getSourceDomain().getName()));
            }
            logger.finer(() -> LMG.log("(objectType=%s, objectName=%s):  Found in appliance=%s and domain=%s.  Returning object.", () -> objectType, () -> objectName, () -> this.objectInFocus.getAppliance().getName(), () -> this.objectInFocus.getSourceDomain().getName()));
            return object;
        }
        logger.info(() -> LMG.log("(objectType=%s, objectName=%s):  Not found in appliance=%s and domain=%s.  Returning NULL", () -> objectType, () -> objectName, () -> this.objectInFocus.getAppliance().getName(), () -> this.objectInFocus.getSourceDomain().getName()));
        return null;
    }

    private void processTopDown() {
        logger.finer("(): Starting");
        ArrayList<ObjectReference<? extends DataPowerConfig>> objectReferences = this.getReferencesFromObject(this.objectInFocus);
        for (ObjectReference<? extends DataPowerConfig> objectReference : objectReferences) {
            String referenceObjectType = objectReference.getClassName();
            String referenceObjectName = objectReference.getName();
            if (referenceObjectType == null) {
                logger.warning(() -> LMG.log("():  referenceObjectType is null.  How???\n", new Supplier[0]));
                return;
            }
            if (referenceObjectName == null) {
                logger.warning(() -> LMG.log("():  referenceObjectName is null.  How???\n", new Supplier[0]));
                return;
            }
            DataPowerConfig configObject = this.getReferencedObject(referenceObjectType, referenceObjectName);
            if (configObject == null) {
                logger.warning(() -> LMG.log("():  The configuration object for %s %s was not found.  Why?\n", () -> referenceObjectType, () -> referenceObjectName));
                return;
            }
            this.addRelationship(configObject);
        }
        logger.finer("():  Done.  No news is good news!");
    }

    private void processBottomUp() {
        logger.finer("(): Starting");
        if (this.objectInFocus == null) {
            logger.severe("():  Object in focus is null!  Why?");
            BenignStackTraceException ste = new BenignStackTraceException("Object In Focus is null");
            ste.printStackTrace();
            return;
        }
        String thisObjectType = this.objectInFocus.getConfigObjectType();
        String thisObjectName = this.objectInFocus.getName();
        ArrayList<DataPowerConfig> allObjectsLooper = new ArrayList<DataPowerConfig>(this.allObjects);
        for (DataPowerConfig dataPowerConfig : allObjectsLooper) {
            if (dataPowerConfig == this.objectInFocus) continue;
            ArrayList<ObjectReference<? extends DataPowerConfig>> objectReferences = this.getReferencesFromObject(dataPowerConfig);
            for (ObjectReference<? extends DataPowerConfig> objectReference : objectReferences) {
                this.processObjectReference(dataPowerConfig, objectReference, thisObjectType, thisObjectName);
            }
        }
        logger.finer("():  No news is good news!");
    }

    private ArrayList<ObjectReference<? extends DataPowerConfig>> getReferencesFromObject(Object anyDataPowerObject) {
        logger.finer(() -> LMG.log("(anyDataPowerObject=%s): Starting", () -> anyDataPowerObject.getClass().getName()));
        ArrayList<ObjectReference<? extends DataPowerConfig>> listOfObjectReferences = new ArrayList<ObjectReference<? extends DataPowerConfig>>();
        if (anyDataPowerObject == null || anyDataPowerObject instanceof DataPowerFileInfo) {
            logger.warning(() -> LMG.log("(anyDataPowerObject=%s):  anyDataPowerObject is null or a file.  Returning empty list.", () -> anyDataPowerObject.getClass().getName()));
            return listOfObjectReferences;
        }
        if (anyDataPowerObject instanceof ConfigStylePolicyAction) {
            ConfigStylePolicyAction stylePolicyAction = (ConfigStylePolicyAction)anyDataPowerObject;
            logger.finer(() -> LMG.log("(anyDataPowerObject=%s):  anyDataPowerObject is a StylePolicyAction.  Looking for references.", () -> anyDataPowerObject.getClass().getName()));
            listOfObjectReferences.addAll(this.getReferencesFromStylePolicyAction(stylePolicyAction));
        }
        ArrayList<String> propertyNames = BeanService.getPropertyNames(anyDataPowerObject);
        for (String propertyName : propertyNames) {
            logger.finest(() -> LMG.log("(anyDataPowerObject=%s):  Processing property %s.", () -> anyDataPowerObject.getClass().getName(), () -> propertyName));
            Class<Serializable> propertyType = BeanService.getPropertyType(anyDataPowerObject, propertyName);
            if (propertyType.isAssignableFrom(Number.class)) continue;
            if (propertyType.isAssignableFrom(ObjectReference.class)) {
                logger.finer(() -> LMG.log("(anyDataPowerObject=%s):  Property %s is an object reference.  Digging!", () -> anyDataPowerObject.getClass().getName(), () -> propertyName));
                ObjectReference objectReference = (ObjectReference)BeanService.getPropertyValue(anyDataPowerObject, propertyName);
                if (objectReference == null) continue;
                objectReference.setReferencingPropertyName(propertyName);
                listOfObjectReferences.add(objectReference);
                continue;
            }
            if (propertyType.getName().startsWith("com.kumbasoft.core.beans.types.")) {
                logger.finer(() -> LMG.log("(anyDataPowerObject=%s):  Property %s is a type of '%s'.  Digging.", () -> anyDataPowerObject.getClass().getName(), () -> propertyName, () -> propertyType.getName()));
                Object object = BeanService.getPropertyValue(anyDataPowerObject, propertyName);
                if (object == null) continue;
                ArrayList<ObjectReference<? extends DataPowerConfig>> objectReferences = this.getReferencesFromObject(object);
                listOfObjectReferences.addAll(objectReferences);
                continue;
            }
            if (propertyType.getSimpleName().equals("String")) {
                String propertyValuePrefix;
                int fileStoreSeparator;
                String propertyValue = (String)BeanService.getPropertyValue(anyDataPowerObject, propertyName);
                if (propertyValue == null || (fileStoreSeparator = (propertyValuePrefix = propertyValue).indexOf(":/")) <= 0 || !FILE_STORES.contains(propertyValuePrefix = propertyValuePrefix.substring(0, fileStoreSeparator + 1))) continue;
                propertyValue = propertyValuePrefix.equals("hsm:") ? propertyValue : StringUtility.coalesce(propertyValue, "/");
                int lastSlash = propertyValue.lastIndexOf("/");
                lastSlash = lastSlash == propertyValue.length() - 1 ? propertyValue.length() : lastSlash + 1;
                String fileName = propertyValue.substring(lastSlash);
                String directory = propertyValue.substring(0, lastSlash);
                DataPowerFileInfo dpFileInfo = new DataPowerFileInfo(this.objectInFocus.getAppliance(), this.objectInFocus.getSourceDomain(), null, 0L, directory, fileName);
                ObjectReference<DataPowerFileInfo> fileReference = this.createPseudoFileObjectReference(dpFileInfo);
                fileReference.setReferencingPropertyName(propertyName);
                logger.finer(() -> LMG.log("(anyDataPowerObject=%s):  Property %s is file reference.  Adding.", () -> anyDataPowerObject.getClass().getName(), () -> propertyName));
                listOfObjectReferences.add(fileReference);
                continue;
            }
            if (!propertyType.isAssignableFrom(ArrayList.class)) continue;
            logger.finer(() -> LMG.log("(anyDataPowerObject=%s):  Property %s is a list.  Processing each element.", () -> anyDataPowerObject.getClass().getName(), () -> propertyName));
            ArrayList listOfObjects = (ArrayList)BeanService.getPropertyValue(anyDataPowerObject, propertyName);
            if (listOfObjects == null) continue;
            int i = 0;
            while (i < listOfObjects.size()) {
                int iteratorIndex = i;
                Object object = listOfObjects.get(i);
                if (object instanceof ObjectReference) {
                    ObjectReference referencedObject = (ObjectReference)object;
                    logger.finer(() -> LMG.log("(anyDataPowerObject=%s):  Property %s element %d is an object reference.  Digging.", () -> anyDataPowerObject.getClass().getName(), () -> propertyName, () -> iteratorIndex));
                    referencedObject.setReferencingPropertyName(propertyName);
                    referencedObject.setReferencingElementIndex(i);
                    listOfObjectReferences.add(referencedObject);
                } else if (object instanceof StylesheetParameter) {
                    StylesheetParameter styleSheetParameter = (StylesheetParameter)object;
                    logger.finer(() -> LMG.log("(anyDataPowerObject=%s):  Property %s element %d is a style sheet parameter.  Digging.", () -> anyDataPowerObject.getClass().getName(), () -> propertyName, () -> iteratorIndex));
                    objectReferences = this.getReferencesFromStyleSheetParameter(styleSheetParameter, propertyName, i);
                    listOfObjectReferences.addAll(objectReferences);
                } else if (object instanceof JMBean) {
                    logger.finer(() -> LMG.log("(anyDataPowerObject=%s):  Property %s element %d is a type.  Digging.", () -> anyDataPowerObject.getClass().getName(), () -> propertyName, () -> iteratorIndex));
                    objectReferences = this.getReferencesFromObject(object);
                    listOfObjectReferences.addAll(objectReferences);
                }
                ++i;
            }
        }
        logger.finer(() -> LMG.log("(anyDataPowerObject=%s): Done", () -> anyDataPowerObject.getClass().getName()));
        return listOfObjectReferences;
    }

    private ArrayList<ObjectReference<? extends DataPowerConfig>> getReferencesFromStyleSheetParameter(StylesheetParameter stylesheetParameter, String propertyName, int parameterIndex) {
        ArrayList<ObjectReference<? extends DataPowerConfig>> listOfObjectReferences;
        block40: {
            String[] objectNames;
            String objectName;
            String className;
            String identifier;
            String value;
            block41: {
                logger.finer(() -> LMG.log("(stylesheetParameter=(%s=%s))", () -> stylesheetParameter.getParameterName(), () -> stylesheetParameter.getParameterValue()));
                listOfObjectReferences = new ArrayList<ObjectReference<? extends DataPowerConfig>>();
                String name = stylesheetParameter.getParameterName();
                value = stylesheetParameter.getParameterValue();
                if (!name.startsWith("{http://www.datapower.com/param/config}")) break block40;
                className = identifier = StringUtility.substringAfter(name, "}");
                objectName = value;
                objectNames = null;
                if (!Comparison.isIn(identifier, DPEnumerations.CONFIG_ENUM)) break block41;
                logger.finer(() -> LMG.log("(stylesheetParameter=(%s=%s)):  Parameter references an object of type %s", () -> stylesheetParameter.getParameterName(), () -> stylesheetParameter.getParameterValue(), () -> identifier));
                className = identifier;
                break block40;
            }
            logger.finer(() -> LMG.log("(stylesheetParameter=(%s=%s)):  Parameter identifier:  %s", () -> stylesheetParameter.getParameterName(), () -> stylesheetParameter.getParameterValue(), () -> identifier));
            switch (identifier) {
                case "additional-certificates": {
                    className = "CryptoCertificate";
                    if (!value.contains("+")) break;
                    objectName = null;
                    objectNames = value.split("\\+");
                    break;
                }
                case "keypair-cert": {
                    className = "CryptoCertificate";
                    break;
                }
                case "keypair-key": {
                    className = "CryptoKey";
                    break;
                }
                case "recipients": {
                    className = "CryptoIdentCred";
                    if (!value.contains("+")) break;
                    objectName = null;
                    objectNames = value.split("\\+");
                    break;
                }
                case "remote-token-retrieval-idcred": {
                    className = "CryptoIdentCred";
                    break;
                }
                case "remote-token-sslclientprofile": {
                    className = "SSLClientProfile";
                    break;
                }
                case "remote-token-sslprofile": {
                    className = "SSLProxyProfile";
                    break;
                }
                case "signer": {
                    if (value.startsWith("name:")) {
                        className = "CryptoCertificate";
                        objectName = StringUtility.substringAfter(value, "name:").trim();
                        break;
                    }
                    className = null;
                    break;
                }
                case "signers": {
                    className = "CryptoIdentCred";
                    if (!value.contains("+")) break;
                    objectName = null;
                    objectNames = value.split("\\+");
                    break;
                }
                case "valcred": {
                    className = "CryptoValCred";
                    break;
                }
                default: {
                    logger.config(() -> LMG.log("(stylesheetParameter=(%s=%s)):  Parameter identifier %s is not handled.  Can it be?", () -> stylesheetParameter.getParameterName(), () -> stylesheetParameter.getParameterValue(), () -> identifier));
                    className = null;
                    objectName = null;
                }
            }
            if (className != null) {
                ArrayList<String> objectNameList = new ArrayList<String>();
                if (objectName != null) {
                    objectNameList.add(objectName);
                } else if (objectNames != null) {
                    objectNameList.addAll(Arrays.asList(objectNames));
                }
                int embeededElementCount = objectNameList.size();
                int embeddedElementOffset = 0;
                for (String oName : objectNameList) {
                    logger.finer(() -> LMG.log("(stylesheetParameter=(%s=%s)):  Getting object configuration for %s", () -> stylesheetParameter.getParameterName(), () -> stylesheetParameter.getParameterValue(), () -> this.objectInFocus.getFQON()));
                    DataPowerConfig dataPowerConfig = this.getObject(className, oName);
                    ObjectReference<DataPowerConfig> reference = new ObjectReference<DataPowerConfig>();
                    reference.setClassName(className);
                    reference.setName(objectName);
                    reference.setReferencedObject(dataPowerConfig);
                    reference.setReferencingPropertyName(propertyName);
                    reference.setReferencingElementIndex(parameterIndex);
                    reference.setEmbeddedElementCount(embeededElementCount);
                    reference.setEmbeddedElementOffset(embeddedElementOffset);
                    logger.finer(() -> LMG.log("(stylesheetParameter=(%s=%s)):  Done getting object configuration for %s", () -> stylesheetParameter.getParameterName(), () -> stylesheetParameter.getParameterValue(), () -> this.objectInFocus.getFQON()));
                    listOfObjectReferences.add(reference);
                    ++embeddedElementOffset;
                }
            }
        }
        logger.finer(() -> LMG.log("(stylesheetParameter=(%s=%s))", () -> stylesheetParameter.getParameterName(), () -> stylesheetParameter.getParameterValue()));
        return listOfObjectReferences;
    }

    private ArrayList<ObjectReference<? extends DataPowerConfig>> getReferencesFromStylePolicyAction(ConfigStylePolicyAction stylePolicyAction) {
        String actionType;
        logger.finer(() -> LMG.log("getReferencesFromStylePolicyAction(stylePolicyAction=(%s, %s))", () -> stylePolicyAction.getFQON(), () -> stylePolicyAction.getType()));
        ArrayList<ObjectReference<? extends DataPowerConfig>> listOfObjectReferences = new ArrayList<ObjectReference<? extends DataPowerConfig>>();
        switch (actionType = stylePolicyAction.getType()) {
            case "call": 
            case "on-error": {
                String objectName = stylePolicyAction.getRule();
                logger.finer(() -> LMG.log("(stylePolicyAction=(%s, %s)):  References a style policy rule named %s.  Getting config.", () -> stylePolicyAction.getFQON(), () -> stylePolicyAction.getType(), () -> objectName));
                DataPowerConfig dataPowerConfig = this.getObject("StylePolicyRule", objectName);
                ObjectReference<DataPowerConfig> reference = new ObjectReference<DataPowerConfig>();
                reference.setClassName("StylePolicyRule");
                reference.setName(objectName);
                reference.setReferencedObject(dataPowerConfig);
                reference.setReferencingPropertyName("rule");
                logger.finer(() -> LMG.log("(stylePolicyAction=(%s, %s)):  Done getting the config of style policy rule named %s.", () -> stylePolicyAction.getFQON(), () -> stylePolicyAction.getType(), () -> objectName));
                listOfObjectReferences.add(reference);
                break;
            }
            case "event-sink": {
                ArrayList<String> asynchActions = stylePolicyAction.getAsyncAction();
                if (!CollectionUtility.isNotEmpty(asynchActions)) break;
                int elementIndex = 0;
                for (String objectName : asynchActions) {
                    logger.finer(() -> LMG.log("(stylePolicyAction=(%s, %s)): Event Sync references an action named %s.  Getting config.", () -> stylePolicyAction.getFQON(), () -> stylePolicyAction.getType(), () -> objectName));
                    DataPowerConfig dataPowerConfig = this.getObject("StylePolicyAction", objectName);
                    ObjectReference<DataPowerConfig> reference = new ObjectReference<DataPowerConfig>();
                    reference.setClassName("StylePolicyAction");
                    reference.setName(objectName);
                    reference.setReferencedObject(dataPowerConfig);
                    reference.setReferencingPropertyName("asynchAction");
                    reference.setReferencingElementIndex(elementIndex);
                    logger.finer(() -> LMG.log("(stylePolicyAction=(%s, %s)):  Done getting the config of Event Sync style policy action named %s.", () -> stylePolicyAction.getFQON(), () -> stylePolicyAction.getType(), () -> objectName));
                    listOfObjectReferences.add(reference);
                    ++elementIndex;
                }
                break;
            }
            case "parse": {
                DynamicParseSettingsReference parseSettingsReference = stylePolicyAction.getParseSettingsReference();
                ObjectReference<ConfigParseSettings> parseSettingsRef = parseSettingsReference.getDefaultType();
                parseSettingsRef.setReferencingPropertyName("parseSettingsReference");
                logger.finer(() -> LMG.log("(stylePolicyAction=(%s, %s)): Parse Settings %s is referenced.", () -> stylePolicyAction.getFQON(), () -> stylePolicyAction.getType(), () -> parseSettingsRef.getName()));
                listOfObjectReferences.add(parseSettingsRef);
            }
        }
        logger.finer(() -> LMG.log("getReferencesFromStylePolicyAction(stylePolicyAction=(%s, %s))", () -> stylePolicyAction.getFQON(), () -> stylePolicyAction.getType()));
        return listOfObjectReferences;
    }

    private ObjectReference<DataPowerFileInfo> createPseudoFileObjectReference(DataPowerFileInfo dpFileInfo) {
        logger.finer(() -> LMG.log("(dpFileInfo=%s):", () -> dpFileInfo.getAbsolutePath()));
        ObjectReference<DataPowerFileInfo> fileReference = new ObjectReference<DataPowerFileInfo>();
        fileReference.setClassName("file");
        fileReference.setName(dpFileInfo.getAbsolutePath());
        fileReference.setReferencedObject(dpFileInfo);
        this.allObjects.add(dpFileInfo);
        this.objectsByType.put("file", dpFileInfo);
        return fileReference;
    }

    private void processObjectReference(DataPowerConfig dataPowerConfig, ObjectReference<? extends DataPowerConfig> referencedObjectReference, String thisObjectType, String thisObjectName) {
        logger.finer(() -> LMG.log("processObjectReference(dataPowerConfig=%s, referencedObjectReference, thisObjectType=%s, thisObjectName=%s)", () -> dataPowerConfig.getFQON(), () -> thisObjectName, () -> thisObjectName));
        String referencedObjectClassName = referencedObjectReference.getClassName();
        String referencedObjectType = referencedObjectClassName == null ? null : (referencedObjectClassName.equals("file") ? "DataPowerFileInfo" : referencedObjectClassName);
        String referencedObjectName = referencedObjectReference.getName();
        if (referencedObjectType == null || referencedObjectName == null) {
            logger.config(() -> LMG.log("(dataPowerConfig=%s, referencedObjectReference, thisObjectType=%s, thisObjectName=%s): Invalid Object Reference:  referencedObjectType=%s, referencedObjectName=%s", () -> dataPowerConfig.getFQON(), () -> thisObjectName, () -> thisObjectName, () -> referencedObjectType, () -> referencedObjectName));
            return;
        }
        if (referencedObjectType.equals(thisObjectType) && referencedObjectName.equals(thisObjectName)) {
            logger.config(() -> LMG.log("(dataPowerConfig=%s, referencedObjectReference, thisObjectType=%s, thisObjectName=%s): Adding to relationship:  referencedObjectType=%s, referencedObjectName=%s", () -> dataPowerConfig.getFQON(), () -> thisObjectName, () -> thisObjectName, () -> referencedObjectType, () -> referencedObjectName));
            this.addRelationship(dataPowerConfig);
        }
        logger.finer(() -> LMG.log("processObjectReference(dataPowerConfig=%s, referencedObjectReference, thisObjectType=%s, thisObjectName=%s):  No news is good news!", () -> dataPowerConfig.getFQON(), () -> thisObjectName, () -> thisObjectName));
    }

    private void addRelationship(DataPowerConfig dataPowerConfig) {
        logger.finer(() -> LMG.log("addRelationship(dataPowerConfig=%s)", () -> dataPowerConfig.getFQON()));
        boolean relationshipExists = false;
        for (ConfigurationRelationship existingReference : this.references) {
            if (!existingReference.getObjectInFocus().equals(dataPowerConfig)) continue;
            relationshipExists = true;
            break;
        }
        if (relationshipExists) {
            logger.config(() -> LMG.log("(dataPowerConfig=%s):  Relationship Exists.  Returning to prevent duplicate.", () -> dataPowerConfig.getFQON()));
            return;
        }
        logger.finer(() -> LMG.log("(dataPowerConfig=%s):  Adding relationship.", () -> dataPowerConfig.getFQON()));
        ConfigurationRelationship configurationRelationship = new ConfigurationRelationship(dataPowerConfig, this.relationshipType, this.allObjects, this.objectsByType, this.selector);
        this.references.add(configurationRelationship);
        logger.finer(() -> LMG.log("addRelationship(dataPowerConfig=%s)", () -> dataPowerConfig.getFQON()));
    }

    private DataPowerConfig getReferencedObject(String referencedObjectType, String referencedObjectName) {
        logger.finer(() -> LMG.log("(referencedObjectType=%s, referencedObjectName=%s): Getting objects by type.", () -> referencedObjectType, () -> referencedObjectName));
        Collection<DataPowerConfig> referencedObjects = this.objectsByType.get(referencedObjectType);
        if (referencedObjects == null) {
            logger.info(() -> LMG.log("(referencedObjectType=%s, referencedObjectName=%s): No objects of type found.", () -> referencedObjectType, () -> referencedObjectName));
            return null;
        }
        this.selector.setCollection(referencedObjects);
        this.selector.clearMap();
        this.selector.addPropertyValueMap("name", referencedObjectName);
        ArrayList referencedObject = (ArrayList)this.selector.getSelectedElements();
        if (referencedObject.size() > 1) {
            String objectInFocusApplianceName = this.objectInFocus == null ? "-Object In Focus is NULL" : this.objectInFocus.getAppliance().getName();
            String objectInFocusDomainName = this.objectInFocus == null ? "-Object in Focus is NULL" : this.objectInFocus.getSourceDomain().getName();
            logger.info(() -> LMG.log("(referencedObjectType=%s, referencedObjectName=%s):  Found %d objects in %s domain of %s.  Why?\n", () -> referencedObjectType, () -> referencedObjectName, () -> referencedObject.size(), () -> objectInFocusDomainName, () -> objectInFocusApplianceName));
            for (DataPowerConfig ref : referencedObject) {
                logger.info(() -> LMG.log("\t%s %s\n", () -> ref.getConfigObjectType(), () -> ref.getName()));
            }
        }
        if (referencedObject.size() == 0) {
            if (this.objectInFocus != null) {
                logger.info(() -> LMG.log("(referencedObjectType=%s, referencedObjectName=%s):  Referenced object size is 0 for %s domain of %s.  Is that correct?\n", () -> referencedObjectType, () -> referencedObjectName, () -> this.objectInFocus.getAppliance().getName(), () -> this.objectInFocus.getSourceDomain().getName()));
            } else {
                logger.info(() -> LMG.log("(referencedObjectType=%s, referencedObjectName=%s):  Referenced object size is 0 when object in focus is null.  Is that correct?\n", () -> referencedObjectType, () -> referencedObjectName));
            }
            return null;
        }
        return (DataPowerConfig)referencedObject.get(0);
    }

    public DataPowerConfig getObjectInFocus() {
        return this.objectInFocus;
    }

    public ArrayList<ConfigurationRelationship> getReferences() {
        return this.references;
    }

    public ConfigurationRelationshipType getRelationshipType() {
        return this.relationshipType;
    }
}

