/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.beans.JMBean;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.beans.Appliance;
import java.util.ArrayList;

public abstract class CopyMoveActionBean<BeanType>
extends JMBean {
    public static final int COPY = 0;
    public static final int MOVE = 1;
    protected int mode;
    protected ArrayList<BeanType> objects;
    protected ArrayList<Appliance> destinationAppliances;
    protected ArrayList<String> destinationDomains;

    public CopyMoveActionBean() {
        this(0);
    }

    public CopyMoveActionBean(int mode) {
        this.setMode(mode);
    }

    public CopyMoveActionBean(ArrayList<BeanType> objects) {
        this(objects, 0);
    }

    public CopyMoveActionBean(ArrayList<BeanType> objects, int mode) {
        this.setMode(mode);
        this.objects = objects;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        switch (mode) {
            case 0: 
            case 1: {
                this.mode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("%s.setMode(mode=%d).  The value of mode is invalid.", this.getClass().getName(), mode));
            }
        }
    }

    public void addObject(BeanType object) {
        if (object == null) {
            return;
        }
        if (this.objects == null) {
            this.objects = new ArrayList();
        }
        this.objects.add(object);
    }

    public ArrayList<BeanType> getObjects() {
        return this.objects;
    }

    public void setObjects(ArrayList<BeanType> objects) {
        this.objects = objects;
    }

    public void clearDestinationAppliances() {
        if (CollectionUtility.isEmpty(this.destinationAppliances)) {
            return;
        }
        this.destinationAppliances.clear();
    }

    public void addDestinationAppliance(Appliance appliance) {
        if (appliance == null) {
            return;
        }
        if (this.destinationAppliances == null) {
            this.destinationAppliances = new ArrayList();
        }
        this.destinationAppliances.add(appliance);
    }

    public ArrayList<Appliance> getDestinationAppliances() {
        return this.destinationAppliances;
    }

    public void clearDestinationDomains() {
        if (CollectionUtility.isEmpty(this.destinationDomains)) {
            return;
        }
        this.destinationDomains.clear();
    }

    public void addDestinationDomain(String domain) {
        if (domain == null) {
            return;
        }
        if (this.destinationDomains == null) {
            this.destinationDomains = new ArrayList();
        }
        this.destinationDomains.add(domain);
    }

    public ArrayList<String> getDestinationDomains() {
        return this.destinationDomains;
    }
}

