/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.util.DateTime;
import com.jmorgan.util.DateTimeException;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.util.FileUtility;
import java.io.File;
import java.util.Objects;

public class DataPowerFileInfo
extends DataPowerConfig
implements Cloneable {
    private DateTime fileDate;
    private long fileSize;
    private String baseDirectory;
    private String fileName;
    private byte[] fileData;
    private String fileContent;
    private File localFile;
    private boolean deleteable;

    public DataPowerFileInfo() {
    }

    public DataPowerFileInfo(Appliance appliance, Domain domain, String date, long fileSize, String FQFN) {
        super(appliance, domain);
        this.setFileDate(date);
        this.setFileSize(fileSize);
        int lastSlash = FQFN.lastIndexOf("/");
        String fileName = FQFN.substring(lastSlash + 1);
        String baseDirectory = FQFN.substring(0, lastSlash);
        this.setBaseDirectory(baseDirectory);
        this.setFileName(fileName);
    }

    public DataPowerFileInfo(Appliance appliance, Domain domain, String date, long fileSize, String baseDirectory, String fileName) {
        super(appliance, domain);
        this.setFileDate(date);
        this.setFileSize(fileSize);
        this.setBaseDirectory(baseDirectory);
        this.setFileName(fileName);
    }

    private DataPowerFileInfo(DataPowerFileInfo that) {
        super(that.getAppliance(), that.getSourceDomain());
        this.setFileDate(that.getFileDate());
        this.setFileSize(that.getFileSize());
        this.setBaseDirectory(that.getBaseDirectory());
        this.setFileName(that.getFileName());
        this.setFileData(that.getFileData());
        this.setFileContent(that.getFileContent());
        this.setLocalFile(that.getLocalFile());
        this.setName(that.getName());
    }

    public Object clone() throws CloneNotSupportedException {
        return new DataPowerFileInfo(this);
    }

    public String getAbsolutePath() {
        String format = this.baseDirectory.endsWith("/") ? "%s%s" : "%s/%s";
        String absolutePath = String.format(format, this.baseDirectory, this.fileName);
        if (this.baseDirectory.startsWith("hsm:")) {
            return absolutePath;
        }
        return StringUtility.coalesce(absolutePath, "/");
    }

    public DateTime getFileDate() {
        return this.fileDate;
    }

    public void setFileDate(DateTime fileDate) {
        this.fileDate = fileDate;
    }

    public void setFileDate(String date) {
        while (true) {
            try {
                DateTime fileDate = new DateTime((String)date);
                this.setFileDate(fileDate);
            }
            catch (DateTimeException dt) {
                if (((String)date).length() != 10) break;
                date = (String)date + " 00:00:00";
                continue;
            }
            break;
        }
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(String baseDirectory) {
        this.baseDirectory = baseDirectory.startsWith("hsm:") ? baseDirectory : StringUtility.coalesce(baseDirectory, "/");
        if (!this.baseDirectory.startsWith("hsm://")) {
            StringUtility.insertInto("/", this.baseDirectory, 4);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        if (fileName.equals(this.baseDirectory)) {
            fileName = "";
        }
        this.fileName = fileName;
        if (StringUtility.isEmpty(fileName)) {
            this.setName(this.baseDirectory);
        } else {
            String format = this.baseDirectory.endsWith("/") ? "%s%s" : "%s/%s";
            String fullFileName = String.format(format, this.baseDirectory, fileName);
            if (this.baseDirectory.startsWith("hsm://")) {
                this.setName(fullFileName);
            } else {
                this.setName(StringUtility.coalesce(fullFileName, "/"));
            }
        }
        this.fileName = StringUtility.coalesce(fileName, "/");
    }

    public boolean isDeleteable() {
        return this.deleteable;
    }

    public void setDeleteable(boolean deleteable) {
        this.deleteable = deleteable;
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    public void setFileData(byte[] fileData) {
        this.fileData = fileData;
        if (fileData == null) {
            return;
        }
        String fileContent = "";
        boolean isTextFile = FileUtility.isText(fileData);
        if (isTextFile) {
            fileContent = new String(fileData);
        }
        this.fileContent = fileContent;
        this.fileSize = this.fileData.length;
    }

    public String getFileContent() {
        return this.fileContent;
    }

    public void setFileContent(String fileContent) {
        this.fileContent = fileContent;
        if (fileContent == null) {
            this.fileData = null;
            this.fileSize = 0L;
            return;
        }
        this.fileData = fileContent.getBytes();
        this.fileSize = this.fileData.length;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(File localFileName) {
        this.localFile = localFileName;
    }

    public String getFileStore() {
        int colon = this.baseDirectory.indexOf(":");
        return this.baseDirectory.substring(0, colon + 1);
    }

    @Override
    public int compareTo(DataPowerFileInfo that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "appliance", "sourceDomain", "baseDirectory", "fileName", "fileDate", "fileSize");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.baseDirectory, this.fileName, this.fileDate, this.fileSize);
    }

    @Override
    public boolean equals(Object o) {
        boolean eq = super.equals(o);
        if (!eq) {
            return eq;
        }
        return this.equals(o, "baseDirectory", "fileName", "fileDate", "fileSize");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("baseDirectory", "fileName", "fileDate", "fileSize"));
    }
}

