/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.beans.JMBean;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import java.util.Objects;

public abstract class DataPowerObject
extends JMBean
implements Comparable<DataPowerObject> {
    private Appliance appliance;
    private Domain sourceDomain;

    public DataPowerObject() {
    }

    public DataPowerObject(Appliance appliance, Domain domain) {
        this();
        this.appliance = appliance;
        if (domain == null) {
            domain = new Domain("default");
        }
        this.sourceDomain = domain;
    }

    public Appliance getAppliance() {
        return this.appliance;
    }

    public void setAppliance(Appliance appliance) {
        this.appliance = appliance;
    }

    public Domain getSourceDomain() {
        return this.sourceDomain;
    }

    public void setSourceDomain(Domain domain) {
        this.sourceDomain = domain;
    }

    public String getFQON() {
        String applianceName = this.appliance == null ? "-null-" : this.appliance.getName();
        String domainName = this.sourceDomain == null ? "-null-" : this.sourceDomain.getName();
        return String.format("%s->%s", applianceName, domainName);
    }

    @Override
    public int compareTo(DataPowerObject that) {
        return this.compareTo(that, "appliance", "sourceDomain");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.appliance, this.sourceDomain);
    }

    public boolean equals(Object o) {
        return this.equals(o, "appliance", "sourceDomain");
    }

    @Override
    public String toString() {
        return this.toString("appliance", "sourceDomain");
    }
}

