/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerStatus;
import com.kumbasoft.core.beans.DataPowerStatusListener;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.AbstractTool;
import java.util.ArrayList;

public class DataPowerStatusCache<StatusType extends DataPowerStatus>
extends AbstractTool
implements DataPowerStatusListener<StatusType> {
    private ArrayList<StatusType> statusCache = new ArrayList();
    private int monitorCount;
    private boolean statusComplete;
    private int lastCacheSize = -1;
    private boolean gotError;
    private ArrayList<DynamicBean> errors;

    public ArrayList<StatusType> getStatusCache() {
        return this.statusCache;
    }

    public void incrementMonitorCount() {
        ++this.monitorCount;
    }

    public int getMonitorCount() {
        return this.monitorCount;
    }

    public void clearCache() {
        if (this.statusCache == null) {
            return;
        }
        this.statusCache.clear();
        this.statusComplete = false;
        this.lastCacheSize = -1;
        this.monitorCount = 0;
        this.gotError = false;
    }

    public boolean isComplete() {
        if (!this.statusComplete) {
            return false;
        }
        if (this.monitorCount > 0) {
            return false;
        }
        int cacheSize = this.statusCache.size();
        if (cacheSize == this.lastCacheSize) {
            return true;
        }
        this.lastCacheSize = cacheSize;
        return false;
    }

    public boolean gotError() {
        return this.gotError;
    }

    public ArrayList<DynamicBean> getErrors() {
        return this.errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statusEvent(StatusType event) {
        this.statusComplete = false;
        if (event == null) {
            logger.warning("(event): Event is null.  Find out why");
            return;
        }
        ArrayList<StatusType> arrayList = this.statusCache;
        synchronized (arrayList) {
            this.statusCache.add(event);
        }
    }

    @Override
    public void statusComplete(Appliance appliance, Domain domain, String statusClass) {
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, StatusClass=%s)", () -> appliance.getName(), () -> domain.getName(), () -> statusClass));
        this.updateState();
    }

    @Override
    public void noStatus(Appliance appliance, Domain domain, String statusClass, DateTime statusTime) {
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, StatusClass=%s, statusTime)", () -> appliance.getName(), () -> domain.getName(), () -> statusClass, () -> statusTime));
        this.updateState();
    }

    private void updateState() {
        this.statusComplete = true;
        this.lastCacheSize = -1;
        --this.monitorCount;
    }

    @Override
    public void statusChanged(StatusType lastEvent, StatusType thisEvent) {
    }

    @Override
    public void error(Appliance appliance, Domain domain, String statusClass, int errorCode, StatusType lastEvent) {
        logger.finer(() -> LMG.log("(Appliance=%s, Domain=%s, StatusClass=%s, LastEvent=%s", () -> appliance.getName(), () -> domain.getName(), () -> statusClass, () -> String.valueOf(lastEvent)));
        this.gotError = true;
        DynamicBean error = new DynamicBean();
        error.setProperty("appliance", appliance);
        error.setProperty("domain", domain);
        error.setProperty("statusClass", statusClass);
        error.setProperty("lastEvent", lastEvent);
        if (this.errors == null) {
            this.errors = new ArrayList();
        }
        this.errors.add(error);
    }
}

