/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.beans.JMBean;
import com.jmorgan.util.collection.UniqueArrayList;
import com.kumbasoft.core.beans.Domain;
import java.util.ArrayList;

public class DomainGroup
extends JMBean
implements Comparable<DomainGroup> {
    private String groupName;
    private UniqueArrayList<Domain> domains = new UniqueArrayList();

    public DomainGroup() {
    }

    public DomainGroup(String groupName) {
        this();
        this.setGroupName(groupName);
    }

    public DomainGroup(Domain domain) {
        this(domain.getName());
        this.addDomain(domain);
    }

    public DomainGroup(String groupName, ArrayList<Domain> domains) {
        this(groupName);
        this.addDomains(domains);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public ArrayList<Domain> getDomains() {
        return this.domains;
    }

    public void addDomain(Domain domain) {
        this.domains.add(domain);
    }

    public void removeDomain(Domain domain) {
        Domain domainToRemove = null;
        for (Domain d : this.domains) {
            if (!d.getName().equals(domain.getName())) continue;
            domainToRemove = d;
            break;
        }
        if (domainToRemove != null) {
            this.domains.remove(domainToRemove);
        }
    }

    public void addDomains(ArrayList<Domain> domains) {
        this.domains.addAll(domains);
    }

    @Override
    public int compareTo(DomainGroup that) {
        return this.compareTo(that, "groupName");
    }

    @Override
    public int hashCode() {
        return this.hashCode("domains", "groupName");
    }

    public boolean equals(Object o) {
        return this.equals(o, "groupName");
    }
}

