/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.beans.JMBean;
import com.jmorgan.util.Pair;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Objects;

public class PrincipalInformation
extends JMBean
implements Comparable<PrincipalInformation> {
    private Principal principal;
    private String subjectDN;
    private String commonName;
    private ArrayList<String> organizationalUnits;
    private String organization;
    private String country;
    private String locality;
    private String state;
    private ArrayList<Pair<String, String>> otherProperties;

    public PrincipalInformation() {
    }

    public PrincipalInformation(Principal principal) {
        this();
        this.setPrincipal(principal);
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        String[] subjectElements;
        this.principal = principal;
        this.subjectDN = principal.getName();
        this.organizationalUnits = new ArrayList();
        String[] stringArray = subjectElements = this.subjectDN.split(",");
        int n = subjectElements.length;
        int n2 = 0;
        while (n2 < n) {
            block26: {
                String[] nvPair;
                String subjectElement = stringArray[n2];
                if ((subjectElement = subjectElement.trim()).startsWith("Subject DN:")) {
                    subjectElement = subjectElement.substring(13);
                }
                if ((nvPair = subjectElement.split("=")).length != 2) break block26;
                switch (nvPair[0].trim()) {
                    case "CN": {
                        this.commonName = nvPair[1].trim();
                        break;
                    }
                    case "C": {
                        this.country = nvPair[1].trim();
                        break;
                    }
                    case "L": {
                        this.locality = nvPair[1].trim();
                        break;
                    }
                    case "ST": {
                        this.state = nvPair[1].trim();
                        break;
                    }
                    case "O": {
                        this.organization = nvPair[1].trim();
                        break;
                    }
                    case "OU": {
                        this.organizationalUnits.add(nvPair[1].trim());
                        break;
                    }
                    default: {
                        if (this.otherProperties == null) {
                            this.otherProperties = new ArrayList();
                        }
                        if (nvPair.length < 2) {
                            System.err.printf("PrincipalInformation.setPrincipal(principal): Subject Element %s has no '='\n", subjectElement);
                            break;
                        }
                        this.otherProperties.add(new Pair<String, String>(nvPair[0].trim(), nvPair[1].trim()));
                    }
                }
            }
            ++n2;
        }
    }

    public String getSubjectDN() {
        return this.subjectDN;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public String getOrganization() {
        return this.organization;
    }

    public ArrayList<String> getOrganizationalUnits() {
        return this.organizationalUnits;
    }

    public String getCountry() {
        return this.country;
    }

    public String getLocality() {
        return this.locality;
    }

    public String getState() {
        return this.state;
    }

    public ArrayList<Pair<String, String>> getOtherProperties() {
        return this.otherProperties;
    }

    @Override
    public int compareTo(PrincipalInformation that) {
        return this.compareTo(that, "subjectDN");
    }

    public boolean equals(Object that) {
        return this.equals(that, "subjectDN");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subjectDN);
    }

    @Override
    public String toString() {
        return this.toString("subjectDN");
    }
}

