/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.beans.JMBean;
import com.jmorgan.lang.Application;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.beans.DataPowerStatus;
import com.kumbasoft.core.beans.DataPowerStatusFilterSpecification;
import com.kumbasoft.core.beans.StatusProviderGraphDefinition;
import com.kumbasoft.core.beans.StatusProviderMenuItemDefinition;
import java.util.ArrayList;

public class StatusProviderInfo
extends JMBean
implements Cloneable,
Comparable<StatusProviderInfo> {
    private Class<? extends DataPowerStatus> statusClass;
    private String name;
    private String displayName;
    private String applicableDomain;
    private int preferredMonitorInterval;
    private long maxDisplayedRows;
    private boolean isBeingMonitored;
    private ArrayList<DataPowerStatusFilterSpecification> filters;
    private boolean graphable;
    private ArrayList<String> graphableProperties;
    private ArrayList<StatusProviderGraphDefinition> graphs;
    private boolean dynamicPopupItemsSupported;
    private ArrayList<StatusProviderMenuItemDefinition> menuItems;
    private int timesViewed;

    public StatusProviderInfo() {
        this.setPreferredMonitorInterval(10000);
        this.setMaxDisplayedRows(100L);
    }

    public StatusProviderInfo(Class<? extends DataPowerStatus> statusClass) {
        this();
        this.setStatusClass(statusClass);
    }

    public StatusProviderInfo(Class<? extends DataPowerStatus> statusClass, String providerName, String domainMatch, String monitorInterval) {
        this.setName(providerName);
        this.setStatusClass(statusClass);
        this.setApplicableDomain(domainMatch);
        this.setPreferredMonitorInterval(Integer.parseInt(monitorInterval));
    }

    private StatusProviderInfo(StatusProviderInfo source) {
        this();
        this.setName(source.getName());
        this.setDisplayName(source.getDisplayName());
        this.setPreferredMonitorInterval(source.getPreferredMonitorInterval());
        this.setMaxDisplayedRows(source.getMaxDisplayedRows());
        this.setStatusClass(source.getStatusClass());
        this.setApplicableDomain(source.getApplicableDomain());
        this.setFilters(source.getFilters());
        this.setGraphable(source.isGraphable());
        this.setGraphs(source.getGraphs());
        this.setTimesViewed(source.getTimesViewed());
        this.setDynamicPopupItemsSupported(source.isDynamicPopupItemsSupported());
        this.setMenuItems(source.getMenuItems());
    }

    public Object clone() {
        return new StatusProviderInfo(this);
    }

    public Class<? extends DataPowerStatus> getStatusClass() {
        return this.statusClass;
    }

    public void setStatusClass(Class<? extends DataPowerStatus> statusClass) {
        this.statusClass = statusClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getApplicableDomain() {
        return this.applicableDomain;
    }

    public void setApplicableDomain(String applicableDomain) {
        if (StringUtility.isEmpty(applicableDomain) || applicableDomain.equals("*")) {
            applicableDomain = ".*";
        }
        this.applicableDomain = applicableDomain;
    }

    public int getTimesViewed() {
        return this.timesViewed;
    }

    public void incrementTimesViewed() {
        ++this.timesViewed;
    }

    public boolean isDynamicPopupItemsSupported() {
        return this.dynamicPopupItemsSupported;
    }

    public void setDynamicPopupItemsSupported(boolean popupSupported) {
        this.dynamicPopupItemsSupported = popupSupported;
    }

    public ArrayList<StatusProviderMenuItemDefinition> getMenuItems() {
        return this.menuItems;
    }

    public void setMenuItems(ArrayList<StatusProviderMenuItemDefinition> menuItems) {
        this.menuItems = menuItems;
    }

    public void addMenuItem(StatusProviderMenuItemDefinition menuItemDefinition) {
        if (menuItemDefinition == null) {
            return;
        }
        if (this.menuItems == null) {
            this.menuItems = new ArrayList();
        }
        this.menuItems.add(menuItemDefinition);
    }

    public void removeMenuItem(StatusProviderMenuItemDefinition menuItemDefinition) {
        if (menuItemDefinition == null || this.menuItems == null) {
            return;
        }
        this.menuItems.remove(menuItemDefinition);
    }

    public void setTimesViewed(int timesViewed) {
        this.timesViewed = timesViewed;
    }

    public int getPreferredMonitorInterval() {
        return this.preferredMonitorInterval;
    }

    public void setPreferredMonitorInterval(int preferredMonitorInterval) {
        this.preferredMonitorInterval = preferredMonitorInterval;
    }

    public long getMaxDisplayedRows() {
        return this.maxDisplayedRows;
    }

    public void setMaxDisplayedRows(long maxDisplayedRows) {
        this.maxDisplayedRows = maxDisplayedRows;
    }

    public boolean isBeingMonitored() {
        return this.isBeingMonitored;
    }

    public void setBeingMonitored(boolean isBeingMonitored) {
        this.isBeingMonitored = isBeingMonitored;
    }

    public void addFilter(DataPowerStatusFilterSpecification filter) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        if (this.filters.contains(filter)) {
            return;
        }
        this.filters.add(filter);
    }

    public DataPowerStatusFilterSpecification getFilter(String filterExpression) {
        if (this.filters == null) {
            return null;
        }
        for (DataPowerStatusFilterSpecification filterSpec : this.filters) {
            if (!filterSpec.getFilterSpecification().equalsIgnoreCase(filterExpression)) continue;
            return filterSpec;
        }
        return null;
    }

    public ArrayList<DataPowerStatusFilterSpecification> getFilters() {
        return this.filters;
    }

    public void setFilters(ArrayList<DataPowerStatusFilterSpecification> filters) {
        this.filters = filters;
    }

    public boolean isGraphable() {
        return this.graphable;
    }

    public void setGraphable(boolean graphable) {
        this.graphable = graphable;
    }

    public void setGraphableProperties(ArrayList<String> graphableProperties) {
        this.graphableProperties = graphableProperties;
    }

    public void addGraph(StatusProviderGraphDefinition spgd) {
        if (this.graphs == null) {
            this.graphs = new ArrayList();
        }
        Application.getApplication().getApplicationLogger().fine(String.format("StatusProviderInfo.addGraph(spgd=%s):  Added to %s\n", spgd.getGraphName(), this.name));
        this.graphs.add(spgd);
    }

    public void deleteGraph(StatusProviderGraphDefinition graphToDelete) {
        if (CollectionUtility.isEmpty(this.graphs)) {
            return;
        }
        if (graphToDelete != null) {
            Application.getApplication().getApplicationLogger().fine(String.format("StatusProviderInfo.deleteGraph(graphToDelete=%s):  Added to %s\n", graphToDelete.getGraphName(), this.name));
            this.graphs.remove(graphToDelete);
        }
    }

    public StatusProviderGraphDefinition getGraph(String graphDefinitionName) {
        if (CollectionUtility.isEmpty(this.graphs)) {
            return null;
        }
        for (StatusProviderGraphDefinition graph : this.graphs) {
            if (!graph.getGraphName().equals(graphDefinitionName)) continue;
            return graph;
        }
        return null;
    }

    public ArrayList<StatusProviderGraphDefinition> getGraphs() {
        if (this.graphs == null) {
            return new ArrayList<StatusProviderGraphDefinition>();
        }
        return this.graphs;
    }

    public void setGraphs(ArrayList<StatusProviderGraphDefinition> graphs) {
        this.graphs = graphs;
    }

    public ArrayList<String> getGraphableProperties() {
        return this.graphableProperties;
    }

    @Override
    public int compareTo(StatusProviderInfo that) {
        return this.compareTo(that, "name");
    }

    public boolean equals(Object o) {
        return this.equals(o, "name");
    }
}

