/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.actions;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.DataPowerAction;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigCryptoCertificate;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ActionConvertCertificate
extends DataPowerAction {
    private ObjectReference<ConfigCryptoCertificate> objectName;
    private String outputFilename;
    private String format;

    @XMLInfo(elementType="element", elementName="ObjectName", elementOrder=0, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="CryptoCertificate", isEnumeration=false, javaName="objectName", javaType="ObjectReference<ConfigCryptoCertificate>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Certificate Name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoCertificate> getObjectName() {
        return this.objectName;
    }

    @XMLInfo(elementType="element", elementName="ObjectName", elementOrder=0, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="CryptoCertificate", isEnumeration=false, javaName="objectName", javaType="ObjectReference<ConfigCryptoCertificate>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Certificate Name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setObjectName(ObjectReference<ConfigCryptoCertificate> objectName) {
        this.objectName = objectName;
    }

    @XMLInfo(elementType="element", elementName="OutputFilename", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="outputFilename", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^temporary:///[-_a-zA-Z0-9.]+$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Output File Name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOutputFilename() {
        return this.outputFilename;
    }

    @XMLInfo(elementType="element", elementName="OutputFilename", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="outputFilename", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^temporary:///[-_a-zA-Z0-9.]+$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Output File Name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOutputFilename(String outputFilename) {
        if (outputFilename != null && outputFilename.matches("^temporary:///[-_a-zA-Z0-9.]+$")) {
            this.outputFilename = outputFilename;
        }
    }

    @XMLInfo(elementType="element", elementName="Format", elementOrder=2, dataPowerType="dmCryptoConvertCertificateFormat", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="format", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Output Format", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getFormat() {
        return this.format;
    }

    @XMLInfo(elementType="element", elementName="Format", elementOrder=2, dataPowerType="dmCryptoConvertCertificateFormat", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="format", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Output Format", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFormat(String format) {
        if (format == null || Comparison.isIn(format, DPEnumerations.CRYPTO_CONVERT_CERTIFICATE_FORMAT)) {
            this.format = format;
        }
    }

    public int compareTo(ActionConvertCertificate that) {
        return this.compareTo(that, "objectName", "outputFilename", "format");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.objectName, this.outputFilename, this.format);
    }

    public boolean equals(Object that) {
        return this.equals(that, "objectName", "outputFilename", "format");
    }

    @Override
    public String toString() {
        return this.toString("objectName", "outputFilename", "format");
    }
}

