/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.actions;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.DataPowerAction;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ActionCreateTAMFiles
extends DataPowerAction {
    private String createCopy;
    private String outputConfigFile;
    private String administrator;
    private String password;
    private String tAMVersion;
    private String tAMDomain;
    private String application;
    private String host;
    private int port;
    private int sSLKeyFileLifetime;
    private long sSLTimeout;
    private String localMode;
    private String listenMode;
    private String localHost;
    private int localPort;
    private String useADRegistry;
    private String aDPrimaryDomain;
    private String aDPrimaryHost;
    private String aDPrimaryReplicas;
    private String lDAPServer;
    private int lDAPPort;
    private String lDAPBindPassword;
    private long lDAPAuthenticateTimeout;
    private long lDAPSearchTimeout;
    private long aDClientTimeout;
    private String enableRegistryCache;
    private int lDAPUserCacheSize;
    private int lDAPPolicyCacheSize;
    private String aDLdapCacheSize;
    private long aDLdapCacheLife;
    private String aDDnforpd;
    private String aDUseMultiDomain;
    private String aDDomaindomain;
    private String aDDomainHost;
    private String aDDomainReplicas;
    private String aDUseEmailUid;
    private String aDGcHost;

    @XMLInfo(elementType="element", elementName="CreateCopy", elementOrder=0, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="create-copy", refType="", isEnumeration=true, javaName="createCopy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Create file copies to download", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCreateCopy() {
        return this.createCopy;
    }

    @XMLInfo(elementType="element", elementName="CreateCopy", elementOrder=0, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="create-copy", refType="", isEnumeration=true, javaName="createCopy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Create file copies to download", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCreateCopy(String createCopy) {
        if (createCopy == null || Comparison.isIn(createCopy, DPEnumerations.TOGGLE)) {
            this.createCopy = createCopy;
        }
    }

    @XMLInfo(elementType="element", elementName="OutputConfigFile", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="file", refType="", isEnumeration=false, javaName="outputConfigFile", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[-_a-zA-Z0-9.]*$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Output configuration file name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOutputConfigFile() {
        return this.outputConfigFile;
    }

    @XMLInfo(elementType="element", elementName="OutputConfigFile", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="file", refType="", isEnumeration=false, javaName="outputConfigFile", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[-_a-zA-Z0-9.]*$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Output configuration file name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOutputConfigFile(String outputConfigFile) {
        if (outputConfigFile != null && outputConfigFile.matches("^[-_a-zA-Z0-9.]*$")) {
            this.outputConfigFile = outputConfigFile;
        }
    }

    @XMLInfo(elementType="element", elementName="Administrator", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="admin", refType="", isEnumeration=false, javaName="administrator", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="sec_master", displayOrder=0, displayValue="Access Manager administrator", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAdministrator() {
        return this.administrator;
    }

    @XMLInfo(elementType="element", elementName="Administrator", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="admin", refType="", isEnumeration=false, javaName="administrator", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="sec_master", displayValue="Access Manager administrator", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAdministrator(String administrator) {
        this.administrator = administrator;
    }

    @XMLInfo(elementType="element", elementName="Password", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="password", refType="", isEnumeration=false, javaName="password", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Administrator password", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPassword() {
        return this.password;
    }

    @XMLInfo(elementType="element", elementName="Password", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="password", refType="", isEnumeration=false, javaName="password", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Administrator password", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPassword(String password) {
        this.password = password;
    }

    @XMLInfo(elementType="element", elementName="TAMVersion", elementOrder=4, dataPowerType="dmTAMVersionType2", subType="", benign=false, isPassword=false, cliAlias="tam-version", refType="", isEnumeration=true, javaName="tAMVersion", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Access Manager version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTAMVersion() {
        return this.tAMVersion;
    }

    @XMLInfo(elementType="element", elementName="TAMVersion", elementOrder=4, dataPowerType="dmTAMVersionType2", subType="", benign=false, isPassword=false, cliAlias="tam-version", refType="", isEnumeration=true, javaName="tAMVersion", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Access Manager version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTAMVersion(String tAMVersion) {
        if (Comparison.isIn(tAMVersion, DPEnumerations.TAMVERSION_TYPE2)) {
            this.tAMVersion = tAMVersion;
        }
    }

    @XMLInfo(elementType="element", elementName="TAMDomain", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="tam-domain", refType="", isEnumeration=false, javaName="tAMDomain", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="Default", displayOrder=0, displayValue="Access Manager domain", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTAMDomain() {
        return this.tAMDomain;
    }

    @XMLInfo(elementType="element", elementName="TAMDomain", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="tam-domain", refType="", isEnumeration=false, javaName="tAMDomain", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="Default", displayValue="Access Manager domain", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTAMDomain(String tAMDomain) {
        this.tAMDomain = tAMDomain;
    }

    @XMLInfo(elementType="element", elementName="Application", elementOrder=6, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="application", refType="", isEnumeration=false, javaName="application", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Access Manager application ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getApplication() {
        return this.application;
    }

    @XMLInfo(elementType="element", elementName="Application", elementOrder=6, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="application", refType="", isEnumeration=false, javaName="application", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Access Manager application ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setApplication(String application) {
        this.application = application;
    }

    @XMLInfo(elementType="element", elementName="Host", elementOrder=7, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="host", refType="", isEnumeration=false, javaName="host", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Policy server", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHost() {
        return this.host;
    }

    @XMLInfo(elementType="element", elementName="Host", elementOrder=7, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="host", refType="", isEnumeration=false, javaName="host", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Policy server", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHost(String host) {
        this.host = host;
    }

    @XMLInfo(elementType="element", elementName="Port", elementOrder=8, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="port", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="7135", displayOrder=0, displayValue="Policy server manager port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getPort() {
        return this.port;
    }

    @XMLInfo(elementType="element", elementName="Port", elementOrder=8, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="port", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="7135", displayValue="Policy server manager port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPort(int port) {
        this.port = port;
    }

    @XMLInfo(elementType="element", elementName="SSLKeyFileLifetime", elementOrder=9, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="ssl-key-expiry", refType="", isEnumeration=false, javaName="sSLKeyFileLifetime", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=7200L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="183", displayOrder=0, displayValue="TLS key file lifetime", units="days", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getSSLKeyFileLifetime() {
        return this.sSLKeyFileLifetime;
    }

    @XMLInfo(elementType="element", elementName="SSLKeyFileLifetime", elementOrder=9, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="ssl-key-expiry", refType="", isEnumeration=false, javaName="sSLKeyFileLifetime", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=7200L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="183", displayValue="TLS key file lifetime", units="days", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLKeyFileLifetime(int sSLKeyFileLifetime) {
        this.sSLKeyFileLifetime = sSLKeyFileLifetime;
    }

    @XMLInfo(elementType="element", elementName="SSLTimeout", elementOrder=10, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="ssl-timeout", refType="", isEnumeration=false, javaName="sSLTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="7200", displayOrder=0, displayValue="TLS session timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getSSLTimeout() {
        return this.sSLTimeout;
    }

    @XMLInfo(elementType="element", elementName="SSLTimeout", elementOrder=10, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="ssl-timeout", refType="", isEnumeration=false, javaName="sSLTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="7200", displayValue="TLS session timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLTimeout(long sSLTimeout) {
        this.sSLTimeout = sSLTimeout;
    }

    @XMLInfo(elementType="element", elementName="LocalMode", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="local-mode", refType="", isEnumeration=true, javaName="localMode", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Use local authorization database", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLocalMode() {
        return this.localMode;
    }

    @XMLInfo(elementType="element", elementName="LocalMode", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="local-mode", refType="", isEnumeration=true, javaName="localMode", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Use local authorization database", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalMode(String localMode) {
        if (Comparison.isIn(localMode, DPEnumerations.TOGGLE)) {
            this.localMode = localMode;
        }
    }

    @XMLInfo(elementType="element", elementName="ListenMode", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="listen-mode", refType="", isEnumeration=true, javaName="listenMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Accept policy update notifications", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getListenMode() {
        return this.listenMode;
    }

    @XMLInfo(elementType="element", elementName="ListenMode", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="listen-mode", refType="", isEnumeration=true, javaName="listenMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Accept policy update notifications", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setListenMode(String listenMode) {
        if (listenMode == null || Comparison.isIn(listenMode, DPEnumerations.TOGGLE)) {
            this.listenMode = listenMode;
        }
    }

    @XMLInfo(elementType="element", elementName="LocalHost", elementOrder=13, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="local-host", refType="", isEnumeration=false, javaName="localHost", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Local authorization server", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLocalHost() {
        return this.localHost;
    }

    @XMLInfo(elementType="element", elementName="LocalHost", elementOrder=13, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="local-host", refType="", isEnumeration=false, javaName="localHost", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Local authorization server", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalHost(String localHost) {
        this.localHost = localHost;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=14, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="local-port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Local authorization port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLocalPort() {
        return this.localPort;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=14, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="local-port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Local authorization port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    @XMLInfo(elementType="element", elementName="UseADRegistry", elementOrder=15, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-ad-registry", refType="", isEnumeration=true, javaName="useADRegistry", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Use Active Directory", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUseADRegistry() {
        return this.useADRegistry;
    }

    @XMLInfo(elementType="element", elementName="UseADRegistry", elementOrder=15, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-ad-registry", refType="", isEnumeration=true, javaName="useADRegistry", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Use Active Directory", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUseADRegistry(String useADRegistry) {
        if (useADRegistry == null || Comparison.isIn(useADRegistry, DPEnumerations.TOGGLE)) {
            this.useADRegistry = useADRegistry;
        }
    }

    @XMLInfo(elementType="element", elementName="ADPrimaryDomain", elementOrder=16, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ad-primary-domain", refType="", isEnumeration=false, javaName="aDPrimaryDomain", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Active Directory primary domain", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getADPrimaryDomain() {
        return this.aDPrimaryDomain;
    }

    @XMLInfo(elementType="element", elementName="ADPrimaryDomain", elementOrder=16, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ad-primary-domain", refType="", isEnumeration=false, javaName="aDPrimaryDomain", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Active Directory primary domain", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setADPrimaryDomain(String aDPrimaryDomain) {
        this.aDPrimaryDomain = aDPrimaryDomain;
    }

    @XMLInfo(elementType="element", elementName="ADPrimaryHost", elementOrder=17, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="ad-primary-host", refType="", isEnumeration=false, javaName="aDPrimaryHost", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Active Directory primary domain host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getADPrimaryHost() {
        return this.aDPrimaryHost;
    }

    @XMLInfo(elementType="element", elementName="ADPrimaryHost", elementOrder=17, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="ad-primary-host", refType="", isEnumeration=false, javaName="aDPrimaryHost", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Active Directory primary domain host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setADPrimaryHost(String aDPrimaryHost) {
        this.aDPrimaryHost = aDPrimaryHost;
    }

    @XMLInfo(elementType="element", elementName="ADPrimaryReplicas", elementOrder=18, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ad-primary-replicas", refType="", isEnumeration=false, javaName="aDPrimaryReplicas", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Active Directory primary domain replica hosts", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getADPrimaryReplicas() {
        return this.aDPrimaryReplicas;
    }

    @XMLInfo(elementType="element", elementName="ADPrimaryReplicas", elementOrder=18, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ad-primary-replicas", refType="", isEnumeration=false, javaName="aDPrimaryReplicas", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Active Directory primary domain replica hosts", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setADPrimaryReplicas(String aDPrimaryReplicas) {
        this.aDPrimaryReplicas = aDPrimaryReplicas;
    }

    @XMLInfo(elementType="element", elementName="LDAPServer", elementOrder=19, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="ldap-host", refType="", isEnumeration=false, javaName="lDAPServer", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP server", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPServer() {
        return this.lDAPServer;
    }

    @XMLInfo(elementType="element", elementName="LDAPServer", elementOrder=19, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="ldap-host", refType="", isEnumeration=false, javaName="lDAPServer", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP server", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPServer(String lDAPServer) {
        this.lDAPServer = lDAPServer;
    }

    @XMLInfo(elementType="element", elementName="LDAPPort", elementOrder=20, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="ldap-port", refType="", isEnumeration=false, javaName="lDAPPort", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="389", displayOrder=0, displayValue="LDAP server port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLDAPPort() {
        return this.lDAPPort;
    }

    @XMLInfo(elementType="element", elementName="LDAPPort", elementOrder=20, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="ldap-port", refType="", isEnumeration=false, javaName="lDAPPort", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="389", displayValue="LDAP server port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPPort(int lDAPPort) {
        this.lDAPPort = lDAPPort;
    }

    @XMLInfo(elementType="element", elementName="LDAPBindPassword", elementOrder=21, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="ldap-password", refType="", isEnumeration=false, javaName="lDAPBindPassword", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP administrator password", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPBindPassword() {
        return this.lDAPBindPassword;
    }

    @XMLInfo(elementType="element", elementName="LDAPBindPassword", elementOrder=21, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="ldap-password", refType="", isEnumeration=false, javaName="lDAPBindPassword", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP administrator password", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPBindPassword(String lDAPBindPassword) {
        this.lDAPBindPassword = lDAPBindPassword;
    }

    @XMLInfo(elementType="element", elementName="LDAPAuthenticateTimeout", elementOrder=22, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="ldap-auth-timeout", refType="", isEnumeration=false, javaName="lDAPAuthenticateTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=600L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="30", displayOrder=0, displayValue="LDAP authentication timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getLDAPAuthenticateTimeout() {
        return this.lDAPAuthenticateTimeout;
    }

    @XMLInfo(elementType="element", elementName="LDAPAuthenticateTimeout", elementOrder=22, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="ldap-auth-timeout", refType="", isEnumeration=false, javaName="lDAPAuthenticateTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=600L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="30", displayValue="LDAP authentication timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPAuthenticateTimeout(long lDAPAuthenticateTimeout) {
        this.lDAPAuthenticateTimeout = lDAPAuthenticateTimeout;
    }

    @XMLInfo(elementType="element", elementName="LDAPSearchTimeout", elementOrder=23, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="ldap-search-timeout", refType="", isEnumeration=false, javaName="lDAPSearchTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=600L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="30", displayOrder=0, displayValue="LDAP search timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getLDAPSearchTimeout() {
        return this.lDAPSearchTimeout;
    }

    @XMLInfo(elementType="element", elementName="LDAPSearchTimeout", elementOrder=23, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="ldap-search-timeout", refType="", isEnumeration=false, javaName="lDAPSearchTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=600L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="30", displayValue="LDAP search timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPSearchTimeout(long lDAPSearchTimeout) {
        this.lDAPSearchTimeout = lDAPSearchTimeout;
    }

    @XMLInfo(elementType="element", elementName="ADClientTimeout", elementOrder=24, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="ldap-search-timeout", refType="", isEnumeration=false, javaName="aDClientTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=900L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="30", displayOrder=0, displayValue="Active Directory client timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getADClientTimeout() {
        return this.aDClientTimeout;
    }

    @XMLInfo(elementType="element", elementName="ADClientTimeout", elementOrder=24, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="ldap-search-timeout", refType="", isEnumeration=false, javaName="aDClientTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=900L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="30", displayValue="Active Directory client timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setADClientTimeout(long aDClientTimeout) {
        this.aDClientTimeout = aDClientTimeout;
    }

    @XMLInfo(elementType="element", elementName="EnableRegistryCache", elementOrder=25, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-ldap-cache", refType="", isEnumeration=true, javaName="enableRegistryCache", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable registry cache", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnableRegistryCache() {
        return this.enableRegistryCache;
    }

    @XMLInfo(elementType="element", elementName="EnableRegistryCache", elementOrder=25, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-ldap-cache", refType="", isEnumeration=true, javaName="enableRegistryCache", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable registry cache", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnableRegistryCache(String enableRegistryCache) {
        if (enableRegistryCache == null || Comparison.isIn(enableRegistryCache, DPEnumerations.TOGGLE)) {
            this.enableRegistryCache = enableRegistryCache;
        }
    }

    @XMLInfo(elementType="element", elementName="LDAPUserCacheSize", elementOrder=26, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="ldap-user-cache-size", refType="", isEnumeration=false, javaName="lDAPUserCacheSize", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="256", displayOrder=0, displayValue="Number of entries in the LDAP user cache", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLDAPUserCacheSize() {
        return this.lDAPUserCacheSize;
    }

    @XMLInfo(elementType="element", elementName="LDAPUserCacheSize", elementOrder=26, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="ldap-user-cache-size", refType="", isEnumeration=false, javaName="lDAPUserCacheSize", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="256", displayValue="Number of entries in the LDAP user cache", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPUserCacheSize(int lDAPUserCacheSize) {
        this.lDAPUserCacheSize = lDAPUserCacheSize;
    }

    @XMLInfo(elementType="element", elementName="LDAPPolicyCacheSize", elementOrder=27, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="ldap-policy-cache-size", refType="", isEnumeration=false, javaName="lDAPPolicyCacheSize", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="20", displayOrder=0, displayValue="Number of entries in the LDAP policy cache", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLDAPPolicyCacheSize() {
        return this.lDAPPolicyCacheSize;
    }

    @XMLInfo(elementType="element", elementName="LDAPPolicyCacheSize", elementOrder=27, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="ldap-policy-cache-size", refType="", isEnumeration=false, javaName="lDAPPolicyCacheSize", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="20", displayValue="Number of entries in the LDAP policy cache", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPPolicyCacheSize(int lDAPPolicyCacheSize) {
        this.lDAPPolicyCacheSize = lDAPPolicyCacheSize;
    }

    @XMLInfo(elementType="element", elementName="ADLdapCacheSize", elementOrder=28, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ad-ldap-cache-size", refType="", isEnumeration=false, javaName="aDLdapCacheSize", javaType="String", isRequired=false, squelchNull=false, minimum=3, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="251", displayOrder=0, displayValue="Number of object entries in the Active Directory cache", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getADLdapCacheSize() {
        return this.aDLdapCacheSize;
    }

    @XMLInfo(elementType="element", elementName="ADLdapCacheSize", elementOrder=28, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ad-ldap-cache-size", refType="", isEnumeration=false, javaName="aDLdapCacheSize", javaType="String", isRequired=false, squelchNull=false, minimum=3, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="251", displayValue="Number of object entries in the Active Directory cache", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setADLdapCacheSize(String aDLdapCacheSize) {
        this.aDLdapCacheSize = aDLdapCacheSize;
    }

    @XMLInfo(elementType="element", elementName="ADLdapCacheLife", elementOrder=29, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="ad-ldap-cache-life", refType="", isEnumeration=false, javaName="aDLdapCacheLife", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="300", displayOrder=0, displayValue="Lifetime of object entries in the Active Directory cache", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getADLdapCacheLife() {
        return this.aDLdapCacheLife;
    }

    @XMLInfo(elementType="element", elementName="ADLdapCacheLife", elementOrder=29, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="ad-ldap-cache-life", refType="", isEnumeration=false, javaName="aDLdapCacheLife", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="300", displayValue="Lifetime of object entries in the Active Directory cache", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setADLdapCacheLife(long aDLdapCacheLife) {
        this.aDLdapCacheLife = aDLdapCacheLife;
    }

    @XMLInfo(elementType="element", elementName="ADDnforpd", elementOrder=30, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ad-dnforpd", refType="", isEnumeration=false, javaName="aDDnforpd", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Active Directory Access Manager distinguished name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getADDnforpd() {
        return this.aDDnforpd;
    }

    @XMLInfo(elementType="element", elementName="ADDnforpd", elementOrder=30, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ad-dnforpd", refType="", isEnumeration=false, javaName="aDDnforpd", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Active Directory Access Manager distinguished name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setADDnforpd(String aDDnforpd) {
        this.aDDnforpd = aDDnforpd;
    }

    @XMLInfo(elementType="element", elementName="ADUseMultiDomain", elementOrder=31, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ad-use-multi-domain", refType="", isEnumeration=true, javaName="aDUseMultiDomain", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable for Active Directory multi-domain configuration", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getADUseMultiDomain() {
        return this.aDUseMultiDomain;
    }

    @XMLInfo(elementType="element", elementName="ADUseMultiDomain", elementOrder=31, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ad-use-multi-domain", refType="", isEnumeration=true, javaName="aDUseMultiDomain", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable for Active Directory multi-domain configuration", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setADUseMultiDomain(String aDUseMultiDomain) {
        if (aDUseMultiDomain == null || Comparison.isIn(aDUseMultiDomain, DPEnumerations.TOGGLE)) {
            this.aDUseMultiDomain = aDUseMultiDomain;
        }
    }

    @XMLInfo(elementType="element", elementName="ADDomaindomain", elementOrder=32, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ad-domain-domain", refType="", isEnumeration=false, javaName="aDDomaindomain", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Active Directory secondary domain", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getADDomaindomain() {
        return this.aDDomaindomain;
    }

    @XMLInfo(elementType="element", elementName="ADDomaindomain", elementOrder=32, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ad-domain-domain", refType="", isEnumeration=false, javaName="aDDomaindomain", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Active Directory secondary domain", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setADDomaindomain(String aDDomaindomain) {
        this.aDDomaindomain = aDDomaindomain;
    }

    @XMLInfo(elementType="element", elementName="ADDomainHost", elementOrder=33, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="ad-domain-host", refType="", isEnumeration=false, javaName="aDDomainHost", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Active Directory secondary domain host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getADDomainHost() {
        return this.aDDomainHost;
    }

    @XMLInfo(elementType="element", elementName="ADDomainHost", elementOrder=33, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="ad-domain-host", refType="", isEnumeration=false, javaName="aDDomainHost", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Active Directory secondary domain host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setADDomainHost(String aDDomainHost) {
        this.aDDomainHost = aDDomainHost;
    }

    @XMLInfo(elementType="element", elementName="ADDomainReplicas", elementOrder=34, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ad-domain-replicas", refType="", isEnumeration=false, javaName="aDDomainReplicas", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Active Directory secondary domain replica hosts", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getADDomainReplicas() {
        return this.aDDomainReplicas;
    }

    @XMLInfo(elementType="element", elementName="ADDomainReplicas", elementOrder=34, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ad-domain-replicas", refType="", isEnumeration=false, javaName="aDDomainReplicas", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Active Directory secondary domain replica hosts", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setADDomainReplicas(String aDDomainReplicas) {
        this.aDDomainReplicas = aDDomainReplicas;
    }

    @XMLInfo(elementType="element", elementName="ADUseEmailUid", elementOrder=35, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ad-use-email-uid", refType="", isEnumeration=true, javaName="aDUseEmailUid", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Allow email format for userPrincipalName attribute", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getADUseEmailUid() {
        return this.aDUseEmailUid;
    }

    @XMLInfo(elementType="element", elementName="ADUseEmailUid", elementOrder=35, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ad-use-email-uid", refType="", isEnumeration=true, javaName="aDUseEmailUid", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Allow email format for userPrincipalName attribute", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setADUseEmailUid(String aDUseEmailUid) {
        if (aDUseEmailUid == null || Comparison.isIn(aDUseEmailUid, DPEnumerations.TOGGLE)) {
            this.aDUseEmailUid = aDUseEmailUid;
        }
    }

    @XMLInfo(elementType="element", elementName="ADGcHost", elementOrder=36, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="ad-gc-host", refType="", isEnumeration=false, javaName="aDGcHost", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Active Directory global catalog host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getADGcHost() {
        return this.aDGcHost;
    }

    @XMLInfo(elementType="element", elementName="ADGcHost", elementOrder=36, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="ad-gc-host", refType="", isEnumeration=false, javaName="aDGcHost", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Active Directory global catalog host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setADGcHost(String aDGcHost) {
        this.aDGcHost = aDGcHost;
    }

    public int compareTo(ActionCreateTAMFiles that) {
        return this.compareTo(that, "createCopy", "outputConfigFile", "administrator", "password", "tAMVersion", "tAMDomain", "application", "host", "port", "sSLKeyFileLifetime", "sSLTimeout", "localMode", "listenMode", "localHost", "localPort", "useADRegistry", "aDPrimaryDomain", "aDPrimaryHost", "aDPrimaryReplicas", "lDAPServer", "lDAPPort", "lDAPBindPassword", "lDAPAuthenticateTimeout", "lDAPSearchTimeout", "aDClientTimeout", "enableRegistryCache", "lDAPUserCacheSize", "lDAPPolicyCacheSize", "aDLdapCacheSize", "aDLdapCacheLife", "aDDnforpd", "aDUseMultiDomain", "aDDomaindomain", "aDDomainHost", "aDDomainReplicas", "aDUseEmailUid", "aDGcHost");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.createCopy, this.outputConfigFile, this.administrator, this.password, this.tAMVersion, this.tAMDomain, this.application, this.host, this.port, this.sSLKeyFileLifetime, this.sSLTimeout, this.localMode, this.listenMode, this.localHost, this.localPort, this.useADRegistry, this.aDPrimaryDomain, this.aDPrimaryHost, this.aDPrimaryReplicas, this.lDAPServer, this.lDAPPort, this.lDAPBindPassword, this.lDAPAuthenticateTimeout, this.lDAPSearchTimeout, this.aDClientTimeout, this.enableRegistryCache, this.lDAPUserCacheSize, this.lDAPPolicyCacheSize, this.aDLdapCacheSize, this.aDLdapCacheLife, this.aDDnforpd, this.aDUseMultiDomain, this.aDDomaindomain, this.aDDomainHost, this.aDDomainReplicas, this.aDUseEmailUid, this.aDGcHost);
    }

    public boolean equals(Object that) {
        return this.equals(that, "createCopy", "outputConfigFile", "administrator", "password", "tAMVersion", "tAMDomain", "application", "host", "port", "sSLKeyFileLifetime", "sSLTimeout", "localMode", "listenMode", "localHost", "localPort", "useADRegistry", "aDPrimaryDomain", "aDPrimaryHost", "aDPrimaryReplicas", "lDAPServer", "lDAPPort", "lDAPBindPassword", "lDAPAuthenticateTimeout", "lDAPSearchTimeout", "aDClientTimeout", "enableRegistryCache", "lDAPUserCacheSize", "lDAPPolicyCacheSize", "aDLdapCacheSize", "aDLdapCacheLife", "aDDnforpd", "aDUseMultiDomain", "aDDomaindomain", "aDDomainHost", "aDDomainReplicas", "aDUseEmailUid", "aDGcHost");
    }

    @Override
    public String toString() {
        return this.toString("createCopy", "outputConfigFile", "administrator", "password", "tAMVersion", "tAMDomain", "application", "host", "port", "sSLKeyFileLifetime", "sSLTimeout", "localMode", "listenMode", "localHost", "localPort", "useADRegistry", "aDPrimaryDomain", "aDPrimaryHost", "aDPrimaryReplicas", "lDAPServer", "lDAPPort", "lDAPBindPassword", "lDAPAuthenticateTimeout", "lDAPSearchTimeout", "aDClientTimeout", "enableRegistryCache", "lDAPUserCacheSize", "lDAPPolicyCacheSize", "aDLdapCacheSize", "aDLdapCacheLife", "aDDnforpd", "aDUseMultiDomain", "aDDomaindomain", "aDDomainHost", "aDDomainReplicas", "aDUseEmailUid", "aDGcHost");
    }
}

