/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.actions;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.DataPowerAction;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ActionCryptoExport
extends DataPowerAction {
    private String objectType;
    private String objectName;
    private String outputFilename;
    private String mechanism;

    @XMLInfo(elementType="element", elementName="ObjectType", elementOrder=0, dataPowerType="dmCryptoObjectType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="objectType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Object Type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getObjectType() {
        return this.objectType;
    }

    @XMLInfo(elementType="element", elementName="ObjectType", elementOrder=0, dataPowerType="dmCryptoObjectType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="objectType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Object Type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setObjectType(String objectType) {
        if (objectType == null || Comparison.isIn(objectType, DPEnumerations.CRYPTO_OBJECT_TYPE)) {
            this.objectType = objectType;
        }
    }

    @XMLInfo(elementType="element", elementName="ObjectName", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="objectName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[-_a-zA-Z0-9.]+$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Object Name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getObjectName() {
        return this.objectName;
    }

    @XMLInfo(elementType="element", elementName="ObjectName", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="objectName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[-_a-zA-Z0-9.]+$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Object Name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setObjectName(String objectName) {
        if (objectName != null && objectName.matches("^[-_a-zA-Z0-9.]+$")) {
            this.objectName = objectName;
        }
    }

    @XMLInfo(elementType="element", elementName="OutputFilename", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="outputFilename", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[-_a-zA-Z0-9.]+$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Output File Name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOutputFilename() {
        return this.outputFilename;
    }

    @XMLInfo(elementType="element", elementName="OutputFilename", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="outputFilename", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[-_a-zA-Z0-9.]+$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Output File Name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOutputFilename(String outputFilename) {
        if (outputFilename != null && outputFilename.matches("^[-_a-zA-Z0-9.]+$")) {
            this.outputFilename = outputFilename;
        }
    }

    @XMLInfo(elementType="element", elementName="Mechanism", elementOrder=3, dataPowerType="dmCryptoExportMechanism", subType="", benign=false, isPassword=false, cliAlias="mechanism", refType="", isEnumeration=true, javaName="mechanism", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Encryption Mechanism", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMechanism() {
        return this.mechanism;
    }

    @XMLInfo(elementType="element", elementName="Mechanism", elementOrder=3, dataPowerType="dmCryptoExportMechanism", subType="", benign=false, isPassword=false, cliAlias="mechanism", refType="", isEnumeration=true, javaName="mechanism", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Encryption Mechanism", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMechanism(String mechanism) {
        if (mechanism == null || Comparison.isIn(mechanism, DPEnumerations.CRYPTO_EXPORT_MECHANISM)) {
            this.mechanism = mechanism;
        }
    }

    public int compareTo(ActionCryptoExport that) {
        return this.compareTo(that, "objectType", "objectName", "outputFilename", "mechanism");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.objectType, this.objectName, this.outputFilename, this.mechanism);
    }

    public boolean equals(Object that) {
        return this.equals(that, "objectType", "objectName", "outputFilename", "mechanism");
    }

    @Override
    public String toString() {
        return this.toString("objectType", "objectName", "outputFilename", "mechanism");
    }
}

