/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAPIApplicationType;
import com.kumbasoft.core.beans.config.ConfigAPIPlan;
import com.kumbasoft.core.beans.config.ConfigAPIRule;
import com.kumbasoft.core.beans.config.ConfigAnalyticsEndpoint;
import com.kumbasoft.core.beans.config.ConfigAssembly;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigRateLimitDefinitionGroup;
import com.kumbasoft.core.beans.types.APIBurstLimit;
import com.kumbasoft.core.beans.types.APICountLimit;
import com.kumbasoft.core.beans.types.APIRateLimit;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.DynamicParseSettingsReference;
import com.kumbasoft.core.beans.types.RoutingPrefix;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigAPICollection
extends ConfigConfigBase {
    private String userSummary;
    private String sandbox;
    private String orgID;
    private String orgName;
    private String catalogID;
    private String catalogName;
    private String devPortalEndpoint;
    private long cacheCapacity;
    private ArrayList<RoutingPrefix> routingPrefix;
    private String useRateLimitGroup;
    private ArrayList<APIRateLimit> defaultRateLimit;
    private ObjectReference<ConfigRateLimitDefinitionGroup> rateLimitGroup;
    private ArrayList<APIBurstLimit> assemblyBurstLimit;
    private ArrayList<APIRateLimit> assemblyRateLimit;
    private ArrayList<APICountLimit> assemblyCountLimit;
    private String enforcePreAssemblyRateLimits;
    private ObjectReference<ConfigAPIRule> aPIProcessingRule;
    private ObjectReference<ConfigAPIRule> aPIErrorRule;
    private ObjectReference<ConfigAssembly> assemblyPreflow;
    private ObjectReference<ConfigAssembly> assemblyPostflow;
    private ArrayList<ObjectReference<ConfigAPIPlan>> plan;
    private ObjectReference<ConfigAnalyticsEndpoint> analyticsEndpoint;
    private ArrayList<ObjectReference<ConfigAPIApplicationType>> applicationType;
    private DynamicParseSettingsReference parseSettingsReference;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Sandbox", elementOrder=2, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="sandbox", refType="", isEnumeration=true, javaName="sandbox", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Sandbox", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSandbox() {
        return this.sandbox;
    }

    @XMLInfo(elementType="element", elementName="Sandbox", elementOrder=2, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="sandbox", refType="", isEnumeration=true, javaName="sandbox", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Sandbox", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSandbox(String sandbox) {
        if (sandbox == null || Comparison.isIn(sandbox, DPEnumerations.TOGGLE)) {
            this.sandbox = sandbox;
        }
    }

    @XMLInfo(elementType="element", elementName="OrgID", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="organization-id", refType="", isEnumeration=false, javaName="orgID", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Organization ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOrgID() {
        return this.orgID;
    }

    @XMLInfo(elementType="element", elementName="OrgID", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="organization-id", refType="", isEnumeration=false, javaName="orgID", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Organization ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    @XMLInfo(elementType="element", elementName="OrgName", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="organization-name", refType="", isEnumeration=false, javaName="orgName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Organization name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOrgName() {
        return this.orgName;
    }

    @XMLInfo(elementType="element", elementName="OrgName", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="organization-name", refType="", isEnumeration=false, javaName="orgName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Organization name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @XMLInfo(elementType="element", elementName="CatalogID", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="catalog-id", refType="", isEnumeration=false, javaName="catalogID", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="default-catalog-id", displayOrder=0, displayValue="Catalog ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCatalogID() {
        return this.catalogID;
    }

    @XMLInfo(elementType="element", elementName="CatalogID", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="catalog-id", refType="", isEnumeration=false, javaName="catalogID", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="default-catalog-id", displayValue="Catalog ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCatalogID(String catalogID) {
        this.catalogID = catalogID;
    }

    @XMLInfo(elementType="element", elementName="CatalogName", elementOrder=6, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="catalog-name", refType="", isEnumeration=false, javaName="catalogName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="default", displayOrder=0, displayValue="Catalog name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCatalogName() {
        return this.catalogName;
    }

    @XMLInfo(elementType="element", elementName="CatalogName", elementOrder=6, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="catalog-name", refType="", isEnumeration=false, javaName="catalogName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="default", displayValue="Catalog name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @XMLInfo(elementType="element", elementName="DevPortalEndpoint", elementOrder=7, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="dev-portal-endpoint", refType="", isEnumeration=false, javaName="devPortalEndpoint", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Developer Portal endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDevPortalEndpoint() {
        return this.devPortalEndpoint;
    }

    @XMLInfo(elementType="element", elementName="DevPortalEndpoint", elementOrder=7, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="dev-portal-endpoint", refType="", isEnumeration=false, javaName="devPortalEndpoint", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Developer Portal endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDevPortalEndpoint(String devPortalEndpoint) {
        this.devPortalEndpoint = devPortalEndpoint;
    }

    @XMLInfo(elementType="element", elementName="CacheCapacity", elementOrder=8, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="cache-capacity", refType="", isEnumeration=false, javaName="cacheCapacity", javaType="long", isRequired=false, squelchNull=false, minimum=8, maximum=51200L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="128", displayOrder=0, displayValue="Subscriber cache capacity", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getCacheCapacity() {
        return this.cacheCapacity;
    }

    @XMLInfo(elementType="element", elementName="CacheCapacity", elementOrder=8, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="cache-capacity", refType="", isEnumeration=false, javaName="cacheCapacity", javaType="long", isRequired=false, squelchNull=false, minimum=8, maximum=51200L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="128", displayValue="Subscriber cache capacity", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCacheCapacity(long cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    public void addRoutingPrefix(RoutingPrefix element) {
        if (element == null) {
            return;
        }
        if (this.routingPrefix == null) {
            this.routingPrefix = new ArrayList();
        }
        this.routingPrefix.add(element);
    }

    public boolean removeRoutingPrefix(RoutingPrefix element) {
        if (element == null || this.routingPrefix == null) {
            return false;
        }
        return this.routingPrefix.remove(element);
    }

    @XMLInfo(elementType="element", elementName="RoutingPrefix", elementOrder=9, dataPowerType="dmRoutingPrefix", subType="", benign=false, isPassword=false, cliAlias="routing-prefix", refType="", isEnumeration=false, javaName="routingPrefix", javaType="RoutingPrefix", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Routing prefixes", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<RoutingPrefix> getRoutingPrefix() {
        return this.routingPrefix;
    }

    @XMLInfo(elementType="element", elementName="RoutingPrefix", elementOrder=9, dataPowerType="dmRoutingPrefix", subType="", benign=false, isPassword=false, cliAlias="routing-prefix", refType="", isEnumeration=false, javaName="routingPrefix", javaType="RoutingPrefix", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Routing prefixes", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRoutingPrefix(ArrayList<RoutingPrefix> routingPrefix) {
        this.routingPrefix = routingPrefix;
    }

    @XMLInfo(elementType="element", elementName="UseRateLimitGroup", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-rate-limit-group", refType="", isEnumeration=true, javaName="useRateLimitGroup", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Use rate limit group", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUseRateLimitGroup() {
        return this.useRateLimitGroup;
    }

    @XMLInfo(elementType="element", elementName="UseRateLimitGroup", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-rate-limit-group", refType="", isEnumeration=true, javaName="useRateLimitGroup", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Use rate limit group", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUseRateLimitGroup(String useRateLimitGroup) {
        if (useRateLimitGroup == null || Comparison.isIn(useRateLimitGroup, DPEnumerations.TOGGLE)) {
            this.useRateLimitGroup = useRateLimitGroup;
        }
    }

    public void addDefaultRateLimit(APIRateLimit element) {
        if (element == null) {
            return;
        }
        if (this.defaultRateLimit == null) {
            this.defaultRateLimit = new ArrayList();
        }
        this.defaultRateLimit.add(element);
    }

    public boolean removeDefaultRateLimit(APIRateLimit element) {
        if (element == null || this.defaultRateLimit == null) {
            return false;
        }
        return this.defaultRateLimit.remove(element);
    }

    @XMLInfo(elementType="element", elementName="DefaultRateLimit", elementOrder=11, dataPowerType="dmAPIRateLimit", subType="", benign=false, isPassword=false, cliAlias="default-rate-limit", refType="", isEnumeration=false, javaName="defaultRateLimit", javaType="APIRateLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Default rate limit", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APIRateLimit> getDefaultRateLimit() {
        return this.defaultRateLimit;
    }

    @XMLInfo(elementType="element", elementName="DefaultRateLimit", elementOrder=11, dataPowerType="dmAPIRateLimit", subType="", benign=false, isPassword=false, cliAlias="default-rate-limit", refType="", isEnumeration=false, javaName="defaultRateLimit", javaType="APIRateLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Default rate limit", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDefaultRateLimit(ArrayList<APIRateLimit> defaultRateLimit) {
        this.defaultRateLimit = defaultRateLimit;
    }

    @XMLInfo(elementType="element", elementName="RateLimitGroup", elementOrder=12, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="rate-limit-group", refType="RateLimitDefinitionGroup", isEnumeration=false, javaName="rateLimitGroup", javaType="ObjectReference<ConfigRateLimitDefinitionGroup>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Rate limit group", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigRateLimitDefinitionGroup> getRateLimitGroup() {
        return this.rateLimitGroup;
    }

    @XMLInfo(elementType="element", elementName="RateLimitGroup", elementOrder=12, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="rate-limit-group", refType="RateLimitDefinitionGroup", isEnumeration=false, javaName="rateLimitGroup", javaType="ObjectReference<ConfigRateLimitDefinitionGroup>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Rate limit group", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRateLimitGroup(ObjectReference<ConfigRateLimitDefinitionGroup> rateLimitGroup) {
        this.rateLimitGroup = rateLimitGroup;
    }

    public void addAssemblyBurstLimit(APIBurstLimit element) {
        if (element == null) {
            return;
        }
        if (this.assemblyBurstLimit == null) {
            this.assemblyBurstLimit = new ArrayList();
        }
        this.assemblyBurstLimit.add(element);
    }

    public boolean removeAssemblyBurstLimit(APIBurstLimit element) {
        if (element == null || this.assemblyBurstLimit == null) {
            return false;
        }
        return this.assemblyBurstLimit.remove(element);
    }

    @XMLInfo(elementType="element", elementName="AssemblyBurstLimit", elementOrder=13, dataPowerType="dmAPIBurstLimit", subType="", benign=false, isPassword=false, cliAlias="assembly-burst-limit", refType="", isEnumeration=false, javaName="assemblyBurstLimit", javaType="APIBurstLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Assembly burst limit", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APIBurstLimit> getAssemblyBurstLimit() {
        return this.assemblyBurstLimit;
    }

    @XMLInfo(elementType="element", elementName="AssemblyBurstLimit", elementOrder=13, dataPowerType="dmAPIBurstLimit", subType="", benign=false, isPassword=false, cliAlias="assembly-burst-limit", refType="", isEnumeration=false, javaName="assemblyBurstLimit", javaType="APIBurstLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Assembly burst limit", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAssemblyBurstLimit(ArrayList<APIBurstLimit> assemblyBurstLimit) {
        this.assemblyBurstLimit = assemblyBurstLimit;
    }

    public void addAssemblyRateLimit(APIRateLimit element) {
        if (element == null) {
            return;
        }
        if (this.assemblyRateLimit == null) {
            this.assemblyRateLimit = new ArrayList();
        }
        this.assemblyRateLimit.add(element);
    }

    public boolean removeAssemblyRateLimit(APIRateLimit element) {
        if (element == null || this.assemblyRateLimit == null) {
            return false;
        }
        return this.assemblyRateLimit.remove(element);
    }

    @XMLInfo(elementType="element", elementName="AssemblyRateLimit", elementOrder=14, dataPowerType="dmAPIRateLimit", subType="", benign=false, isPassword=false, cliAlias="assembly-rate-limit", refType="", isEnumeration=false, javaName="assemblyRateLimit", javaType="APIRateLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Assembly rate limit", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APIRateLimit> getAssemblyRateLimit() {
        return this.assemblyRateLimit;
    }

    @XMLInfo(elementType="element", elementName="AssemblyRateLimit", elementOrder=14, dataPowerType="dmAPIRateLimit", subType="", benign=false, isPassword=false, cliAlias="assembly-rate-limit", refType="", isEnumeration=false, javaName="assemblyRateLimit", javaType="APIRateLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Assembly rate limit", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAssemblyRateLimit(ArrayList<APIRateLimit> assemblyRateLimit) {
        this.assemblyRateLimit = assemblyRateLimit;
    }

    public void addAssemblyCountLimit(APICountLimit element) {
        if (element == null) {
            return;
        }
        if (this.assemblyCountLimit == null) {
            this.assemblyCountLimit = new ArrayList();
        }
        this.assemblyCountLimit.add(element);
    }

    public boolean removeAssemblyCountLimit(APICountLimit element) {
        if (element == null || this.assemblyCountLimit == null) {
            return false;
        }
        return this.assemblyCountLimit.remove(element);
    }

    @XMLInfo(elementType="element", elementName="AssemblyCountLimit", elementOrder=15, dataPowerType="dmAPICountLimit", subType="", benign=false, isPassword=false, cliAlias="assembly-count-limit", refType="", isEnumeration=false, javaName="assemblyCountLimit", javaType="APICountLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Assembly count limit", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APICountLimit> getAssemblyCountLimit() {
        return this.assemblyCountLimit;
    }

    @XMLInfo(elementType="element", elementName="AssemblyCountLimit", elementOrder=15, dataPowerType="dmAPICountLimit", subType="", benign=false, isPassword=false, cliAlias="assembly-count-limit", refType="", isEnumeration=false, javaName="assemblyCountLimit", javaType="APICountLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Assembly count limit", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAssemblyCountLimit(ArrayList<APICountLimit> assemblyCountLimit) {
        this.assemblyCountLimit = assemblyCountLimit;
    }

    @XMLInfo(elementType="element", elementName="EnforcePreAssemblyRateLimits", elementOrder=16, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enforce-pre-assembly-rate-limits", refType="", isEnumeration=true, javaName="enforcePreAssemblyRateLimits", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Enforce preassembly rate limits", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnforcePreAssemblyRateLimits() {
        return this.enforcePreAssemblyRateLimits;
    }

    @XMLInfo(elementType="element", elementName="EnforcePreAssemblyRateLimits", elementOrder=16, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enforce-pre-assembly-rate-limits", refType="", isEnumeration=true, javaName="enforcePreAssemblyRateLimits", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Enforce preassembly rate limits", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnforcePreAssemblyRateLimits(String enforcePreAssemblyRateLimits) {
        if (enforcePreAssemblyRateLimits == null || Comparison.isIn(enforcePreAssemblyRateLimits, DPEnumerations.TOGGLE)) {
            this.enforcePreAssemblyRateLimits = enforcePreAssemblyRateLimits;
        }
    }

    @XMLInfo(elementType="element", elementName="APIProcessingRule", elementOrder=17, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="processing-rule", refType="APIRule", isEnumeration=false, javaName="aPIProcessingRule", javaType="ObjectReference<ConfigAPIRule>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="default-api-rule", displayOrder=0, displayValue="API processing rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAPIRule> getAPIProcessingRule() {
        return this.aPIProcessingRule;
    }

    @XMLInfo(elementType="element", elementName="APIProcessingRule", elementOrder=17, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="processing-rule", refType="APIRule", isEnumeration=false, javaName="aPIProcessingRule", javaType="ObjectReference<ConfigAPIRule>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="default-api-rule", displayValue="API processing rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPIProcessingRule(ObjectReference<ConfigAPIRule> aPIProcessingRule) {
        this.aPIProcessingRule = aPIProcessingRule;
    }

    @XMLInfo(elementType="element", elementName="APIErrorRule", elementOrder=18, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="error-rule", refType="APIRule", isEnumeration=false, javaName="aPIErrorRule", javaType="ObjectReference<ConfigAPIRule>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="default-api-error-rule", displayOrder=0, displayValue="API error rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAPIRule> getAPIErrorRule() {
        return this.aPIErrorRule;
    }

    @XMLInfo(elementType="element", elementName="APIErrorRule", elementOrder=18, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="error-rule", refType="APIRule", isEnumeration=false, javaName="aPIErrorRule", javaType="ObjectReference<ConfigAPIRule>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="default-api-error-rule", displayValue="API error rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPIErrorRule(ObjectReference<ConfigAPIRule> aPIErrorRule) {
        this.aPIErrorRule = aPIErrorRule;
    }

    @XMLInfo(elementType="element", elementName="AssemblyPreflow", elementOrder=19, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="assembly-preprocessing", refType="Assembly", isEnumeration=false, javaName="assemblyPreflow", javaType="ObjectReference<ConfigAssembly>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Assembly preprocessing", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAssembly> getAssemblyPreflow() {
        return this.assemblyPreflow;
    }

    @XMLInfo(elementType="element", elementName="AssemblyPreflow", elementOrder=19, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="assembly-preprocessing", refType="Assembly", isEnumeration=false, javaName="assemblyPreflow", javaType="ObjectReference<ConfigAssembly>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Assembly preprocessing", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAssemblyPreflow(ObjectReference<ConfigAssembly> assemblyPreflow) {
        this.assemblyPreflow = assemblyPreflow;
    }

    @XMLInfo(elementType="element", elementName="AssemblyPostflow", elementOrder=20, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="assembly-postprocessing", refType="Assembly", isEnumeration=false, javaName="assemblyPostflow", javaType="ObjectReference<ConfigAssembly>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Assembly postprocessing", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAssembly> getAssemblyPostflow() {
        return this.assemblyPostflow;
    }

    @XMLInfo(elementType="element", elementName="AssemblyPostflow", elementOrder=20, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="assembly-postprocessing", refType="Assembly", isEnumeration=false, javaName="assemblyPostflow", javaType="ObjectReference<ConfigAssembly>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Assembly postprocessing", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAssemblyPostflow(ObjectReference<ConfigAssembly> assemblyPostflow) {
        this.assemblyPostflow = assemblyPostflow;
    }

    public void addPlan(ObjectReference<ConfigAPIPlan> element) {
        if (element == null) {
            return;
        }
        if (this.plan == null) {
            this.plan = new ArrayList();
        }
        this.plan.add(element);
    }

    public boolean removePlan(ObjectReference<ConfigAPIPlan> element) {
        if (element == null || this.plan == null) {
            return false;
        }
        return this.plan.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Plan", elementOrder=21, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="plan", refType="APIPlan", isEnumeration=false, javaName="plan", javaType="ObjectReference<ConfigAPIPlan>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Plans", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference<ConfigAPIPlan>> getPlan() {
        return this.plan;
    }

    @XMLInfo(elementType="element", elementName="Plan", elementOrder=21, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="plan", refType="APIPlan", isEnumeration=false, javaName="plan", javaType="ObjectReference<ConfigAPIPlan>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Plans", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPlan(ArrayList<ObjectReference<ConfigAPIPlan>> plan) {
        this.plan = plan;
    }

    @XMLInfo(elementType="element", elementName="AnalyticsEndpoint", elementOrder=22, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="analytics-endpoint", refType="AnalyticsEndpoint", isEnumeration=false, javaName="analyticsEndpoint", javaType="ObjectReference<ConfigAnalyticsEndpoint>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Analytic endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAnalyticsEndpoint> getAnalyticsEndpoint() {
        return this.analyticsEndpoint;
    }

    @XMLInfo(elementType="element", elementName="AnalyticsEndpoint", elementOrder=22, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="analytics-endpoint", refType="AnalyticsEndpoint", isEnumeration=false, javaName="analyticsEndpoint", javaType="ObjectReference<ConfigAnalyticsEndpoint>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Analytic endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAnalyticsEndpoint(ObjectReference<ConfigAnalyticsEndpoint> analyticsEndpoint) {
        this.analyticsEndpoint = analyticsEndpoint;
    }

    public void addApplicationType(ObjectReference<ConfigAPIApplicationType> element) {
        if (element == null) {
            return;
        }
        if (this.applicationType == null) {
            this.applicationType = new ArrayList();
        }
        this.applicationType.add(element);
    }

    public boolean removeApplicationType(ObjectReference<ConfigAPIApplicationType> element) {
        if (element == null || this.applicationType == null) {
            return false;
        }
        return this.applicationType.remove(element);
    }

    @XMLInfo(elementType="element", elementName="ApplicationType", elementOrder=23, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="application-type", refType="APIApplicationType", isEnumeration=false, javaName="applicationType", javaType="ObjectReference<ConfigAPIApplicationType>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Application types", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference<ConfigAPIApplicationType>> getApplicationType() {
        return this.applicationType;
    }

    @XMLInfo(elementType="element", elementName="ApplicationType", elementOrder=23, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="application-type", refType="APIApplicationType", isEnumeration=false, javaName="applicationType", javaType="ObjectReference<ConfigAPIApplicationType>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Application types", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setApplicationType(ArrayList<ObjectReference<ConfigAPIApplicationType>> applicationType) {
        this.applicationType = applicationType;
    }

    @XMLInfo(elementType="element", elementName="ParseSettingsReference", elementOrder=24, dataPowerType="dmDynamicParseSettingsReference", subType="", benign=false, isPassword=false, cliAlias="parse-settings-reference", refType="", isEnumeration=false, javaName="parseSettingsReference", javaType="DynamicParseSettingsReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Parse settings", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public DynamicParseSettingsReference getParseSettingsReference() {
        return this.parseSettingsReference;
    }

    @XMLInfo(elementType="element", elementName="ParseSettingsReference", elementOrder=24, dataPowerType="dmDynamicParseSettingsReference", subType="", benign=false, isPassword=false, cliAlias="parse-settings-reference", refType="", isEnumeration=false, javaName="parseSettingsReference", javaType="DynamicParseSettingsReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Parse settings", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setParseSettingsReference(DynamicParseSettingsReference parseSettingsReference) {
        this.parseSettingsReference = parseSettingsReference;
    }

    @Override
    public int compareTo(ConfigAPICollection that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "sandbox", "orgID", "orgName", "catalogID", "catalogName", "devPortalEndpoint", "cacheCapacity", "routingPrefix", "useRateLimitGroup", "defaultRateLimit", "rateLimitGroup", "assemblyBurstLimit", "assemblyRateLimit", "assemblyCountLimit", "enforcePreAssemblyRateLimits", "aPIProcessingRule", "aPIErrorRule", "assemblyPreflow", "assemblyPostflow", "plan", "analyticsEndpoint", "applicationType", "parseSettingsReference");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.sandbox, this.orgID, this.orgName, this.catalogID, this.catalogName, this.devPortalEndpoint, this.cacheCapacity, this.routingPrefix, this.useRateLimitGroup, this.defaultRateLimit, this.rateLimitGroup, this.assemblyBurstLimit, this.assemblyRateLimit, this.assemblyCountLimit, this.enforcePreAssemblyRateLimits, this.aPIProcessingRule, this.aPIErrorRule, this.assemblyPreflow, this.assemblyPostflow, this.plan, this.analyticsEndpoint, this.applicationType, this.parseSettingsReference);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "sandbox", "orgID", "orgName", "catalogID", "catalogName", "devPortalEndpoint", "cacheCapacity", "routingPrefix", "useRateLimitGroup", "defaultRateLimit", "rateLimitGroup", "assemblyBurstLimit", "assemblyRateLimit", "assemblyCountLimit", "enforcePreAssemblyRateLimits", "aPIProcessingRule", "aPIErrorRule", "assemblyPreflow", "assemblyPostflow", "plan", "analyticsEndpoint", "applicationType", "parseSettingsReference");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "sandbox", "orgID", "orgName", "catalogID", "catalogName", "devPortalEndpoint", "cacheCapacity", "routingPrefix", "useRateLimitGroup", "defaultRateLimit", "rateLimitGroup", "assemblyBurstLimit", "assemblyRateLimit", "assemblyCountLimit", "enforcePreAssemblyRateLimits", "aPIProcessingRule", "aPIErrorRule", "assemblyPreflow", "assemblyPostflow", "plan", "analyticsEndpoint", "applicationType", "parseSettingsReference"));
    }
}

