/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAPIPath;
import com.kumbasoft.core.beans.config.ConfigAPISchema;
import com.kumbasoft.core.beans.config.ConfigAPISecurityRequirement;
import com.kumbasoft.core.beans.config.ConfigAssembly;
import com.kumbasoft.core.beans.config.ConfigCORSPolicy;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.types.APIDataTypeDefinition;
import com.kumbasoft.core.beans.types.APIProperty;
import com.kumbasoft.core.beans.types.APIProtocols;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigAPIDefinition
extends ConfigConfigBase {
    private String userSummary;
    private String iD;
    private String name;
    private String version;
    private String basePath;
    private String htmlPage;
    private String type;
    private ObjectReference<ConfigAssembly> assembly;
    private ArrayList<ObjectReference<ConfigAPIPath>> path;
    private ArrayList<String> consume;
    private ArrayList<String> produce;
    private String swaggerLocation;
    private ObjectReference<ConfigAPISchema> graphQLSchema;
    private String wsdlAdvertisedSchemaLocation;
    private ObjectReference<ConfigAPISchema> wsdlValidationSchema;
    private ArrayList<ObjectReference<ConfigAPISecurityRequirement>> securityRequirement;
    private String requireAPIMutualTLS;
    private ArrayList<String> aPIMutualTLSSource;
    private String aPIMutualTLSHeaderName;
    private ArrayList<APIProperty> properties;
    private ArrayList<APIDataTypeDefinition> schemas;
    private String cORSToggle;
    private ObjectReference<ConfigCORSPolicy> cORSPolicy;
    private String activityLogToggle;
    private String content;
    private String errorContent;
    private ArrayList<String> preservedRequestHeader;
    private ArrayList<String> preservedResponseHeader;
    private String messageBuffering;
    private String deploymentState;
    private String shareRateLimitCount;
    private String returnV5Responses;
    private String copyIdHeadersToMessage;
    private String enforceRequiredParams;
    private String allowChunkedUploads;
    private String setV5RequestHeaders;
    private String getRawBodyValue;
    private APIProtocols allowedAPIProtocols;
    private String allowTrailingSlash;
    private String enforceAllHeadersCaseInsensitive;
    private String enforceFormDataParameter;
    private String forceHttp500ForSoap11;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="ID", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="id", refType="", isEnumeration=false, javaName="iD", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="API ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getID() {
        return this.iD;
    }

    @XMLInfo(elementType="element", elementName="ID", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="id", refType="", isEnumeration=false, javaName="iD", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="API ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setID(String iD) {
        this.iD = iD;
    }

    @Override
    @XMLInfo(elementType="element", elementName="Name", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="name", refType="", isEnumeration=false, javaName="name", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="API name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getName() {
        return this.name;
    }

    @Override
    @XMLInfo(elementType="element", elementName="Name", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="name", refType="", isEnumeration=false, javaName="name", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="API name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setName(String name) {
        this.name = name;
    }

    @XMLInfo(elementType="element", elementName="Version", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="version", refType="", isEnumeration=false, javaName="version", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="1.0.0", displayOrder=0, displayValue="API version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getVersion() {
        return this.version;
    }

    @XMLInfo(elementType="element", elementName="Version", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="version", refType="", isEnumeration=false, javaName="version", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="1.0.0", displayValue="API version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setVersion(String version) {
        this.version = version;
    }

    @XMLInfo(elementType="element", elementName="BasePath", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="base-path", refType="", isEnumeration=false, javaName="basePath", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^\\/$||^\\/([0-9a-zA-Z-_.~%!$&'()*+,;=:@]+\\/)*[0-9a-zA-Z-_.~%!$&'()*+,;=:@]+$", allowedValues={}, defaultValue="/", displayOrder=0, displayValue="Base path", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getBasePath() {
        return this.basePath;
    }

    @XMLInfo(elementType="element", elementName="BasePath", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="base-path", refType="", isEnumeration=false, javaName="basePath", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^\\/$||^\\/([0-9a-zA-Z-_.~%!$&'()*+,;=:@]+\\/)*[0-9a-zA-Z-_.~%!$&'()*+,;=:@]+$", allowedValues={}, displayOrder=0, defaultValue="/", displayValue="Base path", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBasePath(String basePath) {
        if (basePath != null && basePath.matches("^\\/$||^\\/([0-9a-zA-Z-_.~%!$&'()*+,;=:@]+\\/)*[0-9a-zA-Z-_.~%!$&'()*+,;=:@]+$")) {
            this.basePath = basePath;
        }
    }

    @XMLInfo(elementType="element", elementName="HtmlPage", elementOrder=6, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="html-page", refType="", isEnumeration=false, javaName="htmlPage", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="HTML page", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHtmlPage() {
        return this.htmlPage;
    }

    @XMLInfo(elementType="element", elementName="HtmlPage", elementOrder=6, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="html-page", refType="", isEnumeration=false, javaName="htmlPage", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="HTML page", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHtmlPage(String htmlPage) {
        this.htmlPage = htmlPage;
    }

    @XMLInfo(elementType="element", elementName="Type", elementOrder=7, dataPowerType="dmAPIType", subType="", benign=false, isPassword=false, cliAlias="type", refType="", isEnumeration=true, javaName="type", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="standard", displayOrder=0, displayValue="Type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getType() {
        return this.type;
    }

    @XMLInfo(elementType="element", elementName="Type", elementOrder=7, dataPowerType="dmAPIType", subType="", benign=false, isPassword=false, cliAlias="type", refType="", isEnumeration=true, javaName="type", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="standard", displayValue="Type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setType(String type) {
        if (type == null || Comparison.isIn(type, DPEnumerations.APITYPE)) {
            this.type = type;
        }
    }

    @XMLInfo(elementType="element", elementName="Assembly", elementOrder=8, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="assembly", refType="Assembly", isEnumeration=false, javaName="assembly", javaType="ObjectReference<ConfigAssembly>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Assembly", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAssembly> getAssembly() {
        return this.assembly;
    }

    @XMLInfo(elementType="element", elementName="Assembly", elementOrder=8, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="assembly", refType="Assembly", isEnumeration=false, javaName="assembly", javaType="ObjectReference<ConfigAssembly>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Assembly", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAssembly(ObjectReference<ConfigAssembly> assembly) {
        this.assembly = assembly;
    }

    public void addPath(ObjectReference<ConfigAPIPath> element) {
        if (element == null) {
            return;
        }
        if (this.path == null) {
            this.path = new ArrayList();
        }
        this.path.add(element);
    }

    public boolean removePath(ObjectReference<ConfigAPIPath> element) {
        if (element == null || this.path == null) {
            return false;
        }
        return this.path.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Path", elementOrder=9, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="path", refType="APIPath", isEnumeration=false, javaName="path", javaType="ObjectReference<ConfigAPIPath>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Paths", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference<ConfigAPIPath>> getPath() {
        return this.path;
    }

    @XMLInfo(elementType="element", elementName="Path", elementOrder=9, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="path", refType="APIPath", isEnumeration=false, javaName="path", javaType="ObjectReference<ConfigAPIPath>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Paths", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPath(ArrayList<ObjectReference<ConfigAPIPath>> path) {
        this.path = path;
    }

    public void addConsume(String element) {
        if (element == null) {
            return;
        }
        if (this.consume == null) {
            this.consume = new ArrayList();
        }
        this.consume.add(element);
    }

    public boolean removeConsume(String element) {
        if (element == null || this.consume == null) {
            return false;
        }
        return this.consume.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Consume", elementOrder=10, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="consume", refType="", isEnumeration=false, javaName="consume", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="[a-zA-Z0-9][a-zA-Z0-9!#$&\\-^_]{0,126}\\/[a-zA-Z0-9][a-zA-Z0-9!#$&\\-^_+.]{0,126}(;\\s*[a-zA-Z0-9][a-zA-Z0-9!#$&\\-^_=\"]{0,126})*$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Consumes", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getConsume() {
        return this.consume;
    }

    @XMLInfo(elementType="element", elementName="Consume", elementOrder=10, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="consume", refType="", isEnumeration=false, javaName="consume", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="[a-zA-Z0-9][a-zA-Z0-9!#$&\\-^_]{0,126}\\/[a-zA-Z0-9][a-zA-Z0-9!#$&\\-^_+.]{0,126}(;\\s*[a-zA-Z0-9][a-zA-Z0-9!#$&\\-^_=\"]{0,126})*$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Consumes", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setConsume(ArrayList<String> consume) {
        this.consume = consume;
    }

    public void addProduce(String element) {
        if (element == null) {
            return;
        }
        if (this.produce == null) {
            this.produce = new ArrayList();
        }
        this.produce.add(element);
    }

    public boolean removeProduce(String element) {
        if (element == null || this.produce == null) {
            return false;
        }
        return this.produce.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Produce", elementOrder=11, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="produce", refType="", isEnumeration=false, javaName="produce", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(application|audio|image|message|multipart|text|video)\\/[a-zA-Z-]+$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Produces", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getProduce() {
        return this.produce;
    }

    @XMLInfo(elementType="element", elementName="Produce", elementOrder=11, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="produce", refType="", isEnumeration=false, javaName="produce", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(application|audio|image|message|multipart|text|video)\\/[a-zA-Z-]+$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Produces", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setProduce(ArrayList<String> produce) {
        this.produce = produce;
    }

    @XMLInfo(elementType="element", elementName="SwaggerLocation", elementOrder=12, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="swagger-location", refType="", isEnumeration=false, javaName="swaggerLocation", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="OpenAPI document", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSwaggerLocation() {
        return this.swaggerLocation;
    }

    @XMLInfo(elementType="element", elementName="SwaggerLocation", elementOrder=12, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="swagger-location", refType="", isEnumeration=false, javaName="swaggerLocation", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="OpenAPI document", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSwaggerLocation(String swaggerLocation) {
        this.swaggerLocation = swaggerLocation;
    }

    @XMLInfo(elementType="element", elementName="GraphQLSchema", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="graphql-schema", refType="APISchema", isEnumeration=false, javaName="graphQLSchema", javaType="ObjectReference<ConfigAPISchema>", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="GraphQL schema location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAPISchema> getGraphQLSchema() {
        return this.graphQLSchema;
    }

    @XMLInfo(elementType="element", elementName="GraphQLSchema", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="graphql-schema", refType="APISchema", isEnumeration=false, javaName="graphQLSchema", javaType="ObjectReference<ConfigAPISchema>", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="GraphQL schema location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setGraphQLSchema(ObjectReference<ConfigAPISchema> graphQLSchema) {
        this.graphQLSchema = graphQLSchema;
    }

    @XMLInfo(elementType="element", elementName="WsdlAdvertisedSchemaLocation", elementOrder=14, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="wsdl-advertised-schema-location", refType="", isEnumeration=false, javaName="wsdlAdvertisedSchemaLocation", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="WSDL advertised schema location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getWsdlAdvertisedSchemaLocation() {
        return this.wsdlAdvertisedSchemaLocation;
    }

    @XMLInfo(elementType="element", elementName="WsdlAdvertisedSchemaLocation", elementOrder=14, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="wsdl-advertised-schema-location", refType="", isEnumeration=false, javaName="wsdlAdvertisedSchemaLocation", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="WSDL advertised schema location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setWsdlAdvertisedSchemaLocation(String wsdlAdvertisedSchemaLocation) {
        this.wsdlAdvertisedSchemaLocation = wsdlAdvertisedSchemaLocation;
    }

    @XMLInfo(elementType="element", elementName="WsdlValidationSchema", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="wsdl-validation-schema", refType="APISchema", isEnumeration=false, javaName="wsdlValidationSchema", javaType="ObjectReference<ConfigAPISchema>", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="WSDL validation schema location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAPISchema> getWsdlValidationSchema() {
        return this.wsdlValidationSchema;
    }

    @XMLInfo(elementType="element", elementName="WsdlValidationSchema", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="wsdl-validation-schema", refType="APISchema", isEnumeration=false, javaName="wsdlValidationSchema", javaType="ObjectReference<ConfigAPISchema>", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="WSDL validation schema location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setWsdlValidationSchema(ObjectReference<ConfigAPISchema> wsdlValidationSchema) {
        this.wsdlValidationSchema = wsdlValidationSchema;
    }

    public void addSecurityRequirement(ObjectReference<ConfigAPISecurityRequirement> element) {
        if (element == null) {
            return;
        }
        if (this.securityRequirement == null) {
            this.securityRequirement = new ArrayList();
        }
        this.securityRequirement.add(element);
    }

    public boolean removeSecurityRequirement(ObjectReference<ConfigAPISecurityRequirement> element) {
        if (element == null || this.securityRequirement == null) {
            return false;
        }
        return this.securityRequirement.remove(element);
    }

    @XMLInfo(elementType="element", elementName="SecurityRequirement", elementOrder=16, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="security-req", refType="APISecurityRequirement", isEnumeration=false, javaName="securityRequirement", javaType="ObjectReference<ConfigAPISecurityRequirement>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Security requirements", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference<ConfigAPISecurityRequirement>> getSecurityRequirement() {
        return this.securityRequirement;
    }

    @XMLInfo(elementType="element", elementName="SecurityRequirement", elementOrder=16, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="security-req", refType="APISecurityRequirement", isEnumeration=false, javaName="securityRequirement", javaType="ObjectReference<ConfigAPISecurityRequirement>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Security requirements", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSecurityRequirement(ArrayList<ObjectReference<ConfigAPISecurityRequirement>> securityRequirement) {
        this.securityRequirement = securityRequirement;
    }

    @XMLInfo(elementType="element", elementName="RequireAPIMutualTLS", elementOrder=17, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="require-api-mutual-tls", refType="", isEnumeration=true, javaName="requireAPIMutualTLS", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="API protection", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRequireAPIMutualTLS() {
        return this.requireAPIMutualTLS;
    }

    @XMLInfo(elementType="element", elementName="RequireAPIMutualTLS", elementOrder=17, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="require-api-mutual-tls", refType="", isEnumeration=true, javaName="requireAPIMutualTLS", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="API protection", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRequireAPIMutualTLS(String requireAPIMutualTLS) {
        if (requireAPIMutualTLS == null || Comparison.isIn(requireAPIMutualTLS, DPEnumerations.TOGGLE)) {
            this.requireAPIMutualTLS = requireAPIMutualTLS;
        }
    }

    public void addAPIMutualTLSSource(String element) {
        if (element == null) {
            return;
        }
        if (this.aPIMutualTLSSource == null) {
            this.aPIMutualTLSSource = new ArrayList();
        }
        this.aPIMutualTLSSource.add(element);
    }

    public boolean removeAPIMutualTLSSource(String element) {
        if (element == null || this.aPIMutualTLSSource == null) {
            return false;
        }
        return this.aPIMutualTLSSource.remove(element);
    }

    @XMLInfo(elementType="element", elementName="APIMutualTLSSource", elementOrder=18, dataPowerType="dmAPIMutualTLSSource", subType="", benign=false, isPassword=false, cliAlias="api-mutual-tls-source", refType="", isEnumeration=true, javaName="aPIMutualTLSSource", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="API protection sources", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getAPIMutualTLSSource() {
        return this.aPIMutualTLSSource;
    }

    @XMLInfo(elementType="element", elementName="APIMutualTLSSource", elementOrder=18, dataPowerType="dmAPIMutualTLSSource", subType="", benign=false, isPassword=false, cliAlias="api-mutual-tls-source", refType="", isEnumeration=true, javaName="aPIMutualTLSSource", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="API protection sources", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPIMutualTLSSource(ArrayList<String> aPIMutualTLSSource) {
        if (CollectionUtility.isEmpty(aPIMutualTLSSource)) {
            this.aPIMutualTLSSource = null;
            return;
        }
        this.aPIMutualTLSSource = aPIMutualTLSSource;
    }

    @XMLInfo(elementType="element", elementName="APIMutualTLSHeaderName", elementOrder=19, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="api-mutual-tls-header-name", refType="", isEnumeration=false, javaName="aPIMutualTLSHeaderName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="X-Client-Certificate", displayOrder=0, displayValue="API protection HTTP header", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAPIMutualTLSHeaderName() {
        return this.aPIMutualTLSHeaderName;
    }

    @XMLInfo(elementType="element", elementName="APIMutualTLSHeaderName", elementOrder=19, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="api-mutual-tls-header-name", refType="", isEnumeration=false, javaName="aPIMutualTLSHeaderName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="X-Client-Certificate", displayValue="API protection HTTP header", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPIMutualTLSHeaderName(String aPIMutualTLSHeaderName) {
        this.aPIMutualTLSHeaderName = aPIMutualTLSHeaderName;
    }

    public void addProperties(APIProperty element) {
        if (element == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(element);
    }

    public boolean removeProperties(APIProperty element) {
        if (element == null || this.properties == null) {
            return false;
        }
        return this.properties.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Properties", elementOrder=20, dataPowerType="dmAPIProperty", subType="", benign=false, isPassword=false, cliAlias="property", refType="", isEnumeration=false, javaName="properties", javaType="APIProperty", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Custom properties", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APIProperty> getProperties() {
        return this.properties;
    }

    @XMLInfo(elementType="element", elementName="Properties", elementOrder=20, dataPowerType="dmAPIProperty", subType="", benign=false, isPassword=false, cliAlias="property", refType="", isEnumeration=false, javaName="properties", javaType="APIProperty", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Custom properties", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setProperties(ArrayList<APIProperty> properties) {
        this.properties = properties;
    }

    public void addSchemas(APIDataTypeDefinition element) {
        if (element == null) {
            return;
        }
        if (this.schemas == null) {
            this.schemas = new ArrayList();
        }
        this.schemas.add(element);
    }

    public boolean removeSchemas(APIDataTypeDefinition element) {
        if (element == null || this.schemas == null) {
            return false;
        }
        return this.schemas.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Schemas", elementOrder=21, dataPowerType="dmAPIDataTypeDefinition", subType="", benign=false, isPassword=false, cliAlias="schema", refType="", isEnumeration=false, javaName="schemas", javaType="APIDataTypeDefinition", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Schemas", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APIDataTypeDefinition> getSchemas() {
        return this.schemas;
    }

    @XMLInfo(elementType="element", elementName="Schemas", elementOrder=21, dataPowerType="dmAPIDataTypeDefinition", subType="", benign=false, isPassword=false, cliAlias="schema", refType="", isEnumeration=false, javaName="schemas", javaType="APIDataTypeDefinition", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Schemas", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSchemas(ArrayList<APIDataTypeDefinition> schemas) {
        this.schemas = schemas;
    }

    @XMLInfo(elementType="element", elementName="CORSToggle", elementOrder=22, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="cors", refType="", isEnumeration=true, javaName="cORSToggle", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable CORS", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCORSToggle() {
        return this.cORSToggle;
    }

    @XMLInfo(elementType="element", elementName="CORSToggle", elementOrder=22, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="cors", refType="", isEnumeration=true, javaName="cORSToggle", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable CORS", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCORSToggle(String cORSToggle) {
        if (cORSToggle == null || Comparison.isIn(cORSToggle, DPEnumerations.TOGGLE)) {
            this.cORSToggle = cORSToggle;
        }
    }

    @XMLInfo(elementType="element", elementName="CORSPolicy", elementOrder=23, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="cors-policy", refType="CORSPolicy", isEnumeration=false, javaName="cORSPolicy", javaType="ObjectReference<ConfigCORSPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="CORS policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCORSPolicy> getCORSPolicy() {
        return this.cORSPolicy;
    }

    @XMLInfo(elementType="element", elementName="CORSPolicy", elementOrder=23, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="cors-policy", refType="CORSPolicy", isEnumeration=false, javaName="cORSPolicy", javaType="ObjectReference<ConfigCORSPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="CORS policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCORSPolicy(ObjectReference<ConfigCORSPolicy> cORSPolicy) {
        this.cORSPolicy = cORSPolicy;
    }

    @XMLInfo(elementType="element", elementName="ActivityLogToggle", elementOrder=24, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="activity-log", refType="", isEnumeration=true, javaName="activityLogToggle", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Enable logging", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getActivityLogToggle() {
        return this.activityLogToggle;
    }

    @XMLInfo(elementType="element", elementName="ActivityLogToggle", elementOrder=24, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="activity-log", refType="", isEnumeration=true, javaName="activityLogToggle", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Enable logging", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setActivityLogToggle(String activityLogToggle) {
        if (activityLogToggle == null || Comparison.isIn(activityLogToggle, DPEnumerations.TOGGLE)) {
            this.activityLogToggle = activityLogToggle;
        }
    }

    @XMLInfo(elementType="element", elementName="Content", elementOrder=25, dataPowerType="dmLogContent", subType="", benign=false, isPassword=false, cliAlias="success-content", refType="", isEnumeration=true, javaName="content", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="activity", displayOrder=0, displayValue="Content on success", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getContent() {
        return this.content;
    }

    @XMLInfo(elementType="element", elementName="Content", elementOrder=25, dataPowerType="dmLogContent", subType="", benign=false, isPassword=false, cliAlias="success-content", refType="", isEnumeration=true, javaName="content", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="activity", displayValue="Content on success", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setContent(String content) {
        if (Comparison.isIn(content, DPEnumerations.LOG_CONTENT)) {
            this.content = content;
        }
    }

    @XMLInfo(elementType="element", elementName="ErrorContent", elementOrder=26, dataPowerType="dmLogContent", subType="", benign=false, isPassword=false, cliAlias="error-content", refType="", isEnumeration=true, javaName="errorContent", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="payload", displayOrder=0, displayValue="Content on error", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getErrorContent() {
        return this.errorContent;
    }

    @XMLInfo(elementType="element", elementName="ErrorContent", elementOrder=26, dataPowerType="dmLogContent", subType="", benign=false, isPassword=false, cliAlias="error-content", refType="", isEnumeration=true, javaName="errorContent", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="payload", displayValue="Content on error", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setErrorContent(String errorContent) {
        if (Comparison.isIn(errorContent, DPEnumerations.LOG_CONTENT)) {
            this.errorContent = errorContent;
        }
    }

    public void addPreservedRequestHeader(String element) {
        if (element == null) {
            return;
        }
        if (this.preservedRequestHeader == null) {
            this.preservedRequestHeader = new ArrayList();
        }
        this.preservedRequestHeader.add(element);
    }

    public boolean removePreservedRequestHeader(String element) {
        if (element == null || this.preservedRequestHeader == null) {
            return false;
        }
        return this.preservedRequestHeader.remove(element);
    }

    @XMLInfo(elementType="element", elementName="PreservedRequestHeader", elementOrder=27, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="preserved-request-header", refType="", isEnumeration=false, javaName="preservedRequestHeader", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Request headers to preserve", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getPreservedRequestHeader() {
        return this.preservedRequestHeader;
    }

    @XMLInfo(elementType="element", elementName="PreservedRequestHeader", elementOrder=27, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="preserved-request-header", refType="", isEnumeration=false, javaName="preservedRequestHeader", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Request headers to preserve", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPreservedRequestHeader(ArrayList<String> preservedRequestHeader) {
        this.preservedRequestHeader = preservedRequestHeader;
    }

    public void addPreservedResponseHeader(String element) {
        if (element == null) {
            return;
        }
        if (this.preservedResponseHeader == null) {
            this.preservedResponseHeader = new ArrayList();
        }
        this.preservedResponseHeader.add(element);
    }

    public boolean removePreservedResponseHeader(String element) {
        if (element == null || this.preservedResponseHeader == null) {
            return false;
        }
        return this.preservedResponseHeader.remove(element);
    }

    @XMLInfo(elementType="element", elementName="PreservedResponseHeader", elementOrder=28, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="preserved-response-header", refType="", isEnumeration=false, javaName="preservedResponseHeader", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Response header to preserve", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getPreservedResponseHeader() {
        return this.preservedResponseHeader;
    }

    @XMLInfo(elementType="element", elementName="PreservedResponseHeader", elementOrder=28, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="preserved-response-header", refType="", isEnumeration=false, javaName="preservedResponseHeader", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Response header to preserve", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPreservedResponseHeader(ArrayList<String> preservedResponseHeader) {
        this.preservedResponseHeader = preservedResponseHeader;
    }

    @XMLInfo(elementType="element", elementName="MessageBuffering", elementOrder=29, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="message-buffering", refType="", isEnumeration=true, javaName="messageBuffering", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable message buffering", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMessageBuffering() {
        return this.messageBuffering;
    }

    @XMLInfo(elementType="element", elementName="MessageBuffering", elementOrder=29, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="message-buffering", refType="", isEnumeration=true, javaName="messageBuffering", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable message buffering", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMessageBuffering(String messageBuffering) {
        if (messageBuffering == null || Comparison.isIn(messageBuffering, DPEnumerations.TOGGLE)) {
            this.messageBuffering = messageBuffering;
        }
    }

    @XMLInfo(elementType="element", elementName="DeploymentState", elementOrder=30, dataPowerType="dmAPIDeploymentState", subType="", benign=false, isPassword=false, cliAlias="deployment-state", refType="", isEnumeration=true, javaName="deploymentState", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="running", displayOrder=0, displayValue="Deployment state", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDeploymentState() {
        return this.deploymentState;
    }

    @XMLInfo(elementType="element", elementName="DeploymentState", elementOrder=30, dataPowerType="dmAPIDeploymentState", subType="", benign=false, isPassword=false, cliAlias="deployment-state", refType="", isEnumeration=true, javaName="deploymentState", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="running", displayValue="Deployment state", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDeploymentState(String deploymentState) {
        if (deploymentState == null || Comparison.isIn(deploymentState, DPEnumerations.APIDEPLOYMENT_STATE)) {
            this.deploymentState = deploymentState;
        }
    }

    @XMLInfo(elementType="element", elementName="ShareRateLimitCount", elementOrder=31, dataPowerType="dmAPIShareCount", subType="", benign=false, isPassword=false, cliAlias="share-count", refType="", isEnumeration=true, javaName="shareRateLimitCount", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="unset", displayOrder=0, displayValue="Share rate limit count", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getShareRateLimitCount() {
        return this.shareRateLimitCount;
    }

    @XMLInfo(elementType="element", elementName="ShareRateLimitCount", elementOrder=31, dataPowerType="dmAPIShareCount", subType="", benign=false, isPassword=false, cliAlias="share-count", refType="", isEnumeration=true, javaName="shareRateLimitCount", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="unset", displayValue="Share rate limit count", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setShareRateLimitCount(String shareRateLimitCount) {
        if (shareRateLimitCount == null || Comparison.isIn(shareRateLimitCount, DPEnumerations.APISHARE_COUNT)) {
            this.shareRateLimitCount = shareRateLimitCount;
        }
    }

    @XMLInfo(elementType="element", elementName="ReturnV5Responses", elementOrder=32, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="return-v5-responses", refType="", isEnumeration=true, javaName="returnV5Responses", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Return v5 responses", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getReturnV5Responses() {
        return this.returnV5Responses;
    }

    @XMLInfo(elementType="element", elementName="ReturnV5Responses", elementOrder=32, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="return-v5-responses", refType="", isEnumeration=true, javaName="returnV5Responses", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Return v5 responses", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setReturnV5Responses(String returnV5Responses) {
        if (returnV5Responses == null || Comparison.isIn(returnV5Responses, DPEnumerations.TOGGLE)) {
            this.returnV5Responses = returnV5Responses;
        }
    }

    @XMLInfo(elementType="element", elementName="CopyIdHeadersToMessage", elementOrder=33, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="copy-id-headers-to-message", refType="", isEnumeration=true, javaName="copyIdHeadersToMessage", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Copy ID headers to message", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCopyIdHeadersToMessage() {
        return this.copyIdHeadersToMessage;
    }

    @XMLInfo(elementType="element", elementName="CopyIdHeadersToMessage", elementOrder=33, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="copy-id-headers-to-message", refType="", isEnumeration=true, javaName="copyIdHeadersToMessage", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Copy ID headers to message", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCopyIdHeadersToMessage(String copyIdHeadersToMessage) {
        if (copyIdHeadersToMessage == null || Comparison.isIn(copyIdHeadersToMessage, DPEnumerations.TOGGLE)) {
            this.copyIdHeadersToMessage = copyIdHeadersToMessage;
        }
    }

    @XMLInfo(elementType="element", elementName="EnforceRequiredParams", elementOrder=34, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enforce-required-params", refType="", isEnumeration=true, javaName="enforceRequiredParams", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Enforce required parameters", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnforceRequiredParams() {
        return this.enforceRequiredParams;
    }

    @XMLInfo(elementType="element", elementName="EnforceRequiredParams", elementOrder=34, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enforce-required-params", refType="", isEnumeration=true, javaName="enforceRequiredParams", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Enforce required parameters", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnforceRequiredParams(String enforceRequiredParams) {
        if (enforceRequiredParams == null || Comparison.isIn(enforceRequiredParams, DPEnumerations.TOGGLE)) {
            this.enforceRequiredParams = enforceRequiredParams;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowChunkedUploads", elementOrder=35, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-chunked-uploads", refType="", isEnumeration=true, javaName="allowChunkedUploads", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Allow chunked uploads", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowChunkedUploads() {
        return this.allowChunkedUploads;
    }

    @XMLInfo(elementType="element", elementName="AllowChunkedUploads", elementOrder=35, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-chunked-uploads", refType="", isEnumeration=true, javaName="allowChunkedUploads", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Allow chunked uploads", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowChunkedUploads(String allowChunkedUploads) {
        if (allowChunkedUploads == null || Comparison.isIn(allowChunkedUploads, DPEnumerations.TOGGLE)) {
            this.allowChunkedUploads = allowChunkedUploads;
        }
    }

    @XMLInfo(elementType="element", elementName="SetV5RequestHeaders", elementOrder=36, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="set-v5-request-headers", refType="", isEnumeration=true, javaName="setV5RequestHeaders", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Set v5 request headers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSetV5RequestHeaders() {
        return this.setV5RequestHeaders;
    }

    @XMLInfo(elementType="element", elementName="SetV5RequestHeaders", elementOrder=36, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="set-v5-request-headers", refType="", isEnumeration=true, javaName="setV5RequestHeaders", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Set v5 request headers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSetV5RequestHeaders(String setV5RequestHeaders) {
        if (setV5RequestHeaders == null || Comparison.isIn(setV5RequestHeaders, DPEnumerations.TOGGLE)) {
            this.setV5RequestHeaders = setV5RequestHeaders;
        }
    }

    @XMLInfo(elementType="element", elementName="GetRawBodyValue", elementOrder=37, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="get-raw-body-value", refType="", isEnumeration=true, javaName="getRawBodyValue", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Get raw body value", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getGetRawBodyValue() {
        return this.getRawBodyValue;
    }

    @XMLInfo(elementType="element", elementName="GetRawBodyValue", elementOrder=37, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="get-raw-body-value", refType="", isEnumeration=true, javaName="getRawBodyValue", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Get raw body value", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setGetRawBodyValue(String getRawBodyValue) {
        if (getRawBodyValue == null || Comparison.isIn(getRawBodyValue, DPEnumerations.TOGGLE)) {
            this.getRawBodyValue = getRawBodyValue;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowedAPIProtocols", elementOrder=38, dataPowerType="dmAPIProtocols", subType="", benign=false, isPassword=false, cliAlias="allowed-api-protocols", refType="", isEnumeration=false, javaName="allowedAPIProtocols", javaType="APIProtocols", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="http+https+ws+wss", displayOrder=0, displayValue="Allowed API protocols", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public APIProtocols getAllowedAPIProtocols() {
        return this.allowedAPIProtocols;
    }

    @XMLInfo(elementType="element", elementName="AllowedAPIProtocols", elementOrder=38, dataPowerType="dmAPIProtocols", subType="", benign=false, isPassword=false, cliAlias="allowed-api-protocols", refType="", isEnumeration=false, javaName="allowedAPIProtocols", javaType="APIProtocols", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="http+https+ws+wss", displayValue="Allowed API protocols", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowedAPIProtocols(APIProtocols allowedAPIProtocols) {
        this.allowedAPIProtocols = allowedAPIProtocols;
    }

    @XMLInfo(elementType="element", elementName="AllowTrailingSlash", elementOrder=39, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-trailing-slash", refType="", isEnumeration=true, javaName="allowTrailingSlash", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Allow trailing slash", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowTrailingSlash() {
        return this.allowTrailingSlash;
    }

    @XMLInfo(elementType="element", elementName="AllowTrailingSlash", elementOrder=39, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-trailing-slash", refType="", isEnumeration=true, javaName="allowTrailingSlash", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Allow trailing slash", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowTrailingSlash(String allowTrailingSlash) {
        if (allowTrailingSlash == null || Comparison.isIn(allowTrailingSlash, DPEnumerations.TOGGLE)) {
            this.allowTrailingSlash = allowTrailingSlash;
        }
    }

    @XMLInfo(elementType="element", elementName="EnforceAllHeadersCaseInsensitive", elementOrder=40, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enforce-all-headers-case-insensitive", refType="", isEnumeration=true, javaName="enforceAllHeadersCaseInsensitive", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enforce all headers as case-insensitive", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnforceAllHeadersCaseInsensitive() {
        return this.enforceAllHeadersCaseInsensitive;
    }

    @XMLInfo(elementType="element", elementName="EnforceAllHeadersCaseInsensitive", elementOrder=40, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enforce-all-headers-case-insensitive", refType="", isEnumeration=true, javaName="enforceAllHeadersCaseInsensitive", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enforce all headers as case-insensitive", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnforceAllHeadersCaseInsensitive(String enforceAllHeadersCaseInsensitive) {
        if (enforceAllHeadersCaseInsensitive == null || Comparison.isIn(enforceAllHeadersCaseInsensitive, DPEnumerations.TOGGLE)) {
            this.enforceAllHeadersCaseInsensitive = enforceAllHeadersCaseInsensitive;
        }
    }

    @XMLInfo(elementType="element", elementName="EnforceFormDataParameter", elementOrder=41, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enforce-form-data-parameter", refType="", isEnumeration=true, javaName="enforceFormDataParameter", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Enforce form data parameter", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnforceFormDataParameter() {
        return this.enforceFormDataParameter;
    }

    @XMLInfo(elementType="element", elementName="EnforceFormDataParameter", elementOrder=41, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enforce-form-data-parameter", refType="", isEnumeration=true, javaName="enforceFormDataParameter", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Enforce form data parameter", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnforceFormDataParameter(String enforceFormDataParameter) {
        if (enforceFormDataParameter == null || Comparison.isIn(enforceFormDataParameter, DPEnumerations.TOGGLE)) {
            this.enforceFormDataParameter = enforceFormDataParameter;
        }
    }

    @XMLInfo(elementType="element", elementName="ForceHttp500ForSoap11", elementOrder=42, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="force-http-500-for-soap11", refType="", isEnumeration=true, javaName="forceHttp500ForSoap11", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Force HTTP 500 for SOAP 1.1", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getForceHttp500ForSoap11() {
        return this.forceHttp500ForSoap11;
    }

    @XMLInfo(elementType="element", elementName="ForceHttp500ForSoap11", elementOrder=42, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="force-http-500-for-soap11", refType="", isEnumeration=true, javaName="forceHttp500ForSoap11", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Force HTTP 500 for SOAP 1.1", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setForceHttp500ForSoap11(String forceHttp500ForSoap11) {
        if (forceHttp500ForSoap11 == null || Comparison.isIn(forceHttp500ForSoap11, DPEnumerations.TOGGLE)) {
            this.forceHttp500ForSoap11 = forceHttp500ForSoap11;
        }
    }

    @Override
    public int compareTo(ConfigAPIDefinition that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "iD", "name", "version", "basePath", "htmlPage", "type", "assembly", "path", "consume", "produce", "swaggerLocation", "graphQLSchema", "wsdlAdvertisedSchemaLocation", "wsdlValidationSchema", "securityRequirement", "requireAPIMutualTLS", "aPIMutualTLSSource", "aPIMutualTLSHeaderName", "properties", "schemas", "cORSToggle", "cORSPolicy", "activityLogToggle", "content", "errorContent", "preservedRequestHeader", "preservedResponseHeader", "messageBuffering", "deploymentState", "shareRateLimitCount", "returnV5Responses", "copyIdHeadersToMessage", "enforceRequiredParams", "allowChunkedUploads", "setV5RequestHeaders", "getRawBodyValue", "allowedAPIProtocols", "allowTrailingSlash", "enforceAllHeadersCaseInsensitive", "enforceFormDataParameter", "forceHttp500ForSoap11");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.iD, this.name, this.version, this.basePath, this.htmlPage, this.type, this.assembly, this.path, this.consume, this.produce, this.swaggerLocation, this.graphQLSchema, this.wsdlAdvertisedSchemaLocation, this.wsdlValidationSchema, this.securityRequirement, this.requireAPIMutualTLS, this.aPIMutualTLSSource, this.aPIMutualTLSHeaderName, this.properties, this.schemas, this.cORSToggle, this.cORSPolicy, this.activityLogToggle, this.content, this.errorContent, this.preservedRequestHeader, this.preservedResponseHeader, this.messageBuffering, this.deploymentState, this.shareRateLimitCount, this.returnV5Responses, this.copyIdHeadersToMessage, this.enforceRequiredParams, this.allowChunkedUploads, this.setV5RequestHeaders, this.getRawBodyValue, this.allowedAPIProtocols, this.allowTrailingSlash, this.enforceAllHeadersCaseInsensitive, this.enforceFormDataParameter, this.forceHttp500ForSoap11);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "iD", "name", "version", "basePath", "htmlPage", "type", "assembly", "path", "consume", "produce", "swaggerLocation", "graphQLSchema", "wsdlAdvertisedSchemaLocation", "wsdlValidationSchema", "securityRequirement", "requireAPIMutualTLS", "aPIMutualTLSSource", "aPIMutualTLSHeaderName", "properties", "schemas", "cORSToggle", "cORSPolicy", "activityLogToggle", "content", "errorContent", "preservedRequestHeader", "preservedResponseHeader", "messageBuffering", "deploymentState", "shareRateLimitCount", "returnV5Responses", "copyIdHeadersToMessage", "enforceRequiredParams", "allowChunkedUploads", "setV5RequestHeaders", "getRawBodyValue", "allowedAPIProtocols", "allowTrailingSlash", "enforceAllHeadersCaseInsensitive", "enforceFormDataParameter", "forceHttp500ForSoap11");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "iD", "name", "version", "basePath", "htmlPage", "type", "assembly", "path", "consume", "produce", "swaggerLocation", "graphQLSchema", "wsdlAdvertisedSchemaLocation", "wsdlValidationSchema", "securityRequirement", "requireAPIMutualTLS", "aPIMutualTLSSource", "aPIMutualTLSHeaderName", "properties", "schemas", "cORSToggle", "cORSPolicy", "activityLogToggle", "content", "errorContent", "preservedRequestHeader", "preservedResponseHeader", "messageBuffering", "deploymentState", "shareRateLimitCount", "returnV5Responses", "copyIdHeadersToMessage", "enforceRequiredParams", "allowChunkedUploads", "setV5RequestHeaders", "getRawBodyValue", "allowedAPIProtocols", "allowTrailingSlash", "enforceAllHeadersCaseInsensitive", "enforceFormDataParameter", "forceHttp500ForSoap11"));
    }
}

