/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAPICollection;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigLDAPConnectionPool;
import com.kumbasoft.core.beans.config.ConfigLoadBalancerGroup;
import com.kumbasoft.core.beans.config.ConfigOpenTelemetry;
import com.kumbasoft.core.beans.config.ConfigSourceProtocolHandler;
import com.kumbasoft.core.beans.config.ConfigURLRefreshPolicy;
import com.kumbasoft.core.beans.types.APIBurstLimit;
import com.kumbasoft.core.beans.types.APICountLimit;
import com.kumbasoft.core.beans.types.APIProxyPolicy;
import com.kumbasoft.core.beans.types.APIRateLimit;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.DocCachePolicy;
import com.kumbasoft.core.beans.types.OpenTelemetryResourceAttribute;
import com.kumbasoft.core.beans.types.ScheduledRule;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigAPIGateway
extends ConfigConfigBase {
    private String userSummary;
    private String gatewayServiceName;
    private ArrayList<ObjectReference<ConfigSourceProtocolHandler>> frontProtocol;
    private ObjectReference<ConfigURLRefreshPolicy> uRLRefreshPolicy;
    private BigInteger cacheMemorySize;
    private long cacheSize;
    private String sHA1Caching;
    private String staticDocumentCalls;
    private ArrayList<ObjectReference<ConfigLoadBalancerGroup>> virtualServers;
    private long docCacheMaxDocs;
    private BigInteger docCacheSize;
    private long docMaxWrites;
    private ArrayList<DocCachePolicy> docCachePolicy;
    private ArrayList<ScheduledRule> scheduledRule;
    private ArrayList<ObjectReference<ConfigAPICollection>> aPICollection;
    private String shareRateLimitCount;
    private ArrayList<APIBurstLimit> assemblyBurstLimit;
    private ArrayList<APIRateLimit> assemblyRateLimit;
    private ArrayList<APICountLimit> assemblyCountLimit;
    private ObjectReference<ConfigLDAPConnectionPool> lDAPConnPool;
    private ArrayList<APIProxyPolicy> proxyPolicies;
    private long frontTimeout;
    private long frontPersistentTimeout;
    private ObjectReference<ConfigOpenTelemetry> openTelemetry;
    private ArrayList<OpenTelemetryResourceAttribute> openTelemetryResourceAttribute;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="GatewayServiceName", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="gateway-service-name", refType="", isEnumeration=false, javaName="gatewayServiceName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Gateway service name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getGatewayServiceName() {
        return this.gatewayServiceName;
    }

    @XMLInfo(elementType="element", elementName="GatewayServiceName", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="gateway-service-name", refType="", isEnumeration=false, javaName="gatewayServiceName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Gateway service name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setGatewayServiceName(String gatewayServiceName) {
        this.gatewayServiceName = gatewayServiceName;
    }

    public void addFrontProtocol(ObjectReference<ConfigSourceProtocolHandler> element) {
        if (element == null) {
            return;
        }
        if (this.frontProtocol == null) {
            this.frontProtocol = new ArrayList();
        }
        this.frontProtocol.add(element);
    }

    public boolean removeFrontProtocol(ObjectReference<ConfigSourceProtocolHandler> element) {
        if (element == null || this.frontProtocol == null) {
            return false;
        }
        return this.frontProtocol.remove(element);
    }

    @XMLInfo(elementType="element", elementName="FrontProtocol", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="front-protocol", refType="SourceProtocolHandler", isEnumeration=false, javaName="frontProtocol", javaType="ObjectReference<ConfigSourceProtocolHandler>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Protocol handler", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference<ConfigSourceProtocolHandler>> getFrontProtocol() {
        return this.frontProtocol;
    }

    @XMLInfo(elementType="element", elementName="FrontProtocol", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="front-protocol", refType="SourceProtocolHandler", isEnumeration=false, javaName="frontProtocol", javaType="ObjectReference<ConfigSourceProtocolHandler>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Protocol handler", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFrontProtocol(ArrayList<ObjectReference<ConfigSourceProtocolHandler>> frontProtocol) {
        this.frontProtocol = frontProtocol;
    }

    @XMLInfo(elementType="element", elementName="URLRefreshPolicy", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="xslrefresh", refType="URLRefreshPolicy", isEnumeration=false, javaName="uRLRefreshPolicy", javaType="ObjectReference<ConfigURLRefreshPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="URL refresh policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigURLRefreshPolicy> getURLRefreshPolicy() {
        return this.uRLRefreshPolicy;
    }

    @XMLInfo(elementType="element", elementName="URLRefreshPolicy", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="xslrefresh", refType="URLRefreshPolicy", isEnumeration=false, javaName="uRLRefreshPolicy", javaType="ObjectReference<ConfigURLRefreshPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="URL refresh policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setURLRefreshPolicy(ObjectReference<ConfigURLRefreshPolicy> uRLRefreshPolicy) {
        this.uRLRefreshPolicy = uRLRefreshPolicy;
    }

    @XMLInfo(elementType="element", elementName="CacheMemorySize", elementOrder=5, dataPowerType="dmUInt64", subType="", benign=false, isPassword=false, cliAlias="xsl-cache-memorysize", refType="", isEnumeration=false, javaName="cacheMemorySize", javaType="java.math.BigInteger", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="2147483647", displayOrder=0, displayValue="Stylesheet cache size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public BigInteger getCacheMemorySize() {
        return this.cacheMemorySize;
    }

    @XMLInfo(elementType="element", elementName="CacheMemorySize", elementOrder=5, dataPowerType="dmUInt64", subType="", benign=false, isPassword=false, cliAlias="xsl-cache-memorysize", refType="", isEnumeration=false, javaName="cacheMemorySize", javaType="java.math.BigInteger", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="2147483647", displayValue="Stylesheet cache size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCacheMemorySize(BigInteger cacheMemorySize) {
        this.cacheMemorySize = cacheMemorySize;
    }

    @XMLInfo(elementType="element", elementName="CacheSize", elementOrder=6, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="xsl-cache-size", refType="", isEnumeration=false, javaName="cacheSize", javaType="long", isRequired=false, squelchNull=false, minimum=5, maximum=250000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="256", displayOrder=0, displayValue="Stylesheet cache count", units="stylesheets", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getCacheSize() {
        return this.cacheSize;
    }

    @XMLInfo(elementType="element", elementName="CacheSize", elementOrder=6, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="xsl-cache-size", refType="", isEnumeration=false, javaName="cacheSize", javaType="long", isRequired=false, squelchNull=false, minimum=5, maximum=250000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="256", displayValue="Stylesheet cache count", units="stylesheets", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    @XMLInfo(elementType="element", elementName="SHA1Caching", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="xsl-checksummed-cache", refType="", isEnumeration=true, javaName="sHA1Caching", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="SHA1 caching", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSHA1Caching() {
        return this.sHA1Caching;
    }

    @XMLInfo(elementType="element", elementName="SHA1Caching", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="xsl-checksummed-cache", refType="", isEnumeration=true, javaName="sHA1Caching", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="SHA1 caching", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSHA1Caching(String sHA1Caching) {
        if (sHA1Caching == null || Comparison.isIn(sHA1Caching, DPEnumerations.TOGGLE)) {
            this.sHA1Caching = sHA1Caching;
        }
    }

    @XMLInfo(elementType="element", elementName="StaticDocumentCalls", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="static-document-calls", refType="", isEnumeration=true, javaName="staticDocumentCalls", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Static document calls", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getStaticDocumentCalls() {
        return this.staticDocumentCalls;
    }

    @XMLInfo(elementType="element", elementName="StaticDocumentCalls", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="static-document-calls", refType="", isEnumeration=true, javaName="staticDocumentCalls", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Static document calls", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setStaticDocumentCalls(String staticDocumentCalls) {
        if (staticDocumentCalls == null || Comparison.isIn(staticDocumentCalls, DPEnumerations.TOGGLE)) {
            this.staticDocumentCalls = staticDocumentCalls;
        }
    }

    public void addVirtualServers(ObjectReference<ConfigLoadBalancerGroup> element) {
        if (element == null) {
            return;
        }
        if (this.virtualServers == null) {
            this.virtualServers = new ArrayList();
        }
        this.virtualServers.add(element);
    }

    public boolean removeVirtualServers(ObjectReference<ConfigLoadBalancerGroup> element) {
        if (element == null || this.virtualServers == null) {
            return false;
        }
        return this.virtualServers.remove(element);
    }

    @XMLInfo(elementType="element", elementName="VirtualServers", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="loadbalancer-group", refType="LoadBalancerGroup", isEnumeration=false, javaName="virtualServers", javaType="ObjectReference<ConfigLoadBalancerGroup>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Load balancer groups", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference<ConfigLoadBalancerGroup>> getVirtualServers() {
        return this.virtualServers;
    }

    @XMLInfo(elementType="element", elementName="VirtualServers", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="loadbalancer-group", refType="LoadBalancerGroup", isEnumeration=false, javaName="virtualServers", javaType="ObjectReference<ConfigLoadBalancerGroup>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Load balancer groups", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setVirtualServers(ArrayList<ObjectReference<ConfigLoadBalancerGroup>> virtualServers) {
        this.virtualServers = virtualServers;
    }

    @XMLInfo(elementType="element", elementName="DocCacheMaxDocs", elementOrder=10, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="maxdocs", refType="", isEnumeration=false, javaName="docCacheMaxDocs", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=250000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="5000", displayOrder=0, displayValue="Document cache count", units="documents", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getDocCacheMaxDocs() {
        return this.docCacheMaxDocs;
    }

    @XMLInfo(elementType="element", elementName="DocCacheMaxDocs", elementOrder=10, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="maxdocs", refType="", isEnumeration=false, javaName="docCacheMaxDocs", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=250000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="5000", displayValue="Document cache count", units="documents", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDocCacheMaxDocs(long docCacheMaxDocs) {
        this.docCacheMaxDocs = docCacheMaxDocs;
    }

    @XMLInfo(elementType="element", elementName="DocCacheSize", elementOrder=11, dataPowerType="dmUInt64", subType="", benign=false, isPassword=false, cliAlias="size", refType="", isEnumeration=false, javaName="docCacheSize", javaType="java.math.BigInteger", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Document cache size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public BigInteger getDocCacheSize() {
        return this.docCacheSize;
    }

    @XMLInfo(elementType="element", elementName="DocCacheSize", elementOrder=11, dataPowerType="dmUInt64", subType="", benign=false, isPassword=false, cliAlias="size", refType="", isEnumeration=false, javaName="docCacheSize", javaType="java.math.BigInteger", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Document cache size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDocCacheSize(BigInteger docCacheSize) {
        this.docCacheSize = docCacheSize;
    }

    @XMLInfo(elementType="element", elementName="DocMaxWrites", elementOrder=12, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-writes", refType="", isEnumeration=false, javaName="docMaxWrites", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=32768L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="32768", displayOrder=0, displayValue="Maximum concurrent writes", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getDocMaxWrites() {
        return this.docMaxWrites;
    }

    @XMLInfo(elementType="element", elementName="DocMaxWrites", elementOrder=12, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-writes", refType="", isEnumeration=false, javaName="docMaxWrites", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=32768L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="32768", displayValue="Maximum concurrent writes", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDocMaxWrites(long docMaxWrites) {
        this.docMaxWrites = docMaxWrites;
    }

    public void addDocCachePolicy(DocCachePolicy element) {
        if (element == null) {
            return;
        }
        if (this.docCachePolicy == null) {
            this.docCachePolicy = new ArrayList();
        }
        this.docCachePolicy.add(element);
    }

    public boolean removeDocCachePolicy(DocCachePolicy element) {
        if (element == null || this.docCachePolicy == null) {
            return false;
        }
        return this.docCachePolicy.remove(element);
    }

    @XMLInfo(elementType="element", elementName="DocCachePolicy", elementOrder=13, dataPowerType="dmDocCachePolicy", subType="", benign=false, isPassword=false, cliAlias="policy", refType="", isEnumeration=false, javaName="docCachePolicy", javaType="DocCachePolicy", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Document cache policy", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<DocCachePolicy> getDocCachePolicy() {
        return this.docCachePolicy;
    }

    @XMLInfo(elementType="element", elementName="DocCachePolicy", elementOrder=13, dataPowerType="dmDocCachePolicy", subType="", benign=false, isPassword=false, cliAlias="policy", refType="", isEnumeration=false, javaName="docCachePolicy", javaType="DocCachePolicy", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Document cache policy", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDocCachePolicy(ArrayList<DocCachePolicy> docCachePolicy) {
        this.docCachePolicy = docCachePolicy;
    }

    public void addScheduledRule(ScheduledRule element) {
        if (element == null) {
            return;
        }
        if (this.scheduledRule == null) {
            this.scheduledRule = new ArrayList();
        }
        this.scheduledRule.add(element);
    }

    public boolean removeScheduledRule(ScheduledRule element) {
        if (element == null || this.scheduledRule == null) {
            return false;
        }
        return this.scheduledRule.remove(element);
    }

    @XMLInfo(elementType="element", elementName="ScheduledRule", elementOrder=14, dataPowerType="dmScheduledRule", subType="", benign=false, isPassword=false, cliAlias="schedule-rule", refType="", isEnumeration=false, javaName="scheduledRule", javaType="ScheduledRule", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Scheduled processing rule", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ScheduledRule> getScheduledRule() {
        return this.scheduledRule;
    }

    @XMLInfo(elementType="element", elementName="ScheduledRule", elementOrder=14, dataPowerType="dmScheduledRule", subType="", benign=false, isPassword=false, cliAlias="schedule-rule", refType="", isEnumeration=false, javaName="scheduledRule", javaType="ScheduledRule", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Scheduled processing rule", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setScheduledRule(ArrayList<ScheduledRule> scheduledRule) {
        this.scheduledRule = scheduledRule;
    }

    public void addAPICollection(ObjectReference<ConfigAPICollection> element) {
        if (element == null) {
            return;
        }
        if (this.aPICollection == null) {
            this.aPICollection = new ArrayList();
        }
        this.aPICollection.add(element);
    }

    public boolean removeAPICollection(ObjectReference<ConfigAPICollection> element) {
        if (element == null || this.aPICollection == null) {
            return false;
        }
        return this.aPICollection.remove(element);
    }

    @XMLInfo(elementType="element", elementName="APICollection", elementOrder=15, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="collection", refType="APICollection", isEnumeration=false, javaName="aPICollection", javaType="ObjectReference<ConfigAPICollection>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="API collection", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference<ConfigAPICollection>> getAPICollection() {
        return this.aPICollection;
    }

    @XMLInfo(elementType="element", elementName="APICollection", elementOrder=15, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="collection", refType="APICollection", isEnumeration=false, javaName="aPICollection", javaType="ObjectReference<ConfigAPICollection>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="API collection", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICollection(ArrayList<ObjectReference<ConfigAPICollection>> aPICollection) {
        this.aPICollection = aPICollection;
    }

    @XMLInfo(elementType="element", elementName="ShareRateLimitCount", elementOrder=16, dataPowerType="dmAPIGatewayShareCount", subType="", benign=false, isPassword=false, cliAlias="share-count", refType="", isEnumeration=true, javaName="shareRateLimitCount", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="yes", displayOrder=0, displayValue="Share rate limit count", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getShareRateLimitCount() {
        return this.shareRateLimitCount;
    }

    @XMLInfo(elementType="element", elementName="ShareRateLimitCount", elementOrder=16, dataPowerType="dmAPIGatewayShareCount", subType="", benign=false, isPassword=false, cliAlias="share-count", refType="", isEnumeration=true, javaName="shareRateLimitCount", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="yes", displayValue="Share rate limit count", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setShareRateLimitCount(String shareRateLimitCount) {
        if (shareRateLimitCount == null || Comparison.isIn(shareRateLimitCount, DPEnumerations.APIGATEWAY_SHARE_COUNT)) {
            this.shareRateLimitCount = shareRateLimitCount;
        }
    }

    public void addAssemblyBurstLimit(APIBurstLimit element) {
        if (element == null) {
            return;
        }
        if (this.assemblyBurstLimit == null) {
            this.assemblyBurstLimit = new ArrayList();
        }
        this.assemblyBurstLimit.add(element);
    }

    public boolean removeAssemblyBurstLimit(APIBurstLimit element) {
        if (element == null || this.assemblyBurstLimit == null) {
            return false;
        }
        return this.assemblyBurstLimit.remove(element);
    }

    @XMLInfo(elementType="element", elementName="AssemblyBurstLimit", elementOrder=17, dataPowerType="dmAPIBurstLimit", subType="", benign=false, isPassword=false, cliAlias="assembly-burst-limit", refType="", isEnumeration=false, javaName="assemblyBurstLimit", javaType="APIBurstLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Assembly burst limits", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APIBurstLimit> getAssemblyBurstLimit() {
        return this.assemblyBurstLimit;
    }

    @XMLInfo(elementType="element", elementName="AssemblyBurstLimit", elementOrder=17, dataPowerType="dmAPIBurstLimit", subType="", benign=false, isPassword=false, cliAlias="assembly-burst-limit", refType="", isEnumeration=false, javaName="assemblyBurstLimit", javaType="APIBurstLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Assembly burst limits", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAssemblyBurstLimit(ArrayList<APIBurstLimit> assemblyBurstLimit) {
        this.assemblyBurstLimit = assemblyBurstLimit;
    }

    public void addAssemblyRateLimit(APIRateLimit element) {
        if (element == null) {
            return;
        }
        if (this.assemblyRateLimit == null) {
            this.assemblyRateLimit = new ArrayList();
        }
        this.assemblyRateLimit.add(element);
    }

    public boolean removeAssemblyRateLimit(APIRateLimit element) {
        if (element == null || this.assemblyRateLimit == null) {
            return false;
        }
        return this.assemblyRateLimit.remove(element);
    }

    @XMLInfo(elementType="element", elementName="AssemblyRateLimit", elementOrder=18, dataPowerType="dmAPIRateLimit", subType="", benign=false, isPassword=false, cliAlias="assembly-rate-limit", refType="", isEnumeration=false, javaName="assemblyRateLimit", javaType="APIRateLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Assembly rate limits", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APIRateLimit> getAssemblyRateLimit() {
        return this.assemblyRateLimit;
    }

    @XMLInfo(elementType="element", elementName="AssemblyRateLimit", elementOrder=18, dataPowerType="dmAPIRateLimit", subType="", benign=false, isPassword=false, cliAlias="assembly-rate-limit", refType="", isEnumeration=false, javaName="assemblyRateLimit", javaType="APIRateLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Assembly rate limits", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAssemblyRateLimit(ArrayList<APIRateLimit> assemblyRateLimit) {
        this.assemblyRateLimit = assemblyRateLimit;
    }

    public void addAssemblyCountLimit(APICountLimit element) {
        if (element == null) {
            return;
        }
        if (this.assemblyCountLimit == null) {
            this.assemblyCountLimit = new ArrayList();
        }
        this.assemblyCountLimit.add(element);
    }

    public boolean removeAssemblyCountLimit(APICountLimit element) {
        if (element == null || this.assemblyCountLimit == null) {
            return false;
        }
        return this.assemblyCountLimit.remove(element);
    }

    @XMLInfo(elementType="element", elementName="AssemblyCountLimit", elementOrder=19, dataPowerType="dmAPICountLimit", subType="", benign=false, isPassword=false, cliAlias="assembly-count-limit", refType="", isEnumeration=false, javaName="assemblyCountLimit", javaType="APICountLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Assembly count limits", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APICountLimit> getAssemblyCountLimit() {
        return this.assemblyCountLimit;
    }

    @XMLInfo(elementType="element", elementName="AssemblyCountLimit", elementOrder=19, dataPowerType="dmAPICountLimit", subType="", benign=false, isPassword=false, cliAlias="assembly-count-limit", refType="", isEnumeration=false, javaName="assemblyCountLimit", javaType="APICountLimit", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Assembly count limits", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAssemblyCountLimit(ArrayList<APICountLimit> assemblyCountLimit) {
        this.assemblyCountLimit = assemblyCountLimit;
    }

    @XMLInfo(elementType="element", elementName="LDAPConnPool", elementOrder=20, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="ldap-pool", refType="LDAPConnectionPool", isEnumeration=false, javaName="lDAPConnPool", javaType="ObjectReference<ConfigLDAPConnectionPool>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP connection pool", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigLDAPConnectionPool> getLDAPConnPool() {
        return this.lDAPConnPool;
    }

    @XMLInfo(elementType="element", elementName="LDAPConnPool", elementOrder=20, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="ldap-pool", refType="LDAPConnectionPool", isEnumeration=false, javaName="lDAPConnPool", javaType="ObjectReference<ConfigLDAPConnectionPool>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP connection pool", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPConnPool(ObjectReference<ConfigLDAPConnectionPool> lDAPConnPool) {
        this.lDAPConnPool = lDAPConnPool;
    }

    public void addProxyPolicies(APIProxyPolicy element) {
        if (element == null) {
            return;
        }
        if (this.proxyPolicies == null) {
            this.proxyPolicies = new ArrayList();
        }
        this.proxyPolicies.add(element);
    }

    public boolean removeProxyPolicies(APIProxyPolicy element) {
        if (element == null || this.proxyPolicies == null) {
            return false;
        }
        return this.proxyPolicies.remove(element);
    }

    @XMLInfo(elementType="element", elementName="ProxyPolicies", elementOrder=21, dataPowerType="dmAPIProxyPolicy", subType="", benign=false, isPassword=false, cliAlias="proxy", refType="", isEnumeration=false, javaName="proxyPolicies", javaType="APIProxyPolicy", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Proxy policy", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APIProxyPolicy> getProxyPolicies() {
        return this.proxyPolicies;
    }

    @XMLInfo(elementType="element", elementName="ProxyPolicies", elementOrder=21, dataPowerType="dmAPIProxyPolicy", subType="", benign=false, isPassword=false, cliAlias="proxy", refType="", isEnumeration=false, javaName="proxyPolicies", javaType="APIProxyPolicy", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Proxy policy", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setProxyPolicies(ArrayList<APIProxyPolicy> proxyPolicies) {
        this.proxyPolicies = proxyPolicies;
    }

    @XMLInfo(elementType="element", elementName="FrontTimeout", elementOrder=22, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="front-timeout", refType="", isEnumeration=false, javaName="frontTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="120", displayOrder=0, displayValue="Front side timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getFrontTimeout() {
        return this.frontTimeout;
    }

    @XMLInfo(elementType="element", elementName="FrontTimeout", elementOrder=22, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="front-timeout", refType="", isEnumeration=false, javaName="frontTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="120", displayValue="Front side timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFrontTimeout(long frontTimeout) {
        this.frontTimeout = frontTimeout;
    }

    @XMLInfo(elementType="element", elementName="FrontPersistentTimeout", elementOrder=23, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="front-persistent-timeout", refType="", isEnumeration=false, javaName="frontPersistentTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="180", displayOrder=0, displayValue="Front persistent timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getFrontPersistentTimeout() {
        return this.frontPersistentTimeout;
    }

    @XMLInfo(elementType="element", elementName="FrontPersistentTimeout", elementOrder=23, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="front-persistent-timeout", refType="", isEnumeration=false, javaName="frontPersistentTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="180", displayValue="Front persistent timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFrontPersistentTimeout(long frontPersistentTimeout) {
        this.frontPersistentTimeout = frontPersistentTimeout;
    }

    @XMLInfo(elementType="element", elementName="OpenTelemetry", elementOrder=24, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="otel", refType="OpenTelemetry", isEnumeration=false, javaName="openTelemetry", javaType="ObjectReference<ConfigOpenTelemetry>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="OpenTelemetry instance", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigOpenTelemetry> getOpenTelemetry() {
        return this.openTelemetry;
    }

    @XMLInfo(elementType="element", elementName="OpenTelemetry", elementOrder=24, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="otel", refType="OpenTelemetry", isEnumeration=false, javaName="openTelemetry", javaType="ObjectReference<ConfigOpenTelemetry>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="OpenTelemetry instance", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOpenTelemetry(ObjectReference<ConfigOpenTelemetry> openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public void addOpenTelemetryResourceAttribute(OpenTelemetryResourceAttribute element) {
        if (element == null) {
            return;
        }
        if (this.openTelemetryResourceAttribute == null) {
            this.openTelemetryResourceAttribute = new ArrayList();
        }
        this.openTelemetryResourceAttribute.add(element);
    }

    public boolean removeOpenTelemetryResourceAttribute(OpenTelemetryResourceAttribute element) {
        if (element == null || this.openTelemetryResourceAttribute == null) {
            return false;
        }
        return this.openTelemetryResourceAttribute.remove(element);
    }

    @XMLInfo(elementType="element", elementName="OpenTelemetryResourceAttribute", elementOrder=25, dataPowerType="dmOpenTelemetryResourceAttribute", subType="", benign=false, isPassword=false, cliAlias="otel-resource-attribute", refType="", isEnumeration=false, javaName="openTelemetryResourceAttribute", javaType="OpenTelemetryResourceAttribute", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="OpenTelemetry resource attributes", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<OpenTelemetryResourceAttribute> getOpenTelemetryResourceAttribute() {
        return this.openTelemetryResourceAttribute;
    }

    @XMLInfo(elementType="element", elementName="OpenTelemetryResourceAttribute", elementOrder=25, dataPowerType="dmOpenTelemetryResourceAttribute", subType="", benign=false, isPassword=false, cliAlias="otel-resource-attribute", refType="", isEnumeration=false, javaName="openTelemetryResourceAttribute", javaType="OpenTelemetryResourceAttribute", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="OpenTelemetry resource attributes", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOpenTelemetryResourceAttribute(ArrayList<OpenTelemetryResourceAttribute> openTelemetryResourceAttribute) {
        this.openTelemetryResourceAttribute = openTelemetryResourceAttribute;
    }

    @Override
    public int compareTo(ConfigAPIGateway that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "gatewayServiceName", "frontProtocol", "uRLRefreshPolicy", "cacheMemorySize", "cacheSize", "sHA1Caching", "staticDocumentCalls", "virtualServers", "docCacheMaxDocs", "docCacheSize", "docMaxWrites", "docCachePolicy", "scheduledRule", "aPICollection", "shareRateLimitCount", "assemblyBurstLimit", "assemblyRateLimit", "assemblyCountLimit", "lDAPConnPool", "proxyPolicies", "frontTimeout", "frontPersistentTimeout", "openTelemetry", "openTelemetryResourceAttribute");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.gatewayServiceName, this.frontProtocol, this.uRLRefreshPolicy, this.cacheMemorySize, this.cacheSize, this.sHA1Caching, this.staticDocumentCalls, this.virtualServers, this.docCacheMaxDocs, this.docCacheSize, this.docMaxWrites, this.docCachePolicy, this.scheduledRule, this.aPICollection, this.shareRateLimitCount, this.assemblyBurstLimit, this.assemblyRateLimit, this.assemblyCountLimit, this.lDAPConnPool, this.proxyPolicies, this.frontTimeout, this.frontPersistentTimeout, this.openTelemetry, this.openTelemetryResourceAttribute);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "gatewayServiceName", "frontProtocol", "uRLRefreshPolicy", "cacheMemorySize", "cacheSize", "sHA1Caching", "staticDocumentCalls", "virtualServers", "docCacheMaxDocs", "docCacheSize", "docMaxWrites", "docCachePolicy", "scheduledRule", "aPICollection", "shareRateLimitCount", "assemblyBurstLimit", "assemblyRateLimit", "assemblyCountLimit", "lDAPConnPool", "proxyPolicies", "frontTimeout", "frontPersistentTimeout", "openTelemetry", "openTelemetryResourceAttribute");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "gatewayServiceName", "frontProtocol", "uRLRefreshPolicy", "cacheMemorySize", "cacheSize", "sHA1Caching", "staticDocumentCalls", "virtualServers", "docCacheMaxDocs", "docCacheSize", "docMaxWrites", "docCachePolicy", "scheduledRule", "aPICollection", "shareRateLimitCount", "assemblyBurstLimit", "assemblyRateLimit", "assemblyCountLimit", "lDAPConnPool", "proxyPolicies", "frontTimeout", "frontPersistentTimeout", "openTelemetry", "openTelemetryResourceAttribute"));
    }
}

