/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAPISchema;
import com.kumbasoft.core.beans.config.ConfigAPISecurityRequirement;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.types.APIParameter;
import com.kumbasoft.core.beans.types.APIResponseSchema;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigAPIOperation
extends ConfigConfigBase {
    private String userSummary;
    private String method;
    private String operationId;
    private String removeConsume;
    private ArrayList<String> consume;
    private ArrayList<String> produce;
    private ObjectReference<ConfigAPISchema> requestSchema;
    private ArrayList<APIResponseSchema> responseSchema;
    private ArrayList<APIParameter> parameter;
    private String removeSecurity;
    private ArrayList<ObjectReference<ConfigAPISecurityRequirement>> security;
    private String sOAPAction;
    private String sOAPElementName;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Method", elementOrder=2, dataPowerType="dmAPIVerb", subType="", benign=false, isPassword=false, cliAlias="method", refType="", isEnumeration=true, javaName="method", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMethod() {
        return this.method;
    }

    @XMLInfo(elementType="element", elementName="Method", elementOrder=2, dataPowerType="dmAPIVerb", subType="", benign=false, isPassword=false, cliAlias="method", refType="", isEnumeration=true, javaName="method", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMethod(String method) {
        if (Comparison.isIn(method, DPEnumerations.APIVERB)) {
            this.method = method;
        }
    }

    @XMLInfo(elementType="element", elementName="OperationId", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="operation-id", refType="", isEnumeration=false, javaName="operationId", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Operation ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOperationId() {
        return this.operationId;
    }

    @XMLInfo(elementType="element", elementName="OperationId", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="operation-id", refType="", isEnumeration=false, javaName="operationId", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Operation ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    @XMLInfo(elementType="element", elementName="RemoveConsume", elementOrder=4, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="remove-consume", refType="", isEnumeration=true, javaName="removeConsume", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Remove consume", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRemoveConsume() {
        return this.removeConsume;
    }

    @XMLInfo(elementType="element", elementName="RemoveConsume", elementOrder=4, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="remove-consume", refType="", isEnumeration=true, javaName="removeConsume", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Remove consume", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRemoveConsume(String removeConsume) {
        if (removeConsume == null || Comparison.isIn(removeConsume, DPEnumerations.TOGGLE)) {
            this.removeConsume = removeConsume;
        }
    }

    public void addConsume(String element) {
        if (element == null) {
            return;
        }
        if (this.consume == null) {
            this.consume = new ArrayList();
        }
        this.consume.add(element);
    }

    public boolean removeConsume(String element) {
        if (element == null || this.consume == null) {
            return false;
        }
        return this.consume.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Consume", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="consume", refType="", isEnumeration=false, javaName="consume", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="[a-zA-Z0-9][a-zA-Z0-9!#$&\\-^_]{0,126}\\/[a-zA-Z0-9][a-zA-Z0-9!#$&\\-^_+.]{0,126}(;\\s*[a-zA-Z0-9][a-zA-Z0-9!#$&\\-^_=\"]{0,126})*$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Consumes", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getConsume() {
        return this.consume;
    }

    @XMLInfo(elementType="element", elementName="Consume", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="consume", refType="", isEnumeration=false, javaName="consume", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="[a-zA-Z0-9][a-zA-Z0-9!#$&\\-^_]{0,126}\\/[a-zA-Z0-9][a-zA-Z0-9!#$&\\-^_+.]{0,126}(;\\s*[a-zA-Z0-9][a-zA-Z0-9!#$&\\-^_=\"]{0,126})*$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Consumes", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setConsume(ArrayList<String> consume) {
        this.consume = consume;
    }

    public void addProduce(String element) {
        if (element == null) {
            return;
        }
        if (this.produce == null) {
            this.produce = new ArrayList();
        }
        this.produce.add(element);
    }

    public boolean removeProduce(String element) {
        if (element == null || this.produce == null) {
            return false;
        }
        return this.produce.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Produce", elementOrder=6, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="produce", refType="", isEnumeration=false, javaName="produce", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(application|audio|image|message|multipart|text|video)\\/[a-zA-Z-]+$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Produces", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getProduce() {
        return this.produce;
    }

    @XMLInfo(elementType="element", elementName="Produce", elementOrder=6, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="produce", refType="", isEnumeration=false, javaName="produce", javaType="String", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(application|audio|image|message|multipart|text|video)\\/[a-zA-Z-]+$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Produces", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setProduce(ArrayList<String> produce) {
        this.produce = produce;
    }

    @XMLInfo(elementType="element", elementName="RequestSchema", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="request-schema", refType="APISchema", isEnumeration=false, javaName="requestSchema", javaType="ObjectReference<ConfigAPISchema>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Request schema", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAPISchema> getRequestSchema() {
        return this.requestSchema;
    }

    @XMLInfo(elementType="element", elementName="RequestSchema", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="request-schema", refType="APISchema", isEnumeration=false, javaName="requestSchema", javaType="ObjectReference<ConfigAPISchema>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Request schema", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRequestSchema(ObjectReference<ConfigAPISchema> requestSchema) {
        this.requestSchema = requestSchema;
    }

    public void addResponseSchema(APIResponseSchema element) {
        if (element == null) {
            return;
        }
        if (this.responseSchema == null) {
            this.responseSchema = new ArrayList();
        }
        this.responseSchema.add(element);
    }

    public boolean removeResponseSchema(APIResponseSchema element) {
        if (element == null || this.responseSchema == null) {
            return false;
        }
        return this.responseSchema.remove(element);
    }

    @XMLInfo(elementType="element", elementName="ResponseSchema", elementOrder=8, dataPowerType="dmAPIResponseSchema", subType="", benign=false, isPassword=false, cliAlias="response-schema", refType="", isEnumeration=false, javaName="responseSchema", javaType="APIResponseSchema", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Response schema", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APIResponseSchema> getResponseSchema() {
        return this.responseSchema;
    }

    @XMLInfo(elementType="element", elementName="ResponseSchema", elementOrder=8, dataPowerType="dmAPIResponseSchema", subType="", benign=false, isPassword=false, cliAlias="response-schema", refType="", isEnumeration=false, javaName="responseSchema", javaType="APIResponseSchema", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Response schema", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setResponseSchema(ArrayList<APIResponseSchema> responseSchema) {
        this.responseSchema = responseSchema;
    }

    public void addParameter(APIParameter element) {
        if (element == null) {
            return;
        }
        if (this.parameter == null) {
            this.parameter = new ArrayList();
        }
        this.parameter.add(element);
    }

    public boolean removeParameter(APIParameter element) {
        if (element == null || this.parameter == null) {
            return false;
        }
        return this.parameter.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Parameter", elementOrder=9, dataPowerType="dmAPIParameter", subType="", benign=false, isPassword=false, cliAlias="parameter", refType="", isEnumeration=false, javaName="parameter", javaType="APIParameter", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Parameters", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APIParameter> getParameter() {
        return this.parameter;
    }

    @XMLInfo(elementType="element", elementName="Parameter", elementOrder=9, dataPowerType="dmAPIParameter", subType="", benign=false, isPassword=false, cliAlias="parameter", refType="", isEnumeration=false, javaName="parameter", javaType="APIParameter", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Parameters", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setParameter(ArrayList<APIParameter> parameter) {
        this.parameter = parameter;
    }

    @XMLInfo(elementType="element", elementName="RemoveSecurity", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="remove-security", refType="", isEnumeration=true, javaName="removeSecurity", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Remove security", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRemoveSecurity() {
        return this.removeSecurity;
    }

    @XMLInfo(elementType="element", elementName="RemoveSecurity", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="remove-security", refType="", isEnumeration=true, javaName="removeSecurity", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Remove security", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRemoveSecurity(String removeSecurity) {
        if (removeSecurity == null || Comparison.isIn(removeSecurity, DPEnumerations.TOGGLE)) {
            this.removeSecurity = removeSecurity;
        }
    }

    public void addSecurity(ObjectReference<ConfigAPISecurityRequirement> element) {
        if (element == null) {
            return;
        }
        if (this.security == null) {
            this.security = new ArrayList();
        }
        this.security.add(element);
    }

    public boolean removeSecurity(ObjectReference<ConfigAPISecurityRequirement> element) {
        if (element == null || this.security == null) {
            return false;
        }
        return this.security.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Security", elementOrder=11, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="security", refType="APISecurityRequirement", isEnumeration=false, javaName="security", javaType="ObjectReference<ConfigAPISecurityRequirement>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Security requirements", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference<ConfigAPISecurityRequirement>> getSecurity() {
        return this.security;
    }

    @XMLInfo(elementType="element", elementName="Security", elementOrder=11, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="security", refType="APISecurityRequirement", isEnumeration=false, javaName="security", javaType="ObjectReference<ConfigAPISecurityRequirement>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Security requirements", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSecurity(ArrayList<ObjectReference<ConfigAPISecurityRequirement>> security) {
        this.security = security;
    }

    @XMLInfo(elementType="element", elementName="SOAPAction", elementOrder=12, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="soap-action", refType="", isEnumeration=false, javaName="sOAPAction", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="SOAP action", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSOAPAction() {
        return this.sOAPAction;
    }

    @XMLInfo(elementType="element", elementName="SOAPAction", elementOrder=12, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="soap-action", refType="", isEnumeration=false, javaName="sOAPAction", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="SOAP action", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSOAPAction(String sOAPAction) {
        this.sOAPAction = sOAPAction;
    }

    @XMLInfo(elementType="element", elementName="SOAPElementName", elementOrder=13, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="soap-element-name", refType="", isEnumeration=false, javaName="sOAPElementName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="SOAP element name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSOAPElementName() {
        return this.sOAPElementName;
    }

    @XMLInfo(elementType="element", elementName="SOAPElementName", elementOrder=13, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="soap-element-name", refType="", isEnumeration=false, javaName="sOAPElementName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="SOAP element name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSOAPElementName(String sOAPElementName) {
        this.sOAPElementName = sOAPElementName;
    }

    @Override
    public int compareTo(ConfigAPIOperation that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "method", "operationId", "removeConsume", "consume", "produce", "requestSchema", "responseSchema", "parameter", "removeSecurity", "security", "sOAPAction", "sOAPElementName");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.method, this.operationId, this.removeConsume, this.consume, this.produce, this.requestSchema, this.responseSchema, this.parameter, this.removeSecurity, this.security, this.sOAPAction, this.sOAPElementName);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "method", "operationId", "removeConsume", "consume", "produce", "requestSchema", "responseSchema", "parameter", "removeSecurity", "security", "sOAPAction", "sOAPElementName");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "method", "operationId", "removeConsume", "consume", "produce", "requestSchema", "responseSchema", "parameter", "removeSecurity", "security", "sOAPAction", "sOAPElementName"));
    }
}

