/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAPIOperation;
import com.kumbasoft.core.beans.config.ConfigAPISchema;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.types.APIParameter;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigAPIPath
extends ConfigConfigBase {
    private String userSummary;
    private String path;
    private ArrayList<ObjectReference<ConfigAPIOperation>> operation;
    private ObjectReference<ConfigAPISchema> requestSchema;
    private ArrayList<APIParameter> parameter;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Path", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="path", refType="", isEnumeration=false, javaName="path", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^\\/$||^\\/([0-9a-zA-Z-_.~%!$&'()*+,;=:@\\{\\}]+\\/)*[0-9a-zA-Z-_.~%!$&'()*+,;=:@\\{\\}]+$", allowedValues={}, defaultValue="/", displayOrder=0, displayValue="Path", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPath() {
        return this.path;
    }

    @XMLInfo(elementType="element", elementName="Path", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="path", refType="", isEnumeration=false, javaName="path", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^\\/$||^\\/([0-9a-zA-Z-_.~%!$&'()*+,;=:@\\{\\}]+\\/)*[0-9a-zA-Z-_.~%!$&'()*+,;=:@\\{\\}]+$", allowedValues={}, displayOrder=0, defaultValue="/", displayValue="Path", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPath(String path) {
        if (path != null && path.matches("^\\/$||^\\/([0-9a-zA-Z-_.~%!$&'()*+,;=:@\\{\\}]+\\/)*[0-9a-zA-Z-_.~%!$&'()*+,;=:@\\{\\}]+$")) {
            this.path = path;
        }
    }

    public void addOperation(ObjectReference<ConfigAPIOperation> element) {
        if (element == null) {
            return;
        }
        if (this.operation == null) {
            this.operation = new ArrayList();
        }
        this.operation.add(element);
    }

    public boolean removeOperation(ObjectReference<ConfigAPIOperation> element) {
        if (element == null || this.operation == null) {
            return false;
        }
        return this.operation.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Operation", elementOrder=3, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="operation", refType="APIOperation", isEnumeration=false, javaName="operation", javaType="ObjectReference<ConfigAPIOperation>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Operation", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference<ConfigAPIOperation>> getOperation() {
        return this.operation;
    }

    @XMLInfo(elementType="element", elementName="Operation", elementOrder=3, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="operation", refType="APIOperation", isEnumeration=false, javaName="operation", javaType="ObjectReference<ConfigAPIOperation>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Operation", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOperation(ArrayList<ObjectReference<ConfigAPIOperation>> operation) {
        this.operation = operation;
    }

    @XMLInfo(elementType="element", elementName="RequestSchema", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="request-schema", refType="APISchema", isEnumeration=false, javaName="requestSchema", javaType="ObjectReference<ConfigAPISchema>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Request schema", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAPISchema> getRequestSchema() {
        return this.requestSchema;
    }

    @XMLInfo(elementType="element", elementName="RequestSchema", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="request-schema", refType="APISchema", isEnumeration=false, javaName="requestSchema", javaType="ObjectReference<ConfigAPISchema>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Request schema", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRequestSchema(ObjectReference<ConfigAPISchema> requestSchema) {
        this.requestSchema = requestSchema;
    }

    public void addParameter(APIParameter element) {
        if (element == null) {
            return;
        }
        if (this.parameter == null) {
            this.parameter = new ArrayList();
        }
        this.parameter.add(element);
    }

    public boolean removeParameter(APIParameter element) {
        if (element == null || this.parameter == null) {
            return false;
        }
        return this.parameter.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Parameter", elementOrder=5, dataPowerType="dmAPIParameter", subType="", benign=false, isPassword=false, cliAlias="parameter", refType="", isEnumeration=false, javaName="parameter", javaType="APIParameter", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Parameters", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APIParameter> getParameter() {
        return this.parameter;
    }

    @XMLInfo(elementType="element", elementName="Parameter", elementOrder=5, dataPowerType="dmAPIParameter", subType="", benign=false, isPassword=false, cliAlias="parameter", refType="", isEnumeration=false, javaName="parameter", javaType="APIParameter", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Parameters", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setParameter(ArrayList<APIParameter> parameter) {
        this.parameter = parameter;
    }

    @Override
    public int compareTo(ConfigAPIPath that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "path", "operation", "requestSchema", "parameter");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.path, this.operation, this.requestSchema, this.parameter);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "path", "operation", "requestSchema", "parameter");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "path", "operation", "requestSchema", "parameter"));
    }
}

