/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAPISecurityDefinition;
import com.kumbasoft.core.beans.config.ConfigSSLClientProfile;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ConfigAPISecurityHTTPScheme
extends ConfigAPISecurityDefinition {
    private String userSummary;
    private String scheme;
    private String bearerFormat;
    private String bearerValidationMethod;
    private String bearerValidationEndpoint;
    private ObjectReference<ConfigSSLClientProfile> bearerValidationTLSProfile;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Scheme", elementOrder=2, dataPowerType="dmAPISecurityHTTPScheme", subType="", benign=false, isPassword=false, cliAlias="http-scheme", refType="", isEnumeration=true, javaName="scheme", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Scheme", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getScheme() {
        return this.scheme;
    }

    @XMLInfo(elementType="element", elementName="Scheme", elementOrder=2, dataPowerType="dmAPISecurityHTTPScheme", subType="", benign=false, isPassword=false, cliAlias="http-scheme", refType="", isEnumeration=true, javaName="scheme", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Scheme", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setScheme(String scheme) {
        if (scheme == null || Comparison.isIn(scheme, DPEnumerations.APISECURITY_HTTPSCHEME)) {
            this.scheme = scheme;
        }
    }

    @XMLInfo(elementType="element", elementName="BearerFormat", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="bearer-format", refType="", isEnumeration=false, javaName="bearerFormat", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Bearer format", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getBearerFormat() {
        return this.bearerFormat;
    }

    @XMLInfo(elementType="element", elementName="BearerFormat", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="bearer-format", refType="", isEnumeration=false, javaName="bearerFormat", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Bearer format", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBearerFormat(String bearerFormat) {
        this.bearerFormat = bearerFormat;
    }

    @XMLInfo(elementType="element", elementName="BearerValidationMethod", elementOrder=4, dataPowerType="dmBearerValidationMethod", subType="", benign=false, isPassword=false, cliAlias="bearer-validation-method", refType="", isEnumeration=true, javaName="bearerValidationMethod", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Bearer validation method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getBearerValidationMethod() {
        return this.bearerValidationMethod;
    }

    @XMLInfo(elementType="element", elementName="BearerValidationMethod", elementOrder=4, dataPowerType="dmBearerValidationMethod", subType="", benign=false, isPassword=false, cliAlias="bearer-validation-method", refType="", isEnumeration=true, javaName="bearerValidationMethod", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Bearer validation method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBearerValidationMethod(String bearerValidationMethod) {
        if (bearerValidationMethod == null || Comparison.isIn(bearerValidationMethod, DPEnumerations.BEARER_VALIDATION_METHOD)) {
            this.bearerValidationMethod = bearerValidationMethod;
        }
    }

    @XMLInfo(elementType="element", elementName="BearerValidationEndpoint", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="bearer-validation-endpoint", refType="", isEnumeration=false, javaName="bearerValidationEndpoint", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Bearer validation endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getBearerValidationEndpoint() {
        return this.bearerValidationEndpoint;
    }

    @XMLInfo(elementType="element", elementName="BearerValidationEndpoint", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="bearer-validation-endpoint", refType="", isEnumeration=false, javaName="bearerValidationEndpoint", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Bearer validation endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBearerValidationEndpoint(String bearerValidationEndpoint) {
        this.bearerValidationEndpoint = bearerValidationEndpoint;
    }

    @XMLInfo(elementType="element", elementName="BearerValidationTLSProfile", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="bearer-validation-tls-profile", refType="SSLClientProfile", isEnumeration=false, javaName="bearerValidationTLSProfile", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Bearer validation TLS profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getBearerValidationTLSProfile() {
        return this.bearerValidationTLSProfile;
    }

    @XMLInfo(elementType="element", elementName="BearerValidationTLSProfile", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="bearer-validation-tls-profile", refType="SSLClientProfile", isEnumeration=false, javaName="bearerValidationTLSProfile", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Bearer validation TLS profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBearerValidationTLSProfile(ObjectReference<ConfigSSLClientProfile> bearerValidationTLSProfile) {
        this.bearerValidationTLSProfile = bearerValidationTLSProfile;
    }

    @Override
    public int compareTo(ConfigAPISecurityHTTPScheme that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "scheme", "bearerFormat", "bearerValidationMethod", "bearerValidationEndpoint", "bearerValidationTLSProfile");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.scheme, this.bearerFormat, this.bearerValidationMethod, this.bearerValidationEndpoint, this.bearerValidationTLSProfile);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "scheme", "bearerFormat", "bearerValidationMethod", "bearerValidationEndpoint", "bearerValidationTLSProfile");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "scheme", "bearerFormat", "bearerValidationMethod", "bearerValidationEndpoint", "bearerValidationTLSProfile"));
    }
}

