/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigCryptoCertificate;
import com.kumbasoft.core.beans.config.ConfigCryptoIdentCred;
import com.kumbasoft.core.beans.config.ConfigPasswordAlias;
import com.kumbasoft.core.beans.config.ConfigSSLClientProfile;
import com.kumbasoft.core.beans.config.ConfigSSLProxyProfile;
import com.kumbasoft.core.beans.types.B2BEnabledDocType;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ConfigB2BCPASenderSetting
extends ConfigConfigBase {
    private String userSummary;
    private B2BEnabledDocType enabledDocType;
    private String destEndpointURL;
    private ObjectReference<ConfigSSLProxyProfile> sSLProxy;
    private String userName;
    private String password;
    private ObjectReference<ConfigPasswordAlias> passwordAlias;
    private long connectionTimeout;
    private String syncReplyMode;
    private String duplicateElimination;
    private String ackRequested;
    private String ackSignatureRequested;
    private String retry;
    private long maxRetries;
    private long retryInterval;
    private long persistDuration;
    private String includeTimeToLive;
    private String encryptionRequired;
    private ObjectReference<ConfigCryptoCertificate> encryptCert;
    private String encryptAlgorithm;
    private String signatureRequired;
    private ObjectReference<ConfigCryptoIdentCred> signIdCred;
    private String signatureAlgorithm;
    private String signDigestAlgorithm;
    private String signatureC14NAlgorithm;
    private String sSLClientConfigType;
    private ObjectReference<ConfigSSLClientProfile> sSLClient;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="EnabledDocType", elementOrder=2, dataPowerType="dmB2BEnabledDocType", subType="", benign=false, isPassword=false, cliAlias="enabled-doc-type", refType="", isEnumeration=false, javaName="enabledDocType", javaType="B2BEnabledDocType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="EnableXML+EnableX12+EnableEDIFACT+EnableBinary", displayOrder=0, displayValue="Enabled document types", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public B2BEnabledDocType getEnabledDocType() {
        return this.enabledDocType;
    }

    @XMLInfo(elementType="element", elementName="EnabledDocType", elementOrder=2, dataPowerType="dmB2BEnabledDocType", subType="", benign=false, isPassword=false, cliAlias="enabled-doc-type", refType="", isEnumeration=false, javaName="enabledDocType", javaType="B2BEnabledDocType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="EnableXML+EnableX12+EnableEDIFACT+EnableBinary", displayValue="Enabled document types", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnabledDocType(B2BEnabledDocType enabledDocType) {
        this.enabledDocType = enabledDocType;
    }

    @XMLInfo(elementType="element", elementName="DestEndpointURL", elementOrder=3, dataPowerType="dmURL", subType="dmAllURLProtocol", benign=false, isPassword=false, cliAlias="dest-url", refType="", isEnumeration=false, javaName="destEndpointURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Destination URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDestEndpointURL() {
        return this.destEndpointURL;
    }

    @XMLInfo(elementType="element", elementName="DestEndpointURL", elementOrder=3, dataPowerType="dmURL", subType="dmAllURLProtocol", benign=false, isPassword=false, cliAlias="dest-url", refType="", isEnumeration=false, javaName="destEndpointURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Destination URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDestEndpointURL(String destEndpointURL) {
        this.destEndpointURL = destEndpointURL;
    }

    @XMLInfo(elementType="element", elementName="SSLProxy", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="sSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLProxyProfile> getSSLProxy() {
        return this.sSLProxy;
    }

    @XMLInfo(elementType="element", elementName="SSLProxy", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="sSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLProxy(ObjectReference<ConfigSSLProxyProfile> sSLProxy) {
        this.sSLProxy = sSLProxy;
    }

    @XMLInfo(elementType="element", elementName="UserName", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="username", refType="", isEnumeration=false, javaName="userName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=128, validationRegex="^[_a-zA-Z0-9-.]+$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserName() {
        return this.userName;
    }

    @XMLInfo(elementType="element", elementName="UserName", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="username", refType="", isEnumeration=false, javaName="userName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=128, validationRegex="^[_a-zA-Z0-9-.]+$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserName(String userName) {
        if (userName != null && userName.matches("^[_a-zA-Z0-9-.]+$")) {
            this.userName = userName;
        }
    }

    @XMLInfo(elementType="element", elementName="Password", elementOrder=6, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="password", refType="", isEnumeration=false, javaName="password", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=128, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Password (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="7.2.0.0", isObsolete=false, obsoletedIn="")
    public String getPassword() {
        return this.password;
    }

    @XMLInfo(elementType="element", elementName="Password", elementOrder=6, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="password", refType="", isEnumeration=false, javaName="password", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=128, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Password (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="7.2.0.0", isObsolete=false, obsoletedIn="")
    public void setPassword(String password) {
        this.password = password;
    }

    @XMLInfo(elementType="element", elementName="PasswordAlias", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password-alias", refType="PasswordAlias", isEnumeration=false, javaName="passwordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=128, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getPasswordAlias() {
        return this.passwordAlias;
    }

    @XMLInfo(elementType="element", elementName="PasswordAlias", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password-alias", refType="PasswordAlias", isEnumeration=false, javaName="passwordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=128, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPasswordAlias(ObjectReference<ConfigPasswordAlias> passwordAlias) {
        this.passwordAlias = passwordAlias;
    }

    @XMLInfo(elementType="element", elementName="ConnectionTimeout", elementOrder=8, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="timeout", refType="", isEnumeration=false, javaName="connectionTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=3, maximum=7200L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="300", displayOrder=0, displayValue="Connection timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @XMLInfo(elementType="element", elementName="ConnectionTimeout", elementOrder=8, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="timeout", refType="", isEnumeration=false, javaName="connectionTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=3, maximum=7200L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="300", displayValue="Connection timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @XMLInfo(elementType="element", elementName="SyncReplyMode", elementOrder=9, dataPowerType="dmEBMSSyncReplyMode", subType="", benign=false, isPassword=false, cliAlias="syncreply-mode", refType="", isEnumeration=true, javaName="syncReplyMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="none", displayOrder=0, displayValue="Sync reply mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSyncReplyMode() {
        return this.syncReplyMode;
    }

    @XMLInfo(elementType="element", elementName="SyncReplyMode", elementOrder=9, dataPowerType="dmEBMSSyncReplyMode", subType="", benign=false, isPassword=false, cliAlias="syncreply-mode", refType="", isEnumeration=true, javaName="syncReplyMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="none", displayValue="Sync reply mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSyncReplyMode(String syncReplyMode) {
        if (syncReplyMode == null || Comparison.isIn(syncReplyMode, DPEnumerations.EBMSSYNC_REPLY_MODE)) {
            this.syncReplyMode = syncReplyMode;
        }
    }

    @XMLInfo(elementType="element", elementName="DuplicateElimination", elementOrder=10, dataPowerType="dmCPASenderRequested", subType="", benign=false, isPassword=false, cliAlias="duplicate-elimination", refType="", isEnumeration=true, javaName="duplicateElimination", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="always", displayOrder=0, displayValue="Duplicate elimination", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDuplicateElimination() {
        return this.duplicateElimination;
    }

    @XMLInfo(elementType="element", elementName="DuplicateElimination", elementOrder=10, dataPowerType="dmCPASenderRequested", subType="", benign=false, isPassword=false, cliAlias="duplicate-elimination", refType="", isEnumeration=true, javaName="duplicateElimination", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="always", displayValue="Duplicate elimination", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDuplicateElimination(String duplicateElimination) {
        if (duplicateElimination == null || Comparison.isIn(duplicateElimination, DPEnumerations.CPASENDER_REQUESTED)) {
            this.duplicateElimination = duplicateElimination;
        }
    }

    @XMLInfo(elementType="element", elementName="AckRequested", elementOrder=11, dataPowerType="dmCPASenderRequested", subType="", benign=false, isPassword=false, cliAlias="ack-requested", refType="", isEnumeration=true, javaName="ackRequested", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="never", displayOrder=0, displayValue="Request acknowledgment", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAckRequested() {
        return this.ackRequested;
    }

    @XMLInfo(elementType="element", elementName="AckRequested", elementOrder=11, dataPowerType="dmCPASenderRequested", subType="", benign=false, isPassword=false, cliAlias="ack-requested", refType="", isEnumeration=true, javaName="ackRequested", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="never", displayValue="Request acknowledgment", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAckRequested(String ackRequested) {
        if (ackRequested == null || Comparison.isIn(ackRequested, DPEnumerations.CPASENDER_REQUESTED)) {
            this.ackRequested = ackRequested;
        }
    }

    @XMLInfo(elementType="element", elementName="AckSignatureRequested", elementOrder=12, dataPowerType="dmCPASenderRequested", subType="", benign=false, isPassword=false, cliAlias="ack-signature-requested", refType="", isEnumeration=true, javaName="ackSignatureRequested", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="never", displayOrder=0, displayValue="Request signed acknowledgment", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAckSignatureRequested() {
        return this.ackSignatureRequested;
    }

    @XMLInfo(elementType="element", elementName="AckSignatureRequested", elementOrder=12, dataPowerType="dmCPASenderRequested", subType="", benign=false, isPassword=false, cliAlias="ack-signature-requested", refType="", isEnumeration=true, javaName="ackSignatureRequested", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="never", displayValue="Request signed acknowledgment", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAckSignatureRequested(String ackSignatureRequested) {
        if (ackSignatureRequested == null || Comparison.isIn(ackSignatureRequested, DPEnumerations.CPASENDER_REQUESTED)) {
            this.ackSignatureRequested = ackSignatureRequested;
        }
    }

    @XMLInfo(elementType="element", elementName="Retry", elementOrder=13, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="retry", refType="", isEnumeration=true, javaName="retry", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Retransmit unacknowledged messages", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRetry() {
        return this.retry;
    }

    @XMLInfo(elementType="element", elementName="Retry", elementOrder=13, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="retry", refType="", isEnumeration=true, javaName="retry", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Retransmit unacknowledged messages", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRetry(String retry) {
        if (retry == null || Comparison.isIn(retry, DPEnumerations.TOGGLE)) {
            this.retry = retry;
        }
    }

    @XMLInfo(elementType="element", elementName="MaxRetries", elementOrder=14, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-retries", refType="", isEnumeration=false, javaName="maxRetries", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=30L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="3", displayOrder=0, displayValue="Retransmit attempts", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxRetries() {
        return this.maxRetries;
    }

    @XMLInfo(elementType="element", elementName="MaxRetries", elementOrder=14, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-retries", refType="", isEnumeration=false, javaName="maxRetries", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=30L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="3", displayValue="Retransmit attempts", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxRetries(long maxRetries) {
        this.maxRetries = maxRetries;
    }

    @XMLInfo(elementType="element", elementName="RetryInterval", elementOrder=15, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="retry-interval", refType="", isEnumeration=false, javaName="retryInterval", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="1800", displayOrder=0, displayValue="Retransmit interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getRetryInterval() {
        return this.retryInterval;
    }

    @XMLInfo(elementType="element", elementName="RetryInterval", elementOrder=15, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="retry-interval", refType="", isEnumeration=false, javaName="retryInterval", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="1800", displayValue="Retransmit interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    @XMLInfo(elementType="element", elementName="PersistDuration", elementOrder=16, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="persist-duration", refType="", isEnumeration=false, javaName="persistDuration", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=6000000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Persistence duration", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getPersistDuration() {
        return this.persistDuration;
    }

    @XMLInfo(elementType="element", elementName="PersistDuration", elementOrder=16, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="persist-duration", refType="", isEnumeration=false, javaName="persistDuration", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=6000000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Persistence duration", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPersistDuration(long persistDuration) {
        this.persistDuration = persistDuration;
    }

    @XMLInfo(elementType="element", elementName="IncludeTimeToLive", elementOrder=17, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="include-time-to-live", refType="", isEnumeration=true, javaName="includeTimeToLive", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Include TimeToLive element", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getIncludeTimeToLive() {
        return this.includeTimeToLive;
    }

    @XMLInfo(elementType="element", elementName="IncludeTimeToLive", elementOrder=17, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="include-time-to-live", refType="", isEnumeration=true, javaName="includeTimeToLive", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Include TimeToLive element", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setIncludeTimeToLive(String includeTimeToLive) {
        if (includeTimeToLive == null || Comparison.isIn(includeTimeToLive, DPEnumerations.TOGGLE)) {
            this.includeTimeToLive = includeTimeToLive;
        }
    }

    @XMLInfo(elementType="element", elementName="EncryptionRequired", elementOrder=18, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="encrypt-required", refType="", isEnumeration=true, javaName="encryptionRequired", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Require encryption", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEncryptionRequired() {
        return this.encryptionRequired;
    }

    @XMLInfo(elementType="element", elementName="EncryptionRequired", elementOrder=18, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="encrypt-required", refType="", isEnumeration=true, javaName="encryptionRequired", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Require encryption", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEncryptionRequired(String encryptionRequired) {
        if (encryptionRequired == null || Comparison.isIn(encryptionRequired, DPEnumerations.TOGGLE)) {
            this.encryptionRequired = encryptionRequired;
        }
    }

    @XMLInfo(elementType="element", elementName="EncryptCert", elementOrder=19, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="encrypt-cert", refType="CryptoCertificate", isEnumeration=false, javaName="encryptCert", javaType="ObjectReference<ConfigCryptoCertificate>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Encryption certificate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoCertificate> getEncryptCert() {
        return this.encryptCert;
    }

    @XMLInfo(elementType="element", elementName="EncryptCert", elementOrder=19, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="encrypt-cert", refType="CryptoCertificate", isEnumeration=false, javaName="encryptCert", javaType="ObjectReference<ConfigCryptoCertificate>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Encryption certificate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEncryptCert(ObjectReference<ConfigCryptoCertificate> encryptCert) {
        this.encryptCert = encryptCert;
    }

    @XMLInfo(elementType="element", elementName="EncryptAlgorithm", elementOrder=20, dataPowerType="dmCryptoEncryptionAlgorithm", subType="", benign=false, isPassword=false, cliAlias="encrypt-algorithm", refType="", isEnumeration=true, javaName="encryptAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="http://www.w3.org/2001/04/xmlenc#tripledes-cbc", displayOrder=0, displayValue="Encryption algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEncryptAlgorithm() {
        return this.encryptAlgorithm;
    }

    @XMLInfo(elementType="element", elementName="EncryptAlgorithm", elementOrder=20, dataPowerType="dmCryptoEncryptionAlgorithm", subType="", benign=false, isPassword=false, cliAlias="encrypt-algorithm", refType="", isEnumeration=true, javaName="encryptAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="http://www.w3.org/2001/04/xmlenc#tripledes-cbc", displayValue="Encryption algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEncryptAlgorithm(String encryptAlgorithm) {
        if (encryptAlgorithm == null || Comparison.isIn(encryptAlgorithm, DPEnumerations.CRYPTO_ENCRYPTION_ALGORITHM)) {
            this.encryptAlgorithm = encryptAlgorithm;
        }
    }

    @XMLInfo(elementType="element", elementName="SignatureRequired", elementOrder=21, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="sign-required", refType="", isEnumeration=true, javaName="signatureRequired", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Require signature", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSignatureRequired() {
        return this.signatureRequired;
    }

    @XMLInfo(elementType="element", elementName="SignatureRequired", elementOrder=21, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="sign-required", refType="", isEnumeration=true, javaName="signatureRequired", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Require signature", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSignatureRequired(String signatureRequired) {
        if (signatureRequired == null || Comparison.isIn(signatureRequired, DPEnumerations.TOGGLE)) {
            this.signatureRequired = signatureRequired;
        }
    }

    @XMLInfo(elementType="element", elementName="SignIdCred", elementOrder=22, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="sign-idcred", refType="CryptoIdentCred", isEnumeration=false, javaName="signIdCred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Signature identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoIdentCred> getSignIdCred() {
        return this.signIdCred;
    }

    @XMLInfo(elementType="element", elementName="SignIdCred", elementOrder=22, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="sign-idcred", refType="CryptoIdentCred", isEnumeration=false, javaName="signIdCred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Signature identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSignIdCred(ObjectReference<ConfigCryptoIdentCred> signIdCred) {
        this.signIdCred = signIdCred;
    }

    @XMLInfo(elementType="element", elementName="SignatureAlgorithm", elementOrder=23, dataPowerType="dmEBMSSignatureAlgorithm", subType="", benign=false, isPassword=false, cliAlias="sign-algorithm", refType="", isEnumeration=true, javaName="signatureAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="rsa-sha1", displayOrder=0, displayValue="Signature algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @XMLInfo(elementType="element", elementName="SignatureAlgorithm", elementOrder=23, dataPowerType="dmEBMSSignatureAlgorithm", subType="", benign=false, isPassword=false, cliAlias="sign-algorithm", refType="", isEnumeration=true, javaName="signatureAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="rsa-sha1", displayValue="Signature algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSignatureAlgorithm(String signatureAlgorithm) {
        if (signatureAlgorithm == null || Comparison.isIn(signatureAlgorithm, DPEnumerations.EBMSSIGNATURE_ALGORITHM)) {
            this.signatureAlgorithm = signatureAlgorithm;
        }
    }

    @XMLInfo(elementType="element", elementName="SignDigestAlgorithm", elementOrder=24, dataPowerType="dmCryptoHashAlgorithm", subType="", benign=false, isPassword=false, cliAlias="sign-digest-algorithm", refType="", isEnumeration=true, javaName="signDigestAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="sha1", displayOrder=0, displayValue="Signing digest algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSignDigestAlgorithm() {
        return this.signDigestAlgorithm;
    }

    @XMLInfo(elementType="element", elementName="SignDigestAlgorithm", elementOrder=24, dataPowerType="dmCryptoHashAlgorithm", subType="", benign=false, isPassword=false, cliAlias="sign-digest-algorithm", refType="", isEnumeration=true, javaName="signDigestAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="sha1", displayValue="Signing digest algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSignDigestAlgorithm(String signDigestAlgorithm) {
        if (signDigestAlgorithm == null || Comparison.isIn(signDigestAlgorithm, DPEnumerations.CRYPTO_HASH_ALGORITHM)) {
            this.signDigestAlgorithm = signDigestAlgorithm;
        }
    }

    @XMLInfo(elementType="element", elementName="SignatureC14NAlgorithm", elementOrder=25, dataPowerType="dmCryptoCanonicalizationAlgorithm", subType="", benign=false, isPassword=false, cliAlias="sign-c14n-algorithm", refType="", isEnumeration=true, javaName="signatureC14NAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="exc-c14n", displayOrder=0, displayValue="Signature canonicalization method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSignatureC14NAlgorithm() {
        return this.signatureC14NAlgorithm;
    }

    @XMLInfo(elementType="element", elementName="SignatureC14NAlgorithm", elementOrder=25, dataPowerType="dmCryptoCanonicalizationAlgorithm", subType="", benign=false, isPassword=false, cliAlias="sign-c14n-algorithm", refType="", isEnumeration=true, javaName="signatureC14NAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="exc-c14n", displayValue="Signature canonicalization method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSignatureC14NAlgorithm(String signatureC14NAlgorithm) {
        if (signatureC14NAlgorithm == null || Comparison.isIn(signatureC14NAlgorithm, DPEnumerations.CRYPTO_CANONICALIZATION_ALGORITHM)) {
            this.signatureC14NAlgorithm = signatureC14NAlgorithm;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLClientConfigType", elementOrder=26, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-client-type", refType="", isEnumeration=true, javaName="sSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="proxy", displayOrder=5, displayValue="TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSSLClientConfigType() {
        return this.sSLClientConfigType;
    }

    @XMLInfo(elementType="element", elementName="SSLClientConfigType", elementOrder=26, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-client-type", refType="", isEnumeration=true, javaName="sSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=5, defaultValue="proxy", displayValue="TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClientConfigType(String sSLClientConfigType) {
        if (sSLClientConfigType == null || Comparison.isIn(sSLClientConfigType, DPEnumerations.SSLCLIENT_CONFIG_TYPE)) {
            this.sSLClientConfigType = sSLClientConfigType;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=27, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=7, displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getSSLClient() {
        return this.sSLClient;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=27, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=7, defaultValue="", displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClient(ObjectReference<ConfigSSLClientProfile> sSLClient) {
        this.sSLClient = sSLClient;
    }

    @Override
    public int compareTo(ConfigB2BCPASenderSetting that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "enabledDocType", "destEndpointURL", "sSLProxy", "userName", "password", "passwordAlias", "connectionTimeout", "syncReplyMode", "duplicateElimination", "ackRequested", "ackSignatureRequested", "retry", "maxRetries", "retryInterval", "persistDuration", "includeTimeToLive", "encryptionRequired", "encryptCert", "encryptAlgorithm", "signatureRequired", "signIdCred", "signatureAlgorithm", "signDigestAlgorithm", "signatureC14NAlgorithm", "sSLClientConfigType", "sSLClient");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.enabledDocType, this.destEndpointURL, this.sSLProxy, this.userName, this.password, this.passwordAlias, this.connectionTimeout, this.syncReplyMode, this.duplicateElimination, this.ackRequested, this.ackSignatureRequested, this.retry, this.maxRetries, this.retryInterval, this.persistDuration, this.includeTimeToLive, this.encryptionRequired, this.encryptCert, this.encryptAlgorithm, this.signatureRequired, this.signIdCred, this.signatureAlgorithm, this.signDigestAlgorithm, this.signatureC14NAlgorithm, this.sSLClientConfigType, this.sSLClient);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "enabledDocType", "destEndpointURL", "sSLProxy", "userName", "password", "passwordAlias", "connectionTimeout", "syncReplyMode", "duplicateElimination", "ackRequested", "ackSignatureRequested", "retry", "maxRetries", "retryInterval", "persistDuration", "includeTimeToLive", "encryptionRequired", "encryptCert", "encryptAlgorithm", "signatureRequired", "signIdCred", "signatureAlgorithm", "signDigestAlgorithm", "signatureC14NAlgorithm", "sSLClientConfigType", "sSLClient");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "enabledDocType", "destEndpointURL", "sSLProxy", "userName", "password", "passwordAlias", "connectionTimeout", "syncReplyMode", "duplicateElimination", "ackRequested", "ackSignatureRequested", "retry", "maxRetries", "retryInterval", "persistDuration", "includeTimeToLive", "encryptionRequired", "encryptCert", "encryptAlgorithm", "signatureRequired", "signIdCred", "signatureAlgorithm", "signDigestAlgorithm", "signatureC14NAlgorithm", "sSLClientConfigType", "sSLClient"));
    }
}

