/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigSequenceCapabilities;
import com.kumbasoft.core.beans.config.ConfigSequenceLocation;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigConfigSequence
extends ConfigConfigBase {
    private String userSummary;
    private ArrayList<ConfigSequenceLocation> locations;
    private String matchPattern;
    private String resultNamePattern;
    private String statusNamePattern;
    private String watch;
    private String useOutputLocation;
    private String outputLocation;
    private String deleteUnused;
    private long runSequenceInterval;
    private ConfigSequenceCapabilities capabilities;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    public void addLocations(ConfigSequenceLocation element) {
        if (element == null) {
            return;
        }
        if (this.locations == null) {
            this.locations = new ArrayList();
        }
        this.locations.add(element);
    }

    public boolean removeLocations(ConfigSequenceLocation element) {
        if (element == null || this.locations == null) {
            return false;
        }
        return this.locations.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Locations", elementOrder=2, dataPowerType="dmConfigSequenceLocation", subType="", benign=false, isPassword=false, cliAlias="location", refType="", isEnumeration=false, javaName="locations", javaType="ConfigSequenceLocation", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Location profiles", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ConfigSequenceLocation> getLocations() {
        return this.locations;
    }

    @XMLInfo(elementType="element", elementName="Locations", elementOrder=2, dataPowerType="dmConfigSequenceLocation", subType="", benign=false, isPassword=false, cliAlias="location", refType="", isEnumeration=false, javaName="locations", javaType="ConfigSequenceLocation", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Location profiles", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocations(ArrayList<ConfigSequenceLocation> locations) {
        this.locations = locations;
    }

    @XMLInfo(elementType="element", elementName="MatchPattern", elementOrder=3, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="match-pattern", refType="", isEnumeration=false, javaName="matchPattern", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="(.*)\\.cfg$", displayOrder=0, displayValue="Matching pattern", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMatchPattern() {
        return this.matchPattern;
    }

    @XMLInfo(elementType="element", elementName="MatchPattern", elementOrder=3, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="match-pattern", refType="", isEnumeration=false, javaName="matchPattern", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="(.*)\\.cfg$", displayValue="Matching pattern", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMatchPattern(String matchPattern) {
        this.matchPattern = matchPattern;
    }

    @XMLInfo(elementType="element", elementName="ResultNamePattern", elementOrder=4, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="result-name-pattern", refType="", isEnumeration=false, javaName="resultNamePattern", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="$1.log", displayOrder=0, displayValue="Result file-naming pattern", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getResultNamePattern() {
        return this.resultNamePattern;
    }

    @XMLInfo(elementType="element", elementName="ResultNamePattern", elementOrder=4, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="result-name-pattern", refType="", isEnumeration=false, javaName="resultNamePattern", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="$1.log", displayValue="Result file-naming pattern", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setResultNamePattern(String resultNamePattern) {
        this.resultNamePattern = resultNamePattern;
    }

    @XMLInfo(elementType="element", elementName="StatusNamePattern", elementOrder=5, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="status-name-pattern", refType="", isEnumeration=false, javaName="statusNamePattern", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="$1.status", displayOrder=0, displayValue="Status file-naming pattern", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getStatusNamePattern() {
        return this.statusNamePattern;
    }

    @XMLInfo(elementType="element", elementName="StatusNamePattern", elementOrder=5, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="status-name-pattern", refType="", isEnumeration=false, javaName="statusNamePattern", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="$1.status", displayValue="Status file-naming pattern", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setStatusNamePattern(String statusNamePattern) {
        this.statusNamePattern = statusNamePattern;
    }

    @XMLInfo(elementType="element", elementName="Watch", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="watch", refType="", isEnumeration=true, javaName="watch", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Watch", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getWatch() {
        return this.watch;
    }

    @XMLInfo(elementType="element", elementName="Watch", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="watch", refType="", isEnumeration=true, javaName="watch", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Watch", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setWatch(String watch) {
        if (watch == null || Comparison.isIn(watch, DPEnumerations.TOGGLE)) {
            this.watch = watch;
        }
    }

    @XMLInfo(elementType="element", elementName="UseOutputLocation", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-output-location", refType="", isEnumeration=true, javaName="useOutputLocation", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Use output location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUseOutputLocation() {
        return this.useOutputLocation;
    }

    @XMLInfo(elementType="element", elementName="UseOutputLocation", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-output-location", refType="", isEnumeration=true, javaName="useOutputLocation", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Use output location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUseOutputLocation(String useOutputLocation) {
        if (useOutputLocation == null || Comparison.isIn(useOutputLocation, DPEnumerations.TOGGLE)) {
            this.useOutputLocation = useOutputLocation;
        }
    }

    @XMLInfo(elementType="element", elementName="OutputLocation", elementOrder=8, dataPowerType="dmFSDirectory", subType="", benign=false, isPassword=false, cliAlias="output-location", refType="", isEnumeration=false, javaName="outputLocation", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="logtemp:///", displayOrder=0, displayValue="Output file location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOutputLocation() {
        return this.outputLocation;
    }

    @XMLInfo(elementType="element", elementName="OutputLocation", elementOrder=8, dataPowerType="dmFSDirectory", subType="", benign=false, isPassword=false, cliAlias="output-location", refType="", isEnumeration=false, javaName="outputLocation", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="logtemp:///", displayValue="Output file location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOutputLocation(String outputLocation) {
        this.outputLocation = outputLocation;
    }

    @XMLInfo(elementType="element", elementName="DeleteUnused", elementOrder=9, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="delete-unused", refType="", isEnumeration=true, javaName="deleteUnused", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Delete unused", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDeleteUnused() {
        return this.deleteUnused;
    }

    @XMLInfo(elementType="element", elementName="DeleteUnused", elementOrder=9, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="delete-unused", refType="", isEnumeration=true, javaName="deleteUnused", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Delete unused", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDeleteUnused(String deleteUnused) {
        if (deleteUnused == null || Comparison.isIn(deleteUnused, DPEnumerations.TOGGLE)) {
            this.deleteUnused = deleteUnused;
        }
    }

    @XMLInfo(elementType="element", elementName="RunSequenceInterval", elementOrder=10, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="run-sequence-interval", refType="", isEnumeration=false, javaName="runSequenceInterval", javaType="long", isRequired=false, squelchNull=false, minimum=100, maximum=60000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="100", displayOrder=0, displayValue="Run interval", units="ms", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getRunSequenceInterval() {
        return this.runSequenceInterval;
    }

    @XMLInfo(elementType="element", elementName="RunSequenceInterval", elementOrder=10, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="run-sequence-interval", refType="", isEnumeration=false, javaName="runSequenceInterval", javaType="long", isRequired=false, squelchNull=false, minimum=100, maximum=60000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="100", displayValue="Run interval", units="ms", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRunSequenceInterval(long runSequenceInterval) {
        this.runSequenceInterval = runSequenceInterval;
    }

    @XMLInfo(elementType="element", elementName="Capabilities", elementOrder=11, dataPowerType="dmConfigSequenceCapabilities", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="capabilities", javaType="ConfigSequenceCapabilities", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Capabilities", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ConfigSequenceCapabilities getCapabilities() {
        return this.capabilities;
    }

    @XMLInfo(elementType="element", elementName="Capabilities", elementOrder=11, dataPowerType="dmConfigSequenceCapabilities", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="capabilities", javaType="ConfigSequenceCapabilities", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Capabilities", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCapabilities(ConfigSequenceCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public int compareTo(ConfigConfigSequence that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "locations", "matchPattern", "resultNamePattern", "statusNamePattern", "watch", "useOutputLocation", "outputLocation", "deleteUnused", "runSequenceInterval", "capabilities");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.locations, this.matchPattern, this.resultNamePattern, this.statusNamePattern, this.watch, this.useOutputLocation, this.outputLocation, this.deleteUnused, this.runSequenceInterval, this.capabilities);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "locations", "matchPattern", "resultNamePattern", "statusNamePattern", "watch", "useOutputLocation", "outputLocation", "deleteUnused", "runSequenceInterval", "capabilities");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "locations", "matchPattern", "resultNamePattern", "statusNamePattern", "watch", "useOutputLocation", "outputLocation", "deleteUnused", "runSequenceInterval", "capabilities"));
    }
}

