/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.config.ConfigMessageMonitor;
import com.kumbasoft.core.beans.types.CountMonitorFilter;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigCountMonitor
extends ConfigMessageMonitor {
    private String measure;
    private String source;
    private String header;
    private ArrayList<CountMonitorFilter> filter;
    private long maxSources;

    @XMLInfo(elementType="element", elementName="Measure", elementOrder=3, dataPowerType="dmCountMonitorType", subType="", benign=false, isPassword=false, cliAlias="measure", refType="", isEnumeration=true, javaName="measure", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="requests", displayOrder=0, displayValue="Measure", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMeasure() {
        return this.measure;
    }

    @XMLInfo(elementType="element", elementName="Measure", elementOrder=3, dataPowerType="dmCountMonitorType", subType="", benign=false, isPassword=false, cliAlias="measure", refType="", isEnumeration=true, javaName="measure", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="requests", displayValue="Measure", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMeasure(String measure) {
        if (Comparison.isIn(measure, DPEnumerations.COUNT_MONITOR_TYPE)) {
            this.measure = measure;
        }
    }

    @XMLInfo(elementType="element", elementName="Source", elementOrder=4, dataPowerType="dmCountMonitorSource", subType="", benign=false, isPassword=false, cliAlias="source", refType="", isEnumeration=true, javaName="source", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="all", displayOrder=0, displayValue="Source", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSource() {
        return this.source;
    }

    @XMLInfo(elementType="element", elementName="Source", elementOrder=4, dataPowerType="dmCountMonitorSource", subType="", benign=false, isPassword=false, cliAlias="source", refType="", isEnumeration=true, javaName="source", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="all", displayValue="Source", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSource(String source) {
        if (Comparison.isIn(source, DPEnumerations.COUNT_MONITOR_SOURCE)) {
            this.source = source;
        }
    }

    @XMLInfo(elementType="element", elementName="Header", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="header", refType="", isEnumeration=false, javaName="header", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="X-Client-IP", displayOrder=0, displayValue="Header", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHeader() {
        return this.header;
    }

    @XMLInfo(elementType="element", elementName="Header", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="header", refType="", isEnumeration=false, javaName="header", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="X-Client-IP", displayValue="Header", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHeader(String header) {
        this.header = header;
    }

    public void addFilter(CountMonitorFilter element) {
        if (element == null) {
            return;
        }
        if (this.filter == null) {
            this.filter = new ArrayList();
        }
        this.filter.add(element);
    }

    public boolean removeFilter(CountMonitorFilter element) {
        if (element == null || this.filter == null) {
            return false;
        }
        return this.filter.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Filter", elementOrder=6, dataPowerType="dmCountMonitorFilter", subType="", benign=false, isPassword=false, cliAlias="filter", refType="", isEnumeration=false, javaName="filter", javaType="CountMonitorFilter", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Thresholds/Filters", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<CountMonitorFilter> getFilter() {
        return this.filter;
    }

    @XMLInfo(elementType="element", elementName="Filter", elementOrder=6, dataPowerType="dmCountMonitorFilter", subType="", benign=false, isPassword=false, cliAlias="filter", refType="", isEnumeration=false, javaName="filter", javaType="CountMonitorFilter", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Thresholds/Filters", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFilter(ArrayList<CountMonitorFilter> filter) {
        this.filter = filter;
    }

    @XMLInfo(elementType="element", elementName="MaxSources", elementOrder=7, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="distinct-sources", refType="", isEnumeration=false, javaName="maxSources", javaType="long", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="10000", displayOrder=0, displayValue="Maximum Distinct Sources", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxSources() {
        return this.maxSources;
    }

    @XMLInfo(elementType="element", elementName="MaxSources", elementOrder=7, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="distinct-sources", refType="", isEnumeration=false, javaName="maxSources", javaType="long", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="10000", displayValue="Maximum Distinct Sources", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxSources(long maxSources) {
        this.maxSources = maxSources;
    }

    @Override
    public int compareTo(ConfigCountMonitor that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "measure", "source", "header", "filter", "maxSources");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.measure, this.source, this.header, this.filter, this.maxSources);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "measure", "source", "header", "filter", "maxSources");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("measure", "source", "header", "filter", "maxSources"));
    }
}

