/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAccessControl;
import com.kumbasoft.core.beans.config.ConfigAccessProfile;
import com.kumbasoft.core.beans.config.ConfigConfigDeploymentPolicy;
import com.kumbasoft.core.beans.config.ConfigDeploymentPolicyParametersBinding;
import com.kumbasoft.core.beans.config.ConfigUser;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.DomainFileMap;
import com.kumbasoft.core.beans.types.DomainMonitoringMap;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigDomain
extends ConfigAccessControl {
    private String userSummary;
    private String configDir;
    private ArrayList<ObjectReference<ConfigDomain>> neighborDomain;
    private ArrayList<ObjectReference<ConfigUser>> domainUser;
    private DomainFileMap fileMap;
    private DomainMonitoringMap monitoringMap;
    private String configMode;
    private String importURL;
    private String importFormat;
    private ObjectReference<ConfigConfigDeploymentPolicy> deploymentPolicy;
    private ObjectReference<ConfigDeploymentPolicyParametersBinding> deploymentPolicyParameters;
    private String localIPRewrite;
    private long maxChkpoints;
    private String configPermissionsMode;
    private ObjectReference<ConfigAccessProfile> configPermissionsProfile;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="ConfigDir", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="configDir", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="config:///", displayOrder=0, displayValue="Configuration directory", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getConfigDir() {
        return this.configDir;
    }

    @XMLInfo(elementType="element", elementName="ConfigDir", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="configDir", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="config:///", displayValue="Configuration directory", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setConfigDir(String configDir) {
        this.configDir = configDir;
    }

    public void addNeighborDomain(ObjectReference<ConfigDomain> element) {
        if (element == null) {
            return;
        }
        if (this.neighborDomain == null) {
            this.neighborDomain = new ArrayList();
        }
        this.neighborDomain.add(element);
    }

    public boolean removeNeighborDomain(ObjectReference<ConfigDomain> element) {
        if (element == null || this.neighborDomain == null) {
            return false;
        }
        return this.neighborDomain.remove(element);
    }

    @XMLInfo(elementType="element", elementName="NeighborDomain", elementOrder=3, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="visible-domain", refType="Domain", isEnumeration=false, javaName="neighborDomain", javaType="ObjectReference<ConfigDomain>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="default", displayOrder=0, displayValue="Visible domains", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference<ConfigDomain>> getNeighborDomain() {
        return this.neighborDomain;
    }

    @XMLInfo(elementType="element", elementName="NeighborDomain", elementOrder=3, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="visible-domain", refType="Domain", isEnumeration=false, javaName="neighborDomain", javaType="ObjectReference<ConfigDomain>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="default", displayValue="Visible domains", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setNeighborDomain(ArrayList<ObjectReference<ConfigDomain>> neighborDomain) {
        this.neighborDomain = neighborDomain;
    }

    public void addDomainUser(ObjectReference<ConfigUser> element) {
        if (element == null) {
            return;
        }
        if (this.domainUser == null) {
            this.domainUser = new ArrayList();
        }
        this.domainUser.add(element);
    }

    public boolean removeDomainUser(ObjectReference<ConfigUser> element) {
        if (element == null || this.domainUser == null) {
            return false;
        }
        return this.domainUser.remove(element);
    }

    @XMLInfo(elementType="element", elementName="DomainUser", elementOrder=4, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="domain-user", refType="User", isEnumeration=false, javaName="domainUser", javaType="ObjectReference<ConfigUser>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="CLI user access", units="", label="", multiplicity=0x7FFFFFFF, status="obsolete", isDeprecated=true, deprecatedIn="3.7.1.0", isObsolete=true, obsoletedIn="3.7.1.0")
    public ArrayList<ObjectReference<ConfigUser>> getDomainUser() {
        return this.domainUser;
    }

    @XMLInfo(elementType="element", elementName="DomainUser", elementOrder=4, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="domain-user", refType="User", isEnumeration=false, javaName="domainUser", javaType="ObjectReference<ConfigUser>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="CLI user access", units="", label="", multiplicity=0x7FFFFFFF, status="obsolete", isDeprecated=true, deprecatedIn="3.7.1.0", isObsolete=true, obsoletedIn="3.7.1.0")
    public void setDomainUser(ArrayList<ObjectReference<ConfigUser>> domainUser) {
        this.domainUser = domainUser;
    }

    @XMLInfo(elementType="element", elementName="FileMap", elementOrder=5, dataPowerType="dmDomainFileMap", subType="", benign=false, isPassword=false, cliAlias="file-permissions", refType="", isEnumeration=false, javaName="fileMap", javaType="DomainFileMap", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="File permission to the local: directory", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public DomainFileMap getFileMap() {
        return this.fileMap;
    }

    @XMLInfo(elementType="element", elementName="FileMap", elementOrder=5, dataPowerType="dmDomainFileMap", subType="", benign=false, isPassword=false, cliAlias="file-permissions", refType="", isEnumeration=false, javaName="fileMap", javaType="DomainFileMap", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="File permission to the local: directory", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFileMap(DomainFileMap fileMap) {
        this.fileMap = fileMap;
    }

    @XMLInfo(elementType="element", elementName="MonitoringMap", elementOrder=6, dataPowerType="dmDomainMonitoringMap", subType="", benign=false, isPassword=false, cliAlias="file-monitoring", refType="", isEnumeration=false, javaName="monitoringMap", javaType="DomainMonitoringMap", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="File-monitoring of the local: directory", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public DomainMonitoringMap getMonitoringMap() {
        return this.monitoringMap;
    }

    @XMLInfo(elementType="element", elementName="MonitoringMap", elementOrder=6, dataPowerType="dmDomainMonitoringMap", subType="", benign=false, isPassword=false, cliAlias="file-monitoring", refType="", isEnumeration=false, javaName="monitoringMap", javaType="DomainMonitoringMap", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="File-monitoring of the local: directory", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMonitoringMap(DomainMonitoringMap monitoringMap) {
        this.monitoringMap = monitoringMap;
    }

    @XMLInfo(elementType="element", elementName="ConfigMode", elementOrder=7, dataPowerType="dmDomainConfigMode", subType="", benign=false, isPassword=false, cliAlias="config-mode", refType="", isEnumeration=true, javaName="configMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="local", displayOrder=0, displayValue="Configuration mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getConfigMode() {
        return this.configMode;
    }

    @XMLInfo(elementType="element", elementName="ConfigMode", elementOrder=7, dataPowerType="dmDomainConfigMode", subType="", benign=false, isPassword=false, cliAlias="config-mode", refType="", isEnumeration=true, javaName="configMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="local", displayValue="Configuration mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setConfigMode(String configMode) {
        if (configMode == null || Comparison.isIn(configMode, DPEnumerations.DOMAIN_CONFIG_MODE)) {
            this.configMode = configMode;
        }
    }

    @XMLInfo(elementType="element", elementName="ImportURL", elementOrder=8, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="import-url", refType="", isEnumeration=false, javaName="importURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Import URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getImportURL() {
        return this.importURL;
    }

    @XMLInfo(elementType="element", elementName="ImportURL", elementOrder=8, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="import-url", refType="", isEnumeration=false, javaName="importURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Import URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setImportURL(String importURL) {
        this.importURL = importURL;
    }

    @XMLInfo(elementType="element", elementName="ImportFormat", elementOrder=9, dataPowerType="dmImportFormat", subType="", benign=false, isPassword=false, cliAlias="import-format", refType="", isEnumeration=true, javaName="importFormat", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="ZIP", displayOrder=0, displayValue="Import format", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getImportFormat() {
        return this.importFormat;
    }

    @XMLInfo(elementType="element", elementName="ImportFormat", elementOrder=9, dataPowerType="dmImportFormat", subType="", benign=false, isPassword=false, cliAlias="import-format", refType="", isEnumeration=true, javaName="importFormat", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="ZIP", displayValue="Import format", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setImportFormat(String importFormat) {
        if (importFormat == null || Comparison.isIn(importFormat, DPEnumerations.IMPORT_FORMAT)) {
            this.importFormat = importFormat;
        }
    }

    @XMLInfo(elementType="element", elementName="DeploymentPolicy", elementOrder=10, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="deployment-policy", refType="ConfigDeploymentPolicy", isEnumeration=false, javaName="deploymentPolicy", javaType="ObjectReference<ConfigConfigDeploymentPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Deployment policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigConfigDeploymentPolicy> getDeploymentPolicy() {
        return this.deploymentPolicy;
    }

    @XMLInfo(elementType="element", elementName="DeploymentPolicy", elementOrder=10, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="deployment-policy", refType="ConfigDeploymentPolicy", isEnumeration=false, javaName="deploymentPolicy", javaType="ObjectReference<ConfigConfigDeploymentPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Deployment policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDeploymentPolicy(ObjectReference<ConfigConfigDeploymentPolicy> deploymentPolicy) {
        this.deploymentPolicy = deploymentPolicy;
    }

    @XMLInfo(elementType="element", elementName="DeploymentPolicyParameters", elementOrder=11, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="deployment-policy-variables", refType="DeploymentPolicyParametersBinding", isEnumeration=false, javaName="deploymentPolicyParameters", javaType="ObjectReference<ConfigDeploymentPolicyParametersBinding>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Deployment policy variables", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigDeploymentPolicyParametersBinding> getDeploymentPolicyParameters() {
        return this.deploymentPolicyParameters;
    }

    @XMLInfo(elementType="element", elementName="DeploymentPolicyParameters", elementOrder=11, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="deployment-policy-variables", refType="DeploymentPolicyParametersBinding", isEnumeration=false, javaName="deploymentPolicyParameters", javaType="ObjectReference<ConfigDeploymentPolicyParametersBinding>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Deployment policy variables", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDeploymentPolicyParameters(ObjectReference<ConfigDeploymentPolicyParametersBinding> deploymentPolicyParameters) {
        this.deploymentPolicyParameters = deploymentPolicyParameters;
    }

    @XMLInfo(elementType="element", elementName="LocalIPRewrite", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="local-ip-rewrite", refType="", isEnumeration=true, javaName="localIPRewrite", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Rewrite local IP addresses", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLocalIPRewrite() {
        return this.localIPRewrite;
    }

    @XMLInfo(elementType="element", elementName="LocalIPRewrite", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="local-ip-rewrite", refType="", isEnumeration=true, javaName="localIPRewrite", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Rewrite local IP addresses", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalIPRewrite(String localIPRewrite) {
        if (localIPRewrite == null || Comparison.isIn(localIPRewrite, DPEnumerations.TOGGLE)) {
            this.localIPRewrite = localIPRewrite;
        }
    }

    @XMLInfo(elementType="element", elementName="MaxChkpoints", elementOrder=13, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="maxchkpoints", refType="", isEnumeration=false, javaName="maxChkpoints", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=5L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="3", displayOrder=0, displayValue="Checkpoint limit", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxChkpoints() {
        return this.maxChkpoints;
    }

    @XMLInfo(elementType="element", elementName="MaxChkpoints", elementOrder=13, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="maxchkpoints", refType="", isEnumeration=false, javaName="maxChkpoints", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=5L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="3", displayValue="Checkpoint limit", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxChkpoints(long maxChkpoints) {
        this.maxChkpoints = maxChkpoints;
    }

    @XMLInfo(elementType="element", elementName="ConfigPermissionsMode", elementOrder=14, dataPowerType="dmDomainConfigPermissionsMode", subType="", benign=false, isPassword=false, cliAlias="config-permissions-mode", refType="", isEnumeration=true, javaName="configPermissionsMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="scope-domain", displayOrder=0, displayValue="Configuration permission mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getConfigPermissionsMode() {
        return this.configPermissionsMode;
    }

    @XMLInfo(elementType="element", elementName="ConfigPermissionsMode", elementOrder=14, dataPowerType="dmDomainConfigPermissionsMode", subType="", benign=false, isPassword=false, cliAlias="config-permissions-mode", refType="", isEnumeration=true, javaName="configPermissionsMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="scope-domain", displayValue="Configuration permission mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setConfigPermissionsMode(String configPermissionsMode) {
        if (configPermissionsMode == null || Comparison.isIn(configPermissionsMode, DPEnumerations.DOMAIN_CONFIG_PERMISSIONS_MODE)) {
            this.configPermissionsMode = configPermissionsMode;
        }
    }

    @XMLInfo(elementType="element", elementName="ConfigPermissionsProfile", elementOrder=15, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="config-permissions-profile", refType="AccessProfile", isEnumeration=false, javaName="configPermissionsProfile", javaType="ObjectReference<ConfigAccessProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Global permission profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAccessProfile> getConfigPermissionsProfile() {
        return this.configPermissionsProfile;
    }

    @XMLInfo(elementType="element", elementName="ConfigPermissionsProfile", elementOrder=15, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="config-permissions-profile", refType="AccessProfile", isEnumeration=false, javaName="configPermissionsProfile", javaType="ObjectReference<ConfigAccessProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Global permission profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setConfigPermissionsProfile(ObjectReference<ConfigAccessProfile> configPermissionsProfile) {
        this.configPermissionsProfile = configPermissionsProfile;
    }

    @Override
    public int compareTo(ConfigDomain that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "configDir", "neighborDomain", "domainUser", "fileMap", "monitoringMap", "configMode", "importURL", "importFormat", "deploymentPolicy", "deploymentPolicyParameters", "localIPRewrite", "maxChkpoints", "configPermissionsMode", "configPermissionsProfile");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.configDir, this.neighborDomain, this.domainUser, this.fileMap, this.monitoringMap, this.configMode, this.importURL, this.importFormat, this.deploymentPolicy, this.deploymentPolicyParameters, this.localIPRewrite, this.maxChkpoints, this.configPermissionsMode, this.configPermissionsProfile);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "configDir", "neighborDomain", "domainUser", "fileMap", "monitoringMap", "configMode", "importURL", "importFormat", "deploymentPolicy", "deploymentPolicyParameters", "localIPRewrite", "maxChkpoints", "configPermissionsMode", "configPermissionsProfile");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "configDir", "neighborDomain", "domainUser", "fileMap", "monitoringMap", "configMode", "importURL", "importFormat", "deploymentPolicy", "deploymentPolicyParameters", "localIPRewrite", "maxChkpoints", "configPermissionsMode", "configPermissionsProfile"));
    }
}

