/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigCryptoIdentCred;
import com.kumbasoft.core.beans.config.ConfigCryptoValCred;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.GatewayPeeringGroupClusterNode;
import com.kumbasoft.core.beans.types.GatewayPeeringGroupPeerNode;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigGatewayPeeringGroup
extends ConfigConfigBase {
    private String userSummary;
    private String mode;
    private ArrayList<GatewayPeeringGroupPeerNode> peerNodes;
    private String clusterPrimaryCount;
    private ArrayList<GatewayPeeringGroupClusterNode> clusterNodes;
    private String clusterAutoConfig;
    private String enableSSL;
    private ObjectReference<ConfigCryptoIdentCred> idcred;
    private ObjectReference<ConfigCryptoValCred> valcred;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Mode", elementOrder=2, dataPowerType="dmGatewayPeeringGroupMode", subType="", benign=false, isPassword=false, cliAlias="mode", refType="", isEnumeration=true, javaName="mode", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="peer", displayOrder=0, displayValue="Mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMode() {
        return this.mode;
    }

    @XMLInfo(elementType="element", elementName="Mode", elementOrder=2, dataPowerType="dmGatewayPeeringGroupMode", subType="", benign=false, isPassword=false, cliAlias="mode", refType="", isEnumeration=true, javaName="mode", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="peer", displayValue="Mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMode(String mode) {
        if (Comparison.isIn(mode, DPEnumerations.GATEWAY_PEERING_GROUP_MODE)) {
            this.mode = mode;
        }
    }

    public void addPeerNodes(GatewayPeeringGroupPeerNode element) {
        if (element == null) {
            return;
        }
        if (this.peerNodes == null) {
            this.peerNodes = new ArrayList();
        }
        this.peerNodes.add(element);
    }

    public boolean removePeerNodes(GatewayPeeringGroupPeerNode element) {
        if (element == null || this.peerNodes == null) {
            return false;
        }
        return this.peerNodes.remove(element);
    }

    @XMLInfo(elementType="element", elementName="PeerNodes", elementOrder=3, dataPowerType="dmGatewayPeeringGroupPeerNode", subType="", benign=false, isPassword=false, cliAlias="peer-node", refType="", isEnumeration=false, javaName="peerNodes", javaType="GatewayPeeringGroupPeerNode", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Peers", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<GatewayPeeringGroupPeerNode> getPeerNodes() {
        return this.peerNodes;
    }

    @XMLInfo(elementType="element", elementName="PeerNodes", elementOrder=3, dataPowerType="dmGatewayPeeringGroupPeerNode", subType="", benign=false, isPassword=false, cliAlias="peer-node", refType="", isEnumeration=false, javaName="peerNodes", javaType="GatewayPeeringGroupPeerNode", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Peers", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPeerNodes(ArrayList<GatewayPeeringGroupPeerNode> peerNodes) {
        this.peerNodes = peerNodes;
    }

    @XMLInfo(elementType="element", elementName="ClusterPrimaryCount", elementOrder=4, dataPowerType="dmGatewayPeeringGroupClusterPrimaryCount", subType="", benign=false, isPassword=false, cliAlias="cluster-primary-count", refType="", isEnumeration=true, javaName="clusterPrimaryCount", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="3", displayOrder=0, displayValue="Primary count", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getClusterPrimaryCount() {
        return this.clusterPrimaryCount;
    }

    @XMLInfo(elementType="element", elementName="ClusterPrimaryCount", elementOrder=4, dataPowerType="dmGatewayPeeringGroupClusterPrimaryCount", subType="", benign=false, isPassword=false, cliAlias="cluster-primary-count", refType="", isEnumeration=true, javaName="clusterPrimaryCount", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="3", displayValue="Primary count", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setClusterPrimaryCount(String clusterPrimaryCount) {
        if (clusterPrimaryCount == null || Comparison.isIn(clusterPrimaryCount, DPEnumerations.GATEWAY_PEERING_GROUP_CLUSTER_PRIMARY_COUNT)) {
            this.clusterPrimaryCount = clusterPrimaryCount;
        }
    }

    public void addClusterNodes(GatewayPeeringGroupClusterNode element) {
        if (element == null) {
            return;
        }
        if (this.clusterNodes == null) {
            this.clusterNodes = new ArrayList();
        }
        this.clusterNodes.add(element);
    }

    public boolean removeClusterNodes(GatewayPeeringGroupClusterNode element) {
        if (element == null || this.clusterNodes == null) {
            return false;
        }
        return this.clusterNodes.remove(element);
    }

    @XMLInfo(elementType="element", elementName="ClusterNodes", elementOrder=5, dataPowerType="dmGatewayPeeringGroupClusterNode", subType="", benign=false, isPassword=false, cliAlias="cluster-node", refType="", isEnumeration=false, javaName="clusterNodes", javaType="GatewayPeeringGroupClusterNode", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Cluster nodes", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<GatewayPeeringGroupClusterNode> getClusterNodes() {
        return this.clusterNodes;
    }

    @XMLInfo(elementType="element", elementName="ClusterNodes", elementOrder=5, dataPowerType="dmGatewayPeeringGroupClusterNode", subType="", benign=false, isPassword=false, cliAlias="cluster-node", refType="", isEnumeration=false, javaName="clusterNodes", javaType="GatewayPeeringGroupClusterNode", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Cluster nodes", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setClusterNodes(ArrayList<GatewayPeeringGroupClusterNode> clusterNodes) {
        this.clusterNodes = clusterNodes;
    }

    @XMLInfo(elementType="element", elementName="ClusterAutoConfig", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="cluster-auto-config", refType="", isEnumeration=true, javaName="clusterAutoConfig", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Auto manage cluster configuration", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getClusterAutoConfig() {
        return this.clusterAutoConfig;
    }

    @XMLInfo(elementType="element", elementName="ClusterAutoConfig", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="cluster-auto-config", refType="", isEnumeration=true, javaName="clusterAutoConfig", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Auto manage cluster configuration", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setClusterAutoConfig(String clusterAutoConfig) {
        if (clusterAutoConfig == null || Comparison.isIn(clusterAutoConfig, DPEnumerations.TOGGLE)) {
            this.clusterAutoConfig = clusterAutoConfig;
        }
    }

    @XMLInfo(elementType="element", elementName="EnableSSL", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enable-ssl", refType="", isEnumeration=true, javaName="enableSSL", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Enable TLS", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnableSSL() {
        return this.enableSSL;
    }

    @XMLInfo(elementType="element", elementName="EnableSSL", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enable-ssl", refType="", isEnumeration=true, javaName="enableSSL", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Enable TLS", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnableSSL(String enableSSL) {
        if (Comparison.isIn(enableSSL, DPEnumerations.TOGGLE)) {
            this.enableSSL = enableSSL;
        }
    }

    @XMLInfo(elementType="element", elementName="Idcred", elementOrder=8, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="idcred", refType="CryptoIdentCred", isEnumeration=false, javaName="idcred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoIdentCred> getIdcred() {
        return this.idcred;
    }

    @XMLInfo(elementType="element", elementName="Idcred", elementOrder=8, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="idcred", refType="CryptoIdentCred", isEnumeration=false, javaName="idcred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setIdcred(ObjectReference<ConfigCryptoIdentCred> idcred) {
        this.idcred = idcred;
    }

    @XMLInfo(elementType="element", elementName="Valcred", elementOrder=9, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="valcred", refType="CryptoValCred", isEnumeration=false, javaName="valcred", javaType="ObjectReference<ConfigCryptoValCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Validation credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoValCred> getValcred() {
        return this.valcred;
    }

    @XMLInfo(elementType="element", elementName="Valcred", elementOrder=9, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="valcred", refType="CryptoValCred", isEnumeration=false, javaName="valcred", javaType="ObjectReference<ConfigCryptoValCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Validation credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setValcred(ObjectReference<ConfigCryptoValCred> valcred) {
        this.valcred = valcred;
    }

    @Override
    public int compareTo(ConfigGatewayPeeringGroup that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "mode", "peerNodes", "clusterPrimaryCount", "clusterNodes", "clusterAutoConfig", "enableSSL", "idcred", "valcred");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.mode, this.peerNodes, this.clusterPrimaryCount, this.clusterNodes, this.clusterAutoConfig, this.enableSSL, this.idcred, this.valcred);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "mode", "peerNodes", "clusterPrimaryCount", "clusterNodes", "clusterAutoConfig", "enableSSL", "idcred", "valcred");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "mode", "peerNodes", "clusterPrimaryCount", "clusterNodes", "clusterAutoConfig", "enableSSL", "idcred", "valcred"));
    }
}

