/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigCryptoValCred;
import com.kumbasoft.core.beans.config.ConfigJSONSettings;
import com.kumbasoft.core.beans.config.ConfigPasswordAlias;
import com.kumbasoft.core.beans.config.ConfigSSHClientProfile;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.GitOpsTemplatePolicy;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigGitOps
extends ConfigConfigBase {
    private String userSummary;
    private String connectionType;
    private String mode;
    private String commitIdentifierType;
    private String commitIdentifier;
    private String remoteLocation;
    private long interval;
    private ObjectReference<ConfigSSHClientProfile> sSHClientProfile;
    private String username;
    private ObjectReference<ConfigPasswordAlias> password;
    private String sSHAuthorizedKeysFile;
    private ObjectReference<ConfigCryptoValCred> tLSValcred;
    private String gitUser;
    private String gitEmail;
    private ObjectReference<ConfigJSONSettings> jSONParseSettings;
    private ArrayList<GitOpsTemplatePolicy> templatePolicies;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="ConnectionType", elementOrder=2, dataPowerType="dmGitOpsConnectionType", subType="", benign=false, isPassword=false, cliAlias="type", refType="", isEnumeration=true, javaName="connectionType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="https", displayOrder=0, displayValue="Connection type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getConnectionType() {
        return this.connectionType;
    }

    @XMLInfo(elementType="element", elementName="ConnectionType", elementOrder=2, dataPowerType="dmGitOpsConnectionType", subType="", benign=false, isPassword=false, cliAlias="type", refType="", isEnumeration=true, javaName="connectionType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="https", displayValue="Connection type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setConnectionType(String connectionType) {
        if (Comparison.isIn(connectionType, DPEnumerations.GIT_OPS_CONNECTION_TYPE)) {
            this.connectionType = connectionType;
        }
    }

    @XMLInfo(elementType="element", elementName="Mode", elementOrder=3, dataPowerType="dmGitOpsMode", subType="", benign=false, isPassword=false, cliAlias="mode", refType="", isEnumeration=true, javaName="mode", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="read-write", displayOrder=0, displayValue="Operation mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMode() {
        return this.mode;
    }

    @XMLInfo(elementType="element", elementName="Mode", elementOrder=3, dataPowerType="dmGitOpsMode", subType="", benign=false, isPassword=false, cliAlias="mode", refType="", isEnumeration=true, javaName="mode", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="read-write", displayValue="Operation mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMode(String mode) {
        if (Comparison.isIn(mode, DPEnumerations.GIT_OPS_MODE)) {
            this.mode = mode;
        }
    }

    @XMLInfo(elementType="element", elementName="CommitIdentifierType", elementOrder=4, dataPowerType="dmGitOpsCommitIdentifierType", subType="", benign=false, isPassword=false, cliAlias="commit-id-type", refType="", isEnumeration=true, javaName="commitIdentifierType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="branch", displayOrder=0, displayValue="Commit identifier type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCommitIdentifierType() {
        return this.commitIdentifierType;
    }

    @XMLInfo(elementType="element", elementName="CommitIdentifierType", elementOrder=4, dataPowerType="dmGitOpsCommitIdentifierType", subType="", benign=false, isPassword=false, cliAlias="commit-id-type", refType="", isEnumeration=true, javaName="commitIdentifierType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="branch", displayValue="Commit identifier type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCommitIdentifierType(String commitIdentifierType) {
        if (Comparison.isIn(commitIdentifierType, DPEnumerations.GIT_OPS_COMMIT_IDENTIFIER_TYPE)) {
            this.commitIdentifierType = commitIdentifierType;
        }
    }

    @XMLInfo(elementType="element", elementName="CommitIdentifier", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="commit-id", refType="", isEnumeration=false, javaName="commitIdentifier", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Commit identifier", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCommitIdentifier() {
        return this.commitIdentifier;
    }

    @XMLInfo(elementType="element", elementName="CommitIdentifier", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="commit-id", refType="", isEnumeration=false, javaName="commitIdentifier", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Commit identifier", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCommitIdentifier(String commitIdentifier) {
        this.commitIdentifier = commitIdentifier;
    }

    @XMLInfo(elementType="element", elementName="RemoteLocation", elementOrder=6, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="location", refType="", isEnumeration=false, javaName="remoteLocation", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Remote location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRemoteLocation() {
        return this.remoteLocation;
    }

    @XMLInfo(elementType="element", elementName="RemoteLocation", elementOrder=6, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="location", refType="", isEnumeration=false, javaName="remoteLocation", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Remote location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRemoteLocation(String remoteLocation) {
        this.remoteLocation = remoteLocation;
    }

    @XMLInfo(elementType="element", elementName="Interval", elementOrder=7, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="interval", refType="", isEnumeration=false, javaName="interval", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=1440L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="5", displayOrder=0, displayValue="Sync Interval", units="Minutes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getInterval() {
        return this.interval;
    }

    @XMLInfo(elementType="element", elementName="Interval", elementOrder=7, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="interval", refType="", isEnumeration=false, javaName="interval", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=1440L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="5", displayValue="Sync Interval", units="Minutes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setInterval(long interval) {
        this.interval = interval;
    }

    @XMLInfo(elementType="element", elementName="SSHClientProfile", elementOrder=8, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssh-client-profile", refType="SSHClientProfile", isEnumeration=false, javaName="sSHClientProfile", javaType="ObjectReference<ConfigSSHClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="SSH client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSHClientProfile> getSSHClientProfile() {
        return this.sSHClientProfile;
    }

    @XMLInfo(elementType="element", elementName="SSHClientProfile", elementOrder=8, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssh-client-profile", refType="SSHClientProfile", isEnumeration=false, javaName="sSHClientProfile", javaType="ObjectReference<ConfigSSHClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="SSH client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSHClientProfile(ObjectReference<ConfigSSHClientProfile> sSHClientProfile) {
        this.sSHClientProfile = sSHClientProfile;
    }

    @XMLInfo(elementType="element", elementName="Username", elementOrder=9, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="username", refType="", isEnumeration=false, javaName="username", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUsername() {
        return this.username;
    }

    @XMLInfo(elementType="element", elementName="Username", elementOrder=9, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="username", refType="", isEnumeration=false, javaName="username", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUsername(String username) {
        this.username = username;
    }

    @XMLInfo(elementType="element", elementName="Password", elementOrder=10, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password", refType="PasswordAlias", isEnumeration=false, javaName="password", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Password", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getPassword() {
        return this.password;
    }

    @XMLInfo(elementType="element", elementName="Password", elementOrder=10, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password", refType="PasswordAlias", isEnumeration=false, javaName="password", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Password", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPassword(ObjectReference<ConfigPasswordAlias> password) {
        this.password = password;
    }

    @XMLInfo(elementType="element", elementName="SSHAuthorizedKeysFile", elementOrder=11, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="ssh-authorized-keyfile", refType="", isEnumeration=false, javaName="sSHAuthorizedKeysFile", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="SSH authorized key file", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSSHAuthorizedKeysFile() {
        return this.sSHAuthorizedKeysFile;
    }

    @XMLInfo(elementType="element", elementName="SSHAuthorizedKeysFile", elementOrder=11, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="ssh-authorized-keyfile", refType="", isEnumeration=false, javaName="sSHAuthorizedKeysFile", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="SSH authorized key file", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSHAuthorizedKeysFile(String sSHAuthorizedKeysFile) {
        this.sSHAuthorizedKeysFile = sSHAuthorizedKeysFile;
    }

    @XMLInfo(elementType="element", elementName="TLSValcred", elementOrder=12, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="https-valcred", refType="CryptoValCred", isEnumeration=false, javaName="tLSValcred", javaType="ObjectReference<ConfigCryptoValCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="HTTPS validation credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoValCred> getTLSValcred() {
        return this.tLSValcred;
    }

    @XMLInfo(elementType="element", elementName="TLSValcred", elementOrder=12, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="https-valcred", refType="CryptoValCred", isEnumeration=false, javaName="tLSValcred", javaType="ObjectReference<ConfigCryptoValCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="HTTPS validation credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTLSValcred(ObjectReference<ConfigCryptoValCred> tLSValcred) {
        this.tLSValcred = tLSValcred;
    }

    @XMLInfo(elementType="element", elementName="GitUser", elementOrder=13, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="name", refType="", isEnumeration=false, javaName="gitUser", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Git user", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getGitUser() {
        return this.gitUser;
    }

    @XMLInfo(elementType="element", elementName="GitUser", elementOrder=13, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="name", refType="", isEnumeration=false, javaName="gitUser", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Git user", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setGitUser(String gitUser) {
        this.gitUser = gitUser;
    }

    @XMLInfo(elementType="element", elementName="GitEmail", elementOrder=14, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="email", refType="", isEnumeration=false, javaName="gitEmail", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Git email", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getGitEmail() {
        return this.gitEmail;
    }

    @XMLInfo(elementType="element", elementName="GitEmail", elementOrder=14, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="email", refType="", isEnumeration=false, javaName="gitEmail", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Git email", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setGitEmail(String gitEmail) {
        this.gitEmail = gitEmail;
    }

    @XMLInfo(elementType="element", elementName="JSONParseSettings", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="json-settings", refType="JSONSettings", isEnumeration=false, javaName="jSONParseSettings", javaType="ObjectReference<ConfigJSONSettings>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="JSON parse settings", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigJSONSettings> getJSONParseSettings() {
        return this.jSONParseSettings;
    }

    @XMLInfo(elementType="element", elementName="JSONParseSettings", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="json-settings", refType="JSONSettings", isEnumeration=false, javaName="jSONParseSettings", javaType="ObjectReference<ConfigJSONSettings>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="JSON parse settings", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setJSONParseSettings(ObjectReference<ConfigJSONSettings> jSONParseSettings) {
        this.jSONParseSettings = jSONParseSettings;
    }

    public void addTemplatePolicies(GitOpsTemplatePolicy element) {
        if (element == null) {
            return;
        }
        if (this.templatePolicies == null) {
            this.templatePolicies = new ArrayList();
        }
        this.templatePolicies.add(element);
    }

    public boolean removeTemplatePolicies(GitOpsTemplatePolicy element) {
        if (element == null || this.templatePolicies == null) {
            return false;
        }
        return this.templatePolicies.remove(element);
    }

    @XMLInfo(elementType="element", elementName="TemplatePolicies", elementOrder=16, dataPowerType="dmGitOpsTemplatePolicy", subType="", benign=false, isPassword=false, cliAlias="template-policy", refType="", isEnumeration=false, javaName="templatePolicies", javaType="GitOpsTemplatePolicy", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Template policies", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<GitOpsTemplatePolicy> getTemplatePolicies() {
        return this.templatePolicies;
    }

    @XMLInfo(elementType="element", elementName="TemplatePolicies", elementOrder=16, dataPowerType="dmGitOpsTemplatePolicy", subType="", benign=false, isPassword=false, cliAlias="template-policy", refType="", isEnumeration=false, javaName="templatePolicies", javaType="GitOpsTemplatePolicy", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Template policies", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTemplatePolicies(ArrayList<GitOpsTemplatePolicy> templatePolicies) {
        this.templatePolicies = templatePolicies;
    }

    @Override
    public int compareTo(ConfigGitOps that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "connectionType", "mode", "commitIdentifierType", "commitIdentifier", "remoteLocation", "interval", "sSHClientProfile", "username", "password", "sSHAuthorizedKeysFile", "tLSValcred", "gitUser", "gitEmail", "jSONParseSettings", "templatePolicies");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.connectionType, this.mode, this.commitIdentifierType, this.commitIdentifier, this.remoteLocation, this.interval, this.sSHClientProfile, this.username, this.password, this.sSHAuthorizedKeysFile, this.tLSValcred, this.gitUser, this.gitEmail, this.jSONParseSettings, this.templatePolicies);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "connectionType", "mode", "commitIdentifierType", "commitIdentifier", "remoteLocation", "interval", "sSHClientProfile", "username", "password", "sSHAuthorizedKeysFile", "tLSValcred", "gitUser", "gitEmail", "jSONParseSettings", "templatePolicies");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "connectionType", "mode", "commitIdentifierType", "commitIdentifier", "remoteLocation", "interval", "sSHClientProfile", "username", "password", "sSHAuthorizedKeysFile", "tLSValcred", "gitUser", "gitEmail", "jSONParseSettings", "templatePolicies"));
    }
}

