/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAccessControlList;
import com.kumbasoft.core.beans.config.ConfigCountMonitor;
import com.kumbasoft.core.beans.config.ConfigDurationMonitor;
import com.kumbasoft.core.beans.config.ConfigService;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.HTTPClientServerVersion;
import com.kumbasoft.core.beans.types.HeaderInjection;
import com.kumbasoft.core.beans.types.HeaderSuppression;
import com.kumbasoft.core.beans.types.MSDebugTriggerType;
import com.kumbasoft.core.beans.types.StylesheetParameter;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigHTTPProxyService
extends ConfigService {
    private String userSummary;
    private String priority;
    private int localPort;
    private String remoteAddress;
    private int remotePort;
    private ObjectReference<ConfigAccessControlList> aCL;
    private long hTTPTimeout;
    private long hTTPPersistTimeout;
    private String doHostRewrite;
    private String suppressHTTPWarnings;
    private String hTTPCompression;
    private String hTTPIncludeResponseTypeEncoding;
    private String alwaysShowErrors;
    private String disallowGet;
    private String disallowEmptyResponse;
    private String hTTPPersistentConnections;
    private String hTTPClientIPLabel;
    private String hTTPLogCorIDLabel;
    private String hTTPProxyHost;
    private int hTTPProxyPort;
    private HTTPClientServerVersion hTTPVersion;
    private String doChunkedUpload;
    private ArrayList<HeaderInjection> headerInjection;
    private ArrayList<HeaderSuppression> headerSuppression;
    private ArrayList<StylesheetParameter> stylesheetParameters;
    private String defaultParamNamespace;
    private String queryParamNamespace;
    private String forcePolicyExec;
    private ArrayList<ObjectReference<ConfigCountMonitor>> countMonitors;
    private ArrayList<ObjectReference<ConfigDurationMonitor>> durationMonitors;
    private String monitorProcessingPolicy;
    private String debugMode;
    private long debugHistory;
    private ArrayList<MSDebugTriggerType> debugTrigger;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Priority", elementOrder=3, dataPowerType="dmSchedulerPriority", subType="", benign=false, isPassword=false, cliAlias="priority", refType="", isEnumeration=true, javaName="priority", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="normal", displayOrder=0, displayValue="Service Priority", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPriority() {
        return this.priority;
    }

    @XMLInfo(elementType="element", elementName="Priority", elementOrder=3, dataPowerType="dmSchedulerPriority", subType="", benign=false, isPassword=false, cliAlias="priority", refType="", isEnumeration=true, javaName="priority", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="normal", displayValue="Service Priority", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPriority(String priority) {
        if (priority == null || Comparison.isIn(priority, DPEnumerations.SCHEDULER_PRIORITY)) {
            this.priority = priority;
        }
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=4, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Port Number", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLocalPort() {
        return this.localPort;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=4, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Port Number", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    @XMLInfo(elementType="element", elementName="RemoteAddress", elementOrder=5, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="remote-ip-address", refType="", isEnumeration=false, javaName="remoteAddress", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Remote Host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @XMLInfo(elementType="element", elementName="RemoteAddress", elementOrder=5, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="remote-ip-address", refType="", isEnumeration=false, javaName="remoteAddress", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Remote Host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @XMLInfo(elementType="element", elementName="RemotePort", elementOrder=6, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="remote-port", refType="", isEnumeration=false, javaName="remotePort", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Remote Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getRemotePort() {
        return this.remotePort;
    }

    @XMLInfo(elementType="element", elementName="RemotePort", elementOrder=6, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="remote-port", refType="", isEnumeration=false, javaName="remotePort", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Remote Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    @XMLInfo(elementType="element", elementName="ACL", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="acl", refType="AccessControlList", isEnumeration=false, javaName="aCL", javaType="ObjectReference<ConfigAccessControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Access Control List", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAccessControlList> getACL() {
        return this.aCL;
    }

    @XMLInfo(elementType="element", elementName="ACL", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="acl", refType="AccessControlList", isEnumeration=false, javaName="aCL", javaType="ObjectReference<ConfigAccessControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Access Control List", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setACL(ObjectReference<ConfigAccessControlList> aCL) {
        this.aCL = aCL;
    }

    @XMLInfo(elementType="element", elementName="HTTPTimeout", elementOrder=8, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="http-timeout", refType="", isEnumeration=false, javaName="hTTPTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="120", displayOrder=0, displayValue="HTTP Timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getHTTPTimeout() {
        return this.hTTPTimeout;
    }

    @XMLInfo(elementType="element", elementName="HTTPTimeout", elementOrder=8, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="http-timeout", refType="", isEnumeration=false, javaName="hTTPTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="120", displayValue="HTTP Timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHTTPTimeout(long hTTPTimeout) {
        this.hTTPTimeout = hTTPTimeout;
    }

    @XMLInfo(elementType="element", elementName="HTTPPersistTimeout", elementOrder=9, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="persistent-timeout", refType="", isEnumeration=false, javaName="hTTPPersistTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=7200L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="180", displayOrder=0, displayValue="HTTP Persistent Timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getHTTPPersistTimeout() {
        return this.hTTPPersistTimeout;
    }

    @XMLInfo(elementType="element", elementName="HTTPPersistTimeout", elementOrder=9, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="persistent-timeout", refType="", isEnumeration=false, javaName="hTTPPersistTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=7200L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="180", displayValue="HTTP Persistent Timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHTTPPersistTimeout(long hTTPPersistTimeout) {
        this.hTTPPersistTimeout = hTTPPersistTimeout;
    }

    @XMLInfo(elementType="element", elementName="DoHostRewrite", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="host-rewriting", refType="", isEnumeration=true, javaName="doHostRewrite", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Host Rewrite", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDoHostRewrite() {
        return this.doHostRewrite;
    }

    @XMLInfo(elementType="element", elementName="DoHostRewrite", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="host-rewriting", refType="", isEnumeration=true, javaName="doHostRewrite", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Host Rewrite", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDoHostRewrite(String doHostRewrite) {
        if (doHostRewrite == null || Comparison.isIn(doHostRewrite, DPEnumerations.TOGGLE)) {
            this.doHostRewrite = doHostRewrite;
        }
    }

    @XMLInfo(elementType="element", elementName="SuppressHTTPWarnings", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="silence-warning", refType="", isEnumeration=true, javaName="suppressHTTPWarnings", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="HTTP Warning Suppression", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSuppressHTTPWarnings() {
        return this.suppressHTTPWarnings;
    }

    @XMLInfo(elementType="element", elementName="SuppressHTTPWarnings", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="silence-warning", refType="", isEnumeration=true, javaName="suppressHTTPWarnings", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="HTTP Warning Suppression", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSuppressHTTPWarnings(String suppressHTTPWarnings) {
        if (suppressHTTPWarnings == null || Comparison.isIn(suppressHTTPWarnings, DPEnumerations.TOGGLE)) {
            this.suppressHTTPWarnings = suppressHTTPWarnings;
        }
    }

    @XMLInfo(elementType="element", elementName="HTTPCompression", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="compression", refType="", isEnumeration=true, javaName="hTTPCompression", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="HTTP Compression", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHTTPCompression() {
        return this.hTTPCompression;
    }

    @XMLInfo(elementType="element", elementName="HTTPCompression", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="compression", refType="", isEnumeration=true, javaName="hTTPCompression", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="HTTP Compression", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHTTPCompression(String hTTPCompression) {
        if (hTTPCompression == null || Comparison.isIn(hTTPCompression, DPEnumerations.TOGGLE)) {
            this.hTTPCompression = hTTPCompression;
        }
    }

    @XMLInfo(elementType="element", elementName="HTTPIncludeResponseTypeEncoding", elementOrder=13, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="include-response-type-encoding", refType="", isEnumeration=true, javaName="hTTPIncludeResponseTypeEncoding", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="HTTP Include charset in response-type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHTTPIncludeResponseTypeEncoding() {
        return this.hTTPIncludeResponseTypeEncoding;
    }

    @XMLInfo(elementType="element", elementName="HTTPIncludeResponseTypeEncoding", elementOrder=13, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="include-response-type-encoding", refType="", isEnumeration=true, javaName="hTTPIncludeResponseTypeEncoding", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="HTTP Include charset in response-type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHTTPIncludeResponseTypeEncoding(String hTTPIncludeResponseTypeEncoding) {
        if (hTTPIncludeResponseTypeEncoding == null || Comparison.isIn(hTTPIncludeResponseTypeEncoding, DPEnumerations.TOGGLE)) {
            this.hTTPIncludeResponseTypeEncoding = hTTPIncludeResponseTypeEncoding;
        }
    }

    @XMLInfo(elementType="element", elementName="AlwaysShowErrors", elementOrder=14, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="always-show-errors", refType="", isEnumeration=true, javaName="alwaysShowErrors", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Always provide full errors", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAlwaysShowErrors() {
        return this.alwaysShowErrors;
    }

    @XMLInfo(elementType="element", elementName="AlwaysShowErrors", elementOrder=14, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="always-show-errors", refType="", isEnumeration=true, javaName="alwaysShowErrors", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Always provide full errors", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAlwaysShowErrors(String alwaysShowErrors) {
        if (alwaysShowErrors == null || Comparison.isIn(alwaysShowErrors, DPEnumerations.TOGGLE)) {
            this.alwaysShowErrors = alwaysShowErrors;
        }
    }

    @XMLInfo(elementType="element", elementName="DisallowGet", elementOrder=15, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="disallow-get", refType="", isEnumeration=true, javaName="disallowGet", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Disallow GET (and HEAD)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDisallowGet() {
        return this.disallowGet;
    }

    @XMLInfo(elementType="element", elementName="DisallowGet", elementOrder=15, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="disallow-get", refType="", isEnumeration=true, javaName="disallowGet", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Disallow GET (and HEAD)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDisallowGet(String disallowGet) {
        if (disallowGet == null || Comparison.isIn(disallowGet, DPEnumerations.TOGGLE)) {
            this.disallowGet = disallowGet;
        }
    }

    @XMLInfo(elementType="element", elementName="DisallowEmptyResponse", elementOrder=16, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="disallow-empty-reply", refType="", isEnumeration=true, javaName="disallowEmptyResponse", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Don't allow empty response bodies", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDisallowEmptyResponse() {
        return this.disallowEmptyResponse;
    }

    @XMLInfo(elementType="element", elementName="DisallowEmptyResponse", elementOrder=16, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="disallow-empty-reply", refType="", isEnumeration=true, javaName="disallowEmptyResponse", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Don't allow empty response bodies", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDisallowEmptyResponse(String disallowEmptyResponse) {
        if (disallowEmptyResponse == null || Comparison.isIn(disallowEmptyResponse, DPEnumerations.TOGGLE)) {
            this.disallowEmptyResponse = disallowEmptyResponse;
        }
    }

    @XMLInfo(elementType="element", elementName="HTTPPersistentConnections", elementOrder=17, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="persistent-connections", refType="", isEnumeration=true, javaName="hTTPPersistentConnections", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="HTTP Persistent Connections", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHTTPPersistentConnections() {
        return this.hTTPPersistentConnections;
    }

    @XMLInfo(elementType="element", elementName="HTTPPersistentConnections", elementOrder=17, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="persistent-connections", refType="", isEnumeration=true, javaName="hTTPPersistentConnections", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="HTTP Persistent Connections", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHTTPPersistentConnections(String hTTPPersistentConnections) {
        if (hTTPPersistentConnections == null || Comparison.isIn(hTTPPersistentConnections, DPEnumerations.TOGGLE)) {
            this.hTTPPersistentConnections = hTTPPersistentConnections;
        }
    }

    @XMLInfo(elementType="element", elementName="HTTPClientIPLabel", elementOrder=18, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="client-address", refType="", isEnumeration=false, javaName="hTTPClientIPLabel", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="X-Client-IP", displayOrder=0, displayValue="HTTP Client IP Label", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHTTPClientIPLabel() {
        return this.hTTPClientIPLabel;
    }

    @XMLInfo(elementType="element", elementName="HTTPClientIPLabel", elementOrder=18, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="client-address", refType="", isEnumeration=false, javaName="hTTPClientIPLabel", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="X-Client-IP", displayValue="HTTP Client IP Label", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHTTPClientIPLabel(String hTTPClientIPLabel) {
        this.hTTPClientIPLabel = hTTPClientIPLabel;
    }

    @XMLInfo(elementType="element", elementName="HTTPLogCorIDLabel", elementOrder=19, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="http-global-tranID-label", refType="", isEnumeration=false, javaName="hTTPLogCorIDLabel", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="X-Global-Transaction-ID", displayOrder=0, displayValue="HTTP Global Transaction ID Label", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHTTPLogCorIDLabel() {
        return this.hTTPLogCorIDLabel;
    }

    @XMLInfo(elementType="element", elementName="HTTPLogCorIDLabel", elementOrder=19, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="http-global-tranID-label", refType="", isEnumeration=false, javaName="hTTPLogCorIDLabel", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="X-Global-Transaction-ID", displayValue="HTTP Global Transaction ID Label", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHTTPLogCorIDLabel(String hTTPLogCorIDLabel) {
        this.hTTPLogCorIDLabel = hTTPLogCorIDLabel;
    }

    @XMLInfo(elementType="element", elementName="HTTPProxyHost", elementOrder=20, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="httpproxy-address", refType="", isEnumeration=false, javaName="hTTPProxyHost", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Proxy Host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHTTPProxyHost() {
        return this.hTTPProxyHost;
    }

    @XMLInfo(elementType="element", elementName="HTTPProxyHost", elementOrder=20, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="httpproxy-address", refType="", isEnumeration=false, javaName="hTTPProxyHost", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Proxy Host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHTTPProxyHost(String hTTPProxyHost) {
        this.hTTPProxyHost = hTTPProxyHost;
    }

    @XMLInfo(elementType="element", elementName="HTTPProxyPort", elementOrder=21, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="httpproxy-port", refType="", isEnumeration=false, javaName="hTTPProxyPort", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="800", displayOrder=0, displayValue="Proxy Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getHTTPProxyPort() {
        return this.hTTPProxyPort;
    }

    @XMLInfo(elementType="element", elementName="HTTPProxyPort", elementOrder=21, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="httpproxy-port", refType="", isEnumeration=false, javaName="hTTPProxyPort", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="800", displayValue="Proxy Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHTTPProxyPort(int hTTPProxyPort) {
        this.hTTPProxyPort = hTTPProxyPort;
    }

    @XMLInfo(elementType="element", elementName="HTTPVersion", elementOrder=22, dataPowerType="dmHTTPClientServerVersion", subType="", benign=false, isPassword=false, cliAlias="version", refType="", isEnumeration=false, javaName="hTTPVersion", javaType="HTTPClientServerVersion", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="HTTP Version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public HTTPClientServerVersion getHTTPVersion() {
        return this.hTTPVersion;
    }

    @XMLInfo(elementType="element", elementName="HTTPVersion", elementOrder=22, dataPowerType="dmHTTPClientServerVersion", subType="", benign=false, isPassword=false, cliAlias="version", refType="", isEnumeration=false, javaName="hTTPVersion", javaType="HTTPClientServerVersion", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="HTTP Version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHTTPVersion(HTTPClientServerVersion hTTPVersion) {
        this.hTTPVersion = hTTPVersion;
    }

    @XMLInfo(elementType="element", elementName="DoChunkedUpload", elementOrder=23, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="chunked-uploads", refType="", isEnumeration=true, javaName="doChunkedUpload", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Allow Chunked Uploads", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDoChunkedUpload() {
        return this.doChunkedUpload;
    }

    @XMLInfo(elementType="element", elementName="DoChunkedUpload", elementOrder=23, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="chunked-uploads", refType="", isEnumeration=true, javaName="doChunkedUpload", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Allow Chunked Uploads", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDoChunkedUpload(String doChunkedUpload) {
        if (doChunkedUpload == null || Comparison.isIn(doChunkedUpload, DPEnumerations.TOGGLE)) {
            this.doChunkedUpload = doChunkedUpload;
        }
    }

    public void addHeaderInjection(HeaderInjection element) {
        if (element == null) {
            return;
        }
        if (this.headerInjection == null) {
            this.headerInjection = new ArrayList();
        }
        this.headerInjection.add(element);
    }

    public boolean removeHeaderInjection(HeaderInjection element) {
        if (element == null || this.headerInjection == null) {
            return false;
        }
        return this.headerInjection.remove(element);
    }

    @XMLInfo(elementType="element", elementName="HeaderInjection", elementOrder=24, dataPowerType="dmHeaderInjection", subType="", benign=false, isPassword=false, cliAlias="inject", refType="", isEnumeration=false, javaName="headerInjection", javaType="HeaderInjection", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="HTTP Header Injection", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<HeaderInjection> getHeaderInjection() {
        return this.headerInjection;
    }

    @XMLInfo(elementType="element", elementName="HeaderInjection", elementOrder=24, dataPowerType="dmHeaderInjection", subType="", benign=false, isPassword=false, cliAlias="inject", refType="", isEnumeration=false, javaName="headerInjection", javaType="HeaderInjection", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="HTTP Header Injection", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHeaderInjection(ArrayList<HeaderInjection> headerInjection) {
        this.headerInjection = headerInjection;
    }

    public void addHeaderSuppression(HeaderSuppression element) {
        if (element == null) {
            return;
        }
        if (this.headerSuppression == null) {
            this.headerSuppression = new ArrayList();
        }
        this.headerSuppression.add(element);
    }

    public boolean removeHeaderSuppression(HeaderSuppression element) {
        if (element == null || this.headerSuppression == null) {
            return false;
        }
        return this.headerSuppression.remove(element);
    }

    @XMLInfo(elementType="element", elementName="HeaderSuppression", elementOrder=25, dataPowerType="dmHeaderSuppression", subType="", benign=false, isPassword=false, cliAlias="suppress", refType="", isEnumeration=false, javaName="headerSuppression", javaType="HeaderSuppression", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="HTTP Header Suppression", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<HeaderSuppression> getHeaderSuppression() {
        return this.headerSuppression;
    }

    @XMLInfo(elementType="element", elementName="HeaderSuppression", elementOrder=25, dataPowerType="dmHeaderSuppression", subType="", benign=false, isPassword=false, cliAlias="suppress", refType="", isEnumeration=false, javaName="headerSuppression", javaType="HeaderSuppression", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="HTTP Header Suppression", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHeaderSuppression(ArrayList<HeaderSuppression> headerSuppression) {
        this.headerSuppression = headerSuppression;
    }

    public void addStylesheetParameters(StylesheetParameter element) {
        if (element == null) {
            return;
        }
        if (this.stylesheetParameters == null) {
            this.stylesheetParameters = new ArrayList();
        }
        this.stylesheetParameters.add(element);
    }

    public boolean removeStylesheetParameters(StylesheetParameter element) {
        if (element == null || this.stylesheetParameters == null) {
            return false;
        }
        return this.stylesheetParameters.remove(element);
    }

    @XMLInfo(elementType="element", elementName="StylesheetParameters", elementOrder=26, dataPowerType="dmStylesheetParameter", subType="", benign=false, isPassword=false, cliAlias="parameter", refType="", isEnumeration=false, javaName="stylesheetParameters", javaType="StylesheetParameter", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Stylesheet Parameter", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<StylesheetParameter> getStylesheetParameters() {
        return this.stylesheetParameters;
    }

    @XMLInfo(elementType="element", elementName="StylesheetParameters", elementOrder=26, dataPowerType="dmStylesheetParameter", subType="", benign=false, isPassword=false, cliAlias="parameter", refType="", isEnumeration=false, javaName="stylesheetParameters", javaType="StylesheetParameter", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Stylesheet Parameter", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setStylesheetParameters(ArrayList<StylesheetParameter> stylesheetParameters) {
        this.stylesheetParameters = stylesheetParameters;
    }

    @XMLInfo(elementType="element", elementName="DefaultParamNamespace", elementOrder=27, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="default-param-namespace", refType="", isEnumeration=false, javaName="defaultParamNamespace", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="http://www.datapower.com/param/config", displayOrder=0, displayValue="Default parameter namespace", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDefaultParamNamespace() {
        return this.defaultParamNamespace;
    }

    @XMLInfo(elementType="element", elementName="DefaultParamNamespace", elementOrder=27, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="default-param-namespace", refType="", isEnumeration=false, javaName="defaultParamNamespace", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="http://www.datapower.com/param/config", displayValue="Default parameter namespace", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDefaultParamNamespace(String defaultParamNamespace) {
        this.defaultParamNamespace = defaultParamNamespace;
    }

    @XMLInfo(elementType="element", elementName="QueryParamNamespace", elementOrder=28, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="query-param-namespace", refType="", isEnumeration=false, javaName="queryParamNamespace", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="http://www.datapower.com/param/query", displayOrder=0, displayValue="Query parameter namespace", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getQueryParamNamespace() {
        return this.queryParamNamespace;
    }

    @XMLInfo(elementType="element", elementName="QueryParamNamespace", elementOrder=28, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="query-param-namespace", refType="", isEnumeration=false, javaName="queryParamNamespace", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="http://www.datapower.com/param/query", displayValue="Query parameter namespace", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setQueryParamNamespace(String queryParamNamespace) {
        this.queryParamNamespace = queryParamNamespace;
    }

    @XMLInfo(elementType="element", elementName="ForcePolicyExec", elementOrder=29, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="force-policy-exec", refType="", isEnumeration=true, javaName="forcePolicyExec", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Process Messages Whose Body Is Empty", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getForcePolicyExec() {
        return this.forcePolicyExec;
    }

    @XMLInfo(elementType="element", elementName="ForcePolicyExec", elementOrder=29, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="force-policy-exec", refType="", isEnumeration=true, javaName="forcePolicyExec", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Process Messages Whose Body Is Empty", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setForcePolicyExec(String forcePolicyExec) {
        if (forcePolicyExec == null || Comparison.isIn(forcePolicyExec, DPEnumerations.TOGGLE)) {
            this.forcePolicyExec = forcePolicyExec;
        }
    }

    public void addCountMonitors(ObjectReference<ConfigCountMonitor> element) {
        if (element == null) {
            return;
        }
        if (this.countMonitors == null) {
            this.countMonitors = new ArrayList();
        }
        this.countMonitors.add(element);
    }

    public boolean removeCountMonitors(ObjectReference<ConfigCountMonitor> element) {
        if (element == null || this.countMonitors == null) {
            return false;
        }
        return this.countMonitors.remove(element);
    }

    @XMLInfo(elementType="element", elementName="CountMonitors", elementOrder=30, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="monitor-count", refType="CountMonitor", isEnumeration=false, javaName="countMonitors", javaType="ObjectReference<ConfigCountMonitor>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Count Monitors", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference<ConfigCountMonitor>> getCountMonitors() {
        return this.countMonitors;
    }

    @XMLInfo(elementType="element", elementName="CountMonitors", elementOrder=30, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="monitor-count", refType="CountMonitor", isEnumeration=false, javaName="countMonitors", javaType="ObjectReference<ConfigCountMonitor>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Count Monitors", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCountMonitors(ArrayList<ObjectReference<ConfigCountMonitor>> countMonitors) {
        this.countMonitors = countMonitors;
    }

    public void addDurationMonitors(ObjectReference<ConfigDurationMonitor> element) {
        if (element == null) {
            return;
        }
        if (this.durationMonitors == null) {
            this.durationMonitors = new ArrayList();
        }
        this.durationMonitors.add(element);
    }

    public boolean removeDurationMonitors(ObjectReference<ConfigDurationMonitor> element) {
        if (element == null || this.durationMonitors == null) {
            return false;
        }
        return this.durationMonitors.remove(element);
    }

    @XMLInfo(elementType="element", elementName="DurationMonitors", elementOrder=31, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="monitor-duration", refType="DurationMonitor", isEnumeration=false, javaName="durationMonitors", javaType="ObjectReference<ConfigDurationMonitor>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Duration Monitors", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference<ConfigDurationMonitor>> getDurationMonitors() {
        return this.durationMonitors;
    }

    @XMLInfo(elementType="element", elementName="DurationMonitors", elementOrder=31, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="monitor-duration", refType="DurationMonitor", isEnumeration=false, javaName="durationMonitors", javaType="ObjectReference<ConfigDurationMonitor>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Duration Monitors", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDurationMonitors(ArrayList<ObjectReference<ConfigDurationMonitor>> durationMonitors) {
        this.durationMonitors = durationMonitors;
    }

    @XMLInfo(elementType="element", elementName="MonitorProcessingPolicy", elementOrder=32, dataPowerType="dmMonitorProcessingPolicy", subType="", benign=false, isPassword=false, cliAlias="monitor-processing-policy", refType="", isEnumeration=true, javaName="monitorProcessingPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="terminate-at-first-throttle", displayOrder=0, displayValue="Monitors evaluation method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMonitorProcessingPolicy() {
        return this.monitorProcessingPolicy;
    }

    @XMLInfo(elementType="element", elementName="MonitorProcessingPolicy", elementOrder=32, dataPowerType="dmMonitorProcessingPolicy", subType="", benign=false, isPassword=false, cliAlias="monitor-processing-policy", refType="", isEnumeration=true, javaName="monitorProcessingPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="terminate-at-first-throttle", displayValue="Monitors evaluation method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMonitorProcessingPolicy(String monitorProcessingPolicy) {
        if (monitorProcessingPolicy == null || Comparison.isIn(monitorProcessingPolicy, DPEnumerations.MONITOR_PROCESSING_POLICY)) {
            this.monitorProcessingPolicy = monitorProcessingPolicy;
        }
    }

    @XMLInfo(elementType="element", elementName="DebugMode", elementOrder=33, dataPowerType="dmDebugMode", subType="", benign=false, isPassword=false, cliAlias="debug-mode", refType="", isEnumeration=true, javaName="debugMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Probe setting", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDebugMode() {
        return this.debugMode;
    }

    @XMLInfo(elementType="element", elementName="DebugMode", elementOrder=33, dataPowerType="dmDebugMode", subType="", benign=false, isPassword=false, cliAlias="debug-mode", refType="", isEnumeration=true, javaName="debugMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Probe setting", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDebugMode(String debugMode) {
        if (debugMode == null || Comparison.isIn(debugMode, DPEnumerations.DEBUG_MODE)) {
            this.debugMode = debugMode;
        }
    }

    @XMLInfo(elementType="element", elementName="DebugHistory", elementOrder=34, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="debug-history", refType="", isEnumeration=false, javaName="debugHistory", javaType="long", isRequired=false, squelchNull=false, minimum=10, maximum=250L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="25", displayOrder=0, displayValue="Transaction History", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getDebugHistory() {
        return this.debugHistory;
    }

    @XMLInfo(elementType="element", elementName="DebugHistory", elementOrder=34, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="debug-history", refType="", isEnumeration=false, javaName="debugHistory", javaType="long", isRequired=false, squelchNull=false, minimum=10, maximum=250L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="25", displayValue="Transaction History", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDebugHistory(long debugHistory) {
        this.debugHistory = debugHistory;
    }

    public void addDebugTrigger(MSDebugTriggerType element) {
        if (element == null) {
            return;
        }
        if (this.debugTrigger == null) {
            this.debugTrigger = new ArrayList();
        }
        this.debugTrigger.add(element);
    }

    public boolean removeDebugTrigger(MSDebugTriggerType element) {
        if (element == null || this.debugTrigger == null) {
            return false;
        }
        return this.debugTrigger.remove(element);
    }

    @XMLInfo(elementType="element", elementName="DebugTrigger", elementOrder=35, dataPowerType="dmMSDebugTriggerType", subType="", benign=false, isPassword=false, cliAlias="debug-trigger", refType="", isEnumeration=false, javaName="debugTrigger", javaType="MSDebugTriggerType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Probe Triggers", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<MSDebugTriggerType> getDebugTrigger() {
        return this.debugTrigger;
    }

    @XMLInfo(elementType="element", elementName="DebugTrigger", elementOrder=35, dataPowerType="dmMSDebugTriggerType", subType="", benign=false, isPassword=false, cliAlias="debug-trigger", refType="", isEnumeration=false, javaName="debugTrigger", javaType="MSDebugTriggerType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Probe Triggers", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDebugTrigger(ArrayList<MSDebugTriggerType> debugTrigger) {
        this.debugTrigger = debugTrigger;
    }

    @Override
    public int compareTo(ConfigHTTPProxyService that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "priority", "localPort", "remoteAddress", "remotePort", "aCL", "hTTPTimeout", "hTTPPersistTimeout", "doHostRewrite", "suppressHTTPWarnings", "hTTPCompression", "hTTPIncludeResponseTypeEncoding", "alwaysShowErrors", "disallowGet", "disallowEmptyResponse", "hTTPPersistentConnections", "hTTPClientIPLabel", "hTTPLogCorIDLabel", "hTTPProxyHost", "hTTPProxyPort", "hTTPVersion", "doChunkedUpload", "headerInjection", "headerSuppression", "stylesheetParameters", "defaultParamNamespace", "queryParamNamespace", "forcePolicyExec", "countMonitors", "durationMonitors", "monitorProcessingPolicy", "debugMode", "debugHistory", "debugTrigger");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.priority, this.localPort, this.remoteAddress, this.remotePort, this.aCL, this.hTTPTimeout, this.hTTPPersistTimeout, this.doHostRewrite, this.suppressHTTPWarnings, this.hTTPCompression, this.hTTPIncludeResponseTypeEncoding, this.alwaysShowErrors, this.disallowGet, this.disallowEmptyResponse, this.hTTPPersistentConnections, this.hTTPClientIPLabel, this.hTTPLogCorIDLabel, this.hTTPProxyHost, this.hTTPProxyPort, this.hTTPVersion, this.doChunkedUpload, this.headerInjection, this.headerSuppression, this.stylesheetParameters, this.defaultParamNamespace, this.queryParamNamespace, this.forcePolicyExec, this.countMonitors, this.durationMonitors, this.monitorProcessingPolicy, this.debugMode, this.debugHistory, this.debugTrigger);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "priority", "localPort", "remoteAddress", "remotePort", "aCL", "hTTPTimeout", "hTTPPersistTimeout", "doHostRewrite", "suppressHTTPWarnings", "hTTPCompression", "hTTPIncludeResponseTypeEncoding", "alwaysShowErrors", "disallowGet", "disallowEmptyResponse", "hTTPPersistentConnections", "hTTPClientIPLabel", "hTTPLogCorIDLabel", "hTTPProxyHost", "hTTPProxyPort", "hTTPVersion", "doChunkedUpload", "headerInjection", "headerSuppression", "stylesheetParameters", "defaultParamNamespace", "queryParamNamespace", "forcePolicyExec", "countMonitors", "durationMonitors", "monitorProcessingPolicy", "debugMode", "debugHistory", "debugTrigger");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "priority", "localPort", "remoteAddress", "remotePort", "aCL", "hTTPTimeout", "hTTPPersistTimeout", "doHostRewrite", "suppressHTTPWarnings", "hTTPCompression", "hTTPIncludeResponseTypeEncoding", "alwaysShowErrors", "disallowGet", "disallowEmptyResponse", "hTTPPersistentConnections", "hTTPClientIPLabel", "hTTPLogCorIDLabel", "hTTPProxyHost", "hTTPProxyPort", "hTTPVersion", "doChunkedUpload", "headerInjection", "headerSuppression", "stylesheetParameters", "defaultParamNamespace", "queryParamNamespace", "forcePolicyExec", "countMonitors", "durationMonitors", "monitorProcessingPolicy", "debugMode", "debugHistory", "debugTrigger"));
    }
}

