/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigCrypto;
import com.kumbasoft.core.beans.config.ConfigJWERecipient;
import com.kumbasoft.core.beans.types.JOSEHeader;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigJWEHeader
extends ConfigCrypto {
    private String userSummary;
    private ArrayList<JOSEHeader> jWEProtectedHeader;
    private ArrayList<JOSEHeader> jWESharedUnprotectedHeader;
    private ObjectReference<ConfigJWERecipient> recipient;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    public void addJWEProtectedHeader(JOSEHeader element) {
        if (element == null) {
            return;
        }
        if (this.jWEProtectedHeader == null) {
            this.jWEProtectedHeader = new ArrayList();
        }
        this.jWEProtectedHeader.add(element);
    }

    public boolean removeJWEProtectedHeader(JOSEHeader element) {
        if (element == null || this.jWEProtectedHeader == null) {
            return false;
        }
        return this.jWEProtectedHeader.remove(element);
    }

    @XMLInfo(elementType="element", elementName="JWEProtectedHeader", elementOrder=2, dataPowerType="dmJOSEHeader", subType="", benign=false, isPassword=false, cliAlias="protected-header", refType="", isEnumeration=false, javaName="jWEProtectedHeader", javaType="JOSEHeader", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Protected Header", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<JOSEHeader> getJWEProtectedHeader() {
        return this.jWEProtectedHeader;
    }

    @XMLInfo(elementType="element", elementName="JWEProtectedHeader", elementOrder=2, dataPowerType="dmJOSEHeader", subType="", benign=false, isPassword=false, cliAlias="protected-header", refType="", isEnumeration=false, javaName="jWEProtectedHeader", javaType="JOSEHeader", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Protected Header", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setJWEProtectedHeader(ArrayList<JOSEHeader> jWEProtectedHeader) {
        this.jWEProtectedHeader = jWEProtectedHeader;
    }

    public void addJWESharedUnprotectedHeader(JOSEHeader element) {
        if (element == null) {
            return;
        }
        if (this.jWESharedUnprotectedHeader == null) {
            this.jWESharedUnprotectedHeader = new ArrayList();
        }
        this.jWESharedUnprotectedHeader.add(element);
    }

    public boolean removeJWESharedUnprotectedHeader(JOSEHeader element) {
        if (element == null || this.jWESharedUnprotectedHeader == null) {
            return false;
        }
        return this.jWESharedUnprotectedHeader.remove(element);
    }

    @XMLInfo(elementType="element", elementName="JWESharedUnprotectedHeader", elementOrder=3, dataPowerType="dmJOSEHeader", subType="", benign=false, isPassword=false, cliAlias="shared-unprotected-header", refType="", isEnumeration=false, javaName="jWESharedUnprotectedHeader", javaType="JOSEHeader", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Shared Unprotected Header", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<JOSEHeader> getJWESharedUnprotectedHeader() {
        return this.jWESharedUnprotectedHeader;
    }

    @XMLInfo(elementType="element", elementName="JWESharedUnprotectedHeader", elementOrder=3, dataPowerType="dmJOSEHeader", subType="", benign=false, isPassword=false, cliAlias="shared-unprotected-header", refType="", isEnumeration=false, javaName="jWESharedUnprotectedHeader", javaType="JOSEHeader", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Shared Unprotected Header", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setJWESharedUnprotectedHeader(ArrayList<JOSEHeader> jWESharedUnprotectedHeader) {
        this.jWESharedUnprotectedHeader = jWESharedUnprotectedHeader;
    }

    @XMLInfo(elementType="element", elementName="Recipient", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="recipient", refType="JWERecipient", isEnumeration=false, javaName="recipient", javaType="ObjectReference<ConfigJWERecipient>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Recipient", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigJWERecipient> getRecipient() {
        return this.recipient;
    }

    @XMLInfo(elementType="element", elementName="Recipient", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="recipient", refType="JWERecipient", isEnumeration=false, javaName="recipient", javaType="ObjectReference<ConfigJWERecipient>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Recipient", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRecipient(ObjectReference<ConfigJWERecipient> recipient) {
        this.recipient = recipient;
    }

    @Override
    public int compareTo(ConfigJWEHeader that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "jWEProtectedHeader", "jWESharedUnprotectedHeader", "recipient");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.jWEProtectedHeader, this.jWESharedUnprotectedHeader, this.recipient);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "jWEProtectedHeader", "jWESharedUnprotectedHeader", "recipient");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "jWEProtectedHeader", "jWESharedUnprotectedHeader", "recipient"));
    }
}

