/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigPasswordAlias;
import com.kumbasoft.core.beans.config.ConfigSSLClientProfile;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.KafkaEndpoint;
import com.kumbasoft.core.beans.types.KafkaProperty;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigKafkaCluster
extends ConfigConfigBase {
    private String userSummary;
    private String protocol;
    private ArrayList<KafkaEndpoint> endpoint;
    private String sASLMechanism;
    private String userName;
    private ObjectReference<ConfigPasswordAlias> passwordAlias;
    private String autocommit;
    private ObjectReference<ConfigSSLClientProfile> sSLClient;
    private long memoryThreshold;
    private long maximumMessageSize;
    private String autoRetry;
    private int retryInterval;
    private ArrayList<KafkaProperty> property;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Protocol", elementOrder=2, dataPowerType="dmKafkaProtocol", subType="", benign=false, isPassword=false, cliAlias="protocol", refType="", isEnumeration=true, javaName="protocol", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="plaintext", displayOrder=0, displayValue="Protocol", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getProtocol() {
        return this.protocol;
    }

    @XMLInfo(elementType="element", elementName="Protocol", elementOrder=2, dataPowerType="dmKafkaProtocol", subType="", benign=false, isPassword=false, cliAlias="protocol", refType="", isEnumeration=true, javaName="protocol", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="plaintext", displayValue="Protocol", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setProtocol(String protocol) {
        if (Comparison.isIn(protocol, DPEnumerations.KAFKA_PROTOCOL)) {
            this.protocol = protocol;
        }
    }

    public void addEndpoint(KafkaEndpoint element) {
        if (element == null) {
            return;
        }
        if (this.endpoint == null) {
            this.endpoint = new ArrayList();
        }
        this.endpoint.add(element);
    }

    public boolean removeEndpoint(KafkaEndpoint element) {
        if (element == null || this.endpoint == null) {
            return false;
        }
        return this.endpoint.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Endpoint", elementOrder=3, dataPowerType="dmKafkaEndpoint", subType="", benign=false, isPassword=false, cliAlias="endpoint", refType="", isEnumeration=false, javaName="endpoint", javaType="KafkaEndpoint", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Endpoints", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<KafkaEndpoint> getEndpoint() {
        return this.endpoint;
    }

    @XMLInfo(elementType="element", elementName="Endpoint", elementOrder=3, dataPowerType="dmKafkaEndpoint", subType="", benign=false, isPassword=false, cliAlias="endpoint", refType="", isEnumeration=false, javaName="endpoint", javaType="KafkaEndpoint", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Endpoints", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEndpoint(ArrayList<KafkaEndpoint> endpoint) {
        this.endpoint = endpoint;
    }

    @XMLInfo(elementType="element", elementName="SASLMechanism", elementOrder=4, dataPowerType="dmKafkaSASLMechanism", subType="", benign=false, isPassword=false, cliAlias="sasl-mechanism", refType="", isEnumeration=true, javaName="sASLMechanism", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="plain", displayOrder=0, displayValue="SASL mechanism", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSASLMechanism() {
        return this.sASLMechanism;
    }

    @XMLInfo(elementType="element", elementName="SASLMechanism", elementOrder=4, dataPowerType="dmKafkaSASLMechanism", subType="", benign=false, isPassword=false, cliAlias="sasl-mechanism", refType="", isEnumeration=true, javaName="sASLMechanism", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="plain", displayValue="SASL mechanism", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSASLMechanism(String sASLMechanism) {
        if (sASLMechanism == null || Comparison.isIn(sASLMechanism, DPEnumerations.KAFKA_SASLMECHANISM)) {
            this.sASLMechanism = sASLMechanism;
        }
    }

    @XMLInfo(elementType="element", elementName="UserName", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="username", refType="", isEnumeration=false, javaName="userName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[^ ]+$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserName() {
        return this.userName;
    }

    @XMLInfo(elementType="element", elementName="UserName", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="username", refType="", isEnumeration=false, javaName="userName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[^ ]+$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserName(String userName) {
        if (userName != null && userName.matches("^[^ ]+$")) {
            this.userName = userName;
        }
    }

    @XMLInfo(elementType="element", elementName="PasswordAlias", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password-alias", refType="PasswordAlias", isEnumeration=false, javaName="passwordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getPasswordAlias() {
        return this.passwordAlias;
    }

    @XMLInfo(elementType="element", elementName="PasswordAlias", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password-alias", refType="PasswordAlias", isEnumeration=false, javaName="passwordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPasswordAlias(ObjectReference<ConfigPasswordAlias> passwordAlias) {
        this.passwordAlias = passwordAlias;
    }

    @XMLInfo(elementType="element", elementName="Autocommit", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="autocommit", refType="", isEnumeration=true, javaName="autocommit", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Autocommit", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAutocommit() {
        return this.autocommit;
    }

    @XMLInfo(elementType="element", elementName="Autocommit", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="autocommit", refType="", isEnumeration=true, javaName="autocommit", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Autocommit", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAutocommit(String autocommit) {
        if (autocommit == null || Comparison.isIn(autocommit, DPEnumerations.TOGGLE)) {
            this.autocommit = autocommit;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=8, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getSSLClient() {
        return this.sSLClient;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=8, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClient(ObjectReference<ConfigSSLClientProfile> sSLClient) {
        this.sSLClient = sSLClient;
    }

    @XMLInfo(elementType="element", elementName="MemoryThreshold", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="memory-threshold", refType="", isEnumeration=false, javaName="memoryThreshold", javaType="long", isRequired=false, squelchNull=false, minimum=0xA00000, maximum=0x40000000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="268435456", displayOrder=0, displayValue="Memory threshold", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMemoryThreshold() {
        return this.memoryThreshold;
    }

    @XMLInfo(elementType="element", elementName="MemoryThreshold", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="memory-threshold", refType="", isEnumeration=false, javaName="memoryThreshold", javaType="long", isRequired=false, squelchNull=false, minimum=0xA00000, maximum=0x40000000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="268435456", displayValue="Memory threshold", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMemoryThreshold(long memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    @XMLInfo(elementType="element", elementName="MaximumMessageSize", elementOrder=10, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="maximum-message-size", refType="", isEnumeration=false, javaName="maximumMessageSize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x40000000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="1048576", displayOrder=0, displayValue="Max message size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    @XMLInfo(elementType="element", elementName="MaximumMessageSize", elementOrder=10, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="maximum-message-size", refType="", isEnumeration=false, javaName="maximumMessageSize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x40000000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="1048576", displayValue="Max message size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaximumMessageSize(long maximumMessageSize) {
        this.maximumMessageSize = maximumMessageSize;
    }

    @XMLInfo(elementType="element", elementName="AutoRetry", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="auto-retry", refType="", isEnumeration=true, javaName="autoRetry", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Automatic retry", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAutoRetry() {
        return this.autoRetry;
    }

    @XMLInfo(elementType="element", elementName="AutoRetry", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="auto-retry", refType="", isEnumeration=true, javaName="autoRetry", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Automatic retry", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAutoRetry(String autoRetry) {
        if (autoRetry == null || Comparison.isIn(autoRetry, DPEnumerations.TOGGLE)) {
            this.autoRetry = autoRetry;
        }
    }

    @XMLInfo(elementType="element", elementName="RetryInterval", elementOrder=12, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="retry-interval", refType="", isEnumeration=false, javaName="retryInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="10", displayOrder=0, displayValue="Retry interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getRetryInterval() {
        return this.retryInterval;
    }

    @XMLInfo(elementType="element", elementName="RetryInterval", elementOrder=12, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="retry-interval", refType="", isEnumeration=false, javaName="retryInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="10", displayValue="Retry interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public void addProperty(KafkaProperty element) {
        if (element == null) {
            return;
        }
        if (this.property == null) {
            this.property = new ArrayList();
        }
        this.property.add(element);
    }

    public boolean removeProperty(KafkaProperty element) {
        if (element == null || this.property == null) {
            return false;
        }
        return this.property.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Property", elementOrder=13, dataPowerType="dmKafkaProperty", subType="", benign=false, isPassword=false, cliAlias="property", refType="", isEnumeration=false, javaName="property", javaType="KafkaProperty", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Properties", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<KafkaProperty> getProperty() {
        return this.property;
    }

    @XMLInfo(elementType="element", elementName="Property", elementOrder=13, dataPowerType="dmKafkaProperty", subType="", benign=false, isPassword=false, cliAlias="property", refType="", isEnumeration=false, javaName="property", javaType="KafkaProperty", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Properties", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setProperty(ArrayList<KafkaProperty> property) {
        this.property = property;
    }

    @Override
    public int compareTo(ConfigKafkaCluster that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "protocol", "endpoint", "sASLMechanism", "userName", "passwordAlias", "autocommit", "sSLClient", "memoryThreshold", "maximumMessageSize", "autoRetry", "retryInterval", "property");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.protocol, this.endpoint, this.sASLMechanism, this.userName, this.passwordAlias, this.autocommit, this.sSLClient, this.memoryThreshold, this.maximumMessageSize, this.autoRetry, this.retryInterval, this.property);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "protocol", "endpoint", "sASLMechanism", "userName", "passwordAlias", "autocommit", "sSLClient", "memoryThreshold", "maximumMessageSize", "autoRetry", "retryInterval", "property");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "protocol", "endpoint", "sASLMechanism", "userName", "passwordAlias", "autocommit", "sSLClient", "memoryThreshold", "maximumMessageSize", "autoRetry", "retryInterval", "property"));
    }
}

