/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigCrypto;
import com.kumbasoft.core.beans.config.ConfigOAuthSupportedClient;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.OAuthRole;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigOAuthSupportedClientGroup
extends ConfigCrypto {
    private String userSummary;
    private String customized;
    private String customizedType;
    private OAuthRole oAuthRole;
    private ArrayList<ObjectReference<ConfigOAuthSupportedClient>> client;
    private String templateProcessUrl;
    private ObjectReference<ConfigOAuthSupportedClient> clientTemplate;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Customized", elementOrder=2, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="customized", refType="", isEnumeration=true, javaName="customized", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Customized OAuth", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCustomized() {
        return this.customized;
    }

    @XMLInfo(elementType="element", elementName="Customized", elementOrder=2, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="customized", refType="", isEnumeration=true, javaName="customized", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Customized OAuth", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCustomized(String customized) {
        if (customized == null || Comparison.isIn(customized, DPEnumerations.TOGGLE)) {
            this.customized = customized;
        }
    }

    @XMLInfo(elementType="element", elementName="CustomizedType", elementOrder=3, dataPowerType="dmOAuthCustomizedType", subType="", benign=false, isPassword=false, cliAlias="customized-type", refType="", isEnumeration=true, javaName="customizedType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="custom", displayOrder=0, displayValue="Customization Type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCustomizedType() {
        return this.customizedType;
    }

    @XMLInfo(elementType="element", elementName="CustomizedType", elementOrder=3, dataPowerType="dmOAuthCustomizedType", subType="", benign=false, isPassword=false, cliAlias="customized-type", refType="", isEnumeration=true, javaName="customizedType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="custom", displayValue="Customization Type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCustomizedType(String customizedType) {
        if (customizedType == null || Comparison.isIn(customizedType, DPEnumerations.OAUTH_CUSTOMIZED_TYPE)) {
            this.customizedType = customizedType;
        }
    }

    @XMLInfo(elementType="element", elementName="OAuthRole", elementOrder=4, dataPowerType="dmOAuthRole", subType="", benign=false, isPassword=false, cliAlias="oauth-role", refType="", isEnumeration=false, javaName="oAuthRole", javaType="OAuthRole", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="OAuth Role", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public OAuthRole getOAuthRole() {
        return this.oAuthRole;
    }

    @XMLInfo(elementType="element", elementName="OAuthRole", elementOrder=4, dataPowerType="dmOAuthRole", subType="", benign=false, isPassword=false, cliAlias="oauth-role", refType="", isEnumeration=false, javaName="oAuthRole", javaType="OAuthRole", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="OAuth Role", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOAuthRole(OAuthRole oAuthRole) {
        this.oAuthRole = oAuthRole;
    }

    public void addClient(ObjectReference<ConfigOAuthSupportedClient> element) {
        if (element == null) {
            return;
        }
        if (this.client == null) {
            this.client = new ArrayList();
        }
        this.client.add(element);
    }

    public boolean removeClient(ObjectReference<ConfigOAuthSupportedClient> element) {
        if (element == null || this.client == null) {
            return false;
        }
        return this.client.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Client", elementOrder=5, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="client", refType="OAuthSupportedClient", isEnumeration=false, javaName="client", javaType="ObjectReference<ConfigOAuthSupportedClient>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Client", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference<ConfigOAuthSupportedClient>> getClient() {
        return this.client;
    }

    @XMLInfo(elementType="element", elementName="Client", elementOrder=5, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="client", refType="OAuthSupportedClient", isEnumeration=false, javaName="client", javaType="ObjectReference<ConfigOAuthSupportedClient>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Client", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setClient(ArrayList<ObjectReference<ConfigOAuthSupportedClient>> client) {
        this.client = client;
    }

    @XMLInfo(elementType="element", elementName="TemplateProcessUrl", elementOrder=6, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="template-process-url", refType="", isEnumeration=false, javaName="templateProcessUrl", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="OAuth Template Process", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTemplateProcessUrl() {
        return this.templateProcessUrl;
    }

    @XMLInfo(elementType="element", elementName="TemplateProcessUrl", elementOrder=6, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="template-process-url", refType="", isEnumeration=false, javaName="templateProcessUrl", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="OAuth Template Process", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTemplateProcessUrl(String templateProcessUrl) {
        this.templateProcessUrl = templateProcessUrl;
    }

    @XMLInfo(elementType="element", elementName="ClientTemplate", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="client-template", refType="OAuthSupportedClient", isEnumeration=false, javaName="clientTemplate", javaType="ObjectReference<ConfigOAuthSupportedClient>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="OAuth Client Template", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigOAuthSupportedClient> getClientTemplate() {
        return this.clientTemplate;
    }

    @XMLInfo(elementType="element", elementName="ClientTemplate", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="client-template", refType="OAuthSupportedClient", isEnumeration=false, javaName="clientTemplate", javaType="ObjectReference<ConfigOAuthSupportedClient>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="OAuth Client Template", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setClientTemplate(ObjectReference<ConfigOAuthSupportedClient> clientTemplate) {
        this.clientTemplate = clientTemplate;
    }

    @Override
    public int compareTo(ConfigOAuthSupportedClientGroup that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "customized", "customizedType", "oAuthRole", "client", "templateProcessUrl", "clientTemplate");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.customized, this.customizedType, this.oAuthRole, this.client, this.templateProcessUrl, this.clientTemplate);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "customized", "customizedType", "oAuthRole", "client", "templateProcessUrl", "clientTemplate");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "customized", "customizedType", "oAuthRole", "client", "templateProcessUrl", "clientTemplate"));
    }
}

