/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigSSLClientProfile;
import com.kumbasoft.core.beans.types.APIProxyPolicy;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.OpenTelemetryExporterHeader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigOpenTelemetryExporter
extends ConfigConfigBase {
    private String userSummary;
    private String type;
    private String hostName;
    private String tracesPath;
    private int port;
    private String hTTPContentType;
    private long timeout;
    private ArrayList<OpenTelemetryExporterHeader> header;
    private String processor;
    private BigInteger maxQueueSize;
    private BigInteger maxExportSize;
    private long exportDelayInterval;
    private ArrayList<APIProxyPolicy> proxyPolicies;
    private ObjectReference<ConfigSSLClientProfile> sSLClient;
    private String compressionAlgorithm;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Type", elementOrder=2, dataPowerType="dmOpenTelemetryExporter", subType="", benign=false, isPassword=false, cliAlias="type", refType="", isEnumeration=true, javaName="type", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="http", displayOrder=0, displayValue="Exporter type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getType() {
        return this.type;
    }

    @XMLInfo(elementType="element", elementName="Type", elementOrder=2, dataPowerType="dmOpenTelemetryExporter", subType="", benign=false, isPassword=false, cliAlias="type", refType="", isEnumeration=true, javaName="type", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="http", displayValue="Exporter type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setType(String type) {
        if (Comparison.isIn(type, DPEnumerations.OPEN_TELEMETRY_EXPORTER)) {
            this.type = type;
        }
    }

    @XMLInfo(elementType="element", elementName="HostName", elementOrder=3, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="hostname", refType="", isEnumeration=false, javaName="hostName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHostName() {
        return this.hostName;
    }

    @XMLInfo(elementType="element", elementName="HostName", elementOrder=3, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="hostname", refType="", isEnumeration=false, javaName="hostName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @XMLInfo(elementType="element", elementName="TracesPath", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="traces-path", refType="", isEnumeration=false, javaName="tracesPath", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="/v1/traces", displayOrder=0, displayValue="Traces", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTracesPath() {
        return this.tracesPath;
    }

    @XMLInfo(elementType="element", elementName="TracesPath", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="traces-path", refType="", isEnumeration=false, javaName="tracesPath", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="/v1/traces", displayValue="Traces", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTracesPath(String tracesPath) {
        this.tracesPath = tracesPath;
    }

    @XMLInfo(elementType="element", elementName="Port", elementOrder=5, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="port", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="4318", displayOrder=0, displayValue="Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getPort() {
        return this.port;
    }

    @XMLInfo(elementType="element", elementName="Port", elementOrder=5, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="port", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="4318", displayValue="Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPort(int port) {
        this.port = port;
    }

    @XMLInfo(elementType="element", elementName="HTTPContentType", elementOrder=6, dataPowerType="dmOpenTelemetryExporterHTTPContentType", subType="", benign=false, isPassword=false, cliAlias="http-content-type", refType="", isEnumeration=true, javaName="hTTPContentType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="json", displayOrder=0, displayValue="Content-Type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHTTPContentType() {
        return this.hTTPContentType;
    }

    @XMLInfo(elementType="element", elementName="HTTPContentType", elementOrder=6, dataPowerType="dmOpenTelemetryExporterHTTPContentType", subType="", benign=false, isPassword=false, cliAlias="http-content-type", refType="", isEnumeration=true, javaName="hTTPContentType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="json", displayValue="Content-Type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHTTPContentType(String hTTPContentType) {
        if (hTTPContentType == null || Comparison.isIn(hTTPContentType, DPEnumerations.OPEN_TELEMETRY_EXPORTER_HTTPCONTENT_TYPE)) {
            this.hTTPContentType = hTTPContentType;
        }
    }

    @XMLInfo(elementType="element", elementName="Timeout", elementOrder=7, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="timeout", refType="", isEnumeration=false, javaName="timeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="10", displayOrder=0, displayValue="Timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getTimeout() {
        return this.timeout;
    }

    @XMLInfo(elementType="element", elementName="Timeout", elementOrder=7, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="timeout", refType="", isEnumeration=false, javaName="timeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="10", displayValue="Timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void addHeader(OpenTelemetryExporterHeader element) {
        if (element == null) {
            return;
        }
        if (this.header == null) {
            this.header = new ArrayList();
        }
        this.header.add(element);
    }

    public boolean removeHeader(OpenTelemetryExporterHeader element) {
        if (element == null || this.header == null) {
            return false;
        }
        return this.header.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Header", elementOrder=8, dataPowerType="dmOpenTelemetryExporterHeader", subType="", benign=false, isPassword=false, cliAlias="header", refType="", isEnumeration=false, javaName="header", javaType="OpenTelemetryExporterHeader", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Headers", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<OpenTelemetryExporterHeader> getHeader() {
        return this.header;
    }

    @XMLInfo(elementType="element", elementName="Header", elementOrder=8, dataPowerType="dmOpenTelemetryExporterHeader", subType="", benign=false, isPassword=false, cliAlias="header", refType="", isEnumeration=false, javaName="header", javaType="OpenTelemetryExporterHeader", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Headers", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHeader(ArrayList<OpenTelemetryExporterHeader> header) {
        this.header = header;
    }

    @XMLInfo(elementType="element", elementName="Processor", elementOrder=9, dataPowerType="dmOpenTelemetryProcessor", subType="", benign=false, isPassword=false, cliAlias="processor", refType="", isEnumeration=true, javaName="processor", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="batch", displayOrder=0, displayValue="Processor", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getProcessor() {
        return this.processor;
    }

    @XMLInfo(elementType="element", elementName="Processor", elementOrder=9, dataPowerType="dmOpenTelemetryProcessor", subType="", benign=false, isPassword=false, cliAlias="processor", refType="", isEnumeration=true, javaName="processor", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="batch", displayValue="Processor", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setProcessor(String processor) {
        if (Comparison.isIn(processor, DPEnumerations.OPEN_TELEMETRY_PROCESSOR)) {
            this.processor = processor;
        }
    }

    @XMLInfo(elementType="element", elementName="MaxQueueSize", elementOrder=10, dataPowerType="dmUInt64", subType="", benign=false, isPassword=false, cliAlias="max-queue-size", refType="", isEnumeration=false, javaName="maxQueueSize", javaType="java.math.BigInteger", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="2048", displayOrder=0, displayValue="Max queue size", units="spans", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public BigInteger getMaxQueueSize() {
        return this.maxQueueSize;
    }

    @XMLInfo(elementType="element", elementName="MaxQueueSize", elementOrder=10, dataPowerType="dmUInt64", subType="", benign=false, isPassword=false, cliAlias="max-queue-size", refType="", isEnumeration=false, javaName="maxQueueSize", javaType="java.math.BigInteger", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="2048", displayValue="Max queue size", units="spans", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxQueueSize(BigInteger maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    @XMLInfo(elementType="element", elementName="MaxExportSize", elementOrder=11, dataPowerType="dmUInt64", subType="", benign=false, isPassword=false, cliAlias="max-export-size", refType="", isEnumeration=false, javaName="maxExportSize", javaType="java.math.BigInteger", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="512", displayOrder=0, displayValue="Max export size", units="spans", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public BigInteger getMaxExportSize() {
        return this.maxExportSize;
    }

    @XMLInfo(elementType="element", elementName="MaxExportSize", elementOrder=11, dataPowerType="dmUInt64", subType="", benign=false, isPassword=false, cliAlias="max-export-size", refType="", isEnumeration=false, javaName="maxExportSize", javaType="java.math.BigInteger", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="512", displayValue="Max export size", units="spans", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxExportSize(BigInteger maxExportSize) {
        this.maxExportSize = maxExportSize;
    }

    @XMLInfo(elementType="element", elementName="ExportDelayInterval", elementOrder=12, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="export-delay-interval", refType="", isEnumeration=false, javaName="exportDelayInterval", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="5000", displayOrder=0, displayValue="Export interval", units="ms", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getExportDelayInterval() {
        return this.exportDelayInterval;
    }

    @XMLInfo(elementType="element", elementName="ExportDelayInterval", elementOrder=12, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="export-delay-interval", refType="", isEnumeration=false, javaName="exportDelayInterval", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="5000", displayValue="Export interval", units="ms", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setExportDelayInterval(long exportDelayInterval) {
        this.exportDelayInterval = exportDelayInterval;
    }

    public void addProxyPolicies(APIProxyPolicy element) {
        if (element == null) {
            return;
        }
        if (this.proxyPolicies == null) {
            this.proxyPolicies = new ArrayList();
        }
        this.proxyPolicies.add(element);
    }

    public boolean removeProxyPolicies(APIProxyPolicy element) {
        if (element == null || this.proxyPolicies == null) {
            return false;
        }
        return this.proxyPolicies.remove(element);
    }

    @XMLInfo(elementType="element", elementName="ProxyPolicies", elementOrder=13, dataPowerType="dmAPIProxyPolicy", subType="", benign=false, isPassword=false, cliAlias="proxy", refType="", isEnumeration=false, javaName="proxyPolicies", javaType="APIProxyPolicy", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Proxy policies", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<APIProxyPolicy> getProxyPolicies() {
        return this.proxyPolicies;
    }

    @XMLInfo(elementType="element", elementName="ProxyPolicies", elementOrder=13, dataPowerType="dmAPIProxyPolicy", subType="", benign=false, isPassword=false, cliAlias="proxy", refType="", isEnumeration=false, javaName="proxyPolicies", javaType="APIProxyPolicy", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Proxy policies", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setProxyPolicies(ArrayList<APIProxyPolicy> proxyPolicies) {
        this.proxyPolicies = proxyPolicies;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=14, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getSSLClient() {
        return this.sSLClient;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=14, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClient(ObjectReference<ConfigSSLClientProfile> sSLClient) {
        this.sSLClient = sSLClient;
    }

    @XMLInfo(elementType="element", elementName="CompressionAlgorithm", elementOrder=15, dataPowerType="dmOpenTelemetryExporterCompressionAlgorithm", subType="", benign=false, isPassword=false, cliAlias="compression", refType="", isEnumeration=true, javaName="compressionAlgorithm", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="none", displayOrder=0, displayValue="Compression algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    @XMLInfo(elementType="element", elementName="CompressionAlgorithm", elementOrder=15, dataPowerType="dmOpenTelemetryExporterCompressionAlgorithm", subType="", benign=false, isPassword=false, cliAlias="compression", refType="", isEnumeration=true, javaName="compressionAlgorithm", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="none", displayValue="Compression algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCompressionAlgorithm(String compressionAlgorithm) {
        if (Comparison.isIn(compressionAlgorithm, DPEnumerations.OPEN_TELEMETRY_EXPORTER_COMPRESSION_ALGORITHM)) {
            this.compressionAlgorithm = compressionAlgorithm;
        }
    }

    @Override
    public int compareTo(ConfigOpenTelemetryExporter that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "type", "hostName", "tracesPath", "port", "hTTPContentType", "timeout", "header", "processor", "maxQueueSize", "maxExportSize", "exportDelayInterval", "proxyPolicies", "sSLClient", "compressionAlgorithm");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.type, this.hostName, this.tracesPath, this.port, this.hTTPContentType, this.timeout, this.header, this.processor, this.maxQueueSize, this.maxExportSize, this.exportDelayInterval, this.proxyPolicies, this.sSLClient, this.compressionAlgorithm);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "type", "hostName", "tracesPath", "port", "hTTPContentType", "timeout", "header", "processor", "maxQueueSize", "maxExportSize", "exportDelayInterval", "proxyPolicies", "sSLClient", "compressionAlgorithm");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "type", "hostName", "tracesPath", "port", "hTTPContentType", "timeout", "header", "processor", "maxQueueSize", "maxExportSize", "exportDelayInterval", "proxyPolicies", "sSLClient", "compressionAlgorithm"));
    }
}

