/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAccessControl;
import com.kumbasoft.core.beans.config.ConfigCryptoKerberosKeytab;
import com.kumbasoft.core.beans.config.ConfigCryptoValCred;
import com.kumbasoft.core.beans.config.ConfigLDAPSearchParameters;
import com.kumbasoft.core.beans.config.ConfigLoadBalancerGroup;
import com.kumbasoft.core.beans.config.ConfigPasswordAlias;
import com.kumbasoft.core.beans.config.ConfigSSLClientProfile;
import com.kumbasoft.core.beans.config.ConfigSSLProxyProfile;
import com.kumbasoft.core.beans.config.ConfigUser;
import com.kumbasoft.core.beans.config.ConfigZosNSSClient;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.RBMSSHAuthenticateType;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigRBMSettings
extends ConfigAccessControl {
    private String userSummary;
    private String aUMethod;
    private RBMSSHAuthenticateType sSHAUMethod;
    private String cAPubKeyFile;
    private ArrayList<String> revokedKeys;
    private ObjectReference<ConfigZosNSSClient> aUZOSNSSConfig;
    private String aUOIDCScope;
    private String aUOIDCClientID;
    private ObjectReference<ConfigPasswordAlias> aUOIDCClientSecret;
    private String aUOIDCIdentityServiceURL;
    private long aUOIDCKeyFetchInterval;
    private ObjectReference<ConfigSSLClientProfile> aUOIDCIdentityServiceURLSSLClient;
    private ObjectReference<ConfigCryptoKerberosKeytab> aUKerberosKeytab;
    private String aUCustomURL;
    private String aUInfoURL;
    private ObjectReference<ConfigCryptoValCred> aUSSLValcred;
    private String aUHost;
    private int aUPort;
    private String aULDAPSearchForDN;
    private String aULDAPBindDN;
    private String aULDAPBindPassword;
    private ObjectReference<ConfigPasswordAlias> aULDAPBindPasswordAlias;
    private ObjectReference<ConfigLDAPSearchParameters> aULDAPSearchParameters;
    private String aULDAPPrefix;
    private String aUForceDNLDAPOrder;
    private String lDAPsuffix;
    private ObjectReference<ConfigSSLProxyProfile> lDAPSSLProxyProfile;
    private ObjectReference<ConfigLoadBalancerGroup> aULDAPLoadBalanceGroup;
    private String aUCacheAllow;
    private long aUCacheTTL;
    private long aULDAPReadTimeout;
    private String mCMethod;
    private String mCCustomURL;
    private String mCLDAPSearchForGroup;
    private String mCHost;
    private int mCPort;
    private ObjectReference<ConfigSSLProxyProfile> mCLDAPSSLProxyProfile;
    private ObjectReference<ConfigLoadBalancerGroup> mCLDAPLoadBalanceGroup;
    private String mCLDAPBindDN;
    private String mCLDAPBindPassword;
    private ObjectReference<ConfigPasswordAlias> mCLDAPBindPasswordAlias;
    private ObjectReference<ConfigLDAPSearchParameters> mCLDAPSearchParameters;
    private String mCInfoURL;
    private long mCLDAPReadTimeout;
    private String lDAPVersion;
    private String fallbackLogin;
    private ArrayList<ObjectReference<ConfigUser>> fallbackUser;
    private String applyToCLI;
    private String restrictAdminToSerialPort;
    private int minPasswordLength;
    private String requireMixedCase;
    private String requireDigit;
    private String requireNonAlphaNumeric;
    private String disallowUsernameSubstring;
    private String doPasswordAging;
    private int maxPasswordAge;
    private int daysPasswordExpiry;
    private String doPasswordHistory;
    private int numOldPasswords;
    private long cliTimeout;
    private int maxFailedLogin;
    private long lockoutPeriod;
    private String mCForceDNLDAPOrder;
    private String passwordHashAlgorithm;
    private String lDAPSSLClientConfigType;
    private ObjectReference<ConfigSSLClientProfile> lDAPSSLClientProfile;
    private String mCLDAPSSLClientConfigType;
    private ObjectReference<ConfigSSLClientProfile> mCLDAPSSLClientProfile;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="AUMethod", elementOrder=2, dataPowerType="dmRBMAuthenticateType", subType="", benign=false, isPassword=false, cliAlias="au-method", refType="", isEnumeration=true, javaName="aUMethod", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="local", displayOrder=0, displayValue="Authentication method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAUMethod() {
        return this.aUMethod;
    }

    @XMLInfo(elementType="element", elementName="AUMethod", elementOrder=2, dataPowerType="dmRBMAuthenticateType", subType="", benign=false, isPassword=false, cliAlias="au-method", refType="", isEnumeration=true, javaName="aUMethod", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="local", displayValue="Authentication method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAUMethod(String aUMethod) {
        if (Comparison.isIn(aUMethod, DPEnumerations.RBMAUTHENTICATE_TYPE)) {
            this.aUMethod = aUMethod;
        }
    }

    @XMLInfo(elementType="element", elementName="SSHAUMethod", elementOrder=3, dataPowerType="dmRBMSSHAuthenticateType", subType="", benign=false, isPassword=false, cliAlias="ssh-au-method", refType="", isEnumeration=false, javaName="sSHAUMethod", javaType="RBMSSHAuthenticateType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="SSH authentication method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public RBMSSHAuthenticateType getSSHAUMethod() {
        return this.sSHAUMethod;
    }

    @XMLInfo(elementType="element", elementName="SSHAUMethod", elementOrder=3, dataPowerType="dmRBMSSHAuthenticateType", subType="", benign=false, isPassword=false, cliAlias="ssh-au-method", refType="", isEnumeration=false, javaName="sSHAUMethod", javaType="RBMSSHAuthenticateType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="SSH authentication method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSHAUMethod(RBMSSHAuthenticateType sSHAUMethod) {
        this.sSHAUMethod = sSHAUMethod;
    }

    @XMLInfo(elementType="element", elementName="CAPubKeyFile", elementOrder=4, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="ssh-ca-pubkey-file", refType="", isEnumeration=false, javaName="cAPubKeyFile", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="CA user public key file", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCAPubKeyFile() {
        return this.cAPubKeyFile;
    }

    @XMLInfo(elementType="element", elementName="CAPubKeyFile", elementOrder=4, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="ssh-ca-pubkey-file", refType="", isEnumeration=false, javaName="cAPubKeyFile", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="CA user public key file", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCAPubKeyFile(String cAPubKeyFile) {
        this.cAPubKeyFile = cAPubKeyFile;
    }

    public void addRevokedKeys(String element) {
        if (element == null) {
            return;
        }
        if (this.revokedKeys == null) {
            this.revokedKeys = new ArrayList();
        }
        this.revokedKeys.add(element);
    }

    public boolean removeRevokedKeys(String element) {
        if (element == null || this.revokedKeys == null) {
            return false;
        }
        return this.revokedKeys.remove(element);
    }

    @XMLInfo(elementType="element", elementName="RevokedKeys", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ssh-revoked-keys", refType="", isEnumeration=false, javaName="revokedKeys", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Revoked keys", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getRevokedKeys() {
        return this.revokedKeys;
    }

    @XMLInfo(elementType="element", elementName="RevokedKeys", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ssh-revoked-keys", refType="", isEnumeration=false, javaName="revokedKeys", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Revoked keys", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRevokedKeys(ArrayList<String> revokedKeys) {
        this.revokedKeys = revokedKeys;
    }

    @XMLInfo(elementType="element", elementName="AUZOSNSSConfig", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="zos-nss-au", refType="ZosNSSClient", isEnumeration=false, javaName="aUZOSNSSConfig", javaType="ObjectReference<ConfigZosNSSClient>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="z/OS NSS client", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigZosNSSClient> getAUZOSNSSConfig() {
        return this.aUZOSNSSConfig;
    }

    @XMLInfo(elementType="element", elementName="AUZOSNSSConfig", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="zos-nss-au", refType="ZosNSSClient", isEnumeration=false, javaName="aUZOSNSSConfig", javaType="ObjectReference<ConfigZosNSSClient>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="z/OS NSS client", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAUZOSNSSConfig(ObjectReference<ConfigZosNSSClient> aUZOSNSSConfig) {
        this.aUZOSNSSConfig = aUZOSNSSConfig;
    }

    @XMLInfo(elementType="element", elementName="AUOIDCScope", elementOrder=7, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="au-oidc-scope", refType="", isEnumeration=false, javaName="aUOIDCScope", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^openid( [^ ]+)*$", allowedValues={}, defaultValue="openid", displayOrder=0, displayValue="Scope", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAUOIDCScope() {
        return this.aUOIDCScope;
    }

    @XMLInfo(elementType="element", elementName="AUOIDCScope", elementOrder=7, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="au-oidc-scope", refType="", isEnumeration=false, javaName="aUOIDCScope", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^openid( [^ ]+)*$", allowedValues={}, displayOrder=0, defaultValue="openid", displayValue="Scope", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAUOIDCScope(String aUOIDCScope) {
        if (aUOIDCScope != null && aUOIDCScope.matches("^openid( [^ ]+)*$")) {
            this.aUOIDCScope = aUOIDCScope;
        }
    }

    @XMLInfo(elementType="element", elementName="AUOIDCClientID", elementOrder=8, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="au-oidc-client-id", refType="", isEnumeration=false, javaName="aUOIDCClientID", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Client ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAUOIDCClientID() {
        return this.aUOIDCClientID;
    }

    @XMLInfo(elementType="element", elementName="AUOIDCClientID", elementOrder=8, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="au-oidc-client-id", refType="", isEnumeration=false, javaName="aUOIDCClientID", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Client ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAUOIDCClientID(String aUOIDCClientID) {
        this.aUOIDCClientID = aUOIDCClientID;
    }

    @XMLInfo(elementType="element", elementName="AUOIDCClientSecret", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="au-oidc-client-secret", refType="PasswordAlias", isEnumeration=false, javaName="aUOIDCClientSecret", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Client secret", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getAUOIDCClientSecret() {
        return this.aUOIDCClientSecret;
    }

    @XMLInfo(elementType="element", elementName="AUOIDCClientSecret", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="au-oidc-client-secret", refType="PasswordAlias", isEnumeration=false, javaName="aUOIDCClientSecret", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Client secret", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAUOIDCClientSecret(ObjectReference<ConfigPasswordAlias> aUOIDCClientSecret) {
        this.aUOIDCClientSecret = aUOIDCClientSecret;
    }

    @XMLInfo(elementType="element", elementName="AUOIDCIdentityServiceURL", elementOrder=10, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="au-oidc-identity-service-url", refType="", isEnumeration=false, javaName="aUOIDCIdentityServiceURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Identity service URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAUOIDCIdentityServiceURL() {
        return this.aUOIDCIdentityServiceURL;
    }

    @XMLInfo(elementType="element", elementName="AUOIDCIdentityServiceURL", elementOrder=10, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="au-oidc-identity-service-url", refType="", isEnumeration=false, javaName="aUOIDCIdentityServiceURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Identity service URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAUOIDCIdentityServiceURL(String aUOIDCIdentityServiceURL) {
        this.aUOIDCIdentityServiceURL = aUOIDCIdentityServiceURL;
    }

    @XMLInfo(elementType="element", elementName="AUOIDCKeyFetchInterval", elementOrder=11, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="au-oidc-key-fetch-interval", refType="", isEnumeration=false, javaName="aUOIDCKeyFetchInterval", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="30", displayOrder=0, displayValue="Retrieval interval for public keys.", units="minutes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getAUOIDCKeyFetchInterval() {
        return this.aUOIDCKeyFetchInterval;
    }

    @XMLInfo(elementType="element", elementName="AUOIDCKeyFetchInterval", elementOrder=11, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="au-oidc-key-fetch-interval", refType="", isEnumeration=false, javaName="aUOIDCKeyFetchInterval", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="30", displayValue="Retrieval interval for public keys.", units="minutes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAUOIDCKeyFetchInterval(long aUOIDCKeyFetchInterval) {
        this.aUOIDCKeyFetchInterval = aUOIDCKeyFetchInterval;
    }

    @XMLInfo(elementType="element", elementName="AUOIDCIdentityServiceURLSSLClient", elementOrder=12, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="au-oidc-identity-service-ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="aUOIDCIdentityServiceURLSSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getAUOIDCIdentityServiceURLSSLClient() {
        return this.aUOIDCIdentityServiceURLSSLClient;
    }

    @XMLInfo(elementType="element", elementName="AUOIDCIdentityServiceURLSSLClient", elementOrder=12, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="au-oidc-identity-service-ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="aUOIDCIdentityServiceURLSSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAUOIDCIdentityServiceURLSSLClient(ObjectReference<ConfigSSLClientProfile> aUOIDCIdentityServiceURLSSLClient) {
        this.aUOIDCIdentityServiceURLSSLClient = aUOIDCIdentityServiceURLSSLClient;
    }

    @XMLInfo(elementType="element", elementName="AUKerberosKeytab", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="au-kerberos-keytab", refType="CryptoKerberosKeytab", isEnumeration=false, javaName="aUKerberosKeytab", javaType="ObjectReference<ConfigCryptoKerberosKeytab>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Kerberos keytab", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoKerberosKeytab> getAUKerberosKeytab() {
        return this.aUKerberosKeytab;
    }

    @XMLInfo(elementType="element", elementName="AUKerberosKeytab", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="au-kerberos-keytab", refType="CryptoKerberosKeytab", isEnumeration=false, javaName="aUKerberosKeytab", javaType="ObjectReference<ConfigCryptoKerberosKeytab>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Kerberos keytab", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAUKerberosKeytab(ObjectReference<ConfigCryptoKerberosKeytab> aUKerberosKeytab) {
        this.aUKerberosKeytab = aUKerberosKeytab;
    }

    @XMLInfo(elementType="element", elementName="AUCustomURL", elementOrder=14, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="au-custom-url", refType="", isEnumeration=false, javaName="aUCustomURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Custom URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAUCustomURL() {
        return this.aUCustomURL;
    }

    @XMLInfo(elementType="element", elementName="AUCustomURL", elementOrder=14, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="au-custom-url", refType="", isEnumeration=false, javaName="aUCustomURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Custom URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAUCustomURL(String aUCustomURL) {
        this.aUCustomURL = aUCustomURL;
    }

    @XMLInfo(elementType="element", elementName="AUInfoURL", elementOrder=15, dataPowerType="dmURL", subType="dmRBMPolicyURL", benign=false, isPassword=false, cliAlias="au-info-url", refType="", isEnumeration=false, javaName="aUInfoURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="XML file URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAUInfoURL() {
        return this.aUInfoURL;
    }

    @XMLInfo(elementType="element", elementName="AUInfoURL", elementOrder=15, dataPowerType="dmURL", subType="dmRBMPolicyURL", benign=false, isPassword=false, cliAlias="au-info-url", refType="", isEnumeration=false, javaName="aUInfoURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="XML file URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAUInfoURL(String aUInfoURL) {
        this.aUInfoURL = aUInfoURL;
    }

    @XMLInfo(elementType="element", elementName="AUSSLValcred", elementOrder=16, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="au-valcred", refType="CryptoValCred", isEnumeration=false, javaName="aUSSLValcred", javaType="ObjectReference<ConfigCryptoValCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Validation credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoValCred> getAUSSLValcred() {
        return this.aUSSLValcred;
    }

    @XMLInfo(elementType="element", elementName="AUSSLValcred", elementOrder=16, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="au-valcred", refType="CryptoValCred", isEnumeration=false, javaName="aUSSLValcred", javaType="ObjectReference<ConfigCryptoValCred>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Validation credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAUSSLValcred(ObjectReference<ConfigCryptoValCred> aUSSLValcred) {
        this.aUSSLValcred = aUSSLValcred;
    }

    @XMLInfo(elementType="element", elementName="AUHost", elementOrder=17, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="au-server-host", refType="", isEnumeration=false, javaName="aUHost", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Server host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAUHost() {
        return this.aUHost;
    }

    @XMLInfo(elementType="element", elementName="AUHost", elementOrder=17, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="au-server-host", refType="", isEnumeration=false, javaName="aUHost", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Server host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAUHost(String aUHost) {
        this.aUHost = aUHost;
    }

    @XMLInfo(elementType="element", elementName="AUPort", elementOrder=18, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="au-server-port", refType="", isEnumeration=false, javaName="aUPort", javaType="int", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Server port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getAUPort() {
        return this.aUPort;
    }

    @XMLInfo(elementType="element", elementName="AUPort", elementOrder=18, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="au-server-port", refType="", isEnumeration=false, javaName="aUPort", javaType="int", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Server port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAUPort(int aUPort) {
        this.aUPort = aUPort;
    }

    @XMLInfo(elementType="element", elementName="AULDAPSearchForDN", elementOrder=19, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="au-ldap-search", refType="", isEnumeration=true, javaName="aULDAPSearchForDN", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Search LDAP for DN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAULDAPSearchForDN() {
        return this.aULDAPSearchForDN;
    }

    @XMLInfo(elementType="element", elementName="AULDAPSearchForDN", elementOrder=19, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="au-ldap-search", refType="", isEnumeration=true, javaName="aULDAPSearchForDN", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Search LDAP for DN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAULDAPSearchForDN(String aULDAPSearchForDN) {
        if (aULDAPSearchForDN == null || Comparison.isIn(aULDAPSearchForDN, DPEnumerations.TOGGLE)) {
            this.aULDAPSearchForDN = aULDAPSearchForDN;
        }
    }

    @XMLInfo(elementType="element", elementName="AULDAPBindDN", elementOrder=20, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="au-ldap-bind-dn", refType="", isEnumeration=false, javaName="aULDAPBindDN", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP bind DN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAULDAPBindDN() {
        return this.aULDAPBindDN;
    }

    @XMLInfo(elementType="element", elementName="AULDAPBindDN", elementOrder=20, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="au-ldap-bind-dn", refType="", isEnumeration=false, javaName="aULDAPBindDN", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP bind DN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAULDAPBindDN(String aULDAPBindDN) {
        this.aULDAPBindDN = aULDAPBindDN;
    }

    @XMLInfo(elementType="element", elementName="AULDAPBindPassword", elementOrder=21, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="au-ldap-bind-password", refType="", isEnumeration=false, javaName="aULDAPBindPassword", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP bind password (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="7.2.0.0", isObsolete=false, obsoletedIn="")
    public String getAULDAPBindPassword() {
        return this.aULDAPBindPassword;
    }

    @XMLInfo(elementType="element", elementName="AULDAPBindPassword", elementOrder=21, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="au-ldap-bind-password", refType="", isEnumeration=false, javaName="aULDAPBindPassword", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP bind password (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="7.2.0.0", isObsolete=false, obsoletedIn="")
    public void setAULDAPBindPassword(String aULDAPBindPassword) {
        this.aULDAPBindPassword = aULDAPBindPassword;
    }

    @XMLInfo(elementType="element", elementName="AULDAPBindPasswordAlias", elementOrder=22, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="au-ldap-bind-password-alias", refType="PasswordAlias", isEnumeration=false, javaName="aULDAPBindPasswordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP bind password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getAULDAPBindPasswordAlias() {
        return this.aULDAPBindPasswordAlias;
    }

    @XMLInfo(elementType="element", elementName="AULDAPBindPasswordAlias", elementOrder=22, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="au-ldap-bind-password-alias", refType="PasswordAlias", isEnumeration=false, javaName="aULDAPBindPasswordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP bind password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAULDAPBindPasswordAlias(ObjectReference<ConfigPasswordAlias> aULDAPBindPasswordAlias) {
        this.aULDAPBindPasswordAlias = aULDAPBindPasswordAlias;
    }

    @XMLInfo(elementType="element", elementName="AULDAPSearchParameters", elementOrder=23, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="au-ldap-parameters", refType="LDAPSearchParameters", isEnumeration=false, javaName="aULDAPSearchParameters", javaType="ObjectReference<ConfigLDAPSearchParameters>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP search parameters", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigLDAPSearchParameters> getAULDAPSearchParameters() {
        return this.aULDAPSearchParameters;
    }

    @XMLInfo(elementType="element", elementName="AULDAPSearchParameters", elementOrder=23, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="au-ldap-parameters", refType="LDAPSearchParameters", isEnumeration=false, javaName="aULDAPSearchParameters", javaType="ObjectReference<ConfigLDAPSearchParameters>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP search parameters", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAULDAPSearchParameters(ObjectReference<ConfigLDAPSearchParameters> aULDAPSearchParameters) {
        this.aULDAPSearchParameters = aULDAPSearchParameters;
    }

    @XMLInfo(elementType="element", elementName="AULDAPPrefix", elementOrder=24, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ldap-prefix", refType="", isEnumeration=false, javaName="aULDAPPrefix", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="cn=", displayOrder=0, displayValue="LDAP prefix", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAULDAPPrefix() {
        return this.aULDAPPrefix;
    }

    @XMLInfo(elementType="element", elementName="AULDAPPrefix", elementOrder=24, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ldap-prefix", refType="", isEnumeration=false, javaName="aULDAPPrefix", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="cn=", displayValue="LDAP prefix", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAULDAPPrefix(String aULDAPPrefix) {
        this.aULDAPPrefix = aULDAPPrefix;
    }

    @XMLInfo(elementType="element", elementName="AUForceDNLDAPOrder", elementOrder=25, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="au-force-dn-ldap-order", refType="", isEnumeration=true, javaName="aUForceDNLDAPOrder", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Convert DN to LDAP format", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAUForceDNLDAPOrder() {
        return this.aUForceDNLDAPOrder;
    }

    @XMLInfo(elementType="element", elementName="AUForceDNLDAPOrder", elementOrder=25, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="au-force-dn-ldap-order", refType="", isEnumeration=true, javaName="aUForceDNLDAPOrder", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Convert DN to LDAP format", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAUForceDNLDAPOrder(String aUForceDNLDAPOrder) {
        if (aUForceDNLDAPOrder == null || Comparison.isIn(aUForceDNLDAPOrder, DPEnumerations.TOGGLE)) {
            this.aUForceDNLDAPOrder = aUForceDNLDAPOrder;
        }
    }

    @XMLInfo(elementType="element", elementName="LDAPsuffix", elementOrder=26, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ldap-suffix", refType="", isEnumeration=false, javaName="lDAPsuffix", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP suffix", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPsuffix() {
        return this.lDAPsuffix;
    }

    @XMLInfo(elementType="element", elementName="LDAPsuffix", elementOrder=26, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="ldap-suffix", refType="", isEnumeration=false, javaName="lDAPsuffix", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP suffix", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPsuffix(String lDAPsuffix) {
        this.lDAPsuffix = lDAPsuffix;
    }

    @XMLInfo(elementType="element", elementName="LDAPSSLProxyProfile", elementOrder=27, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ldap-sslproxy", refType="SSLProxyProfile", isEnumeration=false, javaName="lDAPSSLProxyProfile", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLProxyProfile> getLDAPSSLProxyProfile() {
        return this.lDAPSSLProxyProfile;
    }

    @XMLInfo(elementType="element", elementName="LDAPSSLProxyProfile", elementOrder=27, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ldap-sslproxy", refType="SSLProxyProfile", isEnumeration=false, javaName="lDAPSSLProxyProfile", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPSSLProxyProfile(ObjectReference<ConfigSSLProxyProfile> lDAPSSLProxyProfile) {
        this.lDAPSSLProxyProfile = lDAPSSLProxyProfile;
    }

    @XMLInfo(elementType="element", elementName="AULDAPLoadBalanceGroup", elementOrder=28, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="loadbalancer-group", refType="LoadBalancerGroup", isEnumeration=false, javaName="aULDAPLoadBalanceGroup", javaType="ObjectReference<ConfigLoadBalancerGroup>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Load balancer group", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigLoadBalancerGroup> getAULDAPLoadBalanceGroup() {
        return this.aULDAPLoadBalanceGroup;
    }

    @XMLInfo(elementType="element", elementName="AULDAPLoadBalanceGroup", elementOrder=28, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="loadbalancer-group", refType="LoadBalancerGroup", isEnumeration=false, javaName="aULDAPLoadBalanceGroup", javaType="ObjectReference<ConfigLoadBalancerGroup>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Load balancer group", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAULDAPLoadBalanceGroup(ObjectReference<ConfigLoadBalancerGroup> aULDAPLoadBalanceGroup) {
        this.aULDAPLoadBalanceGroup = aULDAPLoadBalanceGroup;
    }

    @XMLInfo(elementType="element", elementName="AUCacheAllow", elementOrder=29, dataPowerType="dmAAACacheType", subType="", benign=false, isPassword=false, cliAlias="au-cache-mode", refType="", isEnumeration=true, javaName="aUCacheAllow", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="absolute", displayOrder=0, displayValue="Authentication cache mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAUCacheAllow() {
        return this.aUCacheAllow;
    }

    @XMLInfo(elementType="element", elementName="AUCacheAllow", elementOrder=29, dataPowerType="dmAAACacheType", subType="", benign=false, isPassword=false, cliAlias="au-cache-mode", refType="", isEnumeration=true, javaName="aUCacheAllow", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="absolute", displayValue="Authentication cache mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAUCacheAllow(String aUCacheAllow) {
        if (Comparison.isIn(aUCacheAllow, DPEnumerations.AAACACHE_TYPE)) {
            this.aUCacheAllow = aUCacheAllow;
        }
    }

    @XMLInfo(elementType="element", elementName="AUCacheTTL", elementOrder=30, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="au-cache-ttl", refType="", isEnumeration=false, javaName="aUCacheTTL", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="600", displayOrder=0, displayValue="Authentication cache lifetime", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getAUCacheTTL() {
        return this.aUCacheTTL;
    }

    @XMLInfo(elementType="element", elementName="AUCacheTTL", elementOrder=30, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="au-cache-ttl", refType="", isEnumeration=false, javaName="aUCacheTTL", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="600", displayValue="Authentication cache lifetime", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAUCacheTTL(long aUCacheTTL) {
        this.aUCacheTTL = aUCacheTTL;
    }

    @XMLInfo(elementType="element", elementName="AULDAPReadTimeout", elementOrder=31, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="au-ldap-readtimeout", refType="", isEnumeration=false, javaName="aULDAPReadTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="60", displayOrder=0, displayValue="LDAP read timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getAULDAPReadTimeout() {
        return this.aULDAPReadTimeout;
    }

    @XMLInfo(elementType="element", elementName="AULDAPReadTimeout", elementOrder=31, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="au-ldap-readtimeout", refType="", isEnumeration=false, javaName="aULDAPReadTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="60", displayValue="LDAP read timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAULDAPReadTimeout(long aULDAPReadTimeout) {
        this.aULDAPReadTimeout = aULDAPReadTimeout;
    }

    @XMLInfo(elementType="element", elementName="MCMethod", elementOrder=32, dataPowerType="dmRBMMapType", subType="", benign=false, isPassword=false, cliAlias="mc-method", refType="", isEnumeration=true, javaName="mCMethod", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="local", displayOrder=0, displayValue="Credential-mapping method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMCMethod() {
        return this.mCMethod;
    }

    @XMLInfo(elementType="element", elementName="MCMethod", elementOrder=32, dataPowerType="dmRBMMapType", subType="", benign=false, isPassword=false, cliAlias="mc-method", refType="", isEnumeration=true, javaName="mCMethod", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="local", displayValue="Credential-mapping method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMCMethod(String mCMethod) {
        if (Comparison.isIn(mCMethod, DPEnumerations.RBMMAP_TYPE)) {
            this.mCMethod = mCMethod;
        }
    }

    @XMLInfo(elementType="element", elementName="MCCustomURL", elementOrder=33, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="mc-custom-url", refType="", isEnumeration=false, javaName="mCCustomURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Custom URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMCCustomURL() {
        return this.mCCustomURL;
    }

    @XMLInfo(elementType="element", elementName="MCCustomURL", elementOrder=33, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="mc-custom-url", refType="", isEnumeration=false, javaName="mCCustomURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Custom URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMCCustomURL(String mCCustomURL) {
        this.mCCustomURL = mCCustomURL;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPSearchForGroup", elementOrder=34, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="mc-ldap-search", refType="", isEnumeration=true, javaName="mCLDAPSearchForGroup", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Search LDAP for group name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMCLDAPSearchForGroup() {
        return this.mCLDAPSearchForGroup;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPSearchForGroup", elementOrder=34, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="mc-ldap-search", refType="", isEnumeration=true, javaName="mCLDAPSearchForGroup", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Search LDAP for group name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMCLDAPSearchForGroup(String mCLDAPSearchForGroup) {
        if (mCLDAPSearchForGroup == null || Comparison.isIn(mCLDAPSearchForGroup, DPEnumerations.TOGGLE)) {
            this.mCLDAPSearchForGroup = mCLDAPSearchForGroup;
        }
    }

    @XMLInfo(elementType="element", elementName="MCHost", elementOrder=35, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="mc-server-host", refType="", isEnumeration=false, javaName="mCHost", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Server host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMCHost() {
        return this.mCHost;
    }

    @XMLInfo(elementType="element", elementName="MCHost", elementOrder=35, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="mc-server-host", refType="", isEnumeration=false, javaName="mCHost", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Server host", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMCHost(String mCHost) {
        this.mCHost = mCHost;
    }

    @XMLInfo(elementType="element", elementName="MCPort", elementOrder=36, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="mc-server-port", refType="", isEnumeration=false, javaName="mCPort", javaType="int", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Server port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getMCPort() {
        return this.mCPort;
    }

    @XMLInfo(elementType="element", elementName="MCPort", elementOrder=36, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="mc-server-port", refType="", isEnumeration=false, javaName="mCPort", javaType="int", isRequired=false, squelchNull=true, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Server port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMCPort(int mCPort) {
        this.mCPort = mCPort;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPSSLProxyProfile", elementOrder=37, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="mc-ldap-sslproxy", refType="SSLProxyProfile", isEnumeration=false, javaName="mCLDAPSSLProxyProfile", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLProxyProfile> getMCLDAPSSLProxyProfile() {
        return this.mCLDAPSSLProxyProfile;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPSSLProxyProfile", elementOrder=37, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="mc-ldap-sslproxy", refType="SSLProxyProfile", isEnumeration=false, javaName="mCLDAPSSLProxyProfile", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMCLDAPSSLProxyProfile(ObjectReference<ConfigSSLProxyProfile> mCLDAPSSLProxyProfile) {
        this.mCLDAPSSLProxyProfile = mCLDAPSSLProxyProfile;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPLoadBalanceGroup", elementOrder=38, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="mc-loadbalancer-group", refType="LoadBalancerGroup", isEnumeration=false, javaName="mCLDAPLoadBalanceGroup", javaType="ObjectReference<ConfigLoadBalancerGroup>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Load balancer group", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigLoadBalancerGroup> getMCLDAPLoadBalanceGroup() {
        return this.mCLDAPLoadBalanceGroup;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPLoadBalanceGroup", elementOrder=38, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="mc-loadbalancer-group", refType="LoadBalancerGroup", isEnumeration=false, javaName="mCLDAPLoadBalanceGroup", javaType="ObjectReference<ConfigLoadBalancerGroup>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Load balancer group", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMCLDAPLoadBalanceGroup(ObjectReference<ConfigLoadBalancerGroup> mCLDAPLoadBalanceGroup) {
        this.mCLDAPLoadBalanceGroup = mCLDAPLoadBalanceGroup;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPBindDN", elementOrder=39, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="mc-ldap-bind-dn", refType="", isEnumeration=false, javaName="mCLDAPBindDN", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP bind DN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMCLDAPBindDN() {
        return this.mCLDAPBindDN;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPBindDN", elementOrder=39, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="mc-ldap-bind-dn", refType="", isEnumeration=false, javaName="mCLDAPBindDN", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP bind DN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMCLDAPBindDN(String mCLDAPBindDN) {
        this.mCLDAPBindDN = mCLDAPBindDN;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPBindPassword", elementOrder=40, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="mc-ldap-bind-password", refType="", isEnumeration=false, javaName="mCLDAPBindPassword", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP bind password (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="7.2.0.0", isObsolete=false, obsoletedIn="")
    public String getMCLDAPBindPassword() {
        return this.mCLDAPBindPassword;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPBindPassword", elementOrder=40, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="mc-ldap-bind-password", refType="", isEnumeration=false, javaName="mCLDAPBindPassword", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP bind password (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="7.2.0.0", isObsolete=false, obsoletedIn="")
    public void setMCLDAPBindPassword(String mCLDAPBindPassword) {
        this.mCLDAPBindPassword = mCLDAPBindPassword;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPBindPasswordAlias", elementOrder=41, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="mc-ldap-bind-password-alias", refType="PasswordAlias", isEnumeration=false, javaName="mCLDAPBindPasswordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP bind password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getMCLDAPBindPasswordAlias() {
        return this.mCLDAPBindPasswordAlias;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPBindPasswordAlias", elementOrder=41, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="mc-ldap-bind-password-alias", refType="PasswordAlias", isEnumeration=false, javaName="mCLDAPBindPasswordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP bind password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMCLDAPBindPasswordAlias(ObjectReference<ConfigPasswordAlias> mCLDAPBindPasswordAlias) {
        this.mCLDAPBindPasswordAlias = mCLDAPBindPasswordAlias;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPSearchParameters", elementOrder=42, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="mc-ldap-parameters", refType="LDAPSearchParameters", isEnumeration=false, javaName="mCLDAPSearchParameters", javaType="ObjectReference<ConfigLDAPSearchParameters>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP search parameters", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigLDAPSearchParameters> getMCLDAPSearchParameters() {
        return this.mCLDAPSearchParameters;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPSearchParameters", elementOrder=42, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="mc-ldap-parameters", refType="LDAPSearchParameters", isEnumeration=false, javaName="mCLDAPSearchParameters", javaType="ObjectReference<ConfigLDAPSearchParameters>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP search parameters", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMCLDAPSearchParameters(ObjectReference<ConfigLDAPSearchParameters> mCLDAPSearchParameters) {
        this.mCLDAPSearchParameters = mCLDAPSearchParameters;
    }

    @XMLInfo(elementType="element", elementName="MCInfoURL", elementOrder=43, dataPowerType="dmURL", subType="dmRBMPolicyURL", benign=false, isPassword=false, cliAlias="mc-info-url", refType="", isEnumeration=false, javaName="mCInfoURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="XML file URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMCInfoURL() {
        return this.mCInfoURL;
    }

    @XMLInfo(elementType="element", elementName="MCInfoURL", elementOrder=43, dataPowerType="dmURL", subType="dmRBMPolicyURL", benign=false, isPassword=false, cliAlias="mc-info-url", refType="", isEnumeration=false, javaName="mCInfoURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="XML file URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMCInfoURL(String mCInfoURL) {
        this.mCInfoURL = mCInfoURL;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPReadTimeout", elementOrder=44, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="mc-ldap-readtimeout", refType="", isEnumeration=false, javaName="mCLDAPReadTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="60", displayOrder=0, displayValue="LDAP read timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMCLDAPReadTimeout() {
        return this.mCLDAPReadTimeout;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPReadTimeout", elementOrder=44, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="mc-ldap-readtimeout", refType="", isEnumeration=false, javaName="mCLDAPReadTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="60", displayValue="LDAP read timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMCLDAPReadTimeout(long mCLDAPReadTimeout) {
        this.mCLDAPReadTimeout = mCLDAPReadTimeout;
    }

    @XMLInfo(elementType="element", elementName="LDAPVersion", elementOrder=45, dataPowerType="dmLDAPVersion", subType="", benign=false, isPassword=false, cliAlias="ldap-version", refType="", isEnumeration=true, javaName="lDAPVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPVersion() {
        return this.lDAPVersion;
    }

    @XMLInfo(elementType="element", elementName="LDAPVersion", elementOrder=45, dataPowerType="dmLDAPVersion", subType="", benign=false, isPassword=false, cliAlias="ldap-version", refType="", isEnumeration=true, javaName="lDAPVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPVersion(String lDAPVersion) {
        if (lDAPVersion == null || Comparison.isIn(lDAPVersion, DPEnumerations.LDAPVERSION)) {
            this.lDAPVersion = lDAPVersion;
        }
    }

    @XMLInfo(elementType="element", elementName="FallbackLogin", elementOrder=46, dataPowerType="dmRBMFallbackLoginType", subType="", benign=false, isPassword=false, cliAlias="fallback-login", refType="", isEnumeration=true, javaName="fallbackLogin", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="disabled", displayOrder=0, displayValue="Local accounts for fallback", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getFallbackLogin() {
        return this.fallbackLogin;
    }

    @XMLInfo(elementType="element", elementName="FallbackLogin", elementOrder=46, dataPowerType="dmRBMFallbackLoginType", subType="", benign=false, isPassword=false, cliAlias="fallback-login", refType="", isEnumeration=true, javaName="fallbackLogin", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="disabled", displayValue="Local accounts for fallback", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFallbackLogin(String fallbackLogin) {
        if (fallbackLogin == null || Comparison.isIn(fallbackLogin, DPEnumerations.RBMFALLBACK_LOGIN_TYPE)) {
            this.fallbackLogin = fallbackLogin;
        }
    }

    public void addFallbackUser(ObjectReference<ConfigUser> element) {
        if (element == null) {
            return;
        }
        if (this.fallbackUser == null) {
            this.fallbackUser = new ArrayList();
        }
        this.fallbackUser.add(element);
    }

    public boolean removeFallbackUser(ObjectReference<ConfigUser> element) {
        if (element == null || this.fallbackUser == null) {
            return false;
        }
        return this.fallbackUser.remove(element);
    }

    @XMLInfo(elementType="element", elementName="FallbackUser", elementOrder=47, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="fallback-user", refType="User", isEnumeration=false, javaName="fallbackUser", javaType="ObjectReference<ConfigUser>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Fallback users", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference<ConfigUser>> getFallbackUser() {
        return this.fallbackUser;
    }

    @XMLInfo(elementType="element", elementName="FallbackUser", elementOrder=47, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="fallback-user", refType="User", isEnumeration=false, javaName="fallbackUser", javaType="ObjectReference<ConfigUser>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Fallback users", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFallbackUser(ArrayList<ObjectReference<ConfigUser>> fallbackUser) {
        this.fallbackUser = fallbackUser;
    }

    @XMLInfo(elementType="element", elementName="ApplyToCLI", elementOrder=48, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apply-cli", refType="", isEnumeration=true, javaName="applyToCLI", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enforce RBM on CLI", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getApplyToCLI() {
        return this.applyToCLI;
    }

    @XMLInfo(elementType="element", elementName="ApplyToCLI", elementOrder=48, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apply-cli", refType="", isEnumeration=true, javaName="applyToCLI", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enforce RBM on CLI", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setApplyToCLI(String applyToCLI) {
        if (applyToCLI == null || Comparison.isIn(applyToCLI, DPEnumerations.TOGGLE)) {
            this.applyToCLI = applyToCLI;
        }
    }

    @XMLInfo(elementType="element", elementName="RestrictAdminToSerialPort", elementOrder=49, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="restrict-admin", refType="", isEnumeration=true, javaName="restrictAdminToSerialPort", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Restrict admin to serial", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRestrictAdminToSerialPort() {
        return this.restrictAdminToSerialPort;
    }

    @XMLInfo(elementType="element", elementName="RestrictAdminToSerialPort", elementOrder=49, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="restrict-admin", refType="", isEnumeration=true, javaName="restrictAdminToSerialPort", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Restrict admin to serial", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRestrictAdminToSerialPort(String restrictAdminToSerialPort) {
        if (restrictAdminToSerialPort == null || Comparison.isIn(restrictAdminToSerialPort, DPEnumerations.TOGGLE)) {
            this.restrictAdminToSerialPort = restrictAdminToSerialPort;
        }
    }

    @XMLInfo(elementType="element", elementName="MinPasswordLength", elementOrder=50, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="pwd-minimum-length", refType="", isEnumeration=false, javaName="minPasswordLength", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=128L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="6", displayOrder=0, displayValue="Minimum length", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getMinPasswordLength() {
        return this.minPasswordLength;
    }

    @XMLInfo(elementType="element", elementName="MinPasswordLength", elementOrder=50, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="pwd-minimum-length", refType="", isEnumeration=false, javaName="minPasswordLength", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=128L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="6", displayValue="Minimum length", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMinPasswordLength(int minPasswordLength) {
        this.minPasswordLength = minPasswordLength;
    }

    @XMLInfo(elementType="element", elementName="RequireMixedCase", elementOrder=51, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="pwd-mixed-case", refType="", isEnumeration=true, javaName="requireMixedCase", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Require mixed case", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRequireMixedCase() {
        return this.requireMixedCase;
    }

    @XMLInfo(elementType="element", elementName="RequireMixedCase", elementOrder=51, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="pwd-mixed-case", refType="", isEnumeration=true, javaName="requireMixedCase", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Require mixed case", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRequireMixedCase(String requireMixedCase) {
        if (Comparison.isIn(requireMixedCase, DPEnumerations.TOGGLE)) {
            this.requireMixedCase = requireMixedCase;
        }
    }

    @XMLInfo(elementType="element", elementName="RequireDigit", elementOrder=52, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="pwd-digit", refType="", isEnumeration=true, javaName="requireDigit", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Require number", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRequireDigit() {
        return this.requireDigit;
    }

    @XMLInfo(elementType="element", elementName="RequireDigit", elementOrder=52, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="pwd-digit", refType="", isEnumeration=true, javaName="requireDigit", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Require number", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRequireDigit(String requireDigit) {
        if (Comparison.isIn(requireDigit, DPEnumerations.TOGGLE)) {
            this.requireDigit = requireDigit;
        }
    }

    @XMLInfo(elementType="element", elementName="RequireNonAlphaNumeric", elementOrder=53, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="pwd-nonalphanumeric", refType="", isEnumeration=true, javaName="requireNonAlphaNumeric", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Require non-alphanumeric", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRequireNonAlphaNumeric() {
        return this.requireNonAlphaNumeric;
    }

    @XMLInfo(elementType="element", elementName="RequireNonAlphaNumeric", elementOrder=53, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="pwd-nonalphanumeric", refType="", isEnumeration=true, javaName="requireNonAlphaNumeric", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Require non-alphanumeric", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRequireNonAlphaNumeric(String requireNonAlphaNumeric) {
        if (Comparison.isIn(requireNonAlphaNumeric, DPEnumerations.TOGGLE)) {
            this.requireNonAlphaNumeric = requireNonAlphaNumeric;
        }
    }

    @XMLInfo(elementType="element", elementName="DisallowUsernameSubstring", elementOrder=54, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="pwd-username", refType="", isEnumeration=true, javaName="disallowUsernameSubstring", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Disallow username substring", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDisallowUsernameSubstring() {
        return this.disallowUsernameSubstring;
    }

    @XMLInfo(elementType="element", elementName="DisallowUsernameSubstring", elementOrder=54, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="pwd-username", refType="", isEnumeration=true, javaName="disallowUsernameSubstring", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Disallow username substring", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDisallowUsernameSubstring(String disallowUsernameSubstring) {
        if (Comparison.isIn(disallowUsernameSubstring, DPEnumerations.TOGGLE)) {
            this.disallowUsernameSubstring = disallowUsernameSubstring;
        }
    }

    @XMLInfo(elementType="element", elementName="DoPasswordAging", elementOrder=55, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="pwd-aging", refType="", isEnumeration=true, javaName="doPasswordAging", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable aging", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDoPasswordAging() {
        return this.doPasswordAging;
    }

    @XMLInfo(elementType="element", elementName="DoPasswordAging", elementOrder=55, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="pwd-aging", refType="", isEnumeration=true, javaName="doPasswordAging", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable aging", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDoPasswordAging(String doPasswordAging) {
        if (Comparison.isIn(doPasswordAging, DPEnumerations.TOGGLE)) {
            this.doPasswordAging = doPasswordAging;
        }
    }

    @XMLInfo(elementType="element", elementName="MaxPasswordAge", elementOrder=56, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="pwd-max-age", refType="", isEnumeration=false, javaName="maxPasswordAge", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="30", displayOrder=0, displayValue="Max age", units="days", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getMaxPasswordAge() {
        return this.maxPasswordAge;
    }

    @XMLInfo(elementType="element", elementName="MaxPasswordAge", elementOrder=56, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="pwd-max-age", refType="", isEnumeration=false, javaName="maxPasswordAge", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="30", displayValue="Max age", units="days", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxPasswordAge(int maxPasswordAge) {
        this.maxPasswordAge = maxPasswordAge;
    }

    @XMLInfo(elementType="element", elementName="DaysPasswordExpiry", elementOrder=57, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="pwd-exp-day", refType="", isEnumeration=false, javaName="daysPasswordExpiry", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=30L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="7", displayOrder=0, displayValue="Expiry notification", units="days", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getDaysPasswordExpiry() {
        return this.daysPasswordExpiry;
    }

    @XMLInfo(elementType="element", elementName="DaysPasswordExpiry", elementOrder=57, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="pwd-exp-day", refType="", isEnumeration=false, javaName="daysPasswordExpiry", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=30L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="7", displayValue="Expiry notification", units="days", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDaysPasswordExpiry(int daysPasswordExpiry) {
        this.daysPasswordExpiry = daysPasswordExpiry;
    }

    @XMLInfo(elementType="element", elementName="DoPasswordHistory", elementOrder=58, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="pwd-history", refType="", isEnumeration=true, javaName="doPasswordHistory", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Control reuse", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDoPasswordHistory() {
        return this.doPasswordHistory;
    }

    @XMLInfo(elementType="element", elementName="DoPasswordHistory", elementOrder=58, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="pwd-history", refType="", isEnumeration=true, javaName="doPasswordHistory", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Control reuse", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDoPasswordHistory(String doPasswordHistory) {
        if (Comparison.isIn(doPasswordHistory, DPEnumerations.TOGGLE)) {
            this.doPasswordHistory = doPasswordHistory;
        }
    }

    @XMLInfo(elementType="element", elementName="NumOldPasswords", elementOrder=59, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="pwd-max-history", refType="", isEnumeration=false, javaName="numOldPasswords", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="5", displayOrder=0, displayValue="Reuse history", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getNumOldPasswords() {
        return this.numOldPasswords;
    }

    @XMLInfo(elementType="element", elementName="NumOldPasswords", elementOrder=59, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="pwd-max-history", refType="", isEnumeration=false, javaName="numOldPasswords", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="5", displayValue="Reuse history", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setNumOldPasswords(int numOldPasswords) {
        this.numOldPasswords = numOldPasswords;
    }

    @XMLInfo(elementType="element", elementName="CliTimeout", elementOrder=60, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="cli-timeout", refType="", isEnumeration=false, javaName="cliTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=0, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="CLI idle timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getCliTimeout() {
        return this.cliTimeout;
    }

    @XMLInfo(elementType="element", elementName="CliTimeout", elementOrder=60, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="cli-timeout", refType="", isEnumeration=false, javaName="cliTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=0, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="CLI idle timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCliTimeout(long cliTimeout) {
        this.cliTimeout = cliTimeout;
    }

    @XMLInfo(elementType="element", elementName="MaxFailedLogin", elementOrder=61, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="max-login-failure", refType="", isEnumeration=false, javaName="maxFailedLogin", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=64L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Max failed logins", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getMaxFailedLogin() {
        return this.maxFailedLogin;
    }

    @XMLInfo(elementType="element", elementName="MaxFailedLogin", elementOrder=61, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="max-login-failure", refType="", isEnumeration=false, javaName="maxFailedLogin", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=64L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Max failed logins", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxFailedLogin(int maxFailedLogin) {
        this.maxFailedLogin = maxFailedLogin;
    }

    @XMLInfo(elementType="element", elementName="LockoutPeriod", elementOrder=62, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="lockout-duration", refType="", isEnumeration=false, javaName="lockoutPeriod", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=1000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="1", displayOrder=0, displayValue="Lockout duration", units="minutes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getLockoutPeriod() {
        return this.lockoutPeriod;
    }

    @XMLInfo(elementType="element", elementName="LockoutPeriod", elementOrder=62, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="lockout-duration", refType="", isEnumeration=false, javaName="lockoutPeriod", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=1000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="1", displayValue="Lockout duration", units="minutes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLockoutPeriod(long lockoutPeriod) {
        this.lockoutPeriod = lockoutPeriod;
    }

    @XMLInfo(elementType="element", elementName="MCForceDNLDAPOrder", elementOrder=63, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="mc-force-dn-ldap-order", refType="", isEnumeration=true, javaName="mCForceDNLDAPOrder", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Convert DN to LDAP format", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMCForceDNLDAPOrder() {
        return this.mCForceDNLDAPOrder;
    }

    @XMLInfo(elementType="element", elementName="MCForceDNLDAPOrder", elementOrder=63, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="mc-force-dn-ldap-order", refType="", isEnumeration=true, javaName="mCForceDNLDAPOrder", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Convert DN to LDAP format", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMCForceDNLDAPOrder(String mCForceDNLDAPOrder) {
        if (mCForceDNLDAPOrder == null || Comparison.isIn(mCForceDNLDAPOrder, DPEnumerations.TOGGLE)) {
            this.mCForceDNLDAPOrder = mCForceDNLDAPOrder;
        }
    }

    @XMLInfo(elementType="element", elementName="PasswordHashAlgorithm", elementOrder=64, dataPowerType="dmPasswordFileHashAlgorithm", subType="", benign=false, isPassword=false, cliAlias="password-hash-algorithm", refType="", isEnumeration=true, javaName="passwordHashAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="md5crypt", displayOrder=0, displayValue="Password hash algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPasswordHashAlgorithm() {
        return this.passwordHashAlgorithm;
    }

    @XMLInfo(elementType="element", elementName="PasswordHashAlgorithm", elementOrder=64, dataPowerType="dmPasswordFileHashAlgorithm", subType="", benign=false, isPassword=false, cliAlias="password-hash-algorithm", refType="", isEnumeration=true, javaName="passwordHashAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="md5crypt", displayValue="Password hash algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPasswordHashAlgorithm(String passwordHashAlgorithm) {
        if (passwordHashAlgorithm == null || Comparison.isIn(passwordHashAlgorithm, DPEnumerations.PASSWORD_FILE_HASH_ALGORITHM)) {
            this.passwordHashAlgorithm = passwordHashAlgorithm;
        }
    }

    @XMLInfo(elementType="element", elementName="LDAPSSLClientConfigType", elementOrder=65, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-client-type", refType="", isEnumeration=true, javaName="lDAPSSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="client", displayOrder=0, displayValue="TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPSSLClientConfigType() {
        return this.lDAPSSLClientConfigType;
    }

    @XMLInfo(elementType="element", elementName="LDAPSSLClientConfigType", elementOrder=65, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-client-type", refType="", isEnumeration=true, javaName="lDAPSSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="client", displayValue="TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPSSLClientConfigType(String lDAPSSLClientConfigType) {
        if (lDAPSSLClientConfigType == null || Comparison.isIn(lDAPSSLClientConfigType, DPEnumerations.SSLCLIENT_CONFIG_TYPE)) {
            this.lDAPSSLClientConfigType = lDAPSSLClientConfigType;
        }
    }

    @XMLInfo(elementType="element", elementName="LDAPSSLClientProfile", elementOrder=66, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="lDAPSSLClientProfile", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getLDAPSSLClientProfile() {
        return this.lDAPSSLClientProfile;
    }

    @XMLInfo(elementType="element", elementName="LDAPSSLClientProfile", elementOrder=66, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="lDAPSSLClientProfile", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPSSLClientProfile(ObjectReference<ConfigSSLClientProfile> lDAPSSLClientProfile) {
        this.lDAPSSLClientProfile = lDAPSSLClientProfile;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPSSLClientConfigType", elementOrder=67, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="mc-ssl-client-type", refType="", isEnumeration=true, javaName="mCLDAPSSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="client", displayOrder=0, displayValue="TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMCLDAPSSLClientConfigType() {
        return this.mCLDAPSSLClientConfigType;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPSSLClientConfigType", elementOrder=67, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="mc-ssl-client-type", refType="", isEnumeration=true, javaName="mCLDAPSSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="client", displayValue="TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMCLDAPSSLClientConfigType(String mCLDAPSSLClientConfigType) {
        if (mCLDAPSSLClientConfigType == null || Comparison.isIn(mCLDAPSSLClientConfigType, DPEnumerations.SSLCLIENT_CONFIG_TYPE)) {
            this.mCLDAPSSLClientConfigType = mCLDAPSSLClientConfigType;
        }
    }

    @XMLInfo(elementType="element", elementName="MCLDAPSSLClientProfile", elementOrder=68, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="mc-ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="mCLDAPSSLClientProfile", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getMCLDAPSSLClientProfile() {
        return this.mCLDAPSSLClientProfile;
    }

    @XMLInfo(elementType="element", elementName="MCLDAPSSLClientProfile", elementOrder=68, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="mc-ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="mCLDAPSSLClientProfile", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMCLDAPSSLClientProfile(ObjectReference<ConfigSSLClientProfile> mCLDAPSSLClientProfile) {
        this.mCLDAPSSLClientProfile = mCLDAPSSLClientProfile;
    }

    @Override
    public int compareTo(ConfigRBMSettings that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "aUMethod", "sSHAUMethod", "cAPubKeyFile", "revokedKeys", "aUZOSNSSConfig", "aUOIDCScope", "aUOIDCClientID", "aUOIDCClientSecret", "aUOIDCIdentityServiceURL", "aUOIDCKeyFetchInterval", "aUOIDCIdentityServiceURLSSLClient", "aUKerberosKeytab", "aUCustomURL", "aUInfoURL", "aUSSLValcred", "aUHost", "aUPort", "aULDAPSearchForDN", "aULDAPBindDN", "aULDAPBindPassword", "aULDAPBindPasswordAlias", "aULDAPSearchParameters", "aULDAPPrefix", "aUForceDNLDAPOrder", "lDAPsuffix", "lDAPSSLProxyProfile", "aULDAPLoadBalanceGroup", "aUCacheAllow", "aUCacheTTL", "aULDAPReadTimeout", "mCMethod", "mCCustomURL", "mCLDAPSearchForGroup", "mCHost", "mCPort", "mCLDAPSSLProxyProfile", "mCLDAPLoadBalanceGroup", "mCLDAPBindDN", "mCLDAPBindPassword", "mCLDAPBindPasswordAlias", "mCLDAPSearchParameters", "mCInfoURL", "mCLDAPReadTimeout", "lDAPVersion", "fallbackLogin", "fallbackUser", "applyToCLI", "restrictAdminToSerialPort", "minPasswordLength", "requireMixedCase", "requireDigit", "requireNonAlphaNumeric", "disallowUsernameSubstring", "doPasswordAging", "maxPasswordAge", "daysPasswordExpiry", "doPasswordHistory", "numOldPasswords", "cliTimeout", "maxFailedLogin", "lockoutPeriod", "mCForceDNLDAPOrder", "passwordHashAlgorithm", "lDAPSSLClientConfigType", "lDAPSSLClientProfile", "mCLDAPSSLClientConfigType", "mCLDAPSSLClientProfile");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.aUMethod, this.sSHAUMethod, this.cAPubKeyFile, this.revokedKeys, this.aUZOSNSSConfig, this.aUOIDCScope, this.aUOIDCClientID, this.aUOIDCClientSecret, this.aUOIDCIdentityServiceURL, this.aUOIDCKeyFetchInterval, this.aUOIDCIdentityServiceURLSSLClient, this.aUKerberosKeytab, this.aUCustomURL, this.aUInfoURL, this.aUSSLValcred, this.aUHost, this.aUPort, this.aULDAPSearchForDN, this.aULDAPBindDN, this.aULDAPBindPassword, this.aULDAPBindPasswordAlias, this.aULDAPSearchParameters, this.aULDAPPrefix, this.aUForceDNLDAPOrder, this.lDAPsuffix, this.lDAPSSLProxyProfile, this.aULDAPLoadBalanceGroup, this.aUCacheAllow, this.aUCacheTTL, this.aULDAPReadTimeout, this.mCMethod, this.mCCustomURL, this.mCLDAPSearchForGroup, this.mCHost, this.mCPort, this.mCLDAPSSLProxyProfile, this.mCLDAPLoadBalanceGroup, this.mCLDAPBindDN, this.mCLDAPBindPassword, this.mCLDAPBindPasswordAlias, this.mCLDAPSearchParameters, this.mCInfoURL, this.mCLDAPReadTimeout, this.lDAPVersion, this.fallbackLogin, this.fallbackUser, this.applyToCLI, this.restrictAdminToSerialPort, this.minPasswordLength, this.requireMixedCase, this.requireDigit, this.requireNonAlphaNumeric, this.disallowUsernameSubstring, this.doPasswordAging, this.maxPasswordAge, this.daysPasswordExpiry, this.doPasswordHistory, this.numOldPasswords, this.cliTimeout, this.maxFailedLogin, this.lockoutPeriod, this.mCForceDNLDAPOrder, this.passwordHashAlgorithm, this.lDAPSSLClientConfigType, this.lDAPSSLClientProfile, this.mCLDAPSSLClientConfigType, this.mCLDAPSSLClientProfile);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "aUMethod", "sSHAUMethod", "cAPubKeyFile", "revokedKeys", "aUZOSNSSConfig", "aUOIDCScope", "aUOIDCClientID", "aUOIDCClientSecret", "aUOIDCIdentityServiceURL", "aUOIDCKeyFetchInterval", "aUOIDCIdentityServiceURLSSLClient", "aUKerberosKeytab", "aUCustomURL", "aUInfoURL", "aUSSLValcred", "aUHost", "aUPort", "aULDAPSearchForDN", "aULDAPBindDN", "aULDAPBindPassword", "aULDAPBindPasswordAlias", "aULDAPSearchParameters", "aULDAPPrefix", "aUForceDNLDAPOrder", "lDAPsuffix", "lDAPSSLProxyProfile", "aULDAPLoadBalanceGroup", "aUCacheAllow", "aUCacheTTL", "aULDAPReadTimeout", "mCMethod", "mCCustomURL", "mCLDAPSearchForGroup", "mCHost", "mCPort", "mCLDAPSSLProxyProfile", "mCLDAPLoadBalanceGroup", "mCLDAPBindDN", "mCLDAPBindPassword", "mCLDAPBindPasswordAlias", "mCLDAPSearchParameters", "mCInfoURL", "mCLDAPReadTimeout", "lDAPVersion", "fallbackLogin", "fallbackUser", "applyToCLI", "restrictAdminToSerialPort", "minPasswordLength", "requireMixedCase", "requireDigit", "requireNonAlphaNumeric", "disallowUsernameSubstring", "doPasswordAging", "maxPasswordAge", "daysPasswordExpiry", "doPasswordHistory", "numOldPasswords", "cliTimeout", "maxFailedLogin", "lockoutPeriod", "mCForceDNLDAPOrder", "passwordHashAlgorithm", "lDAPSSLClientConfigType", "lDAPSSLClientProfile", "mCLDAPSSLClientConfigType", "mCLDAPSSLClientProfile");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "aUMethod", "sSHAUMethod", "cAPubKeyFile", "revokedKeys", "aUZOSNSSConfig", "aUOIDCScope", "aUOIDCClientID", "aUOIDCClientSecret", "aUOIDCIdentityServiceURL", "aUOIDCKeyFetchInterval", "aUOIDCIdentityServiceURLSSLClient", "aUKerberosKeytab", "aUCustomURL", "aUInfoURL", "aUSSLValcred", "aUHost", "aUPort", "aULDAPSearchForDN", "aULDAPBindDN", "aULDAPBindPassword", "aULDAPBindPasswordAlias", "aULDAPSearchParameters", "aULDAPPrefix", "aUForceDNLDAPOrder", "lDAPsuffix", "lDAPSSLProxyProfile", "aULDAPLoadBalanceGroup", "aUCacheAllow", "aUCacheTTL", "aULDAPReadTimeout", "mCMethod", "mCCustomURL", "mCLDAPSearchForGroup", "mCHost", "mCPort", "mCLDAPSSLProxyProfile", "mCLDAPLoadBalanceGroup", "mCLDAPBindDN", "mCLDAPBindPassword", "mCLDAPBindPasswordAlias", "mCLDAPSearchParameters", "mCInfoURL", "mCLDAPReadTimeout", "lDAPVersion", "fallbackLogin", "fallbackUser", "applyToCLI", "restrictAdminToSerialPort", "minPasswordLength", "requireMixedCase", "requireDigit", "requireNonAlphaNumeric", "disallowUsernameSubstring", "doPasswordAging", "maxPasswordAge", "daysPasswordExpiry", "doPasswordHistory", "numOldPasswords", "cliTimeout", "maxFailedLogin", "lockoutPeriod", "mCForceDNLDAPOrder", "passwordHashAlgorithm", "lDAPSSLClientConfigType", "lDAPSSLClientProfile", "mCLDAPSSLClientConfigType", "mCLDAPSSLClientProfile"));
    }
}

