/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigCrypto;
import com.kumbasoft.core.beans.config.ConfigCryptoKey;
import com.kumbasoft.core.beans.config.ConfigPasswordAlias;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.SSHUserAuthenticationMethods;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigSSHClientProfile
extends ConfigCrypto {
    private String userSummary;
    private String userName;
    private String profileUsage;
    private SSHUserAuthenticationMethods sSHUserAuthentication;
    private ObjectReference<ConfigCryptoKey> userPrivateKey;
    private String password;
    private ObjectReference<ConfigPasswordAlias> passwordAlias;
    private String persistentConnections;
    private long persistentConnectionTimeout;
    private String strictHostKeyChecking;
    private ArrayList<String> ciphers;
    private ArrayList<String> kEXAlg;
    private ArrayList<String> mACAlg;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserName", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="user-name", refType="", isEnumeration=false, javaName="userName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="User", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserName() {
        return this.userName;
    }

    @XMLInfo(elementType="element", elementName="UserName", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="user-name", refType="", isEnumeration=false, javaName="userName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="User", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @XMLInfo(elementType="element", elementName="ProfileUsage", elementOrder=3, dataPowerType="dmSSHProfileUsage", subType="", benign=false, isPassword=false, cliAlias="profile-usage", refType="", isEnumeration=true, javaName="profileUsage", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="sftp", displayOrder=0, displayValue="Profile usage", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getProfileUsage() {
        return this.profileUsage;
    }

    @XMLInfo(elementType="element", elementName="ProfileUsage", elementOrder=3, dataPowerType="dmSSHProfileUsage", subType="", benign=false, isPassword=false, cliAlias="profile-usage", refType="", isEnumeration=true, javaName="profileUsage", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="sftp", displayValue="Profile usage", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setProfileUsage(String profileUsage) {
        if (Comparison.isIn(profileUsage, DPEnumerations.SSHPROFILE_USAGE)) {
            this.profileUsage = profileUsage;
        }
    }

    @XMLInfo(elementType="element", elementName="SSHUserAuthentication", elementOrder=4, dataPowerType="dmSSHUserAuthenticationMethods", subType="", benign=false, isPassword=false, cliAlias="user-auth", refType="", isEnumeration=false, javaName="sSHUserAuthentication", javaType="SSHUserAuthenticationMethods", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="publickey+password", displayOrder=0, displayValue="User authentication", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public SSHUserAuthenticationMethods getSSHUserAuthentication() {
        return this.sSHUserAuthentication;
    }

    @XMLInfo(elementType="element", elementName="SSHUserAuthentication", elementOrder=4, dataPowerType="dmSSHUserAuthenticationMethods", subType="", benign=false, isPassword=false, cliAlias="user-auth", refType="", isEnumeration=false, javaName="sSHUserAuthentication", javaType="SSHUserAuthenticationMethods", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="publickey+password", displayValue="User authentication", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSHUserAuthentication(SSHUserAuthenticationMethods sSHUserAuthentication) {
        this.sSHUserAuthentication = sSHUserAuthentication;
    }

    @XMLInfo(elementType="element", elementName="UserPrivateKey", elementOrder=5, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="user-private-key", refType="CryptoKey", isEnumeration=false, javaName="userPrivateKey", javaType="ObjectReference<ConfigCryptoKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="User private key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoKey> getUserPrivateKey() {
        return this.userPrivateKey;
    }

    @XMLInfo(elementType="element", elementName="UserPrivateKey", elementOrder=5, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="user-private-key", refType="CryptoKey", isEnumeration=false, javaName="userPrivateKey", javaType="ObjectReference<ConfigCryptoKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="User private key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserPrivateKey(ObjectReference<ConfigCryptoKey> userPrivateKey) {
        this.userPrivateKey = userPrivateKey;
    }

    @XMLInfo(elementType="element", elementName="Password", elementOrder=6, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="user-password", refType="", isEnumeration=false, javaName="password", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Password (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="7.2.0.0", isObsolete=false, obsoletedIn="")
    public String getPassword() {
        return this.password;
    }

    @XMLInfo(elementType="element", elementName="Password", elementOrder=6, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="user-password", refType="", isEnumeration=false, javaName="password", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Password (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="7.2.0.0", isObsolete=false, obsoletedIn="")
    public void setPassword(String password) {
        this.password = password;
    }

    @XMLInfo(elementType="element", elementName="PasswordAlias", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="user-password-alias", refType="PasswordAlias", isEnumeration=false, javaName="passwordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Password Alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getPasswordAlias() {
        return this.passwordAlias;
    }

    @XMLInfo(elementType="element", elementName="PasswordAlias", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="user-password-alias", refType="PasswordAlias", isEnumeration=false, javaName="passwordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Password Alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPasswordAlias(ObjectReference<ConfigPasswordAlias> passwordAlias) {
        this.passwordAlias = passwordAlias;
    }

    @XMLInfo(elementType="element", elementName="PersistentConnections", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="persistent-connections", refType="", isEnumeration=true, javaName="persistentConnections", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Persistent connections", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPersistentConnections() {
        return this.persistentConnections;
    }

    @XMLInfo(elementType="element", elementName="PersistentConnections", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="persistent-connections", refType="", isEnumeration=true, javaName="persistentConnections", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Persistent connections", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPersistentConnections(String persistentConnections) {
        if (persistentConnections == null || Comparison.isIn(persistentConnections, DPEnumerations.TOGGLE)) {
            this.persistentConnections = persistentConnections;
        }
    }

    @XMLInfo(elementType="element", elementName="PersistentConnectionTimeout", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="persistent-connection-timeout", refType="", isEnumeration=false, javaName="persistentConnectionTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="120", displayOrder=0, displayValue="Persistent connection idle timeout", units="Seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getPersistentConnectionTimeout() {
        return this.persistentConnectionTimeout;
    }

    @XMLInfo(elementType="element", elementName="PersistentConnectionTimeout", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="persistent-connection-timeout", refType="", isEnumeration=false, javaName="persistentConnectionTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="120", displayValue="Persistent connection idle timeout", units="Seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPersistentConnectionTimeout(long persistentConnectionTimeout) {
        this.persistentConnectionTimeout = persistentConnectionTimeout;
    }

    @XMLInfo(elementType="element", elementName="StrictHostKeyChecking", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="strict-host-key-checking", refType="", isEnumeration=true, javaName="strictHostKeyChecking", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Strict host key checking", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getStrictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    @XMLInfo(elementType="element", elementName="StrictHostKeyChecking", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="strict-host-key-checking", refType="", isEnumeration=true, javaName="strictHostKeyChecking", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Strict host key checking", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setStrictHostKeyChecking(String strictHostKeyChecking) {
        if (strictHostKeyChecking == null || Comparison.isIn(strictHostKeyChecking, DPEnumerations.TOGGLE)) {
            this.strictHostKeyChecking = strictHostKeyChecking;
        }
    }

    public void addCiphers(String element) {
        if (element == null) {
            return;
        }
        if (this.ciphers == null) {
            this.ciphers = new ArrayList();
        }
        this.ciphers.add(element);
    }

    public boolean removeCiphers(String element) {
        if (element == null || this.ciphers == null) {
            return false;
        }
        return this.ciphers.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Ciphers", elementOrder=11, dataPowerType="dmSSHCipherSuite", subType="", benign=false, isPassword=false, cliAlias="ciphers", refType="", isEnumeration=true, javaName="ciphers", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="AES128-CTR", displayOrder=0, displayValue="Ciphers", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getCiphers() {
        return this.ciphers;
    }

    @XMLInfo(elementType="element", elementName="Ciphers", elementOrder=11, dataPowerType="dmSSHCipherSuite", subType="", benign=false, isPassword=false, cliAlias="ciphers", refType="", isEnumeration=true, javaName="ciphers", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="AES128-CTR", displayValue="Ciphers", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCiphers(ArrayList<String> ciphers) {
        if (CollectionUtility.isEmpty(ciphers)) {
            this.ciphers = null;
            return;
        }
        this.ciphers = ciphers;
    }

    public void addKEXAlg(String element) {
        if (element == null) {
            return;
        }
        if (this.kEXAlg == null) {
            this.kEXAlg = new ArrayList();
        }
        this.kEXAlg.add(element);
    }

    public boolean removeKEXAlg(String element) {
        if (element == null || this.kEXAlg == null) {
            return false;
        }
        return this.kEXAlg.remove(element);
    }

    @XMLInfo(elementType="element", elementName="KEXAlg", elementOrder=12, dataPowerType="dmSSHKEXList", subType="", benign=false, isPassword=false, cliAlias="kex-alg", refType="", isEnumeration=true, javaName="kEXAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="CURVE25519-SHA256_AT_LIBSSH.ORG", displayOrder=0, displayValue="Key exchange algorithms", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getKEXAlg() {
        return this.kEXAlg;
    }

    @XMLInfo(elementType="element", elementName="KEXAlg", elementOrder=12, dataPowerType="dmSSHKEXList", subType="", benign=false, isPassword=false, cliAlias="kex-alg", refType="", isEnumeration=true, javaName="kEXAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="CURVE25519-SHA256_AT_LIBSSH.ORG", displayValue="Key exchange algorithms", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setKEXAlg(ArrayList<String> kEXAlg) {
        if (CollectionUtility.isEmpty(kEXAlg)) {
            this.kEXAlg = null;
            return;
        }
        this.kEXAlg = kEXAlg;
    }

    public void addMACAlg(String element) {
        if (element == null) {
            return;
        }
        if (this.mACAlg == null) {
            this.mACAlg = new ArrayList();
        }
        this.mACAlg.add(element);
    }

    public boolean removeMACAlg(String element) {
        if (element == null || this.mACAlg == null) {
            return false;
        }
        return this.mACAlg.remove(element);
    }

    @XMLInfo(elementType="element", elementName="MACAlg", elementOrder=13, dataPowerType="dmSSHMACList", subType="", benign=false, isPassword=false, cliAlias="mac-alg", refType="", isEnumeration=true, javaName="mACAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="UMAC-64_AT_OPENSSH.COM", displayOrder=0, displayValue="Message authentication codes", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getMACAlg() {
        return this.mACAlg;
    }

    @XMLInfo(elementType="element", elementName="MACAlg", elementOrder=13, dataPowerType="dmSSHMACList", subType="", benign=false, isPassword=false, cliAlias="mac-alg", refType="", isEnumeration=true, javaName="mACAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="UMAC-64_AT_OPENSSH.COM", displayValue="Message authentication codes", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMACAlg(ArrayList<String> mACAlg) {
        if (CollectionUtility.isEmpty(mACAlg)) {
            this.mACAlg = null;
            return;
        }
        this.mACAlg = mACAlg;
    }

    @Override
    public int compareTo(ConfigSSHClientProfile that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "userName", "profileUsage", "sSHUserAuthentication", "userPrivateKey", "password", "passwordAlias", "persistentConnections", "persistentConnectionTimeout", "strictHostKeyChecking", "ciphers", "kEXAlg", "mACAlg");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.userName, this.profileUsage, this.sSHUserAuthentication, this.userPrivateKey, this.password, this.passwordAlias, this.persistentConnections, this.persistentConnectionTimeout, this.strictHostKeyChecking, this.ciphers, this.kEXAlg, this.mACAlg);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "userName", "profileUsage", "sSHUserAuthentication", "userPrivateKey", "password", "passwordAlias", "persistentConnections", "persistentConnectionTimeout", "strictHostKeyChecking", "ciphers", "kEXAlg", "mACAlg");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "userName", "profileUsage", "sSHUserAuthentication", "userPrivateKey", "password", "passwordAlias", "persistentConnections", "persistentConnectionTimeout", "strictHostKeyChecking", "ciphers", "kEXAlg", "mACAlg"));
    }
}

