/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAAAPolicy;
import com.kumbasoft.core.beans.config.ConfigAccessControlList;
import com.kumbasoft.core.beans.config.ConfigCryptoKey;
import com.kumbasoft.core.beans.config.ConfigSourceProtocolHandler;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.SFTPServerVirtualDirectory;
import com.kumbasoft.core.beans.types.SSHUserAuthenticationMethods;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigSSHServerSourceProtocolHandler
extends ConfigSourceProtocolHandler {
    private String userSummary;
    private String localAddress;
    private int localPort;
    private ObjectReference<ConfigAccessControlList> aCL;
    private ArrayList<ObjectReference<ConfigCryptoKey>> hostPrivateKeys;
    private SSHUserAuthenticationMethods sSHUserAuthentication;
    private String allowBackendListings;
    private String allowBackendDelete;
    private String allowBackendStat;
    private String allowBackendMkdir;
    private String allowBackendRmdir;
    private String allowBackendRename;
    private ObjectReference<ConfigAAAPolicy> aAAPolicy;
    private String filesystemType;
    private String defaultDirectory;
    private long idleTimeout;
    private long persistentFilesystemTimeout;
    private ArrayList<SFTPServerVirtualDirectory> virtualDirectories;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="LocalAddress", elementOrder=2, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="address", refType="", isEnumeration=false, javaName="localAddress", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0.0.0.0", displayOrder=0, displayValue="Local IP address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLocalAddress() {
        return this.localAddress;
    }

    @XMLInfo(elementType="element", elementName="LocalAddress", elementOrder=2, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="address", refType="", isEnumeration=false, javaName="localAddress", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0.0.0.0", displayValue="Local IP address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=3, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65534L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="22", displayOrder=0, displayValue="Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLocalPort() {
        return this.localPort;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=3, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65534L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="22", displayValue="Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    @XMLInfo(elementType="element", elementName="ACL", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="acl", refType="AccessControlList", isEnumeration=false, javaName="aCL", javaType="ObjectReference<ConfigAccessControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Access control list", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAccessControlList> getACL() {
        return this.aCL;
    }

    @XMLInfo(elementType="element", elementName="ACL", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="acl", refType="AccessControlList", isEnumeration=false, javaName="aCL", javaType="ObjectReference<ConfigAccessControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Access control list", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setACL(ObjectReference<ConfigAccessControlList> aCL) {
        this.aCL = aCL;
    }

    public void addHostPrivateKeys(ObjectReference<ConfigCryptoKey> element) {
        if (element == null) {
            return;
        }
        if (this.hostPrivateKeys == null) {
            this.hostPrivateKeys = new ArrayList();
        }
        this.hostPrivateKeys.add(element);
    }

    public boolean removeHostPrivateKeys(ObjectReference<ConfigCryptoKey> element) {
        if (element == null || this.hostPrivateKeys == null) {
            return false;
        }
        return this.hostPrivateKeys.remove(element);
    }

    @XMLInfo(elementType="element", elementName="HostPrivateKeys", elementOrder=5, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="host-private-key", refType="CryptoKey", isEnumeration=false, javaName="hostPrivateKeys", javaType="ObjectReference<ConfigCryptoKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Host private keys", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference<ConfigCryptoKey>> getHostPrivateKeys() {
        return this.hostPrivateKeys;
    }

    @XMLInfo(elementType="element", elementName="HostPrivateKeys", elementOrder=5, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="host-private-key", refType="CryptoKey", isEnumeration=false, javaName="hostPrivateKeys", javaType="ObjectReference<ConfigCryptoKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Host private keys", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHostPrivateKeys(ArrayList<ObjectReference<ConfigCryptoKey>> hostPrivateKeys) {
        this.hostPrivateKeys = hostPrivateKeys;
    }

    @XMLInfo(elementType="element", elementName="SSHUserAuthentication", elementOrder=6, dataPowerType="dmSSHUserAuthenticationMethods", subType="", benign=false, isPassword=false, cliAlias="user-auth", refType="", isEnumeration=false, javaName="sSHUserAuthentication", javaType="SSHUserAuthenticationMethods", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0x03", displayOrder=0, displayValue="User authentication", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public SSHUserAuthenticationMethods getSSHUserAuthentication() {
        return this.sSHUserAuthentication;
    }

    @XMLInfo(elementType="element", elementName="SSHUserAuthentication", elementOrder=6, dataPowerType="dmSSHUserAuthenticationMethods", subType="", benign=false, isPassword=false, cliAlias="user-auth", refType="", isEnumeration=false, javaName="sSHUserAuthentication", javaType="SSHUserAuthenticationMethods", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0x03", displayValue="User authentication", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSHUserAuthentication(SSHUserAuthenticationMethods sSHUserAuthentication) {
        this.sSHUserAuthentication = sSHUserAuthentication;
    }

    @XMLInfo(elementType="element", elementName="AllowBackendListings", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-backend-listings", refType="", isEnumeration=true, javaName="allowBackendListings", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Allow back-end listings", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowBackendListings() {
        return this.allowBackendListings;
    }

    @XMLInfo(elementType="element", elementName="AllowBackendListings", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-backend-listings", refType="", isEnumeration=true, javaName="allowBackendListings", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Allow back-end listings", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowBackendListings(String allowBackendListings) {
        if (allowBackendListings == null || Comparison.isIn(allowBackendListings, DPEnumerations.TOGGLE)) {
            this.allowBackendListings = allowBackendListings;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowBackendDelete", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-backend-delete", refType="", isEnumeration=true, javaName="allowBackendDelete", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Allow file deletes", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowBackendDelete() {
        return this.allowBackendDelete;
    }

    @XMLInfo(elementType="element", elementName="AllowBackendDelete", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-backend-delete", refType="", isEnumeration=true, javaName="allowBackendDelete", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Allow file deletes", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowBackendDelete(String allowBackendDelete) {
        if (allowBackendDelete == null || Comparison.isIn(allowBackendDelete, DPEnumerations.TOGGLE)) {
            this.allowBackendDelete = allowBackendDelete;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowBackendStat", elementOrder=9, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-backend-stat", refType="", isEnumeration=true, javaName="allowBackendStat", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Allow stat operations", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowBackendStat() {
        return this.allowBackendStat;
    }

    @XMLInfo(elementType="element", elementName="AllowBackendStat", elementOrder=9, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-backend-stat", refType="", isEnumeration=true, javaName="allowBackendStat", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Allow stat operations", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowBackendStat(String allowBackendStat) {
        if (allowBackendStat == null || Comparison.isIn(allowBackendStat, DPEnumerations.TOGGLE)) {
            this.allowBackendStat = allowBackendStat;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowBackendMkdir", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-backend-mkdir", refType="", isEnumeration=true, javaName="allowBackendMkdir", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Allow directory creates", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowBackendMkdir() {
        return this.allowBackendMkdir;
    }

    @XMLInfo(elementType="element", elementName="AllowBackendMkdir", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-backend-mkdir", refType="", isEnumeration=true, javaName="allowBackendMkdir", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Allow directory creates", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowBackendMkdir(String allowBackendMkdir) {
        if (allowBackendMkdir == null || Comparison.isIn(allowBackendMkdir, DPEnumerations.TOGGLE)) {
            this.allowBackendMkdir = allowBackendMkdir;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowBackendRmdir", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-backend-rmdir", refType="", isEnumeration=true, javaName="allowBackendRmdir", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Allow directory deletes", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowBackendRmdir() {
        return this.allowBackendRmdir;
    }

    @XMLInfo(elementType="element", elementName="AllowBackendRmdir", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-backend-rmdir", refType="", isEnumeration=true, javaName="allowBackendRmdir", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Allow directory deletes", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowBackendRmdir(String allowBackendRmdir) {
        if (allowBackendRmdir == null || Comparison.isIn(allowBackendRmdir, DPEnumerations.TOGGLE)) {
            this.allowBackendRmdir = allowBackendRmdir;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowBackendRename", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-backend-rename", refType="", isEnumeration=true, javaName="allowBackendRename", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Allow file/directory renames", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowBackendRename() {
        return this.allowBackendRename;
    }

    @XMLInfo(elementType="element", elementName="AllowBackendRename", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-backend-rename", refType="", isEnumeration=true, javaName="allowBackendRename", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Allow file/directory renames", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowBackendRename(String allowBackendRename) {
        if (allowBackendRename == null || Comparison.isIn(allowBackendRename, DPEnumerations.TOGGLE)) {
            this.allowBackendRename = allowBackendRename;
        }
    }

    @XMLInfo(elementType="element", elementName="AAAPolicy", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="aaa-policy", refType="AAAPolicy", isEnumeration=false, javaName="aAAPolicy", javaType="ObjectReference<ConfigAAAPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="AAA policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAAAPolicy> getAAAPolicy() {
        return this.aAAPolicy;
    }

    @XMLInfo(elementType="element", elementName="AAAPolicy", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="aaa-policy", refType="AAAPolicy", isEnumeration=false, javaName="aAAPolicy", javaType="ObjectReference<ConfigAAAPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="AAA policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAAAPolicy(ObjectReference<ConfigAAAPolicy> aAAPolicy) {
        this.aAAPolicy = aAAPolicy;
    }

    @XMLInfo(elementType="element", elementName="FilesystemType", elementOrder=14, dataPowerType="dmSFTPFilesystemType", subType="", benign=false, isPassword=false, cliAlias="filesystem", refType="", isEnumeration=true, javaName="filesystemType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="transparent", displayOrder=0, displayValue="File system type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getFilesystemType() {
        return this.filesystemType;
    }

    @XMLInfo(elementType="element", elementName="FilesystemType", elementOrder=14, dataPowerType="dmSFTPFilesystemType", subType="", benign=false, isPassword=false, cliAlias="filesystem", refType="", isEnumeration=true, javaName="filesystemType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="transparent", displayValue="File system type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFilesystemType(String filesystemType) {
        if (filesystemType == null || Comparison.isIn(filesystemType, DPEnumerations.SFTPFILESYSTEM_TYPE)) {
            this.filesystemType = filesystemType;
        }
    }

    @XMLInfo(elementType="element", elementName="DefaultDirectory", elementOrder=15, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="default-directory", refType="", isEnumeration=false, javaName="defaultDirectory", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^/([^/]+(/[^/]+)*)?$", allowedValues={}, defaultValue="/", displayOrder=0, displayValue="Default directory", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDefaultDirectory() {
        return this.defaultDirectory;
    }

    @XMLInfo(elementType="element", elementName="DefaultDirectory", elementOrder=15, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="default-directory", refType="", isEnumeration=false, javaName="defaultDirectory", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^/([^/]+(/[^/]+)*)?$", allowedValues={}, displayOrder=0, defaultValue="/", displayValue="Default directory", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDefaultDirectory(String defaultDirectory) {
        if (defaultDirectory != null && defaultDirectory.matches("^/([^/]+(/[^/]+)*)?$")) {
            this.defaultDirectory = defaultDirectory;
        }
    }

    @XMLInfo(elementType="element", elementName="IdleTimeout", elementOrder=16, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="idle-timeout", refType="", isEnumeration=false, javaName="idleTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Idle timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @XMLInfo(elementType="element", elementName="IdleTimeout", elementOrder=16, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="idle-timeout", refType="", isEnumeration=false, javaName="idleTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Idle timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @XMLInfo(elementType="element", elementName="PersistentFilesystemTimeout", elementOrder=17, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="persistent-filesystem-timeout", refType="", isEnumeration=false, javaName="persistentFilesystemTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=43200L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="600", displayOrder=0, displayValue="Persistent file system timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getPersistentFilesystemTimeout() {
        return this.persistentFilesystemTimeout;
    }

    @XMLInfo(elementType="element", elementName="PersistentFilesystemTimeout", elementOrder=17, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="persistent-filesystem-timeout", refType="", isEnumeration=false, javaName="persistentFilesystemTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=43200L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="600", displayValue="Persistent file system timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPersistentFilesystemTimeout(long persistentFilesystemTimeout) {
        this.persistentFilesystemTimeout = persistentFilesystemTimeout;
    }

    public void addVirtualDirectories(SFTPServerVirtualDirectory element) {
        if (element == null) {
            return;
        }
        if (this.virtualDirectories == null) {
            this.virtualDirectories = new ArrayList();
        }
        this.virtualDirectories.add(element);
    }

    public boolean removeVirtualDirectories(SFTPServerVirtualDirectory element) {
        if (element == null || this.virtualDirectories == null) {
            return false;
        }
        return this.virtualDirectories.remove(element);
    }

    @XMLInfo(elementType="element", elementName="VirtualDirectories", elementOrder=18, dataPowerType="dmSFTPServerVirtualDirectory", subType="", benign=false, isPassword=false, cliAlias="virtual-directory", refType="", isEnumeration=false, javaName="virtualDirectories", javaType="SFTPServerVirtualDirectory", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Virtual directories", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<SFTPServerVirtualDirectory> getVirtualDirectories() {
        return this.virtualDirectories;
    }

    @XMLInfo(elementType="element", elementName="VirtualDirectories", elementOrder=18, dataPowerType="dmSFTPServerVirtualDirectory", subType="", benign=false, isPassword=false, cliAlias="virtual-directory", refType="", isEnumeration=false, javaName="virtualDirectories", javaType="SFTPServerVirtualDirectory", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Virtual directories", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setVirtualDirectories(ArrayList<SFTPServerVirtualDirectory> virtualDirectories) {
        this.virtualDirectories = virtualDirectories;
    }

    @Override
    public int compareTo(ConfigSSHServerSourceProtocolHandler that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "localAddress", "localPort", "aCL", "hostPrivateKeys", "sSHUserAuthentication", "allowBackendListings", "allowBackendDelete", "allowBackendStat", "allowBackendMkdir", "allowBackendRmdir", "allowBackendRename", "aAAPolicy", "filesystemType", "defaultDirectory", "idleTimeout", "persistentFilesystemTimeout", "virtualDirectories");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.localAddress, this.localPort, this.aCL, this.hostPrivateKeys, this.sSHUserAuthentication, this.allowBackendListings, this.allowBackendDelete, this.allowBackendStat, this.allowBackendMkdir, this.allowBackendRmdir, this.allowBackendRename, this.aAAPolicy, this.filesystemType, this.defaultDirectory, this.idleTimeout, this.persistentFilesystemTimeout, this.virtualDirectories);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "localAddress", "localPort", "aCL", "hostPrivateKeys", "sSHUserAuthentication", "allowBackendListings", "allowBackendDelete", "allowBackendStat", "allowBackendMkdir", "allowBackendRmdir", "allowBackendRename", "aAAPolicy", "filesystemType", "defaultDirectory", "idleTimeout", "persistentFilesystemTimeout", "virtualDirectories");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "localAddress", "localPort", "aCL", "hostPrivateKeys", "sSHUserAuthentication", "allowBackendListings", "allowBackendDelete", "allowBackendStat", "allowBackendMkdir", "allowBackendRmdir", "allowBackendRename", "aAAPolicy", "filesystemType", "defaultDirectory", "idleTimeout", "persistentFilesystemTimeout", "virtualDirectories"));
    }
}

