/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigStandaloneStandbyControlInterface;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigStandaloneStandbyControl
extends ConfigConfigBase {
    private String userSummary;
    private ObjectReference<ConfigStandaloneStandbyControlInterface> ethernetInterface;
    private long group;
    private String virtualIP;
    private ArrayList<String> secondaryVirtualIP;
    private String preempt;
    private long priority;
    private String selfBalance;
    private BigInteger authentication;
    private long helloTimer;
    private long holdTimer;
    private String distAlg;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments (read-only)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments (read-only)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Interface", elementOrder=2, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="interface", refType="StandaloneStandbyControlInterface", isEnumeration=false, javaName="ethernetInterface", javaType="ObjectReference<ConfigStandaloneStandbyControlInterface>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Interface", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigStandaloneStandbyControlInterface> getEthernetInterface() {
        return this.ethernetInterface;
    }

    @XMLInfo(elementType="element", elementName="Interface", elementOrder=2, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="interface", refType="StandaloneStandbyControlInterface", isEnumeration=false, javaName="ethernetInterface", javaType="ObjectReference<ConfigStandaloneStandbyControlInterface>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Interface", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEthernetInterface(ObjectReference<ConfigStandaloneStandbyControlInterface> ethernetInterface) {
        this.ethernetInterface = ethernetInterface;
    }

    @XMLInfo(elementType="element", elementName="Group", elementOrder=3, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="standby-group", refType="", isEnumeration=false, javaName="group", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=255L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="1", displayOrder=0, displayValue="Group number", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getGroup() {
        return this.group;
    }

    @XMLInfo(elementType="element", elementName="Group", elementOrder=3, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="standby-group", refType="", isEnumeration=false, javaName="group", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=255L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="1", displayValue="Group number", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setGroup(long group) {
        this.group = group;
    }

    @XMLInfo(elementType="element", elementName="VirtualIP", elementOrder=4, dataPowerType="dmIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="standby-virtual-ip", refType="", isEnumeration=false, javaName="virtualIP", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Primary virtual IP address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getVirtualIP() {
        return this.virtualIP;
    }

    @XMLInfo(elementType="element", elementName="VirtualIP", elementOrder=4, dataPowerType="dmIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="standby-virtual-ip", refType="", isEnumeration=false, javaName="virtualIP", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Primary virtual IP address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setVirtualIP(String virtualIP) {
        this.virtualIP = virtualIP;
    }

    public void addSecondaryVirtualIP(String element) {
        if (element == null) {
            return;
        }
        if (this.secondaryVirtualIP == null) {
            this.secondaryVirtualIP = new ArrayList();
        }
        this.secondaryVirtualIP.add(element);
    }

    public boolean removeSecondaryVirtualIP(String element) {
        if (element == null || this.secondaryVirtualIP == null) {
            return false;
        }
        return this.secondaryVirtualIP.remove(element);
    }

    @XMLInfo(elementType="element", elementName="SecondaryVirtualIP", elementOrder=5, dataPowerType="dmIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="standby-secondary-virtual-ip", refType="", isEnumeration=false, javaName="secondaryVirtualIP", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Secondary virtual IP addresses", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getSecondaryVirtualIP() {
        return this.secondaryVirtualIP;
    }

    @XMLInfo(elementType="element", elementName="SecondaryVirtualIP", elementOrder=5, dataPowerType="dmIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="standby-secondary-virtual-ip", refType="", isEnumeration=false, javaName="secondaryVirtualIP", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Secondary virtual IP addresses", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSecondaryVirtualIP(ArrayList<String> secondaryVirtualIP) {
        this.secondaryVirtualIP = secondaryVirtualIP;
    }

    @XMLInfo(elementType="element", elementName="Preempt", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="standby-preempt", refType="", isEnumeration=true, javaName="preempt", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable preemption", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPreempt() {
        return this.preempt;
    }

    @XMLInfo(elementType="element", elementName="Preempt", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="standby-preempt", refType="", isEnumeration=true, javaName="preempt", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable preemption", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPreempt(String preempt) {
        if (preempt == null || Comparison.isIn(preempt, DPEnumerations.TOGGLE)) {
            this.preempt = preempt;
        }
    }

    @XMLInfo(elementType="element", elementName="Priority", elementOrder=7, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="standby-priority", refType="", isEnumeration=false, javaName="priority", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=255L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="100", displayOrder=0, displayValue="Priority", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getPriority() {
        return this.priority;
    }

    @XMLInfo(elementType="element", elementName="Priority", elementOrder=7, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="standby-priority", refType="", isEnumeration=false, javaName="priority", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=255L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="100", displayValue="Priority", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPriority(long priority) {
        this.priority = priority;
    }

    @XMLInfo(elementType="element", elementName="SelfBalance", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="standby-self-balance", refType="", isEnumeration=true, javaName="selfBalance", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable self-balancing", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSelfBalance() {
        return this.selfBalance;
    }

    @XMLInfo(elementType="element", elementName="SelfBalance", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="standby-self-balance", refType="", isEnumeration=true, javaName="selfBalance", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable self-balancing", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSelfBalance(String selfBalance) {
        if (selfBalance == null || Comparison.isIn(selfBalance, DPEnumerations.TOGGLE)) {
            this.selfBalance = selfBalance;
        }
    }

    @XMLInfo(elementType="element", elementName="Authentication", elementOrder=9, dataPowerType="dmUInt64", subType="", benign=false, isPassword=false, cliAlias="standby-authentication", refType="", isEnumeration=false, javaName="authentication", javaType="java.math.BigInteger", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0x5841333500000000", displayOrder=0, displayValue="Authentication data", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public BigInteger getAuthentication() {
        return this.authentication;
    }

    @XMLInfo(elementType="element", elementName="Authentication", elementOrder=9, dataPowerType="dmUInt64", subType="", benign=false, isPassword=false, cliAlias="standby-authentication", refType="", isEnumeration=false, javaName="authentication", javaType="java.math.BigInteger", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0x5841333500000000", displayValue="Authentication data", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAuthentication(BigInteger authentication) {
        this.authentication = authentication;
    }

    @XMLInfo(elementType="element", elementName="HelloTimer", elementOrder=10, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="standby-hello-timer", refType="", isEnumeration=false, javaName="helloTimer", javaType="long", isRequired=false, squelchNull=false, minimum=2, maximum=40L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="3", displayOrder=0, displayValue="Hello timer", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getHelloTimer() {
        return this.helloTimer;
    }

    @XMLInfo(elementType="element", elementName="HelloTimer", elementOrder=10, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="standby-hello-timer", refType="", isEnumeration=false, javaName="helloTimer", javaType="long", isRequired=false, squelchNull=false, minimum=2, maximum=40L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="3", displayValue="Hello timer", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHelloTimer(long helloTimer) {
        this.helloTimer = helloTimer;
    }

    @XMLInfo(elementType="element", elementName="HoldTimer", elementOrder=11, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="standby-hold-timer", refType="", isEnumeration=false, javaName="holdTimer", javaType="long", isRequired=false, squelchNull=false, minimum=6, maximum=120L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="10", displayOrder=0, displayValue="Hold timer", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getHoldTimer() {
        return this.holdTimer;
    }

    @XMLInfo(elementType="element", elementName="HoldTimer", elementOrder=11, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="standby-hold-timer", refType="", isEnumeration=false, javaName="holdTimer", javaType="long", isRequired=false, squelchNull=false, minimum=6, maximum=120L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="10", displayValue="Hold timer", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHoldTimer(long holdTimer) {
        this.holdTimer = holdTimer;
    }

    @XMLInfo(elementType="element", elementName="DistAlg", elementOrder=12, dataPowerType="dmLVSDistributionAlgorithm", subType="", benign=false, isPassword=false, cliAlias="standby-distribution-algorithm", refType="", isEnumeration=true, javaName="distAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="wlc", displayOrder=0, displayValue="Distribution algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDistAlg() {
        return this.distAlg;
    }

    @XMLInfo(elementType="element", elementName="DistAlg", elementOrder=12, dataPowerType="dmLVSDistributionAlgorithm", subType="", benign=false, isPassword=false, cliAlias="standby-distribution-algorithm", refType="", isEnumeration=true, javaName="distAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="wlc", displayValue="Distribution algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDistAlg(String distAlg) {
        if (distAlg == null || Comparison.isIn(distAlg, DPEnumerations.LVSDISTRIBUTION_ALGORITHM)) {
            this.distAlg = distAlg;
        }
    }

    @Override
    public int compareTo(ConfigStandaloneStandbyControl that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "ethernetInterface", "group", "virtualIP", "secondaryVirtualIP", "preempt", "priority", "selfBalance", "authentication", "helloTimer", "holdTimer", "distAlg");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.ethernetInterface, this.group, this.virtualIP, this.secondaryVirtualIP, this.preempt, this.priority, this.selfBalance, this.authentication, this.helloTimer, this.holdTimer, this.distAlg);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "ethernetInterface", "group", "virtualIP", "secondaryVirtualIP", "preempt", "priority", "selfBalance", "authentication", "helloTimer", "holdTimer", "distAlg");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "ethernetInterface", "group", "virtualIP", "secondaryVirtualIP", "preempt", "priority", "selfBalance", "authentication", "helloTimer", "holdTimer", "distAlg"));
    }
}

