/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAAAPolicy;
import com.kumbasoft.core.beans.config.ConfigAccessControlList;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigCryptoSSKey;
import com.kumbasoft.core.beans.config.ConfigNameValueProfile;
import com.kumbasoft.core.beans.config.ConfigSimpleCountMonitor;
import com.kumbasoft.core.beans.config.ConfigStylePolicyRule;
import com.kumbasoft.core.beans.config.ConfigWebAppErrorHandlingPolicy;
import com.kumbasoft.core.beans.config.ConfigWebAppSessionPolicy;
import com.kumbasoft.core.beans.types.CookieProfile;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.HTTPRequestMethods;
import com.kumbasoft.core.beans.types.HTTPVersionMask;
import com.kumbasoft.core.beans.types.MultipartFormDataProfile;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigWebAppRequest
extends ConfigConfigBase {
    private String userSummary;
    private String policyType;
    private String sSLPolicy;
    private ObjectReference<ConfigAAAPolicy> aAA;
    private ObjectReference<ConfigCryptoSSKey> sSKey;
    private ObjectReference<ConfigSimpleCountMonitor> rateLimiter;
    private ObjectReference<ConfigAccessControlList> aCL;
    private HTTPRequestMethods oKMethods;
    private HTTPVersionMask oKVersions;
    private long minBodySize;
    private long maxBodySize;
    private String xMLPolicy;
    private ObjectReference<ConfigStylePolicyRule> xMLRule;
    private String nonXMLPolicy;
    private ObjectReference<ConfigStylePolicyRule> nonXMLRule;
    private ObjectReference<ConfigWebAppErrorHandlingPolicy> errorPolicy;
    private ObjectReference<ConfigWebAppSessionPolicy> sessionManagementProfile;
    private ObjectReference<ConfigNameValueProfile> headerGNVC;
    private ObjectReference<ConfigNameValueProfile> urlEncodedGNVC;
    private String queryStringPolicy;
    private ObjectReference<ConfigNameValueProfile> queryStringGNVC;
    private String sQLInjection;
    private long maxURISize;
    private String uRIFilterUnicode;
    private String uRIFilterDotDot;
    private String uRIFilterExe;
    private String uRIFilterFragment;
    private ArrayList<String> contentTypes;
    private MultipartFormDataProfile multipartFormData;
    private CookieProfile cookieProfile;
    private String processAllCookie;
    private ArrayList<String> cookieNameVector;
    private String sQLInjectionPatternsFile;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="PolicyType", elementOrder=2, dataPowerType="dmSatisfactionPolicy", subType="", benign=false, isPassword=false, cliAlias="policy-type", refType="", isEnumeration=true, javaName="policyType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="admission", displayOrder=0, displayValue="Style", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPolicyType() {
        return this.policyType;
    }

    @XMLInfo(elementType="element", elementName="PolicyType", elementOrder=2, dataPowerType="dmSatisfactionPolicy", subType="", benign=false, isPassword=false, cliAlias="policy-type", refType="", isEnumeration=true, javaName="policyType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="admission", displayValue="Style", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPolicyType(String policyType) {
        if (policyType == null || Comparison.isIn(policyType, DPEnumerations.SATISFACTION_POLICY)) {
            this.policyType = policyType;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLPolicy", elementOrder=3, dataPowerType="dmARDType", subType="", benign=false, isPassword=false, cliAlias="request-ssl-policy", refType="", isEnumeration=true, javaName="sSLPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="allow", displayOrder=0, displayValue="Allow SSL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSSLPolicy() {
        return this.sSLPolicy;
    }

    @XMLInfo(elementType="element", elementName="SSLPolicy", elementOrder=3, dataPowerType="dmARDType", subType="", benign=false, isPassword=false, cliAlias="request-ssl-policy", refType="", isEnumeration=true, javaName="sSLPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="allow", displayValue="Allow SSL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLPolicy(String sSLPolicy) {
        if (sSLPolicy == null || Comparison.isIn(sSLPolicy, DPEnumerations.ARDTYPE)) {
            this.sSLPolicy = sSLPolicy;
        }
    }

    @XMLInfo(elementType="element", elementName="AAA", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="aaa-policy", refType="AAAPolicy", isEnumeration=false, javaName="aAA", javaType="ObjectReference<ConfigAAAPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="AAA Policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAAAPolicy> getAAA() {
        return this.aAA;
    }

    @XMLInfo(elementType="element", elementName="AAA", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="aaa-policy", refType="AAAPolicy", isEnumeration=false, javaName="aAA", javaType="ObjectReference<ConfigAAAPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="AAA Policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAAA(ObjectReference<ConfigAAAPolicy> aAA) {
        this.aAA = aAA;
    }

    @XMLInfo(elementType="element", elementName="SSKey", elementOrder=5, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ss-key", refType="CryptoSSKey", isEnumeration=false, javaName="sSKey", javaType="ObjectReference<ConfigCryptoSSKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Shared Secret Key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoSSKey> getSSKey() {
        return this.sSKey;
    }

    @XMLInfo(elementType="element", elementName="SSKey", elementOrder=5, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ss-key", refType="CryptoSSKey", isEnumeration=false, javaName="sSKey", javaType="ObjectReference<ConfigCryptoSSKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Shared Secret Key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSKey(ObjectReference<ConfigCryptoSSKey> sSKey) {
        this.sSKey = sSKey;
    }

    @XMLInfo(elementType="element", elementName="RateLimiter", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ratelimiter-policy", refType="SimpleCountMonitor", isEnumeration=false, javaName="rateLimiter", javaType="ObjectReference<ConfigSimpleCountMonitor>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Rate Limiting", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSimpleCountMonitor> getRateLimiter() {
        return this.rateLimiter;
    }

    @XMLInfo(elementType="element", elementName="RateLimiter", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ratelimiter-policy", refType="SimpleCountMonitor", isEnumeration=false, javaName="rateLimiter", javaType="ObjectReference<ConfigSimpleCountMonitor>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Rate Limiting", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRateLimiter(ObjectReference<ConfigSimpleCountMonitor> rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    @XMLInfo(elementType="element", elementName="ACL", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="acl", refType="AccessControlList", isEnumeration=false, javaName="aCL", javaType="ObjectReference<ConfigAccessControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Access Control List", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAccessControlList> getACL() {
        return this.aCL;
    }

    @XMLInfo(elementType="element", elementName="ACL", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="acl", refType="AccessControlList", isEnumeration=false, javaName="aCL", javaType="ObjectReference<ConfigAccessControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Access Control List", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setACL(ObjectReference<ConfigAccessControlList> aCL) {
        this.aCL = aCL;
    }

    @XMLInfo(elementType="element", elementName="OKMethods", elementOrder=8, dataPowerType="dmHTTPRequestMethods", subType="", benign=false, isPassword=false, cliAlias="request-methods", refType="", isEnumeration=false, javaName="oKMethods", javaType="HTTPRequestMethods", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0x000B", displayOrder=0, displayValue="Methods", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public HTTPRequestMethods getOKMethods() {
        return this.oKMethods;
    }

    @XMLInfo(elementType="element", elementName="OKMethods", elementOrder=8, dataPowerType="dmHTTPRequestMethods", subType="", benign=false, isPassword=false, cliAlias="request-methods", refType="", isEnumeration=false, javaName="oKMethods", javaType="HTTPRequestMethods", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0x000B", displayValue="Methods", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOKMethods(HTTPRequestMethods oKMethods) {
        this.oKMethods = oKMethods;
    }

    @XMLInfo(elementType="element", elementName="OKVersions", elementOrder=9, dataPowerType="dmHTTPVersionMask", subType="", benign=false, isPassword=false, cliAlias="request-versions", refType="", isEnumeration=false, javaName="oKVersions", javaType="HTTPVersionMask", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0x03", displayOrder=0, displayValue="Versions", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public HTTPVersionMask getOKVersions() {
        return this.oKVersions;
    }

    @XMLInfo(elementType="element", elementName="OKVersions", elementOrder=9, dataPowerType="dmHTTPVersionMask", subType="", benign=false, isPassword=false, cliAlias="request-versions", refType="", isEnumeration=false, javaName="oKVersions", javaType="HTTPVersionMask", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0x03", displayValue="Versions", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOKVersions(HTTPVersionMask oKVersions) {
        this.oKVersions = oKVersions;
    }

    @XMLInfo(elementType="element", elementName="MinBodySize", elementOrder=10, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="request-body-min", refType="", isEnumeration=false, javaName="minBodySize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Minimum Size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMinBodySize() {
        return this.minBodySize;
    }

    @XMLInfo(elementType="element", elementName="MinBodySize", elementOrder=10, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="request-body-min", refType="", isEnumeration=false, javaName="minBodySize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Minimum Size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMinBodySize(long minBodySize) {
        this.minBodySize = minBodySize;
    }

    @XMLInfo(elementType="element", elementName="MaxBodySize", elementOrder=11, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="request-body-max", refType="", isEnumeration=false, javaName="maxBodySize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="128000000", displayOrder=0, displayValue="Maximum Size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxBodySize() {
        return this.maxBodySize;
    }

    @XMLInfo(elementType="element", elementName="MaxBodySize", elementOrder=11, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="request-body-max", refType="", isEnumeration=false, javaName="maxBodySize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="128000000", displayValue="Maximum Size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxBodySize(long maxBodySize) {
        this.maxBodySize = maxBodySize;
    }

    @XMLInfo(elementType="element", elementName="XMLPolicy", elementOrder=12, dataPowerType="dmWebAppXMLPolicy", subType="", benign=false, isPassword=false, cliAlias="request-xml-policy", refType="", isEnumeration=true, javaName="xMLPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="nothing", displayOrder=0, displayValue="XML Processing", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getXMLPolicy() {
        return this.xMLPolicy;
    }

    @XMLInfo(elementType="element", elementName="XMLPolicy", elementOrder=12, dataPowerType="dmWebAppXMLPolicy", subType="", benign=false, isPassword=false, cliAlias="request-xml-policy", refType="", isEnumeration=true, javaName="xMLPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="nothing", displayValue="XML Processing", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setXMLPolicy(String xMLPolicy) {
        if (xMLPolicy == null || Comparison.isIn(xMLPolicy, DPEnumerations.WEB_APP_XMLPOLICY)) {
            this.xMLPolicy = xMLPolicy;
        }
    }

    @XMLInfo(elementType="element", elementName="XMLRule", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="request-xml-rule", refType="StylePolicyRule", isEnumeration=false, javaName="xMLRule", javaType="ObjectReference<ConfigStylePolicyRule>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="XML Transformation Rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigStylePolicyRule> getXMLRule() {
        return this.xMLRule;
    }

    @XMLInfo(elementType="element", elementName="XMLRule", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="request-xml-rule", refType="StylePolicyRule", isEnumeration=false, javaName="xMLRule", javaType="ObjectReference<ConfigStylePolicyRule>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="XML Transformation Rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setXMLRule(ObjectReference<ConfigStylePolicyRule> xMLRule) {
        this.xMLRule = xMLRule;
    }

    @XMLInfo(elementType="element", elementName="NonXMLPolicy", elementOrder=14, dataPowerType="dmWebAppNonXMLPolicy", subType="", benign=false, isPassword=false, cliAlias="request-nonxml-policy", refType="", isEnumeration=true, javaName="nonXMLPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="nothing", displayOrder=0, displayValue="Non-XML Processing", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getNonXMLPolicy() {
        return this.nonXMLPolicy;
    }

    @XMLInfo(elementType="element", elementName="NonXMLPolicy", elementOrder=14, dataPowerType="dmWebAppNonXMLPolicy", subType="", benign=false, isPassword=false, cliAlias="request-nonxml-policy", refType="", isEnumeration=true, javaName="nonXMLPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="nothing", displayValue="Non-XML Processing", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setNonXMLPolicy(String nonXMLPolicy) {
        if (nonXMLPolicy == null || Comparison.isIn(nonXMLPolicy, DPEnumerations.WEB_APP_NON_XMLPOLICY)) {
            this.nonXMLPolicy = nonXMLPolicy;
        }
    }

    @XMLInfo(elementType="element", elementName="NonXMLRule", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="request-nonxml-rule", refType="StylePolicyRule", isEnumeration=false, javaName="nonXMLRule", javaType="ObjectReference<ConfigStylePolicyRule>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Non-XML Processing Rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigStylePolicyRule> getNonXMLRule() {
        return this.nonXMLRule;
    }

    @XMLInfo(elementType="element", elementName="NonXMLRule", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="request-nonxml-rule", refType="StylePolicyRule", isEnumeration=false, javaName="nonXMLRule", javaType="ObjectReference<ConfigStylePolicyRule>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Non-XML Processing Rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setNonXMLRule(ObjectReference<ConfigStylePolicyRule> nonXMLRule) {
        this.nonXMLRule = nonXMLRule;
    }

    @XMLInfo(elementType="element", elementName="ErrorPolicy", elementOrder=16, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="error-policy-override", refType="WebAppErrorHandlingPolicy", isEnumeration=false, javaName="errorPolicy", javaType="ObjectReference<ConfigWebAppErrorHandlingPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Error Policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigWebAppErrorHandlingPolicy> getErrorPolicy() {
        return this.errorPolicy;
    }

    @XMLInfo(elementType="element", elementName="ErrorPolicy", elementOrder=16, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="error-policy-override", refType="WebAppErrorHandlingPolicy", isEnumeration=false, javaName="errorPolicy", javaType="ObjectReference<ConfigWebAppErrorHandlingPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Error Policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setErrorPolicy(ObjectReference<ConfigWebAppErrorHandlingPolicy> errorPolicy) {
        this.errorPolicy = errorPolicy;
    }

    @XMLInfo(elementType="element", elementName="SessionManagementProfile", elementOrder=17, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="session-policy", refType="WebAppSessionPolicy", isEnumeration=false, javaName="sessionManagementProfile", javaType="ObjectReference<ConfigWebAppSessionPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Session Policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigWebAppSessionPolicy> getSessionManagementProfile() {
        return this.sessionManagementProfile;
    }

    @XMLInfo(elementType="element", elementName="SessionManagementProfile", elementOrder=17, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="session-policy", refType="WebAppSessionPolicy", isEnumeration=false, javaName="sessionManagementProfile", javaType="ObjectReference<ConfigWebAppSessionPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Session Policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSessionManagementProfile(ObjectReference<ConfigWebAppSessionPolicy> sessionManagementProfile) {
        this.sessionManagementProfile = sessionManagementProfile;
    }

    @XMLInfo(elementType="element", elementName="HeaderGNVC", elementOrder=18, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="request-header-profile", refType="NameValueProfile", isEnumeration=false, javaName="headerGNVC", javaType="ObjectReference<ConfigNameValueProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Header Name-Value Profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigNameValueProfile> getHeaderGNVC() {
        return this.headerGNVC;
    }

    @XMLInfo(elementType="element", elementName="HeaderGNVC", elementOrder=18, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="request-header-profile", refType="NameValueProfile", isEnumeration=false, javaName="headerGNVC", javaType="ObjectReference<ConfigNameValueProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Header Name-Value Profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHeaderGNVC(ObjectReference<ConfigNameValueProfile> headerGNVC) {
        this.headerGNVC = headerGNVC;
    }

    @XMLInfo(elementType="element", elementName="UrlEncodedGNVC", elementOrder=19, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="request-body-profile", refType="NameValueProfile", isEnumeration=false, javaName="urlEncodedGNVC", javaType="ObjectReference<ConfigNameValueProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="URL-Encoded Body Name-Value Profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigNameValueProfile> getUrlEncodedGNVC() {
        return this.urlEncodedGNVC;
    }

    @XMLInfo(elementType="element", elementName="UrlEncodedGNVC", elementOrder=19, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="request-body-profile", refType="NameValueProfile", isEnumeration=false, javaName="urlEncodedGNVC", javaType="ObjectReference<ConfigNameValueProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="URL-Encoded Body Name-Value Profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUrlEncodedGNVC(ObjectReference<ConfigNameValueProfile> urlEncodedGNVC) {
        this.urlEncodedGNVC = urlEncodedGNVC;
    }

    @XMLInfo(elementType="element", elementName="QueryStringPolicy", elementOrder=20, dataPowerType="dmARDType", subType="", benign=false, isPassword=false, cliAlias="request-qs-policy", refType="", isEnumeration=true, javaName="queryStringPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="allow", displayOrder=0, displayValue="Allow Query String", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getQueryStringPolicy() {
        return this.queryStringPolicy;
    }

    @XMLInfo(elementType="element", elementName="QueryStringPolicy", elementOrder=20, dataPowerType="dmARDType", subType="", benign=false, isPassword=false, cliAlias="request-qs-policy", refType="", isEnumeration=true, javaName="queryStringPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="allow", displayValue="Allow Query String", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setQueryStringPolicy(String queryStringPolicy) {
        if (queryStringPolicy == null || Comparison.isIn(queryStringPolicy, DPEnumerations.ARDTYPE)) {
            this.queryStringPolicy = queryStringPolicy;
        }
    }

    @XMLInfo(elementType="element", elementName="QueryStringGNVC", elementOrder=21, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="request-qs-profile", refType="NameValueProfile", isEnumeration=false, javaName="queryStringGNVC", javaType="ObjectReference<ConfigNameValueProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="QueryString Name-Value Profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigNameValueProfile> getQueryStringGNVC() {
        return this.queryStringGNVC;
    }

    @XMLInfo(elementType="element", elementName="QueryStringGNVC", elementOrder=21, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="request-qs-profile", refType="NameValueProfile", isEnumeration=false, javaName="queryStringGNVC", javaType="ObjectReference<ConfigNameValueProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="QueryString Name-Value Profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setQueryStringGNVC(ObjectReference<ConfigNameValueProfile> queryStringGNVC) {
        this.queryStringGNVC = queryStringGNVC;
    }

    @XMLInfo(elementType="element", elementName="SQLInjection", elementOrder=22, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="request-sql-policy", refType="", isEnumeration=true, javaName="sQLInjection", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="SQL Injection Filter", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSQLInjection() {
        return this.sQLInjection;
    }

    @XMLInfo(elementType="element", elementName="SQLInjection", elementOrder=22, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="request-sql-policy", refType="", isEnumeration=true, javaName="sQLInjection", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="SQL Injection Filter", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSQLInjection(String sQLInjection) {
        if (sQLInjection == null || Comparison.isIn(sQLInjection, DPEnumerations.TOGGLE)) {
            this.sQLInjection = sQLInjection;
        }
    }

    @XMLInfo(elementType="element", elementName="MaxURISize", elementOrder=23, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="request-uri-max", refType="", isEnumeration=false, javaName="maxURISize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="1024", displayOrder=0, displayValue="Maximum URI Length", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxURISize() {
        return this.maxURISize;
    }

    @XMLInfo(elementType="element", elementName="MaxURISize", elementOrder=23, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="request-uri-max", refType="", isEnumeration=false, javaName="maxURISize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="1024", displayValue="Maximum URI Length", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxURISize(long maxURISize) {
        this.maxURISize = maxURISize;
    }

    @XMLInfo(elementType="element", elementName="URIFilterUnicode", elementOrder=24, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="request-uri-filter-unicode", refType="", isEnumeration=true, javaName="uRIFilterUnicode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Filter Unicode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getURIFilterUnicode() {
        return this.uRIFilterUnicode;
    }

    @XMLInfo(elementType="element", elementName="URIFilterUnicode", elementOrder=24, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="request-uri-filter-unicode", refType="", isEnumeration=true, javaName="uRIFilterUnicode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Filter Unicode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setURIFilterUnicode(String uRIFilterUnicode) {
        if (uRIFilterUnicode == null || Comparison.isIn(uRIFilterUnicode, DPEnumerations.TOGGLE)) {
            this.uRIFilterUnicode = uRIFilterUnicode;
        }
    }

    @XMLInfo(elementType="element", elementName="URIFilterDotDot", elementOrder=25, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="request-uri-filter-dotdot", refType="", isEnumeration=true, javaName="uRIFilterDotDot", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Filter Dot Dot", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getURIFilterDotDot() {
        return this.uRIFilterDotDot;
    }

    @XMLInfo(elementType="element", elementName="URIFilterDotDot", elementOrder=25, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="request-uri-filter-dotdot", refType="", isEnumeration=true, javaName="uRIFilterDotDot", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Filter Dot Dot", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setURIFilterDotDot(String uRIFilterDotDot) {
        if (uRIFilterDotDot == null || Comparison.isIn(uRIFilterDotDot, DPEnumerations.TOGGLE)) {
            this.uRIFilterDotDot = uRIFilterDotDot;
        }
    }

    @XMLInfo(elementType="element", elementName="URIFilterExe", elementOrder=26, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="request-uri-filter-exe", refType="", isEnumeration=true, javaName="uRIFilterExe", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Filter .exe", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getURIFilterExe() {
        return this.uRIFilterExe;
    }

    @XMLInfo(elementType="element", elementName="URIFilterExe", elementOrder=26, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="request-uri-filter-exe", refType="", isEnumeration=true, javaName="uRIFilterExe", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Filter .exe", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setURIFilterExe(String uRIFilterExe) {
        if (uRIFilterExe == null || Comparison.isIn(uRIFilterExe, DPEnumerations.TOGGLE)) {
            this.uRIFilterExe = uRIFilterExe;
        }
    }

    @XMLInfo(elementType="element", elementName="URIFilterFragment", elementOrder=27, dataPowerType="dmURIFragmentFixupType", subType="", benign=false, isPassword=false, cliAlias="request-uri-filter-fragment", refType="", isEnumeration=true, javaName="uRIFilterFragment", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="truncate", displayOrder=0, displayValue="Fragmented URI Policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getURIFilterFragment() {
        return this.uRIFilterFragment;
    }

    @XMLInfo(elementType="element", elementName="URIFilterFragment", elementOrder=27, dataPowerType="dmURIFragmentFixupType", subType="", benign=false, isPassword=false, cliAlias="request-uri-filter-fragment", refType="", isEnumeration=true, javaName="uRIFilterFragment", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="truncate", displayValue="Fragmented URI Policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setURIFilterFragment(String uRIFilterFragment) {
        if (uRIFilterFragment == null || Comparison.isIn(uRIFilterFragment, DPEnumerations.URIFRAGMENT_FIXUP_TYPE)) {
            this.uRIFilterFragment = uRIFilterFragment;
        }
    }

    public void addContentTypes(String element) {
        if (element == null) {
            return;
        }
        if (this.contentTypes == null) {
            this.contentTypes = new ArrayList();
        }
        this.contentTypes.add(element);
    }

    public boolean removeContentTypes(String element) {
        if (element == null || this.contentTypes == null) {
            return false;
        }
        return this.contentTypes.remove(element);
    }

    @XMLInfo(elementType="element", elementName="ContentTypes", elementOrder=28, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="request-content-type", refType="", isEnumeration=false, javaName="contentTypes", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="application/www-url-encoded", displayOrder=0, displayValue="Content-Type List", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getContentTypes() {
        return this.contentTypes;
    }

    @XMLInfo(elementType="element", elementName="ContentTypes", elementOrder=28, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="request-content-type", refType="", isEnumeration=false, javaName="contentTypes", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="application/www-url-encoded", displayValue="Content-Type List", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setContentTypes(ArrayList<String> contentTypes) {
        this.contentTypes = contentTypes;
    }

    @XMLInfo(elementType="element", elementName="MultipartFormData", elementOrder=29, dataPowerType="dmMultipartFormDataProfile", subType="", benign=false, isPassword=false, cliAlias="multipart-form-data", refType="", isEnumeration=false, javaName="multipartFormData", javaType="MultipartFormDataProfile", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Multipart/Form-Data Profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public MultipartFormDataProfile getMultipartFormData() {
        return this.multipartFormData;
    }

    @XMLInfo(elementType="element", elementName="MultipartFormData", elementOrder=29, dataPowerType="dmMultipartFormDataProfile", subType="", benign=false, isPassword=false, cliAlias="multipart-form-data", refType="", isEnumeration=false, javaName="multipartFormData", javaType="MultipartFormDataProfile", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Multipart/Form-Data Profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMultipartFormData(MultipartFormDataProfile multipartFormData) {
        this.multipartFormData = multipartFormData;
    }

    @XMLInfo(elementType="element", elementName="CookieProfile", elementOrder=30, dataPowerType="dmCookieProfile", subType="", benign=false, isPassword=false, cliAlias="cookie-policy", refType="", isEnumeration=false, javaName="cookieProfile", javaType="CookieProfile", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Cookie Profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public CookieProfile getCookieProfile() {
        return this.cookieProfile;
    }

    @XMLInfo(elementType="element", elementName="CookieProfile", elementOrder=30, dataPowerType="dmCookieProfile", subType="", benign=false, isPassword=false, cliAlias="cookie-policy", refType="", isEnumeration=false, javaName="cookieProfile", javaType="CookieProfile", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Cookie Profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCookieProfile(CookieProfile cookieProfile) {
        this.cookieProfile = cookieProfile;
    }

    @XMLInfo(elementType="element", elementName="ProcessAllCookie", elementOrder=31, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="process-all-cookie", refType="", isEnumeration=true, javaName="processAllCookie", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Sign or Encrypt All Cookies", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getProcessAllCookie() {
        return this.processAllCookie;
    }

    @XMLInfo(elementType="element", elementName="ProcessAllCookie", elementOrder=31, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="process-all-cookie", refType="", isEnumeration=true, javaName="processAllCookie", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Sign or Encrypt All Cookies", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setProcessAllCookie(String processAllCookie) {
        if (processAllCookie == null || Comparison.isIn(processAllCookie, DPEnumerations.TOGGLE)) {
            this.processAllCookie = processAllCookie;
        }
    }

    public void addCookieNameVector(String element) {
        if (element == null) {
            return;
        }
        if (this.cookieNameVector == null) {
            this.cookieNameVector = new ArrayList();
        }
        this.cookieNameVector.add(element);
    }

    public boolean removeCookieNameVector(String element) {
        if (element == null || this.cookieNameVector == null) {
            return false;
        }
        return this.cookieNameVector.remove(element);
    }

    @XMLInfo(elementType="element", elementName="CookieNameVector", elementOrder=32, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="cookie-namelist", refType="", isEnumeration=false, javaName="cookieNameVector", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Cookie Names", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getCookieNameVector() {
        return this.cookieNameVector;
    }

    @XMLInfo(elementType="element", elementName="CookieNameVector", elementOrder=32, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="cookie-namelist", refType="", isEnumeration=false, javaName="cookieNameVector", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Cookie Names", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCookieNameVector(ArrayList<String> cookieNameVector) {
        this.cookieNameVector = cookieNameVector;
    }

    @XMLInfo(elementType="element", elementName="SQLInjectionPatternsFile", elementOrder=33, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="sql-injection-patterns-file", refType="", isEnumeration=false, javaName="sQLInjectionPatternsFile", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="store:///SQL-Injection-Patterns.xml", displayOrder=0, displayValue="SQL Injection Patterns File", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSQLInjectionPatternsFile() {
        return this.sQLInjectionPatternsFile;
    }

    @XMLInfo(elementType="element", elementName="SQLInjectionPatternsFile", elementOrder=33, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="sql-injection-patterns-file", refType="", isEnumeration=false, javaName="sQLInjectionPatternsFile", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="store:///SQL-Injection-Patterns.xml", displayValue="SQL Injection Patterns File", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSQLInjectionPatternsFile(String sQLInjectionPatternsFile) {
        this.sQLInjectionPatternsFile = sQLInjectionPatternsFile;
    }

    @Override
    public int compareTo(ConfigWebAppRequest that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "policyType", "sSLPolicy", "aAA", "sSKey", "rateLimiter", "aCL", "oKMethods", "oKVersions", "minBodySize", "maxBodySize", "xMLPolicy", "xMLRule", "nonXMLPolicy", "nonXMLRule", "errorPolicy", "sessionManagementProfile", "headerGNVC", "urlEncodedGNVC", "queryStringPolicy", "queryStringGNVC", "sQLInjection", "maxURISize", "uRIFilterUnicode", "uRIFilterDotDot", "uRIFilterExe", "uRIFilterFragment", "contentTypes", "multipartFormData", "cookieProfile", "processAllCookie", "cookieNameVector", "sQLInjectionPatternsFile");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.policyType, this.sSLPolicy, this.aAA, this.sSKey, this.rateLimiter, this.aCL, this.oKMethods, this.oKVersions, this.minBodySize, this.maxBodySize, this.xMLPolicy, this.xMLRule, this.nonXMLPolicy, this.nonXMLRule, this.errorPolicy, this.sessionManagementProfile, this.headerGNVC, this.urlEncodedGNVC, this.queryStringPolicy, this.queryStringGNVC, this.sQLInjection, this.maxURISize, this.uRIFilterUnicode, this.uRIFilterDotDot, this.uRIFilterExe, this.uRIFilterFragment, this.contentTypes, this.multipartFormData, this.cookieProfile, this.processAllCookie, this.cookieNameVector, this.sQLInjectionPatternsFile);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "policyType", "sSLPolicy", "aAA", "sSKey", "rateLimiter", "aCL", "oKMethods", "oKVersions", "minBodySize", "maxBodySize", "xMLPolicy", "xMLRule", "nonXMLPolicy", "nonXMLRule", "errorPolicy", "sessionManagementProfile", "headerGNVC", "urlEncodedGNVC", "queryStringPolicy", "queryStringGNVC", "sQLInjection", "maxURISize", "uRIFilterUnicode", "uRIFilterDotDot", "uRIFilterExe", "uRIFilterFragment", "contentTypes", "multipartFormData", "cookieProfile", "processAllCookie", "cookieNameVector", "sQLInjectionPatternsFile");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "policyType", "sSLPolicy", "aAA", "sSKey", "rateLimiter", "aCL", "oKMethods", "oKVersions", "minBodySize", "maxBodySize", "xMLPolicy", "xMLRule", "nonXMLPolicy", "nonXMLRule", "errorPolicy", "sessionManagementProfile", "headerGNVC", "urlEncodedGNVC", "queryStringPolicy", "queryStringGNVC", "sQLInjection", "maxURISize", "uRIFilterUnicode", "uRIFilterDotDot", "uRIFilterExe", "uRIFilterFragment", "contentTypes", "multipartFormData", "cookieProfile", "processAllCookie", "cookieNameVector", "sQLInjectionPatternsFile"));
    }
}

